/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.IErrorHandler;
import eu.ddmore.libpharmml.IMarshaller;
import eu.ddmore.libpharmml.dom.PharmML;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.impl.LoggerWrapper;
import eu.ddmore.libpharmml.impl.Messages;
import eu.ddmore.libpharmml.impl.NamespaceFilter;
import eu.ddmore.libpharmml.impl.PharmMLSchemaFactory;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import eu.ddmore.libpharmml.validation.SymbolResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;

public class MarshallerImpl
implements IMarshaller {
    public static final String CONTEXT_NAME = Messages.getString("MarshallerImpl.contextDefn");
    private IErrorHandler errorHandler;

    @Override
    public void marshall(PharmML dom, OutputStream os) {
        this.marshall(dom, os, null);
    }

    @Override
    public void marshall(PharmML dom, OutputStream os, Marshaller.Listener mListener) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)CONTEXT_NAME);
            PharmMLVersion version = PharmMLVersion.getEnum(dom.getWrittenVersion());
            if (version == null) {
                version = PharmMLVersion.DEFAULT;
            }
            this.setMarshalVersion(dom, version);
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setListener(mListener);
            if (!version.isEqualOrLaterThan(PharmMLVersion.DEFAULT)) {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                NamespaceFilter filter = new NamespaceFilter(version);
                m.marshal((Object)dom, (OutputStream)byteOut);
                filter.filterRawText(new ByteArrayInputStream(byteOut.toByteArray()), os);
            } else {
                m.marshal((Object)dom, os);
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PharmML unmarshall(InputStream is) {
        try {
            byte[] data = MarshallerImpl.toByteArray(is);
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            PharmMLVersion currentDocVersion = MarshallerImpl.parseVersion(bais);
            bais.reset();
            return this.unmarshall(bais, currentDocVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PharmML unmarshall(InputStream in, PharmMLVersion version) {
        return this.unmarshall(in, version, null);
    }

    @Override
    public PharmML unmarshall(InputStream is, PharmMLVersion version, Unmarshaller.Listener uListener) {
        try {
            PharmML doc;
            JAXBContext context = JAXBContext.newInstance((String)CONTEXT_NAME);
            Unmarshaller u = context.createUnmarshaller();
            u.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    int severity = event.getSeverity();
                    switch (severity) {
                        case 1: {
                            MarshallerImpl.this.errorHandler.handleError("SCHEMA", event.getMessage(), event.getLocator());
                            break;
                        }
                        case 2: {
                            MarshallerImpl.this.errorHandler.handleError("SCHEMA", event.getMessage(), event.getLocator());
                            break;
                        }
                        case 0: {
                            MarshallerImpl.this.errorHandler.handleWarning(event.getMessage());
                        }
                    }
                    return true;
                }
            });
            Schema mySchema = PharmMLSchemaFactory.getInstance().createPharmMlSchema(version, PharmMLSchemaFactory.NamespaceType.DEFAULT);
            u.setSchema(mySchema);
            u.setListener(uListener);
            if (!version.isEqualOrLaterThan(PharmMLVersion.DEFAULT)) {
                XMLStreamReader xmlsr = new NamespaceFilter(version).getXMLStreamReader(is);
                doc = (PharmML)u.unmarshal(xmlsr);
            } else {
                doc = (PharmML)u.unmarshal(is);
            }
            if (version.isEqualOrLaterThan(PharmMLVersion.V0_6)) {
                SymbolResolver sr = new SymbolResolver(doc, this.errorHandler);
                sr.validateAll();
            } else {
                LoggerWrapper.getLogger().info("Version is below " + (Object)((Object)PharmMLVersion.V0_6) + ", no complex validation performed.");
            }
            return doc;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void setErrorHandler(IErrorHandler repFact) {
        this.errorHandler = repFact;
    }

    @Override
    public IErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    static PharmMLVersion parseVersion(InputStream is) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        XMLStreamReader sReader = factory.createXMLStreamReader(is);
        String version = null;
        while (sReader.hasNext() && version == null) {
            int event = sReader.next();
            switch (event) {
                case 1: {
                    if (!"PharmML".equals(sReader.getLocalName())) break;
                    version = sReader.getAttributeValue(null, "writtenVersion");
                }
            }
        }
        sReader.close();
        PharmMLVersion phVersion = PharmMLVersion.getEnum(version);
        if (phVersion == null) {
            phVersion = PharmMLVersion.DEFAULT;
            LoggerWrapper.getLogger().warning("Missing writtenVersion attribute or unknown version for PharmML element. Using default version (" + phVersion.getValue() + ").");
        }
        return phVersion;
    }

    static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int read = 0;
        while ((read = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, read);
        }
        baos.flush();
        return baos.toByteArray();
    }

    private void setMarshalVersion(PharmMLElement node, PharmMLVersion version) {
        node.setMarshalVersion(version);
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            if (!(child instanceof PharmMLElement)) continue;
            this.setMarshalVersion((PharmMLElement)child, version);
        }
    }
}

