/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.impl.PharmMLVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class NamespaceFilter
extends XMLFilterImpl {
    private static final String NS_PATTERN_ROOT = "http://www.pharmml.org/pharmml/%s/";
    protected static final String NS_PATTERN_CT = "http://www.pharmml.org/pharmml/%s/CommonTypes";
    protected static final String NS_PATTERN_DS = "http://www.pharmml.org/pharmml/%s/Dataset";
    protected static final String NS_PATTERN_MATH = "http://www.pharmml.org/pharmml/%s/Maths";
    protected static final String NS_PATTERN_MDEF = "http://www.pharmml.org/pharmml/%s/ModelDefinition";
    protected static final String NS_PATTERN_TD = "http://www.pharmml.org/pharmml/%s/TrialDesign";
    protected static final String NS_PATTERN_MSTEPS = "http://www.pharmml.org/pharmml/%s/ModellingSteps";
    public static final String NS_PATTERN_MML = "http://www.pharmml.org/pharmml/%s/PharmML";
    public static final String NS_DEFAULT_CT = "http://www.pharmml.org/pharmml/0.8/CommonTypes";
    public static final String NS_DEFAULT_DS = "http://www.pharmml.org/pharmml/0.8/Dataset";
    public static final String NS_DEFAULT_MATH = "http://www.pharmml.org/pharmml/0.8/Maths";
    public static final String NS_DEFAULT_MDEF = "http://www.pharmml.org/pharmml/0.8/ModelDefinition";
    public static final String NS_DEFAULT_TD = "http://www.pharmml.org/pharmml/0.8/TrialDesign";
    public static final String NS_DEFAULT_MSTEPS = "http://www.pharmml.org/pharmml/0.8/ModellingSteps";
    public static final String NS_DEFAULT_MML = "http://www.pharmml.org/pharmml/0.8/PharmML";
    public static final String NS_DEFAULT_UNCERTML = "http://www.uncertml.org/3.0";
    public static final String NS_DEFAULT_PROBONTO = "http://www.pharmml.org/probonto/ProbOnto";
    protected final String NS_DOC_ROOT;
    protected final String NS_DOC_CT;
    protected final String NS_DOC_DS;
    protected final String NS_DOC_MATH;
    protected final String NS_DOC_MDEF;
    protected final String NS_DOC_TD;
    protected final String NS_DOC_MSTEPS;
    protected final String NS_DOC_MML;
    protected final String NS_DOC_PROBONTO;
    private static final String NS_OLD_ROOT = "http://www.pharmml.org/2013/03/";
    public static final String NS_OLD_CT = "http://www.pharmml.org/2013/03/CommonTypes";
    public static final String NS_OLD_DS = "http://www.pharmml.org/2013/08/Dataset";
    public static final String NS_OLD_MATH = "http://www.pharmml.org/2013/03/Maths";
    public static final String NS_OLD_MDEF = "http://www.pharmml.org/2013/03/ModelDefinition";
    public static final String NS_OLD_TD = "http://www.pharmml.org/2013/03/TrialDesign";
    public static final String NS_OLD_MSTEPS = "http://www.pharmml.org/2013/03/ModellingSteps";
    public static final String NS_OLD_MML = "http://www.pharmml.org/2013/03/PharmML";

    public NamespaceFilter(PharmMLVersion writtenVersion) {
        if (writtenVersion == null) {
            throw new IllegalArgumentException("Written version cannot be null");
        }
        if (writtenVersion.isEqualOrLaterThan(PharmMLVersion.V0_6)) {
            this.NS_DOC_ROOT = String.format(NS_PATTERN_ROOT, writtenVersion.getURIVersion());
            this.NS_DOC_CT = String.format(NS_PATTERN_CT, writtenVersion.getURIVersion());
            this.NS_DOC_DS = String.format(NS_PATTERN_DS, writtenVersion.getURIVersion());
            this.NS_DOC_MATH = String.format(NS_PATTERN_MATH, writtenVersion.getURIVersion());
            this.NS_DOC_MDEF = String.format(NS_PATTERN_MDEF, writtenVersion.getURIVersion());
            this.NS_DOC_TD = String.format(NS_PATTERN_TD, writtenVersion.getURIVersion());
            this.NS_DOC_MSTEPS = String.format(NS_PATTERN_MSTEPS, writtenVersion.getURIVersion());
            this.NS_DOC_MML = String.format(NS_PATTERN_MML, writtenVersion.getURIVersion());
            this.NS_DOC_PROBONTO = writtenVersion.isEqualOrLaterThan(PharmMLVersion.V0_7_3) ? NS_DEFAULT_PROBONTO : this.NS_DOC_MSTEPS;
        } else {
            this.NS_DOC_ROOT = NS_OLD_ROOT;
            this.NS_DOC_CT = NS_OLD_CT;
            this.NS_DOC_DS = NS_OLD_DS;
            this.NS_DOC_MATH = NS_OLD_MATH;
            this.NS_DOC_MDEF = NS_OLD_MDEF;
            this.NS_DOC_TD = NS_OLD_TD;
            this.NS_DOC_MSTEPS = NS_OLD_MSTEPS;
            this.NS_DOC_MML = NS_OLD_MML;
            this.NS_DOC_PROBONTO = null;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
        super.startElement(this.filterInputNamespace(arg0), arg1, arg2, arg3);
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        super.endElement(this.filterInputNamespace(arg0), arg1, arg2);
    }

    private String filterInputNamespace(String ns) {
        if (ns == null) {
            return null;
        }
        if (ns.equals(this.NS_DOC_CT)) {
            return NS_DEFAULT_CT;
        }
        if (ns.equals(this.NS_DOC_DS)) {
            return NS_DEFAULT_DS;
        }
        if (ns.equals(this.NS_DOC_MATH)) {
            return NS_DEFAULT_MATH;
        }
        if (ns.equals(this.NS_DOC_MDEF)) {
            return NS_DEFAULT_MDEF;
        }
        if (ns.equals(this.NS_DOC_MSTEPS)) {
            return NS_DEFAULT_MSTEPS;
        }
        if (ns.equals(this.NS_DOC_TD)) {
            return NS_DEFAULT_TD;
        }
        if (ns.equals(this.NS_DOC_MML)) {
            return NS_DEFAULT_MML;
        }
        return ns;
    }

    private String filterOutputNamespace(String ns) {
        if (ns == null) {
            return null;
        }
        if (ns.equals(NS_DEFAULT_CT)) {
            return this.NS_DOC_CT;
        }
        if (ns.equals(NS_DEFAULT_DS)) {
            return this.NS_DOC_DS;
        }
        if (ns.equals(NS_DEFAULT_MATH)) {
            return this.NS_DOC_MATH;
        }
        if (ns.equals(NS_DEFAULT_MDEF)) {
            return this.NS_DOC_MDEF;
        }
        if (ns.equals(NS_DEFAULT_MSTEPS)) {
            return this.NS_DOC_MSTEPS;
        }
        if (ns.equals(NS_DEFAULT_TD)) {
            return this.NS_DOC_TD;
        }
        if (ns.equals(NS_DEFAULT_MML)) {
            return this.NS_DOC_MML;
        }
        return ns;
    }

    public final XMLStreamReader getXMLStreamReader(final InputStream is) throws XMLStreamException {
        XMLStreamReader filterReader = new XMLStreamReader(){
            XMLStreamReader reader;
            {
                this.reader = XMLInputFactory.newInstance().createXMLStreamReader(is);
            }

            @Override
            public Object getProperty(String name) throws IllegalArgumentException {
                return this.reader.getProperty(name);
            }

            @Override
            public int next() throws XMLStreamException {
                return this.reader.next();
            }

            @Override
            public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
                this.reader.require(type, NamespaceFilter.this.filterInputNamespace(namespaceURI), localName);
            }

            @Override
            public String getElementText() throws XMLStreamException {
                return this.reader.getElementText();
            }

            @Override
            public int nextTag() throws XMLStreamException {
                return this.reader.nextTag();
            }

            @Override
            public boolean hasNext() throws XMLStreamException {
                return this.reader.hasNext();
            }

            @Override
            public void close() throws XMLStreamException {
                this.reader.close();
            }

            @Override
            public String getNamespaceURI(String prefix) {
                return NamespaceFilter.this.filterInputNamespace(this.reader.getNamespaceURI(prefix));
            }

            @Override
            public boolean isStartElement() {
                return this.reader.isStartElement();
            }

            @Override
            public boolean isEndElement() {
                return this.reader.isEndElement();
            }

            @Override
            public boolean isCharacters() {
                return this.reader.isCharacters();
            }

            @Override
            public boolean isWhiteSpace() {
                return this.reader.isWhiteSpace();
            }

            @Override
            public String getAttributeValue(String namespaceURI, String localName) {
                return this.reader.getAttributeValue(NamespaceFilter.this.filterInputNamespace(namespaceURI), localName);
            }

            @Override
            public int getAttributeCount() {
                return this.reader.getAttributeCount();
            }

            @Override
            public QName getAttributeName(int index) {
                return this.reader.getAttributeName(index);
            }

            @Override
            public String getAttributeNamespace(int index) {
                return NamespaceFilter.this.filterInputNamespace(this.reader.getAttributeNamespace(index));
            }

            @Override
            public String getAttributeLocalName(int index) {
                return this.reader.getAttributeLocalName(index);
            }

            @Override
            public String getAttributePrefix(int index) {
                return this.reader.getAttributePrefix(index);
            }

            @Override
            public String getAttributeType(int index) {
                return this.reader.getAttributeType(index);
            }

            @Override
            public String getAttributeValue(int index) {
                return this.reader.getAttributeValue(index);
            }

            @Override
            public boolean isAttributeSpecified(int index) {
                return this.reader.isAttributeSpecified(index);
            }

            @Override
            public int getNamespaceCount() {
                return this.reader.getNamespaceCount();
            }

            @Override
            public String getNamespacePrefix(int index) {
                return this.reader.getNamespacePrefix(index);
            }

            @Override
            public String getNamespaceURI(int index) {
                return NamespaceFilter.this.filterInputNamespace(this.reader.getNamespaceURI(index));
            }

            @Override
            public NamespaceContext getNamespaceContext() {
                final NamespaceContext context = this.reader.getNamespaceContext();
                return new NamespaceContext(){

                    public Iterator<?> getPrefixes(String namespaceURI) {
                        return context.getPrefixes(namespaceURI);
                    }

                    @Override
                    public String getPrefix(String namespaceURI) {
                        return context.getPrefix(namespaceURI);
                    }

                    @Override
                    public String getNamespaceURI(String prefix) {
                        return NamespaceFilter.this.filterInputNamespace(context.getNamespaceURI(prefix));
                    }
                };
            }

            @Override
            public int getEventType() {
                return this.reader.getEventType();
            }

            @Override
            public String getText() {
                return this.reader.getText();
            }

            @Override
            public char[] getTextCharacters() {
                return this.reader.getTextCharacters();
            }

            @Override
            public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
                return this.reader.getTextCharacters(sourceStart, target, targetStart, length);
            }

            @Override
            public int getTextStart() {
                return this.reader.getTextStart();
            }

            @Override
            public int getTextLength() {
                return this.reader.getTextLength();
            }

            @Override
            public String getEncoding() {
                return this.reader.getEncoding();
            }

            @Override
            public boolean hasText() {
                return this.reader.hasText();
            }

            @Override
            public Location getLocation() {
                return this.reader.getLocation();
            }

            @Override
            public QName getName() {
                QName qname = this.reader.getName();
                QName newQname = new QName(NamespaceFilter.this.filterInputNamespace(qname.getNamespaceURI()), qname.getLocalPart(), qname.getPrefix());
                return newQname;
            }

            @Override
            public String getLocalName() {
                return this.reader.getLocalName();
            }

            @Override
            public boolean hasName() {
                return this.reader.hasName();
            }

            @Override
            public String getNamespaceURI() {
                return NamespaceFilter.this.filterInputNamespace(this.reader.getNamespaceURI());
            }

            @Override
            public String getPrefix() {
                return this.reader.getPrefix();
            }

            @Override
            public String getVersion() {
                return this.reader.getVersion();
            }

            @Override
            public boolean isStandalone() {
                return this.reader.isStandalone();
            }

            @Override
            public boolean standaloneSet() {
                return this.reader.standaloneSet();
            }

            @Override
            public String getCharacterEncodingScheme() {
                return this.reader.getCharacterEncodingScheme();
            }

            @Override
            public String getPITarget() {
                return this.reader.getPITarget();
            }

            @Override
            public String getPIData() {
                return this.reader.getPIData();
            }
        };
        return filterReader;
    }

    public final XMLStreamWriter getXMLStreamWriter(final XMLStreamWriter writer) throws XMLStreamException {
        return new XMLStreamWriter(){

            @Override
            public void writeStartElement(String localName) throws XMLStreamException {
                writer.writeStartElement(localName);
            }

            @Override
            public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
                writer.writeStartElement(NamespaceFilter.this.filterOutputNamespace(namespaceURI), localName);
            }

            @Override
            public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
                writer.writeEmptyElement(NamespaceFilter.this.filterOutputNamespace(namespaceURI), localName);
            }

            @Override
            public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
                writer.writeEmptyElement(prefix, localName, NamespaceFilter.this.filterOutputNamespace(namespaceURI));
            }

            @Override
            public void writeEmptyElement(String localName) throws XMLStreamException {
                writer.writeEmptyElement(localName);
            }

            @Override
            public void writeEndElement() throws XMLStreamException {
                writer.writeEndElement();
            }

            @Override
            public void writeEndDocument() throws XMLStreamException {
                writer.writeEndDocument();
            }

            @Override
            public void close() throws XMLStreamException {
                writer.close();
            }

            @Override
            public void flush() throws XMLStreamException {
                writer.flush();
            }

            @Override
            public void writeAttribute(String localName, String value) throws XMLStreamException {
                writer.writeAttribute(localName, value);
            }

            @Override
            public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
                writer.writeAttribute(prefix, NamespaceFilter.this.filterOutputNamespace(namespaceURI), localName, value);
            }

            @Override
            public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
                writer.writeAttribute(NamespaceFilter.this.filterOutputNamespace(namespaceURI), localName, value);
            }

            @Override
            public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
                writer.writeNamespace(prefix, NamespaceFilter.this.filterOutputNamespace(namespaceURI));
            }

            @Override
            public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
                writer.writeDefaultNamespace(NamespaceFilter.this.filterOutputNamespace(namespaceURI));
            }

            @Override
            public void writeComment(String data) throws XMLStreamException {
                writer.writeComment(data);
            }

            @Override
            public void writeProcessingInstruction(String target) throws XMLStreamException {
                writer.writeProcessingInstruction(target);
            }

            @Override
            public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
                writer.writeProcessingInstruction(target, data);
            }

            @Override
            public void writeCData(String data) throws XMLStreamException {
                writer.writeCData(data);
            }

            @Override
            public void writeDTD(String dtd) throws XMLStreamException {
                writer.writeDTD(dtd);
            }

            @Override
            public void writeEntityRef(String name) throws XMLStreamException {
                writer.writeEntityRef(name);
            }

            @Override
            public void writeStartDocument() throws XMLStreamException {
                writer.writeStartDocument();
            }

            @Override
            public void writeStartDocument(String version) throws XMLStreamException {
                writer.writeStartDocument(version);
            }

            @Override
            public void writeStartDocument(String encoding, String version) throws XMLStreamException {
                writer.writeStartDocument(encoding, version);
            }

            @Override
            public void writeCharacters(String text) throws XMLStreamException {
                writer.writeCharacters(text);
            }

            @Override
            public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
                writer.writeCharacters(text, start, len);
            }

            @Override
            public String getPrefix(String uri) throws XMLStreamException {
                return writer.getPrefix(NamespaceFilter.this.filterOutputNamespace(uri));
            }

            @Override
            public void setPrefix(String prefix, String uri) throws XMLStreamException {
                writer.setPrefix(prefix, NamespaceFilter.this.filterOutputNamespace(uri));
            }

            @Override
            public void setDefaultNamespace(String uri) throws XMLStreamException {
                writer.setDefaultNamespace(NamespaceFilter.this.filterOutputNamespace(uri));
            }

            @Override
            public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
                writer.setNamespaceContext(context);
            }

            @Override
            public NamespaceContext getNamespaceContext() {
                return writer.getNamespaceContext();
            }

            @Override
            public Object getProperty(String name) throws IllegalArgumentException {
                return writer.getProperty(name);
            }

            @Override
            public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
                writer.writeStartElement(prefix, localName, NamespaceFilter.this.filterOutputNamespace(namespaceURI));
            }
        };
    }

    public final XMLStreamWriter getXMLStreamWriter(OutputStream os) throws XMLStreamException {
        return this.getXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(os));
    }

    public final XMLStreamWriter getXMLStreamWriter(Writer writer) throws XMLStreamException {
        return this.getXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(writer));
    }

    void filterRawText(InputStream is, OutputStream os) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        OutputStreamWriter osw = new OutputStreamWriter(os);
        while ((line = br.readLine()) != null) {
            line = line.replaceAll("xmlns(:\\w+)?=\"http://www.pharmml.org/[^\"]+/([^\"]+)\"", "xmlns$1=\"" + this.NS_DOC_ROOT + "$2\"");
            line = line.replaceAll("xmlns(:\\w+)?=\"http://www.pharmml.org/[^\"]+/ProbOnto\"", "xmlns$1=\"http://www.pharmml.org/probonto/ProbOnto\"");
            line = line.replaceAll("xmlns(:\\w+)?=\"http://www.pharmml.org/2013/03/Dataset", "xmlns$1=\"http://www.pharmml.org/2013/08/Dataset");
            osw.append(line);
            osw.append("\n");
        }
        br.close();
        osw.close();
    }

    public String getMMLNamespaceURI() {
        return this.NS_DOC_MML;
    }
}

