/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.IPharmMLResource;
import eu.ddmore.libpharmml.IValidationReport;
import eu.ddmore.libpharmml.IdFactory;
import eu.ddmore.libpharmml.dom.Identifiable;
import eu.ddmore.libpharmml.dom.PharmML;
import eu.ddmore.libpharmml.impl.Utils;
import java.util.Hashtable;
import java.util.Map;

public class PharmMLResourceImpl
implements IPharmMLResource {
    private final PharmML dom;
    private final IValidationReport creationReport;
    private IdFactory idFactory;
    private final Map<String, Boolean> parameters;

    PharmMLResourceImpl(PharmML dom, IValidationReport creationReport, IdFactory idFactory) {
        this.dom = dom;
        this.creationReport = creationReport;
        this.idFactory = idFactory;
        this.parameters = new Hashtable<String, Boolean>();
        this.parameters.put("pharmmlresource.param.autoset_id", Boolean.TRUE);
        this.parameters.put("pharmmlresource.param.describe_variables", Boolean.FALSE);
    }

    @Override
    public PharmML getDom() {
        return this.dom;
    }

    @Override
    public IValidationReport getCreationReport() {
        return this.creationReport;
    }

    @Override
    public Identifiable find(String id) {
        if (this.idFactory != null) {
            return this.idFactory.getIdentifiable(id);
        }
        return Utils.findById(this.dom, id);
    }

    @Override
    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    @Override
    public void setIdFactory(IdFactory idFactory) {
        this.idFactory = idFactory;
    }

    @Override
    public void setParameter(String param, Boolean value) {
        this.parameters.put(param, value);
    }

    @Override
    public Boolean getParameter(String argument) {
        return this.parameters.get(argument);
    }
}

