/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.impl.LoggerWrapper;
import eu.ddmore.libpharmml.impl.NamespaceFilter;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.xerces.util.XMLCatalogResolver;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class PharmMLSchemaFactory {
    private static PharmMLSchemaFactory anInstance = null;

    public static PharmMLSchemaFactory getInstance() {
        if (anInstance == null) {
            anInstance = new PharmMLSchemaFactory();
        }
        return anInstance;
    }

    public Schema createPharmMlSchema(PharmMLVersion version, NamespaceType type) {
        try {
            Schema mySchema;
            String[] locationData = this.resolveCatalogLocation(version, type);
            String catalogLocation = locationData[0];
            String systemURI = locationData[1];
            URL url = this.getClass().getResource(catalogLocation);
            String[] catalogs = new String[]{url.toExternalForm()};
            XMLCatalogResolver resolver = new XMLCatalogResolver();
            resolver.setCatalogList(catalogs);
            String val = resolver.resolveSystem(systemURI);
            StreamSource src = new StreamSource(val);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            sf.setResourceResolver((LSResourceResolver)resolver);
            try {
                mySchema = sf.newSchema(new StreamSource[]{src});
            }
            catch (SAXException e) {
                LoggerWrapper.getLogger().severe("Could not find " + (Object)((Object)type) + " schemas for version " + version.getValue());
                LoggerWrapper.getLogger().info("-src: " + src + " -catalogs: " + catalogs + " -url: " + url + " -catalogLocation: " + catalogLocation + " -systemURI: " + systemURI);
                throw new RuntimeException(e.getMessage(), e);
            }
            return mySchema;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String[] resolveCatalogLocation(PharmMLVersion version, NamespaceType type) {
        String systemURI;
        String catalogLocation;
        if (version.isEqualOrLaterThan(PharmMLVersion.V0_8)) {
            catalogLocation = version.getCatalogLocation();
            systemURI = "http://www.pharmml.org/pharmml/0.8/PharmML";
        } else if (type.equals((Object)NamespaceType.DEFAULT)) {
            catalogLocation = version.getDefaultCatalogLocation();
            systemURI = "http://www.pharmml.org/pharmml/0.8/PharmML";
        } else {
            catalogLocation = version.getCatalogLocation();
            systemURI = new NamespaceFilter(version).getMMLNamespaceURI();
        }
        return new String[]{catalogLocation, systemURI};
    }

    @Deprecated
    public Schema createPharmMlSchema() {
        return this.createPharmMlSchema(PharmMLVersion.V0_2_1, NamespaceType.DEFAULT);
    }

    public static enum NamespaceType {
        DEFAULT,
        OLD;

    }
}

