/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.IPharmMLResource;
import eu.ddmore.libpharmml.IPharmMLValidator;
import eu.ddmore.libpharmml.IValidationReport;
import eu.ddmore.libpharmml.dom.PharmML;
import eu.ddmore.libpharmml.impl.IdFactoryImpl;
import eu.ddmore.libpharmml.impl.LoggerWrapper;
import eu.ddmore.libpharmml.impl.MarshalListener;
import eu.ddmore.libpharmml.impl.MarshallerImpl;
import eu.ddmore.libpharmml.impl.PharmMLSchemaFactory;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import eu.ddmore.libpharmml.impl.ValidationReportFactory;
import eu.ddmore.libpharmml.validation.PharmMLValidator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PharmMLValidatorImpl
implements IPharmMLValidator {
    @Override
    public IValidationReport createValidationReport(IPharmMLResource resource) {
        try {
            PharmML dom = resource.getDom();
            String writtenVersion = dom.getWrittenVersion();
            PharmMLVersion docVersion = null;
            if (writtenVersion != null) {
                docVersion = PharmMLVersion.getEnum(writtenVersion);
            }
            if (docVersion == null) {
                docVersion = PharmMLVersion.DEFAULT;
                LoggerWrapper.getLogger().warning("Missing or unknown writtenVersion of PharmML document. Using default version (" + docVersion.getValue() + ").");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MarshallerImpl m = new MarshallerImpl();
            MarshalListener ml = new MarshalListener(docVersion, new IdFactoryImpl());
            ml.autosetId(false);
            m.marshall(dom, baos, ml);
            StreamSource source = new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
            Schema schema = PharmMLSchemaFactory.getInstance().createPharmMlSchema(docVersion, PharmMLSchemaFactory.NamespaceType.OLD);
            Validator schemaValidator = schema.newValidator();
            final ValidationReportFactory rptFact = new ValidationReportFactory();
            schemaValidator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    rptFact.handleWarning(exception.getMessage() + "[" + exception.getLineNumber() + "," + exception.getColumnNumber() + "].");
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    rptFact.handleError("SCHEMA", exception.getMessage() + "[" + exception.getLineNumber() + "," + exception.getColumnNumber() + "].");
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    rptFact.handleError("SCHEMA", exception.getMessage() + "[" + exception.getLineNumber() + "," + exception.getColumnNumber() + "].");
                }
            });
            schemaValidator.validate(source);
            if (docVersion.isEqualOrLaterThan(PharmMLVersion.V0_6)) {
                PharmMLValidator pharmmlValidator = new PharmMLValidator(dom);
                pharmmlValidator.validate(rptFact);
            } else {
                LoggerWrapper.getLogger().info("Version is below " + (Object)((Object)PharmMLVersion.V0_6) + ", no complex validation performed.");
            }
            return rptFact.createReport();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

