/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.impl.Messages;

public enum PharmMLVersion {
    V0_2_1("0.2.1", null, "MarshallerImpl.xmlCatalogLocation.0.2.1", 1),
    V0_3("0.3", null, "MarshallerImpl.xmlCatalogLocation.0.3", 2),
    V0_3_1("0.3.1", null, "MarshallerImpl.xmlCatalogLocation.0.3.1", 3),
    V0_4("0.4", null, "MarshallerImpl.xmlCatalogLocation.0.4", 4),
    V0_4_1("0.4.1", null, "MarshallerImpl.xmlCatalogLocation.0.4.1", 5),
    V0_5("0.5", null, "MarshallerImpl.xmlCatalogLocation.0.5", 6),
    V0_5_1("0.5.1", null, "MarshallerImpl.xmlCatalogLocation.0.5.1", 7),
    V0_6("0.6", "0.6", "MarshallerImpl.xmlCatalogLocation.0.6", 8),
    V0_6_1("0.6.1", "0.6", "MarshallerImpl.xmlCatalogLocation.0.6", 9),
    V0_6_2("0.6.2", "0.6", "MarshallerImpl.xmlCatalogLocation.0.6", 10),
    V0_7_3("0.7.3", "0.7", "MarshallerImpl.xmlCatalogLocation.0.7.3", 11),
    V0_8("0.8", "0.8", "MarshallerImpl.xmlCatalogLocation.0.8", 12),
    V0_8_1("0.8.1", "0.8", "MarshallerImpl.xmlCatalogLocation.0.8.1", 13);

    public static final PharmMLVersion DEFAULT;
    private final String version;
    private final String uriVersion;
    private final String catalogLocation;
    private final int index;

    private PharmMLVersion(String version, String uriVersion, String catalogMessage, int index) {
        this.version = version;
        this.uriVersion = uriVersion;
        this.catalogLocation = Messages.getString(catalogMessage);
        this.index = index;
    }

    public String getValue() {
        return this.version;
    }

    public String getURIVersion() {
        return this.uriVersion;
    }

    public String getCatalogLocation() {
        return this.catalogLocation;
    }

    public String getDefaultCatalogLocation() {
        if (this.isEqualOrLaterThan(V0_8)) {
            return this.catalogLocation;
        }
        return this.catalogLocation.replace("/xmlCatalog.xml", "/default/xmlCatalog.xml");
    }

    public static PharmMLVersion getEnum(String version) {
        for (PharmMLVersion enumVersion : PharmMLVersion.values()) {
            if (!version.equals(enumVersion.getValue())) continue;
            return enumVersion;
        }
        if (version.startsWith("0.7")) {
            return V0_7_3;
        }
        return null;
    }

    public String toString() {
        return this.getValue();
    }

    public boolean isEqualOrLaterThan(PharmMLVersion version) {
        return this.index >= version.index;
    }

    public boolean isBetween(PharmMLVersion from, PharmMLVersion to) {
        return this.index >= from.index && this.index <= to.index;
    }

    static {
        DEFAULT = V0_8_1;
    }
}

