/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.IErrorHandler;
import eu.ddmore.libpharmml.IdFactory;
import eu.ddmore.libpharmml.dom.AbstractTreeNode;
import eu.ddmore.libpharmml.dom.Identifiable;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.dataset.DatasetMap;
import eu.ddmore.libpharmml.dom.modellingsteps.TargetTool;
import eu.ddmore.libpharmml.dom.tags.AdaptedClass;
import eu.ddmore.libpharmml.exceptions.AnnotationException;
import eu.ddmore.libpharmml.impl.LoggerWrapper;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import eu.ddmore.libpharmml.impl.Utils;
import eu.ddmore.libpharmml.util.annotations.HasElementRenamed;
import eu.ddmore.libpharmml.util.annotations.HasElementsRenamed;
import eu.ddmore.libpharmml.util.annotations.RenamedElement;
import eu.ddmore.libpharmml.validation.PharmMLValidator;
import eu.ddmore.libpharmml.validation.Validatable;
import eu.ddmore.libpharmml.validation.exceptions.DuplicateIdentifierException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.tree.TreeNode;
import javax.xml.bind.Unmarshaller;

public class UnmarshalListener
extends Unmarshaller.Listener {
    private final PharmMLVersion docVersion;
    private final IdFactory idFactory;
    private final IErrorHandler errorHandler;

    public UnmarshalListener(PharmMLVersion docVersion, IdFactory idFactory, IErrorHandler errorHandler) {
        this.docVersion = docVersion;
        this.idFactory = idFactory;
        this.errorHandler = errorHandler;
    }

    public void beforeUnmarshal(Object target, Object parent) {
        if (target instanceof PharmMLElement) {
            ((PharmMLElement)target).setUnmarshalVersion(this.docVersion);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterUnmarshal(Object target, Object parent) {
        this.checkForRenamedElements(target);
        if (target instanceof Identifiable && ((Identifiable)target).getId() != null) {
            try {
                Identifiable identifiable;
                if (target instanceof AdaptedClass) {
                    Object POJO = ((AdaptedClass)target).getUnmappedObject();
                    if (!(POJO instanceof Identifiable)) throw new RuntimeException("POJO \"" + POJO + "\" doesn't implement Identifiable while adapted class does, or is null");
                    identifiable = (Identifiable)POJO;
                } else {
                    identifiable = (Identifiable)target;
                }
                this.idFactory.storeIdentifiable(identifiable);
                LoggerWrapper.getLogger().info("Stored object with id \"" + identifiable.getId() + "\"");
            }
            catch (DuplicateIdentifierException e) {
                LoggerWrapper.getLogger().warning("Identifier \"" + e.getDuplicate().getId() + "\" is duplicate.");
            }
        }
        if (target instanceof Validatable && this.docVersion.isEqualOrLaterThan(PharmMLVersion.V0_6)) {
            ((Validatable)target).validate(this.errorHandler);
        }
        if (target instanceof AbstractTreeNode && parent instanceof TreeNode) {
            ((AbstractTreeNode)target).setParent((TreeNode)parent);
        }
        if (target instanceof DatasetMap) {
            this.validateDatasetMap((DatasetMap)target);
        }
        if (!(target instanceof TargetTool)) return;
        this.validateTargetTool((TargetTool)target);
    }

    protected final void checkForRenamedElements(Object source) {
        Class<?> _class = source.getClass();
        this.checkForRenamedElements(_class, source);
    }

    private void checkForRenamedElements(Class<?> _class, Object source) {
        Class<?> superclass;
        Annotation annotation;
        if (_class.isAnnotationPresent(HasElementRenamed.class)) {
            annotation = _class.getAnnotation(HasElementRenamed.class);
            this.handleAnnotation((HasElementRenamed)annotation, _class, source);
        }
        if (_class.isAnnotationPresent(HasElementsRenamed.class)) {
            annotation = _class.getAnnotation(HasElementsRenamed.class);
            this.handleAnnotation((HasElementsRenamed)annotation, _class, source);
        }
        if ((superclass = _class.getSuperclass()) != null) {
            this.checkForRenamedElements(superclass, source);
        }
    }

    private void handleAnnotation(HasElementRenamed annotation, Class<?> _class, Object target) {
        try {
            String transientField = annotation.transientField();
            ArrayList<PharmMLVersion> versionList = new ArrayList<PharmMLVersion>();
            HashMap<PharmMLVersion, String> versionToField = new HashMap<PharmMLVersion, String>();
            for (RenamedElement renamedEl : annotation.mappedFields()) {
                versionList.add(renamedEl.since());
                versionToField.put(renamedEl.since(), renamedEl.field());
            }
            Collections.sort(versionList, Collections.reverseOrder());
            for (PharmMLVersion version : versionList) {
                if (!this.docVersion.isEqualOrLaterThan(version)) continue;
                String mappedField = (String)versionToField.get((Object)version);
                Utils.copyField(target, _class, mappedField, transientField, true);
                LoggerWrapper.getLogger().info("Using " + mappedField + " as " + transientField + " in " + target);
                break;
            }
        }
        catch (NoSuchFieldException e) {
            throw new AnnotationException(target, "1 field does not exist.");
        }
    }

    private void handleAnnotation(HasElementsRenamed annotation, Class<?> _class, Object target) {
        for (HasElementRenamed singleAnnot : annotation.value()) {
            this.handleAnnotation(singleAnnot, _class, target);
        }
    }

    private void validateDatasetMap(DatasetMap dm) {
        PharmMLValidator.validateDatasetMap(dm, this.errorHandler);
    }

    private void validateTargetTool(TargetTool tt) {
        PharmMLValidator.validateTargetTool(tt, this.errorHandler);
    }
}

