/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.IValidationError;
import eu.ddmore.libpharmml.dom.AbstractTreeNode;
import javax.xml.bind.ValidationEventLocator;

public class ValidationErrorImpl
implements IValidationError {
    private final String ruleId;
    private final String msg;
    private final AbstractTreeNode invalidObject;
    private final Integer lineNumber;

    public ValidationErrorImpl(String ruleId, String msg) {
        this.ruleId = ruleId;
        this.msg = msg;
        this.invalidObject = null;
        this.lineNumber = null;
    }

    public ValidationErrorImpl(String ruleId, String msg, ValidationEventLocator locator) {
        this.ruleId = ruleId;
        this.msg = msg;
        this.invalidObject = null;
        this.lineNumber = locator.getLineNumber();
    }

    public ValidationErrorImpl(String ruleId, String msg, AbstractTreeNode invalidObject) {
        this.ruleId = ruleId;
        this.msg = msg;
        this.invalidObject = invalidObject;
        this.lineNumber = null;
    }

    @Override
    public String getRuleId() {
        return this.ruleId;
    }

    @Override
    public String getErrorMsg() {
        return this.msg;
    }

    @Override
    public AbstractTreeNode getInvalidObject() {
        return this.invalidObject;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.msg == null ? 0 : this.msg.hashCode());
        result = 31 * result + (this.ruleId == null ? 0 : this.ruleId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationErrorImpl other = (ValidationErrorImpl)obj;
        if (this.msg == null ? other.msg != null : !this.msg.equals(other.msg)) {
            return false;
        }
        return !(this.ruleId == null ? other.ruleId != null : !this.ruleId.equals(other.ruleId));
    }

    public String toString() {
        if (this.invalidObject != null) {
            return "ValidationErrorImpl [ruleId=" + this.ruleId + ", msg=\"" + this.msg + "\", object=" + this.invalidObject + "]";
        }
        if (this.lineNumber != null) {
            return "ValidationErrorImpl [ruleId=" + this.ruleId + ", msg=\"" + this.msg + "\", line=" + this.lineNumber + "]";
        }
        return "ValidationErrorImpl [ruleId=" + this.ruleId + ", msg=\"" + this.msg + "\"]";
    }

    @Override
    public Integer getLineNumber() {
        return this.lineNumber;
    }
}

