/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.impl;

import eu.ddmore.libpharmml.IErrorHandler;
import eu.ddmore.libpharmml.IValidationError;
import eu.ddmore.libpharmml.IValidationReport;
import eu.ddmore.libpharmml.dom.AbstractTreeNode;
import eu.ddmore.libpharmml.impl.ValidationErrorImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.ValidationEventLocator;

public class ValidationReportFactory
implements IErrorHandler {
    public static final String SCHEMA_ERR_CODE = "SCHEMA";
    private final List<IValidationError> errors = new ArrayList<IValidationError>();

    @Override
    public void handleWarning(String exception) {
    }

    @Override
    @Deprecated
    public void handleError(String exception) {
        this.handleError(SCHEMA_ERR_CODE, exception, (AbstractTreeNode)null);
    }

    public IValidationReport createReport() {
        return new IValidationReport(){

            @Override
            public int numErrors() {
                return ValidationReportFactory.this.errors.size();
            }

            @Override
            public boolean isValid() {
                return ValidationReportFactory.this.errors.isEmpty();
            }

            @Override
            public IValidationError getError(int errNum) {
                return (IValidationError)ValidationReportFactory.this.errors.get(errNum - 1);
            }

            @Override
            public Iterator<IValidationError> errorIterator() {
                return ValidationReportFactory.this.errors.iterator();
            }
        };
    }

    public boolean addError(IValidationError error) {
        return this.errors.add(error);
    }

    @Override
    public void handleError(String id, String errMsg, ValidationEventLocator locator) {
        this.errors.add(new ValidationErrorImpl(id, errMsg, locator));
    }

    @Override
    public void handleError(String id, String errMsg, AbstractTreeNode invalidObject) {
        this.errors.add(new ValidationErrorImpl(id, errMsg, invalidObject));
    }

    @Override
    public void handleError(String id, String errMsg) {
        this.errors.add(new ValidationErrorImpl(id, errMsg));
    }
}

