/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SubList<E>
implements List<E> {
    private List<? super E> masterList;
    private Class<E> filter;

    public SubList(List<? super E> master, Class<E> filter) {
        if (master == null || filter == null) {
            throw new IllegalArgumentException();
        }
        this.masterList = master;
        this.filter = filter;
    }

    private List<E> subList() {
        ArrayList<E> subList = new ArrayList<E>();
        for (E element : this.masterList) {
            if (!this.filter.isInstance(element)) continue;
            subList.add(element);
        }
        return subList;
    }

    @Override
    public int size() {
        return this.subList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.subList().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.subList().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.subList().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.subList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.subList().toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.masterList.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.masterList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.subList().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.masterList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.masterList.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.masterList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.subList().retainAll(c);
    }

    @Override
    public void clear() {
        for (E element : this.subList()) {
            this.masterList.remove(element);
        }
    }

    @Override
    public E get(int index) {
        return this.subList().get(index);
    }

    @Override
    public E set(int index, E element) {
        int realIndex = this.masterList.indexOf(this.subList().get(index));
        return this.masterList.set(realIndex, element);
    }

    @Override
    public void add(int index, E element) {
        if (index == 0) {
            this.masterList.add(index, element);
        } else {
            int previousIndex = this.masterList.indexOf(this.subList().get(index - 1));
            this.masterList.add(previousIndex + 1, element);
        }
    }

    @Override
    public E remove(int index) {
        E removedEl = this.subList().get(index);
        this.masterList.remove(removedEl);
        return removedEl;
    }

    @Override
    public int indexOf(Object o) {
        return this.subList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.subList().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.subList().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.subList().listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.subList().subList(fromIndex, toIndex);
    }
}

