/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.validation;

import eu.ddmore.libpharmml.IErrorHandler;
import eu.ddmore.libpharmml.dom.PharmML;
import eu.ddmore.libpharmml.dom.dataset.ColumnDefinition;
import eu.ddmore.libpharmml.dom.dataset.ColumnMapping;
import eu.ddmore.libpharmml.dom.dataset.DatasetMap;
import eu.ddmore.libpharmml.dom.modellingsteps.TargetTool;
import eu.ddmore.libpharmml.impl.LoggerWrapper;
import eu.ddmore.libpharmml.validation.SymbolResolver;
import eu.ddmore.libpharmml.validation.Validatable;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.tree.TreeNode;

public class PharmMLValidator {
    private final PharmML dom;

    public PharmMLValidator(PharmML dom) {
        this.dom = dom;
    }

    public void validate(IErrorHandler errorHandler) {
        SymbolResolver sr = new SymbolResolver(this.dom, errorHandler);
        sr.validateAll();
        this.recursiveValidate(errorHandler, this.dom);
    }

    private void recursiveValidate(IErrorHandler errorHandler, TreeNode el) {
        if (el instanceof Validatable) {
            LoggerWrapper.getLogger().info("Validating " + el);
            ((Validatable)((Object)el)).validate(errorHandler);
        }
        if (el instanceof DatasetMap) {
            LoggerWrapper.getLogger().info("Validating " + el);
            PharmMLValidator.validateDatasetMap((DatasetMap)((Object)el), errorHandler);
        }
        if (el instanceof TargetTool) {
            LoggerWrapper.getLogger().info("Validating " + el);
            PharmMLValidator.validateTargetTool((TargetTool)el, errorHandler);
        }
        Enumeration<? extends TreeNode> children = el.children();
        while (children.hasMoreElements()) {
            this.recursiveValidate(errorHandler, children.nextElement());
        }
    }

    public static void validateDatasetMap(DatasetMap dm, IErrorHandler errorHandler) {
        HashSet<String> columnIds = new HashSet<String>();
        if (dm.getDataSet() != null && dm.getDataSet().getDefinition() != null) {
            for (ColumnDefinition column : dm.getDataSet().getDefinition().getListOfColumn()) {
                if (column.getColumnId() == null) continue;
                columnIds.add(column.getColumnId());
            }
        }
        for (ColumnMapping cm : dm.getListOfColumnMapping()) {
            if (cm.getColumnRef() == null || cm.getColumnRef().getColumnIdRef() == null || columnIds.contains(cm.getColumnRef().getColumnIdRef())) continue;
            errorHandler.handleError("S13", "The column reference \"" + cm.getColumnRef().getColumnIdRef() + "\" does not resolve to" + " a column in the associated dataset.", cm);
        }
    }

    public static void validateTargetTool(TargetTool tt, IErrorHandler errorHandler) {
        HashSet<String> columnIds = new HashSet<String>();
        if (tt.getTargetToolData() != null && tt.getTargetToolData().getDefinition() != null) {
            for (ColumnDefinition column : tt.getTargetToolData().getDefinition().getListOfColumn()) {
                if (column.getColumnId() == null) continue;
                columnIds.add(column.getColumnId());
            }
        }
        for (ColumnMapping cm : tt.getColumnMapping()) {
            if (cm.getColumnRef() == null || cm.getColumnRef().getColumnIdRef() == null || columnIds.contains(cm.getColumnRef().getColumnIdRef())) continue;
            errorHandler.handleError("S13", "The column reference \"" + cm.getColumnRef().getColumnIdRef() + "\" does not resolve to" + " a column in the associated dataset.", cm);
        }
    }
}

