/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.validation;

import eu.ddmore.libpharmml.IErrorHandler;
import eu.ddmore.libpharmml.dom.AbstractTreeNode;
import eu.ddmore.libpharmml.dom.IndependentVariable;
import eu.ddmore.libpharmml.dom.PharmML;
import eu.ddmore.libpharmml.dom.commontypes.Block;
import eu.ddmore.libpharmml.dom.commontypes.FunctionDefinition;
import eu.ddmore.libpharmml.dom.commontypes.FunctionParameter;
import eu.ddmore.libpharmml.dom.commontypes.OidRef;
import eu.ddmore.libpharmml.dom.commontypes.Symbol;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.SymbolScope;
import eu.ddmore.libpharmml.dom.maths.FunctionCallType;
import eu.ddmore.libpharmml.dom.tags.PharmMLObject;
import eu.ddmore.libpharmml.dom.tags.ReferenceContainer;
import eu.ddmore.libpharmml.exceptions.DuplicatedBlockException;
import eu.ddmore.libpharmml.exceptions.DuplicatedSymbolException;
import eu.ddmore.libpharmml.impl.LoggerWrapper;
import eu.ddmore.libpharmml.validation.ValidationBlock;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;

public class SymbolResolver {
    private IErrorHandler errorHandler;
    private ValidationBlock globalBlock;
    private List<ValidationBlock> anonymousBlocks;
    private Map<String, ValidationBlock> blocks = new Hashtable<String, ValidationBlock>();
    private Map<String, ValidationBlock> functions = new Hashtable<String, ValidationBlock>();
    private List<FunctionCallType> functionCalls = new ArrayList<FunctionCallType>();
    private List<ReferenceContainer> containers;
    private Map<String, PharmMLObject> objects;

    public SymbolResolver(PharmML dom, IErrorHandler errorHandler) {
        this.anonymousBlocks = new ArrayList<ValidationBlock>();
        this.globalBlock = new ValidationBlock(null);
        this.errorHandler = errorHandler;
        this.containers = new ArrayList<ReferenceContainer>();
        this.objects = new Hashtable<String, PharmMLObject>();
        this.init(dom);
    }

    private void init(PharmML dom) {
        for (IndependentVariable iv : dom.getListOfIndependentVariable()) {
            try {
                this.globalBlock.addSymbol(iv);
            }
            catch (DuplicatedSymbolException e) {
                this.handleException(e);
            }
        }
        for (FunctionDefinition fd : dom.getListOfFunctionDefinition()) {
            ValidationBlock block = this.storeFunctionDefinition(fd);
            for (FunctionParameter fa : fd.getFunctionArgument()) {
                try {
                    block.addSymbol(fa);
                }
                catch (DuplicatedSymbolException e) {
                    this.handleException(e);
                }
            }
        }
        if (dom.getModelDefinition() != null) {
            this.browseTree(dom.getModelDefinition(), this.globalBlock);
        }
        if (dom.getModellingSteps() != null) {
            this.browseTree(dom.getModellingSteps(), this.globalBlock);
        }
        if (dom.getTrialDesign() != null) {
            this.browseTree(dom.getTrialDesign(), this.globalBlock);
        }
    }

    private void browseTree(TreeNode node, ValidationBlock currentScope) {
        if (node instanceof FunctionCallType) {
            this.storeFunctionCall((FunctionCallType)node);
            return;
        }
        if (node instanceof SymbolScope) {
            currentScope = node instanceof Block ? this.storeBlock((Block)((Object)node)) : this.storeAnonymousBlock((SymbolScope)((Object)node));
        }
        if (node instanceof Symbol) {
            try {
                if (((Symbol)((Object)node)).getSymbId() != null) {
                    currentScope.addSymbol((Symbol)((Object)node));
                }
            }
            catch (DuplicatedSymbolException e) {
                this.handleException(e);
            }
        }
        if (node instanceof SymbolRef) {
            currentScope.addReference((SymbolRef)node);
        }
        if (node instanceof PharmMLObject) {
            this.storeObject((PharmMLObject)((Object)node));
        }
        if (node instanceof ReferenceContainer) {
            this.storeReferenceContainer((ReferenceContainer)((Object)node));
        }
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            this.browseTree(children.nextElement(), currentScope);
        }
    }

    private ValidationBlock storeBlock(Block block) {
        if (block.getBlkId() == null) {
            LoggerWrapper.getLogger().warning(block + " has undefined blkId. Will be validated as an" + " anonymous scope.");
            return this.storeAnonymousBlock(block);
        }
        if (this.blocks.containsKey(block.getBlkId())) {
            this.handleException(new DuplicatedBlockException(block));
        }
        ValidationBlock newBlock = new ValidationBlock(block.getBlkId());
        this.blocks.put(block.getBlkId(), newBlock);
        return newBlock;
    }

    private ValidationBlock storeAnonymousBlock(SymbolScope block) {
        ValidationBlock newBlock = new ValidationBlock(null);
        this.anonymousBlocks.add(newBlock);
        return newBlock;
    }

    private ValidationBlock storeFunctionDefinition(FunctionDefinition fd) {
        ValidationBlock newBlock = new ValidationBlock(null);
        this.functions.put(fd.getSymbId(), newBlock);
        return newBlock;
    }

    private void storeFunctionCall(FunctionCallType fc) {
        this.functionCalls.add(fc);
    }

    private void storeObject(PharmMLObject o) {
        if (o.getOid() != null) {
            this.objects.put(o.getOid(), o);
        } else {
            LoggerWrapper.getLogger().info("PharmMLObject with null oid won't be stored.");
        }
    }

    private void storeReferenceContainer(ReferenceContainer rc) {
        this.containers.add(rc);
    }

    private void handleException(DuplicatedSymbolException e) {
        this.errorHandler.handleError("S1", "Symbols must be unique within their scope (" + e.getDuplicatedSymbol().getSymbId() + ").", (AbstractTreeNode)((Object)e.getDuplicatedSymbol()));
    }

    private void handleException(DuplicatedBlockException e) {
        this.errorHandler.handleError("S1", "Blocks must be unique (" + e.getDuplicatedBlock().getBlkId() + ").", (AbstractTreeNode)((Object)e.getDuplicatedBlock()));
    }

    public void handleUnresolvedObject(OidRef oidRef) {
        this.errorHandler.handleError("S2", "Object reference (oidRef) \"" + oidRef.getOidRef() + "\" is not resolved.", oidRef);
    }

    public void handleIncompatibleObject(OidRef oidref, PharmMLObject o, TreeNode parent) {
        this.errorHandler.handleError("S5", "Element using oidRef=\"" + oidref.getOidRef() + "\" within " + parent + " object is incompatible with the referred object type (" + o.getClass().getSimpleName() + ").", oidref);
    }

    private void handleUnresolvedSymbol(SymbolRef symbolRef, ValidationBlock within) {
        this.errorHandler.handleError("S2", "Symbol reference \"" + symbolRef + "\" is not resolved.", symbolRef);
    }

    private void handleUnresolvedSymbol(FunctionCallType symbolRef) {
        this.errorHandler.handleError("S2", "Symbol reference \"" + symbolRef + "\" is not resolved.", symbolRef);
    }

    private void handleUnresolvedSymbol(FunctionCallType.FunctionArgument fa, String functionId) {
        this.errorHandler.handleError("S2", "Function argument \"" + fa.getSymbId() + "\" is not defined within the function \"" + functionId + "\".", fa);
    }

    private void handleUnusedArgument(FunctionCallType fc, String faId) {
        this.errorHandler.handleError("S2", "Function argument \"" + faId + "\" is not used in FunctionCall \"" + fc.getSymbRef().getSymbIdRef() + "\".", fc);
    }

    private boolean isIndependentSymbol(String symbId) {
        return this.globalBlock.containsSymbol(symbId);
    }

    public void validateAll() {
        this.validateSymbols();
        this.validateFunctionCalls();
        this.validateObjectReferences();
    }

    public void validateSymbols() {
        List<ValidationBlock> blocks = this.getAllBlocks();
        for (ValidationBlock block : blocks) {
            for (SymbolRef ref : block.getListOfSymbolRef()) {
                ValidationBlock targetBlock;
                if (ref.getBlkIdRef() == null) {
                    targetBlock = block;
                } else if (this.blocks.containsKey(ref.getBlkIdRef())) {
                    targetBlock = this.blocks.get(ref.getBlkIdRef());
                } else {
                    this.handleUnresolvedSymbol(ref, block);
                    continue;
                }
                if (targetBlock.containsSymbol(ref.getSymbIdRef()) || this.isIndependentSymbol(ref.getSymbIdRef())) continue;
                this.handleUnresolvedSymbol(ref, block);
            }
        }
    }

    public void validateFunctionCalls() {
        for (FunctionCallType fc : this.functionCalls) {
            if (fc.getSymbRef() == null || fc.getSymbRef().getSymbIdRef() == null) continue;
            if (this.functions.containsKey(fc.getSymbRef().getSymbIdRef())) {
                ValidationBlock functionBlock = this.functions.get(fc.getSymbRef().getSymbIdRef());
                for (FunctionCallType.FunctionArgument fp : fc.getListOfFunctionArgument()) {
                    if (fp.getSymbId() == null || functionBlock.containsSymbol(fp.getSymbId())) continue;
                    this.handleUnresolvedSymbol(fp, fc.getSymbRef().getSymbIdRef());
                }
                for (Symbol fa : functionBlock.listOfSymbol()) {
                    if (fc.containsFunctionArgument(fa.getSymbId())) continue;
                    this.handleUnusedArgument(fc, fa.getSymbId());
                }
                continue;
            }
            this.handleUnresolvedSymbol(fc);
        }
    }

    public void validateObjectReferences() {
        for (ReferenceContainer rc : this.containers) {
            rc.validateReferences(this, this.errorHandler);
        }
    }

    public PharmMLObject getObject(String oid) {
        return this.objects.get(oid);
    }

    public boolean containsObject(String oid) {
        return this.objects.containsKey(oid);
    }

    List<ValidationBlock> getAllBlocks() {
        ArrayList<ValidationBlock> list = new ArrayList<ValidationBlock>();
        list.add(this.globalBlock);
        list.addAll(this.anonymousBlocks);
        list.addAll(this.blocks.values());
        return list;
    }
}

