/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.libpharmml.validation;

import eu.ddmore.libpharmml.dom.commontypes.Symbol;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.exceptions.DuplicatedSymbolException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class ValidationBlock {
    private String id;
    private Map<String, Symbol> symbols;
    private List<SymbolRef> references;

    public ValidationBlock(String id) {
        this.id = id;
        this.symbols = new Hashtable<String, Symbol>();
        this.references = new ArrayList<SymbolRef>();
    }

    public String getId() {
        return this.id;
    }

    public Collection<Symbol> listOfSymbol() {
        return this.symbols.values();
    }

    public Symbol getSymbol(String symbId) {
        return this.symbols.get(symbId);
    }

    public boolean containsSymbol(String symbId) {
        return this.symbols.containsKey(symbId);
    }

    public void addSymbol(Symbol symbol) throws DuplicatedSymbolException {
        if (this.symbols.containsKey(symbol.getSymbId())) {
            throw new DuplicatedSymbolException(symbol);
        }
        this.symbols.put(symbol.getSymbId(), symbol);
    }

    public void addReference(SymbolRef ref) {
        this.references.add(ref);
    }

    public List<SymbolRef> getListOfSymbolRef() {
        return this.references;
    }
}

