/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs;

import crx.converter.engine.Accessor;
import crx.converter.engine.ConversionDetail_;
import crx.converter.engine.Manager;
import crx.converter.engine.ParameterContext;
import crx.converter.engine.Part;
import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.engine.ScriptDefinition;
import crx.converter.engine.SymbolReader;
import crx.converter.engine.Utils;
import crx.converter.engine.VariableDeclarationContext;
import crx.converter.engine.assoc.DependencyGraph;
import crx.converter.engine.assoc.DependencyLexer;
import crx.converter.engine.assoc.DependencyRef;
import crx.converter.engine.common.DataFiles;
import crx.converter.engine.common.ObservationParameter;
import crx.converter.engine.common.TabularDataset;
import crx.converter.engine.common.TemporalDoseEvent;
import crx.converter.spi.ILexer;
import crx.converter.spi.IParser;
import crx.converter.spi.blocks.CovariateBlock;
import crx.converter.spi.blocks.ObservationBlock;
import crx.converter.spi.blocks.ParameterBlock;
import crx.converter.spi.blocks.StructuralBlock;
import crx.converter.spi.blocks.TrialDesignBlock;
import crx.converter.spi.blocks.VariabilityBlock;
import crx.converter.spi.steps.BaseStep;
import crx.converter.spi.steps.EstimationStep;
import crx.converter.spi.steps.SimulationStep;
import crx.converter.tree.BaseTreeMaker;
import crx.converter.tree.BinaryTree;
import crx.converter.tree.NestedTreeRef;
import crx.converter.tree.Node;
import crx.converter.tree.TreeMaker;
import eu.ddmore.converters.unipv.winbugs.Parser;
import eu.ddmore.converters.unipv.winbugs.PascalParser;
import eu.ddmore.converters.unipv.winbugs.PascalParser2;
import eu.ddmore.converters.unipv.winbugs.parts.CovariateBlockImpl;
import eu.ddmore.converters.unipv.winbugs.parts.EstimationStepImpl;
import eu.ddmore.converters.unipv.winbugs.parts.ObservationBlockImpl;
import eu.ddmore.converters.unipv.winbugs.parts.ParameterBlockImpl;
import eu.ddmore.converters.unipv.winbugs.parts.StructuralBlockImpl;
import eu.ddmore.converters.unipv.winbugs.parts.TrialDesignBlockImpl;
import eu.ddmore.converters.unipv.winbugs.parts.VariabilityBlockImpl;
import eu.ddmore.convertertoolbox.api.domain.LanguageVersion;
import eu.ddmore.convertertoolbox.api.domain.Version;
import eu.ddmore.convertertoolbox.api.response.ConversionDetail;
import eu.ddmore.convertertoolbox.api.response.ConversionReport;
import eu.ddmore.convertertoolbox.domain.ConversionReportImpl;
import eu.ddmore.convertertoolbox.domain.LanguageVersionImpl;
import eu.ddmore.convertertoolbox.domain.VersionImpl;
import eu.ddmore.libpharmml.ILibPharmML;
import eu.ddmore.libpharmml.IPharmMLResource;
import eu.ddmore.libpharmml.IValidationReport;
import eu.ddmore.libpharmml.PharmMlFactory;
import eu.ddmore.libpharmml.dom.IndependentVariable;
import eu.ddmore.libpharmml.dom.PharmML;
import eu.ddmore.libpharmml.dom.commontypes.CommonVariableDefinition;
import eu.ddmore.libpharmml.dom.commontypes.DerivativeVariable;
import eu.ddmore.libpharmml.dom.commontypes.FunctionDefinition;
import eu.ddmore.libpharmml.dom.commontypes.FunctionParameter;
import eu.ddmore.libpharmml.dom.commontypes.IntValue;
import eu.ddmore.libpharmml.dom.commontypes.Name;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.VariableDefinition;
import eu.ddmore.libpharmml.dom.dataset.ColumnDefinition;
import eu.ddmore.libpharmml.dom.dataset.ColumnMapping;
import eu.ddmore.libpharmml.dom.dataset.ColumnReference;
import eu.ddmore.libpharmml.dom.dataset.ColumnType;
import eu.ddmore.libpharmml.dom.dataset.DataSet;
import eu.ddmore.libpharmml.dom.dataset.HeaderColumnsDefinition;
import eu.ddmore.libpharmml.dom.dataset.MapType;
import eu.ddmore.libpharmml.dom.dataset.TargetMapping;
import eu.ddmore.libpharmml.dom.maths.Condition;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.FunctionCallType;
import eu.ddmore.libpharmml.dom.maths.LogicBinOp;
import eu.ddmore.libpharmml.dom.maths.ObjectFactory;
import eu.ddmore.libpharmml.dom.maths.Piece;
import eu.ddmore.libpharmml.dom.maths.Piecewise;
import eu.ddmore.libpharmml.dom.modeldefn.CommonParameter;
import eu.ddmore.libpharmml.dom.modeldefn.ContinuousCovariate;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateDefinition;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateModel;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateRelation;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateTransformation;
import eu.ddmore.libpharmml.dom.modeldefn.FixedEffectRelation;
import eu.ddmore.libpharmml.dom.modeldefn.GeneralObsError;
import eu.ddmore.libpharmml.dom.modeldefn.IndividualParameter;
import eu.ddmore.libpharmml.dom.modeldefn.ModelDefinition;
import eu.ddmore.libpharmml.dom.modeldefn.ObservationError;
import eu.ddmore.libpharmml.dom.modeldefn.ObservationModel;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterModel;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomEffect;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomVariable;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import eu.ddmore.libpharmml.dom.modeldefn.StructuralModel;
import eu.ddmore.libpharmml.dom.modeldefn.StructuredModel;
import eu.ddmore.libpharmml.dom.modeldefn.StructuredObsError;
import eu.ddmore.libpharmml.dom.modeldefn.TransformedCovariate;
import eu.ddmore.libpharmml.dom.modeldefn.VariabilityDefnBlock;
import eu.ddmore.libpharmml.dom.modeldefn.VariabilityLevelDefinition;
import eu.ddmore.libpharmml.dom.modeldefn.pkmacro.PKMacro;
import eu.ddmore.libpharmml.dom.modeldefn.pkmacro.PKMacroList;
import eu.ddmore.libpharmml.dom.modellingsteps.CommonModellingStep;
import eu.ddmore.libpharmml.dom.modellingsteps.Estimation;
import eu.ddmore.libpharmml.dom.modellingsteps.ModellingSteps;
import eu.ddmore.libpharmml.dom.trialdesign.ExternalDataSet;
import eu.ddmore.libpharmml.dom.trialdesign.TrialDesign;
import eu.ddmore.libpharmml.dom.uncertml.VarRefType;
import eu.ddmore.libpharmml.impl.PharmMLVersion;
import eu.ddmore.libpharmml.pkmacro.exceptions.InvalidMacroException;
import eu.ddmore.libpharmml.pkmacro.translation.Input;
import eu.ddmore.libpharmml.pkmacro.translation.MacroOutput;
import eu.ddmore.libpharmml.pkmacro.translation.Translator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class ConverterProvider
extends DependencyLexer
implements ILexer {
    private static eu.ddmore.libpharmml.dom.commontypes.ObjectFactory cof = new eu.ddmore.libpharmml.dom.commontypes.ObjectFactory();
    private static eu.ddmore.libpharmml.dom.dataset.ObjectFactory ds_of = new eu.ddmore.libpharmml.dom.dataset.ObjectFactory();
    private static Manager m = new Manager();
    private static ObjectFactory math_of = new ObjectFactory();
    IParser parser;
    private boolean permit_objective_ETAs = true;
    private boolean permitEmptyTrialDesignBlock = false;
    private boolean remove_illegal_chars = false;
    private boolean filter_reserved_words = false;
    private IPharmMLResource res = null;
    private boolean resetRegToCov = true;
    private ScriptDefinition sd = new ScriptDefinition();
    private boolean sort_parameter_model_by_context = false;
    private boolean sort_structural_model = false;
    private LanguageVersion source = null;
    private LanguageVersion target = null;
    private PharmMLVersion target_level = PharmMLVersion.V0_8_1;
    private boolean terminate_with_duff_xml = false;
    private Translator tr = new Translator();
    private boolean translate_macros = true;
    private boolean useGlobalConditionalDoseVariable = false;
    private boolean usePiecewiseAsEvents = false;
    private boolean validate_xml = false;
    private boolean created_parameter_context = false;
    private Map<StructuralModel, List<PKMacro>> macro_input_map = new HashMap<StructuralModel, List<PKMacro>>();
    private Map<StructuralModel, MacroOutput> macro_output_map = new HashMap<StructuralModel, MacroOutput>();
    private String model_filename = new String();
    private static final String SCRIPT_FILE_SUFFIX = "txt";
    private static final String WINBUGSDIR = "BlackBoxWinBUGS/";
    private String pascalN = "ODEPascal";
    private String WBScriptFName = "RunScript.txt";
    String rootName = ".";
    private static final String pascalExtension = ".txt";
    public static final int NOPASCAL = 0;
    public static final int PASCAL1 = 1;
    public static final int PASCAL2 = 2;
    protected static final String RK45SOLVER = "RK45";
    protected static final String LSODASOLVER = "LSODA";
    public static final int ODESOLVER_RK45 = 1;
    public static final int ODESOLVER_LSODA = 2;
    private Version converterVersion = new VersionImpl(1, 7, 0);
    private String output_dir = ".";
    private ILibPharmML lib = null;
    private String name = "Core Lexer";
    private List<String> ordered_levels = new ArrayList<String>();
    private Map<PopulationParameter, ParameterContext> param_context_map = new HashMap<PopulationParameter, ParameterContext>();
    private ParameterBlock pb = null;
    private IValidationReport validation_report = null;
    private boolean is_echo_exception = true;
    private DataFiles data_files = new DataFiles();
    private StructuralBlock currentSb = null;
    private boolean hasResetColumnUsageRegToCov = false;
    private HashMap<Object, String> index_symbol_map = new HashMap();
    private boolean isolate_conditional_dose_variable = true;
    private boolean isolate_dt = true;
    private String outputDirPascal1;
    private String outputDirPascal2;
    private String outputDirPascal2Mod;
    private String outputDirPiecewisePascal;
    private String pwFileName;
    private String covFileName;
    private String bbCompileScriptDir;
    private int parserType;
    private int solverType;
    private int totCov;
    private int num1;
    private int update;

    public String getPwFileName() {
        return this.pwFileName;
    }

    public String getCovFileName() {
        return this.covFileName;
    }

    public void setPwFileName(String pwFileName) {
        this.pwFileName = this.outputDirPascal2Mod + pwFileName;
    }

    public void setCovFileName(String pwFileName) {
        this.covFileName = this.outputDirPascal2Mod + pwFileName;
    }

    public ConverterProvider(String fName, String gName) throws IOException, NullPointerException {
        this.initAll();
    }

    public ConverterProvider() throws IOException, NullPointerException {
        this.initLibrary();
        this.tm = new BaseTreeMaker();
        this.initAll();
    }

    public void setParserType(int parserType) {
        this.parserType = parserType;
    }

    private void initAll() throws IOException, NullPointerException {
        VersionImpl source_version = new VersionImpl(0, 8, 1);
        this.source = new LanguageVersionImpl("PharmML", (Version)source_version);
        VersionImpl target_version = new VersionImpl(1, 4, 3);
        this.target = new LanguageVersionImpl("WINBUGS", (Version)target_version);
        this.converterVersion = new VersionImpl(1, 0, 0);
        this.getTreeMaker().setPermitParameterWithoutAssignment(true);
        this.initParser();
    }

    private String getSolver(String property) {
        switch (property) {
            case "RK45": {
                return "1";
            }
            case "LSODA": {
                return "2";
            }
        }
        System.err.println("Wrong or missing solver type. RK45 is selected as default.");
        return "1";
    }

    public static String getModelName(File src) {
        String name = src.getPath();
        int idx = name.lastIndexOf("/");
        name = idx >= 0 ? name.substring(idx + 1) : name;
        idx = name.lastIndexOf("\\");
        name = idx >= 0 ? name.substring(idx + 1) : name;
        name = name.substring(0, name.indexOf("."));
        return name;
    }

    public void setOutputDirectory(File dir) {
        boolean done = false;
        if (dir == null) {
            throw new NullPointerException("Output directory is NULL.");
        }
        if (dir.isDirectory() && dir.canRead() && dir.canWrite()) {
            this.output_dir = dir.getAbsolutePath();
            done = true;
        }
        if (!done) {
            throw new IllegalStateException("Unable to assign output directory path.");
        }
    }

    public ConversionReport performConvert(File src, File outputDirectory) {
        File f = null;
        String separ = "/";
        if (src.getAbsolutePath().lastIndexOf(separ) < 0) {
            separ = "\\";
        }
        String jobD = src.getAbsolutePath().substring(0, src.getAbsolutePath().lastIndexOf(separ));
        System.out.println("jobD = " + jobD);
        Parser theParser = (Parser)this.getParser();
        Parser.setJobDir(jobD);
        Parser.setOutputDir(this.output_dir);
        this.setParserProp(src, (Parser)this.getParser());
        ((Parser)this.getParser()).setXmlFileName(src);
        this.getScriptDefinition().flushAllSymbols();
        try {
            this.parser.setRunId(m.generateRunId());
            this.setOutputDirectory(outputDirectory);
            try {
                this.createWinBUGSModel(outputDirectory, src);
                f = theParser.createScriptWinbugs(src, new File(Parser.winbugsDir + "/" + this.WBScriptFName), outputDirectory.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Winbugs converter Exception = " + e.getMessage());
            }
            return this.getCrxSuccessReport(f);
        }
        catch (Exception e) {
            return this.getExceptionReport(e);
        }
    }

    private void initLibrary() {
        this.lib = PharmMlFactory.getInstance().createLibPharmML();
    }

    protected void loadPharmML(File xml_file_path) throws IOException {
        FileInputStream in = new FileInputStream(xml_file_path);
        this.res = this.lib.createDomFromResource((InputStream)in);
        ((InputStream)in).close();
        this.dom = this.res.getDom();
        this.getAccessor();
        this.model_filename = xml_file_path.getAbsolutePath();
        this.parser.setPharmMLWrittenVersion(this.dom.getWrittenVersion());
        if (this.validate_xml) {
            this.validation_report = this.res.getCreationReport();
            if (this.validation_report != null && !this.validation_report.isValid() && this.terminate_with_duff_xml) {
                throw new IllegalStateException("The XML of the PharmML input model is not well-formed and valid.");
            }
        }
        this.translatePKMacros();
    }

    public String getOutputDirectory() {
        return this.output_dir;
    }

    private void setParserProp(File src, Parser p) {
        String name = src.getPath();
        if (this.parser instanceof PascalParser2) {
            ((PascalParser2)p).setPascalFileName(new File(this.outputDirPascal2 + "/" + this.pascalN + pascalExtension));
            ((PascalParser2)p).setPascalModFileName(new File(this.outputDirPascal2Mod + "/" + this.pascalN + "_Mod" + pascalExtension));
            ((PascalParser2)p).setPascalPKmodel(this.outputDirPascal2 + "/" + "PKModels.txt");
            ((PascalParser2)p).setPascalPKmetricsFileName(new File(this.outputDirPascal2 + "/" + "PKModels.txt"));
            this.setPwFileName("FunctionPiecewise");
            this.setCovFileName("FunctionCovariate");
            ((PascalParser2)p).setPiecewisePascalName(this.getPwFileName());
            ((PascalParser2)p).setCovariatePascalName(this.getCovFileName());
            PascalParser2 cfr_ignored_0 = (PascalParser2)p;
            PascalParser2.setBbCompileScriptDir(this.bbCompileScriptDir);
        }
    }

    public void setParser(IParser parser_) {
        if (parser_ == null) {
            throw new NullPointerException("The parser is null.");
        }
        this.parser = parser_;
    }

    public void initParser() throws FileNotFoundException, IOException {
        System.out.println("InitParser() ");
        this.setParserType(this.parserType);
        PascalParser2 p = null;
        try {
            p = new PascalParser2();
            p.setOdeSolver(RK45SOLVER);
            if (this.solverType == 2) {
                p.setOdeSolver(LSODASOLVER);
            }
            p.setOutputDirPascal2(this.outputDirPascal2);
            p.setOutputDirPascal2Mod(this.outputDirPascal2Mod);
            p.setOutputDirPiecewisePascal(this.outputDirPascal2Mod);
            p.setLexer(this);
            p.setModelNum(1);
            if (System.getenv("SEE_HOME") != null) {
                Parser.setWinbugsTemplateDir(System.getenv("SEE_HOME") + "/" + WINBUGSDIR + "Templates" + "/");
                Parser.setWinbugsDir(System.getenv("SEE_HOME") + "/" + WINBUGSDIR);
            } else {
                Parser.setWinbugsDir(".");
                Parser.setWinbugsTemplateDir("Templates/");
            }
            if (System.getenv("SEE_HOME") != null) {
                this.rootName = System.getenv("SEE_HOME");
                this.outputDirPascal1 = this.rootName + WINBUGSDIR + "WBDiff/Mod/";
                this.outputDirPascal2 = this.rootName + WINBUGSDIR + "Pmetrics/Mod/";
                this.outputDirPascal2Mod = this.rootName + WINBUGSDIR + "WBDev/Mod/";
                this.outputDirPiecewisePascal = this.rootName + WINBUGSDIR + "WBDev/Mod/";
                this.bbCompileScriptDir = this.rootName + WINBUGSDIR + "/";
            } else {
                this.outputDirPascal1 = "SEE/WBDiff/Mod/";
                this.outputDirPascal2 = "SEE/Pmetrics/Mod/";
                this.outputDirPascal2Mod = "SEE/WBDev/Mod/";
                this.outputDirPiecewisePascal = "SEE/WBDev/Mod/";
                this.bbCompileScriptDir = this.rootName + "/";
            }
            this.setParser((IParser)p);
        }
        catch (IOException ex) {
            Logger.getLogger(ConverterProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("FINE InitParser() ");
    }

    public void setSolverType(int solverType) {
        this.solverType = solverType;
    }

    public void setTotCov(int tot) {
        this.totCov = tot;
    }

    public String getScriptFilename(String output_dir, String modelFileName) {
        String format = "%s/%s.%s";
        return String.format(format, output_dir, modelFileName, SCRIPT_FILE_SUFFIX);
    }

    public void createBlocks(File outputDirectory) throws IOException {
        this.parser.initialise();
        if (outputDirectory == null) {
            throw new NullPointerException("The output directroy is NULL");
        }
        this.createFunctionTrees();
        this.createVariabilityMap();
        this.createObservationMap();
        this.createTrialDesignMaps();
        this.createParameterMap();
        this.createStepMap();
        this.createStepTrees();
        this.createStateMap();
        this.createCovariateMap();
        this.createParameterTrees();
        this.createStructuralTrees();
        this.createBlockTrees();
        this.createCovariateTrees();
        if (this.permit_objective_ETAs) {
            this.doObjectiveETAs();
        }
        this.sortElementOrdering();
    }

    private void createBlockTrees() {
        this.buildPartTrees(this.sd.getBlocksMap());
    }

    private void createCovariateMap() {
        ModelDefinition def = this.dom.getModelDefinition();
        if (def == null) {
            return;
        }
        List cmts = def.getListOfCovariateModel();
        if (cmts == null) {
            return;
        }
        for (CovariateModel cmt : cmts) {
            this.getCovariateBlocks().add(new CovariateBlockImpl(cmt, this));
        }
    }

    private void createCovariateTrees() {
        for (CovariateBlock cb : this.getCovariateBlocks()) {
            cb.buildTrees();
        }
    }

    private EstimationStep createEstimationStep(Estimation est_) {
        return new EstimationStepImpl(est_, this);
    }

    private void buildPartTrees(Map<String, Part> parts) {
        if (parts == null) {
            return;
        }
        Set<String> keys = parts.keySet();
        for (String key : keys) {
            Part part;
            if (key == null || (part = parts.get(key)) == null) continue;
            part.buildTrees();
        }
    }

    private void createFunctionTrees() {
        if (this.dom == null) {
            return;
        }
        List funcs = this.dom.getListOfFunctionDefinition();
        if (funcs == null) {
            return;
        }
        if (funcs.isEmpty()) {
            return;
        }
        for (FunctionDefinition func : funcs) {
            BinaryTree bt = this.tm.newInstance((Object)func);
            if (bt == null) {
                throw new IllegalStateException("The funcion assignment block cannot be null.");
            }
            this.sd.getStatementsMap().put(func, bt);
            this.sd.getFunctions().add(func);
        }
    }

    private void createObservationMap() {
        ModelDefinition def = this.dom.getModelDefinition();
        if (def == null) {
            return;
        }
        List observations = def.getListOfObservationModel();
        for (ObservationModel ob : observations) {
            if (ob == null) continue;
            ObservationBlockImpl obb = new ObservationBlockImpl(ob, this);
            obb.buildTrees();
            this.getObservationBlocks().add(obb);
        }
    }

    private ParameterBlock createParameterBlock(ParameterModel pmt) {
        return new ParameterBlockImpl(pmt, this);
    }

    public void createParameterContext() {
        if (this.created_parameter_context) {
            return;
        }
        ParameterBlock pdb = this.getParameterBlock();
        if (pdb == null) {
            return;
        }
        List params = pdb.getParameters();
        for (PopulationParameter p : params) {
            this.getParameterContext(p);
        }
        this.doParameterContext_ObservationBlocks();
        this.doParameterContext_Individuals(pdb);
        this.created_parameter_context = true;
    }

    private void createParameterMap() {
        ModelDefinition def = this.dom.getModelDefinition();
        if (def == null) {
            return;
        }
        List param_models = def.getListOfParameterModel();
        if (param_models.isEmpty()) {
            return;
        }
        for (ParameterModel pm : param_models) {
            if (pm == null) continue;
            this.sd.getParameterBlocks().add(new ParameterBlockImpl(pm, this));
        }
    }

    private void createParameterTrees() {
        for (ParameterBlock pb : this.sd.getParameterBlocks()) {
            if (pb == null) continue;
            pb.buildTrees();
        }
    }

    private File createScript(File src, File outputDirectory) throws Exception {
        if (outputDirectory == null) {
            throw new NullPointerException("The output directroy is NULL");
        }
        this.model_filename = src.getName().replace(".xml", "");
        String output_filename = this.getScriptFilename(outputDirectory.getAbsolutePath(), this.model_filename);
        PrintWriter fout = new PrintWriter(output_filename);
        PascalParser p = (PascalParser)this.parser;
        p.writePreMainBlockElements(fout, src);
        p.writeAllModelFunctions(outputDirectory);
        if (p.hasDiffEquations) {
            p.adjustDataFile();
        }
        this.parser.cleanUp();
        File f = new File(output_filename);
        return f;
    }

    private void createStateMap() {
        if (this.dom == null) {
            return;
        }
        ModelDefinition def = this.dom.getModelDefinition();
        if (def == null) {
            return;
        }
        List smts = def.getListOfStructuralModel();
        if (smts.isEmpty()) {
            return;
        }
        for (StructuralModel sm : smts) {
            if (sm == null) continue;
            StructuralBlock sb = this.createStructuralBlock(sm);
            if (this.macro_input_map.containsKey(sm)) {
                sb.setPKMacros(this.macro_input_map.get(sm));
            }
            if (this.macro_output_map.containsKey(sm)) {
                sb.setPKMacroOutput(this.macro_output_map.get(sm));
            }
            this.getStructuralBlocks().add(sb);
        }
    }

    private void createStepMap() {
        if (this.dom == null) {
            return;
        }
        ModellingSteps steps_ = this.dom.getModellingSteps();
        TrialDesign td = this.dom.getTrialDesign();
        if (steps_ == null) {
            throw new IllegalStateException("The PharmML file does not have the required 'ModellingSteps' section.");
        }
        if (td == null) {
            throw new NullPointerException("Model trial design is not specified.");
        }
        for (JAXBElement o : steps_.getCommonModellingStep()) {
            CommonModellingStep step = (CommonModellingStep)o.getValue();
            if (step == null || !PharmMLTypeChecker.isEstimation((Object)step)) continue;
            Estimation est_step = (Estimation)step;
            if (est_step.getOid() == null) {
                throw new IllegalStateException("Estimation step OID cannot be NULL");
            }
            this.sd.getStepsMap().put(est_step.getOid(), this.createEstimationStep(est_step));
        }
    }

    private void createStepTrees() {
        this.buildPartTrees(this.sd.getStepsMap());
    }

    private StructuralBlock createStructuralBlock(StructuralModel sm) {
        return new StructuralBlockImpl(sm, this);
    }

    private void createStructuralTrees() {
        for (StructuralBlock sb : this.getStructuralBlocks()) {
            if (sb == null) continue;
            sb.buildTrees();
        }
    }

    public BinaryTree createTree(Object o) {
        BinaryTree bt = this.tm.newInstance(o);
        this.addStatement(o, bt);
        this.updateNestedTrees();
        return bt;
    }

    public void addStatement(Object element, BinaryTree tree) {
        if (element != null && tree != null) {
            this.sd.getStatementsMap().put(element, tree);
        }
    }

    public boolean addStatement(NestedTreeRef ref) {
        if (ref != null && ref.element != null && ref.bt != null) {
            if (this.sd.getStatementsMap().containsKey(ref.element)) {
                this.sd.getStatementsMap().remove(ref.element);
            }
            this.sd.getStatementsMap().put(ref.element, ref.bt);
            return true;
        }
        return false;
    }

    private TrialDesignBlock createTrialDesignBlock(TrialDesign td) {
        return new TrialDesignBlockImpl(td, this);
    }

    private void createTrialDesignMaps() throws IOException {
        if (this.dom == null) {
            return;
        }
        TrialDesign td = this.dom.getTrialDesign();
        if (td == null) {
            return;
        }
        this.sd.setTrialDesignBlock(this.createTrialDesignBlock(td));
        this.sd.getBlocksMap().put(this.getTrialDesign().getName(), this.getTrialDesign());
    }

    private void createVariabilityMap() {
        ModelDefinition def = this.dom.getModelDefinition();
        if (def == null) {
            return;
        }
        List vms = def.getListOfVariabilityModel();
        if (vms == null) {
            return;
        }
        for (VariabilityDefnBlock vm : vms) {
            if (vm == null) continue;
            VariabilityBlockImpl vb = new VariabilityBlockImpl(vm, this);
            this.sd.getVariabilityBlocks().add(vb);
        }
    }

    private void doObjectiveETAs() {
        List obs = this.sd.getObservationBlocks();
        ParameterBlock pm = this.getParameterBlock();
        for (ObservationBlock ob : obs) {
            if (ob == null || !ob.hasIndividualParameters()) continue;
            for (IndividualParameter ip : ob.getIndividualParameters()) {
                if (ip == null) continue;
                pm.addIndividualParameter(ip);
            }
            this.setMixedEffect(true);
        }
    }

    private void doParameterContext_CovariateRelation(List<CovariateRelation> covs) {
        if (covs == null) {
            return;
        }
        if (covs.isEmpty()) {
            return;
        }
        for (CovariateRelation cov : covs) {
            if (cov == null) continue;
            for (FixedEffectRelation fixed_effect : cov.getListOfFixedEffect()) {
                PopulationParameter p;
                ParameterContext ctx;
                PharmMLRootType o;
                SymbolRef ref;
                if (fixed_effect == null || (ref = fixed_effect.getSymbRef()) == null || !PharmMLTypeChecker.isPopulationParameter((Object)(o = this.accessor.fetchElement(ref))) || (ctx = this.getParameterContext(p = (PopulationParameter)o)) == null) continue;
                ctx.theta_fixed_effect = true;
            }
        }
    }

    private void doParameterContext_Individuals(ParameterBlock pdb) {
        List ips = pdb.getIndividualParameters();
        for (IndividualParameter ip : ips) {
            if (ip == null || ip.getStructuredModel() == null) continue;
            StructuredModel gm = ip.getStructuredModel();
            this.doParameterContext_LinearCovariate(gm.getLinearCovariate());
            this.doParameterContext_RandomEffects(gm.getListOfRandomEffects());
        }
    }

    private void doParameterContext_LinearCovariate(StructuredModel.LinearCovariate lc) {
        if (lc == null) {
            return;
        }
        this.doParameterContext_PopulationValue_(lc.getPopulationValue());
        this.doParameterContext_CovariateRelation(lc.getListOfCovariate());
    }

    private void doParameterContext_ObservationBlocks() {
        List<ObservationBlock> obs = this.getObservationBlocks();
        for (ObservationBlock ob : obs) {
            StructuredObsError goe;
            if (ob == null) continue;
            ObservationError error_model = ob.getObservationError();
            ArrayList<SymbolRef> residuals = new ArrayList<SymbolRef>();
            ArrayList<NestedTreeRef> error_trees = new ArrayList<NestedTreeRef>();
            if (PharmMLTypeChecker.isStructuredError((Object)error_model)) {
                goe = (StructuredObsError)error_model;
                error_trees.add(new NestedTreeRef((Object)goe, this.tm.newInstance((Object)goe)));
                StructuredObsError.ErrorModel error = goe.getErrorModel();
                if (error == null) {
                    throw new NullPointerException("Gaussian erorr model not specified.");
                }
                error_trees.add(new NestedTreeRef((Object)error, this.tm.newInstance((Object)error.getAssign())));
                StructuredObsError.Output output = goe.getOutput();
                if (output == null) {
                    throw new NullPointerException("Gaussian erorr model, output variable not specified.");
                }
                if (output.getSymbRef() == null) {
                    throw new NullPointerException("Gaussian Output variable not specified (symbId='" + goe.getSymbId() + "')");
                }
                StructuredObsError.ResidualError residual_error = goe.getResidualError();
                if (residual_error == null) {
                    throw new NullPointerException("Gaussian erorr model, residual variable not specified.");
                }
                if (residual_error.getSymbRef() == null) {
                    throw new NullPointerException("Gaussian Residual error variable not specified (symbId='" + goe.getSymbId() + "')");
                }
                residuals.add(residual_error.getSymbRef());
            } else if (PharmMLTypeChecker.isGeneralError((Object)error_model)) {
                goe = (GeneralObsError)error_model;
                error_trees.add(new NestedTreeRef((Object)goe, this.tm.newInstance((Object)goe)));
                error_trees.add(new NestedTreeRef((Object)goe.getAssign(), this.tm.newInstance((Object)goe.getAssign())));
            }
            for (NestedTreeRef ntr : error_trees) {
                if (ntr == null) continue;
                for (Node node : ntr.bt.nodes) {
                    if (!PharmMLTypeChecker.isFunctionCall((Object)node.data)) continue;
                    FunctionCallType call = (FunctionCallType)node.data;
                    for (FunctionCallType.FunctionArgument arg : call.getListOfFunctionArgument()) {
                        ParameterContext ctx;
                        PharmMLRootType element;
                        if (arg == null || arg.getSymbRef() == null || !PharmMLTypeChecker.isPopulationParameter((Object)(element = this.accessor.fetchElement(arg.getSymbRef()))) || (ctx = this.getParameterContext((PopulationParameter)element)) == null) continue;
                        ctx.error_model = true;
                    }
                }
            }
        }
    }

    private void doParameterContext_PopulationValue_(StructuredModel.LinearCovariate.PopulationValue pv) {
        if (pv == null) {
            return;
        }
        BinaryTree bt = this.tm.newInstance((Object)pv);
        ArrayList<BinaryTree> bts = new ArrayList<BinaryTree>();
        bts.add(bt);
        for (NestedTreeRef ref : this.tm.getNestedTrees()) {
            if (ref == null) continue;
            bts.add(bt);
        }
        for (BinaryTree bt_ : bts) {
            for (Node node : bt_.nodes) {
                PopulationParameter p;
                ParameterContext ctx;
                SymbolRef sref;
                PharmMLRootType element;
                if (node == null || !PharmMLTypeChecker.isSymbolReference((Object)node.data) || !PharmMLTypeChecker.isPopulationParameter((Object)(element = this.accessor.fetchElement(sref = (SymbolRef)node.data))) || (ctx = this.getParameterContext(p = (PopulationParameter)element)) == null) continue;
                ctx.theta = true;
            }
        }
    }

    private void doParameterContext_RandomEffects(List<ParameterRandomEffect> rfs) {
        if (rfs == null) {
            return;
        }
        if (rfs.isEmpty()) {
            return;
        }
        for (ParameterRandomEffect rf : rfs) {
            if (rf == null) continue;
            for (SymbolRef ref : rf.getSymbRef()) {
                PharmMLRootType element;
                if (ref == null || (element = this.accessor.fetchElement(ref)) == null) continue;
                ArrayList<BinaryTree> bts = new ArrayList<BinaryTree>();
                bts.add(this.tm.newInstance((Object)element));
                for (NestedTreeRef nref : this.tm.getNestedTrees()) {
                    if (ref == null) continue;
                    bts.add(nref.bt);
                }
                for (BinaryTree bt : bts) {
                    for (Node node : bt.nodes) {
                        SymbolRef sref;
                        PopulationParameter p;
                        ParameterContext ctx;
                        PharmMLRootType o;
                        if (PharmMLTypeChecker.isVariableReference((Object)node.data)) {
                            VarRefType vref = (VarRefType)node.data;
                            o = this.accessor.fetchElement(vref);
                            if (!PharmMLTypeChecker.isPopulationParameter((Object)o) || (ctx = this.getParameterContext(p = (PopulationParameter)o)) == null) continue;
                            ctx.omega = true;
                            continue;
                        }
                        if (!PharmMLTypeChecker.isSymbolReference((Object)node.data) || !PharmMLTypeChecker.isPopulationParameter((Object)(o = this.accessor.fetchElement(sref = (SymbolRef)node.data))) || (ctx = this.getParameterContext(p = (PopulationParameter)o)) == null) continue;
                        ctx.omega = true;
                    }
                }
            }
        }
    }

    public Accessor getAccessor() {
        if (this.accessor == null) {
            this.accessor = new Accessor(this.dom);
        }
        return this.accessor;
    }

    public Version getConverterVersion() {
        return this.converterVersion;
    }

    public CovariateBlock getCovariateBlock() {
        List<CovariateBlock> cbs = this.getCovariateBlocks();
        if (cbs != null && !cbs.isEmpty()) {
            return cbs.get(0);
        }
        return null;
    }

    public List<CovariateBlock> getCovariateBlocks() {
        return this.sd.getCovariateBlocks();
    }

    public List<CovariateDefinition> getCovariates() {
        ArrayList<CovariateDefinition> list = new ArrayList<CovariateDefinition>();
        for (CovariateBlock cb : this.getCovariateBlocks()) {
            List covs = cb.getCovariates();
            for (CovariateDefinition cov : covs) {
                if (cov == null) continue;
                list.add(cov);
            }
        }
        return list;
    }

    private ConversionReport getCrxSuccessReport(File path) {
        ConversionReportImpl report = new ConversionReportImpl();
        ConversionDetail_ detail = new ConversionDetail_();
        detail.addInfo("status", "script created.");
        if (path != null) {
            detail.setFile(path);
        }
        detail.setSeverity(ConversionDetail.Severity.INFO);
        report.addDetail((ConversionDetail)detail);
        report.setReturnCode(ConversionReport.ConversionCode.SUCCESS);
        return report;
    }

    public DataFiles getDataFiles() {
        return this.data_files;
    }

    public List<ObservationBlock> getErrorModels() {
        return this.getObservationBlocks();
    }

    private ConversionReport getExceptionReport(Exception e) {
        ConversionReportImpl report = new ConversionReportImpl();
        if (this.is_echo_exception) {
            e.printStackTrace(System.err);
        }
        ConversionDetail_ detail = new ConversionDetail_();
        detail.addInfo("error_message", e.getMessage());
        detail.setSeverity(ConversionDetail.Severity.ERROR);
        detail.setMessage(e.getMessage());
        report.addDetail((ConversionDetail)detail);
        report.setReturnCode(ConversionReport.ConversionCode.FAILURE);
        return report;
    }

    public String getIndexSymbol(Object key) {
        throw new UnsupportedOperationException();
    }

    public Integer getIndividualParameterIndex(String symbol) {
        Integer idx = -1;
        if (symbol != null && !this.sd.getParameterBlocks().isEmpty() && this.getParameterBlock() != null) {
            List ips = this.getParameterBlock().getIndividualParameters();
            int i = 1;
            for (IndividualParameter ip : ips) {
                if (ip == null) continue;
                String currentSymbol = ip.getSymbId();
                if (currentSymbol != null && currentSymbol.equals(symbol)) {
                    idx = i;
                }
                ++i;
            }
        }
        return idx;
    }

    public ILibPharmML getLibrary() {
        return this.lib;
    }

    public List<VariableDefinition> getLocalVariables() {
        if (!this.sd.getStructuralBlocks().isEmpty()) {
            StructuralBlock structuralBlock = this.getStructuralBlocks().get(0);
            if (structuralBlock != null) {
                return structuralBlock.getLocalVariables();
            }
            return new ArrayList<VariableDefinition>();
        }
        return new ArrayList<VariableDefinition>();
    }

    public String getModelFilename() {
        return this.model_filename;
    }

    public String getModelName() {
        String name = null;
        if (this.dom != null) {
            Name n = this.dom.getName();
            if (n == null) {
                return name;
            }
            name = n.getValue();
            if (name != null) {
                name = name.replaceAll("\n", "");
                name = name.replaceAll("\\s+", " ");
                name = name.replace('\\', '/');
            }
        }
        return name;
    }

    public Integer getModelParameterIndex(String name) {
        Integer idx = -1;
        if (!this.sd.getParameterBlocks().isEmpty() && this.getParameterBlock() != null) {
            idx = this.getParameterBlock().getParameterIndex(name);
        }
        return idx;
    }

    public List<PopulationParameter> getModelParameters() {
        if (!this.sd.getParameterBlocks().isEmpty()) {
            if (this.getParameterBlock() != null) {
                return this.getParameterBlock().getParameters();
            }
            return new ArrayList<PopulationParameter>();
        }
        return new ArrayList<PopulationParameter>();
    }

    public String getName() {
        return this.name;
    }

    public List<ObservationBlock> getObservationBlocks() {
        return this.sd.getObservationBlocks();
    }

    public ObservationParameter getObservationParameter(PopulationParameter p) {
        ObservationParameter op = null;
        for (ObservationBlock ob : this.getObservationBlocks()) {
            if (ob == null || !ob.isObservationParameter(p)) continue;
            op = ob.getObservationParameter(p);
            break;
        }
        return op;
    }

    public ParameterBlock getParameterBlock() {
        if (this.pb == null) {
            if (!this.sd.getParameterBlocks().isEmpty()) {
                this.pb = (ParameterBlock)this.sd.getParameterBlocks().get(0);
            } else {
                ParameterModel pmt = new ParameterModel();
                pmt.setBlkId("pm");
                ModelDefinition def = this.dom.getModelDefinition();
                if (def == null) {
                    def = new ModelDefinition();
                    this.dom.setModelDefinition(def);
                }
                def.getListOfParameterModel().add(pmt);
                this.pb = this.createParameterBlock(pmt);
            }
        }
        return this.pb;
    }

    private ParameterContext getParameterContext(PopulationParameter p) {
        ParameterContext ctx = null;
        if (p == null) {
            throw new NullPointerException("Parameter is NULL.");
        }
        if (this.param_context_map.containsKey(p)) {
            ctx = this.param_context_map.get(p);
        } else {
            ctx = new ParameterContext(p);
            this.param_context_map.put(p, ctx);
        }
        return ctx;
    }

    public Map<PopulationParameter, ParameterContext> getParameterContextMap() {
        return this.param_context_map;
    }

    public IParser getParser() {
        return this.parser;
    }

    public IPharmMLResource getResource() {
        return this.res;
    }

    public ScriptDefinition getScriptDefinition() {
        return this.sd;
    }

    public List<String> getSimulationOutputNames() {
        ArrayList<String> names = new ArrayList<String>();
        SimulationStep step = this.getSimulationStep();
        SymbolReader z = this.parser.getSymbolReader();
        if (step != null) {
            List outputs = step.getContinuousList();
            for (SymbolRef ref : outputs) {
                PharmMLRootType element = this.accessor.fetchElement(ref);
                if (element == null) continue;
                names.add(z.get((Object)element));
            }
        }
        return names;
    }

    public Map<Integer, CommonVariableDefinition> getSimulationOutputs() {
        StructuralBlock block = this.getStrucuturalBlock();
        return this.getSimulationOutputs(block);
    }

    public Map<Integer, CommonVariableDefinition> getSimulationOutputs(StructuralBlock sb) {
        throw new UnsupportedOperationException();
    }

    public SimulationStep getSimulationStep() {
        throw new UnsupportedOperationException();
    }

    public List<String> getSortedVariabilityLevels() {
        return this.ordered_levels;
    }

    public LanguageVersion getSource() {
        return this.source;
    }

    public BinaryTree getStatement(Object key) {
        BinaryTree bt = null;
        if (key != null && this.sd.getStatementsMap().containsKey(key)) {
            bt = (BinaryTree)this.sd.getStatementsMap().get(key);
            this.sd.getStatementsMap().remove(key);
        }
        return bt;
    }

    public Integer getStateVariableIndex(String name) {
        throw new UnsupportedOperationException();
    }

    public List<StructuralBlock> getStructuralBlocks() {
        return this.sd.getStructuralBlocks();
    }

    public StructuralBlock getStrucuturalBlock() {
        if (this.currentSb == null && !this.sd.getStructuralBlocks().isEmpty()) {
            this.currentSb = (StructuralBlock)this.sd.getStructuralBlocks().get(0);
        }
        return this.currentSb;
    }

    public LanguageVersion getTarget() {
        return this.target;
    }

    private CommonVariableDefinition getTranslatedElement(Integer adm) {
        if (adm == null) {
            return null;
        }
        for (MacroOutput output : this.macro_output_map.values()) {
            if (output == null) continue;
            for (Input input : output.getListOfInput()) {
                IntValue i;
                if (input == null || !PharmMLTypeChecker.isInt((Object)input.getAdm()) || (i = (IntValue)input.getAdm()).getValue() == null || adm.intValue() != i.getValue().intValue()) continue;
                return input.getTarget();
            }
        }
        return null;
    }

    public Translator getTranslator() {
        return this.tr;
    }

    public TreeMaker getTreeMaker() {
        this.tm.setPermitDeclarationOnlyVariables(true);
        return this.tm;
    }

    public TrialDesignBlock getTrialDesign() {
        return this.sd.getTrialDesignBlock();
    }

    public IValidationReport getValidationReport() {
        return this.validation_report;
    }

    public VariabilityBlock getVariabilityBlock(SymbolRef ref) {
        VariabilityBlock vb = null;
        if (ref != null) {
            String symbId = ref.getSymbIdRef();
            String blkId = ref.getBlkIdRef();
            if (blkId != null && symbId != null) {
                for (VariabilityBlock vb_ : this.sd.getVariabilityBlocks()) {
                    if (vb_ == null || !blkId.equals(vb_.getName()) || !vb_.hasSymbolId(symbId)) continue;
                    vb = vb_;
                    break;
                }
            }
            if (vb == null && symbId != null) {
                for (VariabilityBlock vb_ : this.sd.getVariabilityBlocks()) {
                    if (vb_ == null || !vb_.hasSymbolId(symbId)) continue;
                    vb = vb_;
                    break;
                }
            }
        }
        return vb;
    }

    private boolean guessColumnDoseContext(BaseStep step, VariableDefinition v) {
        if (step == null || v == null) {
            return false;
        }
        if (!step.hasTemporalDoseEvent()) {
            return false;
        }
        TemporalDoseEvent tde = step.getTemporalDoseEvent();
        if (tde == null) {
            return false;
        }
        return !v.equals(tde.getTargetElement());
    }

    public boolean hasDoneEstimation() {
        throw new UnsupportedOperationException();
    }

    public boolean hasEstimation() {
        for (Part step : this.sd.getStepsMap().values()) {
            if (!(step instanceof EstimationStep)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEvents() {
        StructuralBlock sb = this.getStrucuturalBlock();
        if (sb != null) {
            return sb.hasEvents();
        }
        return false;
    }

    public boolean hasExternalDatasets() {
        return !this.data_files.getExternalDataSets().isEmpty();
    }

    public boolean hasResetColumnFromRegToCov() {
        return this.hasResetColumnUsageRegToCov;
    }

    public boolean hasSimulation() {
        throw new UnsupportedOperationException();
    }

    public boolean hasStatement(Object key) {
        if (key != null) {
            return this.sd.getStatementsMap().containsKey(key);
        }
        return false;
    }

    public boolean hasTrialDesign() {
        return this.getTrialDesign() != null;
    }

    public boolean hasWashout() {
        throw new UnsupportedOperationException();
    }

    private void initialise() {
        this.setSortParameterModelByContext(true);
        this.setSortStructuralModel(true);
        this.setValidateXML(true);
    }

    public boolean isADMEScript() {
        throw new UnsupportedOperationException();
    }

    public boolean isAtLastStructuralBlock() {
        throw new UnsupportedOperationException();
    }

    public boolean isCategoricalCovariate() {
        throw new UnsupportedOperationException();
    }

    public boolean isCategoricalDiscrete() {
        throw new UnsupportedOperationException();
    }

    public boolean isDDE() {
        throw new UnsupportedOperationException();
    }

    public boolean isDiscrete() {
        throw new UnsupportedOperationException();
    }

    public boolean isDuplicateVariablesPermitted() {
        throw new UnsupportedOperationException();
    }

    public boolean isFilterReservedWords() {
        return this.filter_reserved_words;
    }

    public boolean isGeneratedDosingParameter(PopulationParameter p) {
        throw new UnsupportedOperationException();
    }

    public boolean isIndexFromZero() {
        throw new UnsupportedOperationException();
    }

    public boolean isIndividualParameter_(String symbol) {
        if (symbol != null && !this.sd.getParameterBlocks().isEmpty() && this.getParameterBlock() != null) {
            List ips = this.getParameterBlock().getIndividualParameters();
            for (IndividualParameter ip : ips) {
                String currentSymbol;
                if (ip == null || (currentSymbol = ip.getSymbId()) == null || !currentSymbol.equals(symbol)) continue;
                return true;
            }
        }
        return false;
    }

    private void remapColumnPostPKMacroTranslation(ColumnMapping mapping, TabularDataset table) {
        if (mapping == null) {
            return;
        }
        if (mapping.getListOfTargetMapping().isEmpty()) {
            return;
        }
        ArrayList targets = new ArrayList();
        targets.addAll(mapping.getListOfTargetMapping());
        ColumnReference cref = mapping.getColumnRef();
        if (cref == null) {
            throw new NullPointerException("Column reference in an element mapping is NULL");
        }
        ColumnDefinition col = table.getColumn(cref);
        if (col == null) {
            throw new NullPointerException("A column declaration is undefined (name='" + cref.getColumnIdRef() + "')");
        }
        mapping.getListOfTargetMapping().clear();
        if (ColumnType.DOSE.equals(col.getListOfColumnType().get(0))) {
            for (TargetMapping target : targets) {
                if (target == null) continue;
                int size = target.getListOfMap().size();
                if (size > 0) {
                    this.remapDoseTarget(table, mapping, target.getListOfMap());
                    continue;
                }
                throw new UnsupportedOperationException("Unrecognised dosing target cardinality (name='" + cref.getColumnIdRef() + "')");
            }
        } else {
            throw new UnsupportedOperationException("Unrecognised target mapping context on a data column (name='" + cref.getColumnIdRef() + "')");
        }
    }

    private void remapDoseTarget(TabularDataset table, ColumnMapping mapping, List<MapType> maps) {
        if (mapping == null || maps == null || table == null) {
            return;
        }
        if (maps.isEmpty()) {
            return;
        }
        Piecewise pw = mapping.createPiecewise();
        boolean flag = false;
        for (MapType map : maps) {
            if (map == null) {
                throw new NullPointerException("A dose target mapping record is NULL");
            }
            Integer adm = map.getAdmNumber();
            String dataSymbol = map.getDataSymbol();
            if (adm == null) {
                throw new NullPointerException("The administration number is not specified");
            }
            CommonVariableDefinition v = this.getTranslatedElement(adm);
            if (v == null) continue;
            flag = true;
            if (dataSymbol != null) {
                this.remapDoseTargetWithAdministrationAndCompartment(table, v, pw, dataSymbol);
                continue;
            }
            this.remapDoseTargetWithAdministrationOnly(table, v, pw);
        }
        if (!flag) {
            throw new IllegalStateException("Unable to determine model element from the translated PK macro");
        }
    }

    private static Piece addPiece(Piecewise block, boolean createCondition) {
        Piece piece = null;
        if (block != null) {
            piece = new Piece();
            block.getListOfPiece().add(piece);
            if (createCondition) {
                Condition cond = new Condition();
                piece.setCondition(cond);
            }
        }
        return piece;
    }

    private void remapDoseTargetWithAdministrationAndCompartment(TabularDataset table, CommonVariableDefinition target, Piecewise pw, String dataSymbol) {
        if (table == null || target == null || pw == null || dataSymbol == null) {
            return;
        }
        ColumnDefinition adm_col = table.getColumn(ColumnType.ADM);
        ColumnDefinition dose_col = table.getColumn(ColumnType.DOSE);
        if (dose_col == null) {
            throw new IllegalStateException("The dose column is not specified in the model external dataset declaration");
        }
        if (adm_col == null) {
            throw new IllegalStateException("The administration column (ADM) is not specified in the model external dataset declaration");
        }
        Piece piece = ConverterProvider.addPiece(pw, true);
        piece.setValue((ExpressionValue)ConverterProvider.symbolRef((PharmMLRootType)target, this.accessor));
        LogicBinOp ADM_clause = ConverterProvider.logicalBinaryOperator("eq", new Object[]{adm_col, Integer.valueOf(dataSymbol)}, this.accessor);
        LogicBinOp DOSE_clause = ConverterProvider.logicalBinaryOperator("gt", new Object[]{dose_col, 0}, this.accessor);
        LogicBinOp lbop = ConverterProvider.logicalBinaryOperator("and", new Object[]{ADM_clause, DOSE_clause}, this.accessor);
        piece.getCondition().setLogicBinop(lbop);
    }

    private void remapDoseTargetWithAdministrationOnly(TabularDataset table, CommonVariableDefinition target, Piecewise pw) {
        if (table == null || target == null || pw == null) {
            return;
        }
        ColumnDefinition dose_col = table.getColumn(ColumnType.DOSE);
        if (dose_col == null) {
            throw new IllegalStateException("The dose column is not specified in the model external dataset declaration");
        }
        Piece piece = ConverterProvider.addPiece(pw, true);
        piece.setValue((ExpressionValue)ConverterProvider.symbolRef((PharmMLRootType)target, this.accessor));
        LogicBinOp DOSE_clause = ConverterProvider.logicalBinaryOperator("gt", new Object[]{dose_col, 0}, this.accessor);
        piece.getCondition().setLogicBinop(DOSE_clause);
    }

    private void resetRegressorToCovariate() {
        if (!this.resetRegToCov) {
            return;
        }
        TrialDesign td = this.dom.getTrialDesign();
        if (td == null) {
            return;
        }
        List exds = td.getListOfExternalDataSet();
        if (exds == null) {
            return;
        }
        if (exds.isEmpty()) {
            return;
        }
        for (ExternalDataSet exd : exds) {
            List cols;
            HeaderColumnsDefinition definition;
            DataSet ds;
            if (exd == null || (ds = exd.getDataSet()) == null || (definition = ds.getDefinition()) == null || (cols = definition.getListOfColumn()) == null) continue;
            for (ColumnDefinition col : cols) {
                ColumnType type;
                if (col == null || (type = (ColumnType)col.getListOfColumnType().get(0)) == null || !type.equals((Object)ColumnType.REG)) continue;
                col.setColumnType(new ColumnType[]{ColumnType.COVARIATE});
                this.hasResetColumnUsageRegToCov = true;
            }
        }
    }

    public void setCurrentStructuralBlock(StructuralBlock sb) {
        if (sb == null) {
            throw new NullPointerException("Structural block is NULL.");
        }
        this.currentSb = sb;
    }

    public void setDeactivateIdFactory(boolean decision) {
        throw new UnsupportedOperationException();
    }

    public void setDom(PharmML dom) {
        this.dom = dom;
    }

    public void setDuplicateVariablesPermitted(boolean decision) {
        throw new UnsupportedOperationException();
    }

    public void setEchoException(boolean decision) {
        this.is_echo_exception = decision;
    }

    public void setFilterReservedWords(boolean decision) {
        this.filter_reserved_words = decision;
    }

    public void setIndexFromZero(boolean decision) {
        throw new UnsupportedOperationException();
    }

    public void setIsolateConditionalDoseVariable(boolean decision) {
        this.isolate_conditional_dose_variable = decision;
    }

    public void setIsolateDoseTimingVariable(boolean decision) {
        this.isolate_dt = decision;
    }

    public void setLexOnly(boolean decision) {
        throw new UnsupportedOperationException();
    }

    public void setLoadOnly(boolean decision) {
        throw new UnsupportedOperationException();
    }

    public void setMixedEffect(boolean value) {
        throw new UnsupportedOperationException();
    }

    public void setModelFilename(String model_filename_) {
        this.model_filename = model_filename_;
    }

    public void setPermitEmptyTrialDesignBlock(boolean decision) {
        this.permitEmptyTrialDesignBlock = decision;
    }

    public void setRemoveIllegalCharacters(boolean decision) {
        this.remove_illegal_chars = decision;
    }

    public void setRunId(String run_id_) {
        throw new UnsupportedOperationException();
    }

    public void setSaveRenamedSymbolList(boolean decision) {
        throw new UnsupportedOperationException();
    }

    public void setSaveSimulationOutput(boolean decision) {
        throw new UnsupportedOperationException();
    }

    public void setScriptDefinition(ScriptDefinition sd_) {
        this.sd = sd_;
    }

    public void setSortParameterModel(boolean decision) {
        throw new UnsupportedOperationException();
    }

    public void setSortParameterModelByClustering(boolean decision) {
        throw new UnsupportedOperationException();
    }

    public void setSortParameterModelByContext(boolean decision) {
        this.sort_parameter_model_by_context = decision;
    }

    public void setSortStructuralModel(boolean decision) {
        this.sort_structural_model = decision;
    }

    public void setTranslator(Translator tr_) {
        if (tr_ != null) {
            this.tr = tr_;
        }
    }

    public void setTreeMaker(TreeMaker tm) {
        if (tm != null) {
            this.tm = tm;
        }
    }

    public void setUseGlobalConditionalDoseVariable(boolean decision) {
        this.useGlobalConditionalDoseVariable = decision;
    }

    public void setUsePiecewiseAsEvents(boolean decision) {
        this.usePiecewiseAsEvents = decision;
    }

    public void setValidateXML(boolean decision) {
        this.validate_xml = decision;
    }

    private void sortElementOrdering() throws NullPointerException, IOException {
        if (this.sort_parameter_model_by_context) {
            this.sortParameterBlockByContext(this.getParameterBlock());
        }
        if (this.sort_structural_model) {
            this.sortStructuralBlock((StructuralBlockImpl)this.getStrucuturalBlock());
        }
    }

    private void sortParameterBlockByContext(ParameterBlock pb) throws NullPointerException, IOException {
        EstimationStep est;
        PopulationParameter p;
        ParameterContext ctx;
        List depends_upon;
        DependencyRef ref;
        this.createParameterContext();
        ArrayList old_list = new ArrayList();
        ArrayList<Object> new_list = new ArrayList<Object>();
        old_list.addAll(pb.getListOfDeclarations());
        ArrayList<DependencyRef> refs = new ArrayList<DependencyRef>();
        HashMap<Object, DependencyRef> dep_map = new HashMap<Object, DependencyRef>();
        for (PharmMLRootType o : old_list) {
            DependencyRef ref2 = new DependencyRef((PharmMLElement)o);
            BinaryTree bt = this.tm.newInstance((Object)o);
            this.addDependency(ref2, bt);
            List ntrefs = this.tm.getNestedTrees();
            for (NestedTreeRef ntref : ntrefs) {
                this.addDependency(ref2, ntref.bt);
            }
            refs.add(ref2);
            dep_map.put(o, ref2);
        }
        for (int i = 0; i < refs.size(); ++i) {
            DependencyRef ref3 = (DependencyRef)refs.get(i);
            if (!ref3.hasDependendsUpon()) continue;
            for (int j = 0; j < ref3.getDependsUpon().size(); ++j) {
                PharmMLElement depends_upon2 = (PharmMLElement)ref3.getDependsUpon().get(j);
                DependencyRef other_ref = (DependencyRef)dep_map.get(depends_upon2);
                if (other_ref == null || !other_ref.hasDependendsUpon()) continue;
                for (int k = 0; k < other_ref.getDependsUpon().size(); ++k) {
                    ref3.addDependency((PharmMLElement)other_ref.getDependsUpon().get(k));
                }
            }
        }
        List elements_under_consideration = DependencyRef.createElementsUnderConsideration(refs);
        if (elements_under_consideration.isEmpty()) {
            return;
        }
        DependencyRef.updateDependencyContext((List)elements_under_consideration, refs);
        dep_map = new HashMap();
        for (DependencyRef ref4 : refs) {
            dep_map.put(ref4.getElement(), ref4);
        }
        List ips = pb.getIndividualParameters();
        if (ips.size() > 0) {
            old_list.removeAll(ips);
            for (IndividualParameter ip : ips) {
                DependencyRef ref5;
                if (ip == null || (ref5 = (DependencyRef)dep_map.get(ip)) == null) continue;
                List depends_upon3 = ref5.getDependsUpon();
                for (PharmMLElement o : depends_upon3) {
                    PopulationParameter p2;
                    ParameterContext ctx2;
                    if (!PharmMLTypeChecker.isPopulationParameter((Object)o) || (ctx2 = this.getParameterContext(p2 = (PopulationParameter)o)) == null || !ctx2.theta) continue;
                    if (!new_list.contains(p2)) {
                        new_list.add(p2);
                    }
                    if (!old_list.contains(p2)) continue;
                    old_list.remove(p2);
                }
            }
        }
        ArrayList<PopulationParameter> elements_to_remove = new ArrayList<PopulationParameter>();
        for (PharmMLRootType o : old_list) {
            if (!PharmMLTypeChecker.isPopulationParameter((Object)o)) continue;
            PopulationParameter p3 = (PopulationParameter)o;
            ParameterContext ctx3 = this.getParameterContext(p3);
            if (!ctx3.error_model) continue;
            if (!new_list.contains(p3)) {
                new_list.add(p3);
            }
            if (elements_to_remove.contains(p3)) continue;
            elements_to_remove.add(p3);
        }
        if (!elements_to_remove.isEmpty()) {
            old_list.removeAll(elements_to_remove);
            elements_to_remove.clear();
        }
        if (ips.size() > 0) {
            for (IndividualParameter ip : ips) {
                if (ip == null || (ref = (DependencyRef)dep_map.get(ip)) == null) continue;
                depends_upon = ref.getDependsUpon();
                for (PharmMLElement o : depends_upon) {
                    if (!PharmMLTypeChecker.isPopulationParameter((Object)o) || (ctx = this.getParameterContext(p = (PopulationParameter)o)) == null || !ctx.theta_fixed_effect) continue;
                    if (!new_list.contains(p)) {
                        new_list.add(p);
                    }
                    if (!old_list.contains(p)) continue;
                    old_list.remove(p);
                }
            }
        }
        if (ips.size() > 0) {
            for (IndividualParameter ip : ips) {
                if (ip == null || (ref = (DependencyRef)dep_map.get(ip)) == null) continue;
                depends_upon = ref.getDependsUpon();
                for (PharmMLElement o : depends_upon) {
                    if (!PharmMLTypeChecker.isPopulationParameter((Object)o) || (ctx = this.getParameterContext(p = (PopulationParameter)o)) == null || !ctx.omega) continue;
                    if (!new_list.contains(p)) {
                        new_list.add(p);
                    }
                    if (!old_list.contains(p)) continue;
                    old_list.remove(p);
                }
            }
        }
        if (ips.size() > 0) {
            for (IndividualParameter ip : ips) {
                if (ip == null || (ref = (DependencyRef)dep_map.get(ip)) == null) continue;
                depends_upon = ref.getDependsUpon();
                for (PharmMLElement o : depends_upon) {
                    if (!PharmMLTypeChecker.isRandomVariable((Object)o)) continue;
                    if (!new_list.contains(o)) {
                        new_list.add((PharmMLRootType)o);
                    }
                    if (!old_list.contains(o)) continue;
                    old_list.remove(o);
                }
            }
        }
        if (ips.size() > 0) {
            for (IndividualParameter ip : ips) {
                if (!new_list.contains(ip)) {
                    new_list.add(ip);
                }
                if (!old_list.contains(ip)) continue;
                old_list.remove(ip);
            }
        }
        if (old_list.size() == 1) {
            new_list.addAll(old_list);
            old_list.clear();
        } else if (old_list.size() > 1) {
            refs.clear();
            for (PharmMLRootType o : old_list) {
                if (o == null || (ref = (DependencyRef)dep_map.get(o)) == null || refs.contains(ref)) continue;
                refs.add(ref);
            }
            elements_under_consideration = DependencyRef.createElementsUnderConsideration(refs);
            if (!elements_under_consideration.isEmpty()) {
                DependencyRef.updateDependencyContext((List)elements_under_consideration, refs);
                DependencyGraph g = new DependencyGraph(refs);
                g.createVertices();
                int edgeCount = g.createEdges();
                if (edgeCount > 0) {
                    g.sort();
                    List ordered_variables = g.getSortedElements();
                    for (PharmMLElement o : ordered_variables) {
                        if (!new_list.contains(o)) {
                            new_list.add((PharmMLRootType)o);
                        }
                        if (!old_list.contains(o)) continue;
                        old_list.remove(o);
                    }
                }
            }
            if (!old_list.isEmpty()) {
                for (PharmMLRootType o : old_list) {
                    if (new_list.contains(o)) continue;
                    new_list.add(o);
                }
            }
        }
        ArrayList<Object> ordered_variables = new ArrayList<Object>();
        ordered_variables.addAll(new_list);
        pb.setOrderedVariableList(ordered_variables);
        if (this.hasEstimation() && (est = this.getEstimationStep()) != null) {
            est.update();
        }
    }

    private void sortStructuralBlock(StructuralBlock sb) throws NullPointerException, IOException {
        if (sb == null) {
            return;
        }
        List list = sb.getListOfDeclarations();
        ArrayList<DependencyRef> refs = new ArrayList<DependencyRef>();
        HashMap<PharmMLRootType, DependencyRef> dep_map = new HashMap<PharmMLRootType, DependencyRef>();
        for (PharmMLRootType o : list) {
            DependencyRef ref = new DependencyRef((PharmMLElement)o);
            BinaryTree bt = this.tm.newInstance((Object)o);
            List ntrefs = this.tm.getNestedTrees();
            ArrayList local_ntrefs = new ArrayList();
            local_ntrefs.addAll(ntrefs);
            this.addDependency(ref, bt);
            for (NestedTreeRef ntref : local_ntrefs) {
                this.addDependency(ref, ntref.bt);
            }
            refs.add(ref);
            dep_map.put(o, ref);
        }
        for (int i = 0; i < refs.size(); ++i) {
            DependencyRef ref = (DependencyRef)refs.get(i);
            if (!ref.hasDependendsUpon()) continue;
            for (int j = 0; j < ref.getDependsUpon().size(); ++j) {
                PharmMLElement depends_upon = (PharmMLElement)ref.getDependsUpon().get(j);
                DependencyRef other_ref = (DependencyRef)dep_map.get(depends_upon);
                if (other_ref == null || !other_ref.hasDependendsUpon()) continue;
                for (int k = 0; k < other_ref.getDependsUpon().size(); ++k) {
                    ref.addDependency((PharmMLElement)other_ref.getDependsUpon().get(k));
                }
            }
        }
        List elements_under_consideration = DependencyRef.createElementsUnderConsideration(refs);
        if (elements_under_consideration.isEmpty()) {
            return;
        }
        DependencyRef.updateDependencyContext((List)elements_under_consideration, refs);
        DependencyGraph g = new DependencyGraph(refs);
        g.createVertices();
        int edgeCount = g.createEdges();
        if (edgeCount == 0) {
            return;
        }
        g.sort();
        List ordered_variables = g.getSortedElements();
        if (ordered_variables.isEmpty()) {
            return;
        }
        sb.setOrderedVariableList(ordered_variables);
    }

    public String toString() {
        return String.format("PharmMLToWINBUGSConverter [source=%s, target=%s, converterVersion=%s]", this.source, this.target, this.converterVersion);
    }

    private void translatePKMacros() {
        if (!this.translate_macros) {
            return;
        }
        ModelDefinition def = this.dom.getModelDefinition();
        if (def == null) {
            return;
        }
        ArrayList<StructuralModel> sms_with_macros = new ArrayList<StructuralModel>();
        List sms = def.getListOfStructuralModel();
        Accessor a = new Accessor(this.dom);
        for (StructuralModel sm : sms) {
            PKMacroList macros;
            if (sm == null || (macros = a.getPKMacros(sm)) == null || macros.getListOfMacro().isEmpty()) continue;
            sms_with_macros.add(sm);
        }
        if (sms_with_macros.size() == 0) {
            return;
        }
        if (this.tr == null) {
            throw new NullPointerException("The Macro translator is NULL.");
        }
        for (StructuralModel sm : sms_with_macros) {
            try {
                MacroOutput output = this.tr.translate(sm, this.target_level, ((Parser)this.getParser()).getIndependentVariable());
                StructuralModel sm_translated = output.getStructuralModel();
                if (!ConverterProvider.replace(this.dom, sm, sm_translated)) {
                    throw new IllegalStateException("PK macros translation failed (blkId='" + sm.getBlkId() + "')");
                }
                PKMacroList macros = this.accessor.getPKMacros(sm);
                if (!this.macro_output_map.containsKey(sm_translated)) {
                    this.macro_output_map.put(sm_translated, output);
                }
                if (this.macro_input_map.containsKey(sm_translated)) continue;
                this.macro_input_map.put(sm_translated, macros.getListOfMacro());
            }
            catch (InvalidMacroException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        this.updatePKMacroDataMappings();
    }

    private static boolean replace(PharmML dom, StructuralModel old_sm, StructuralModel new_sm) {
        if (dom == null || old_sm == null || new_sm == null) {
            return false;
        }
        String blkId = old_sm.getBlkId();
        if (blkId == null) {
            return false;
        }
        ModelDefinition def = dom.getModelDefinition();
        if (def == null) {
            return false;
        }
        List sms_original = def.getListOfStructuralModel();
        if (sms_original == null) {
            return false;
        }
        if (sms_original.isEmpty()) {
            return false;
        }
        ArrayList sms = new ArrayList();
        sms.addAll(sms_original);
        boolean foundBlock = false;
        for (StructuralModel sm : sms) {
            if (sm == null || !sm.equals(old_sm)) continue;
            foundBlock = true;
            break;
        }
        if (!foundBlock) {
            return false;
        }
        new_sm.setBlkId(blkId);
        sms_original.clear();
        for (StructuralModel sm : sms) {
            if (sm == null) continue;
            if (sm.equals(old_sm)) {
                sms_original.add(new_sm);
                continue;
            }
            sms_original.add(sm);
        }
        return true;
    }

    public void updateNestedTrees() {
        for (NestedTreeRef ref : this.tm.getNestedTrees()) {
            this.addStatement(ref);
        }
        this.tm.getNestedTrees().clear();
    }

    private void updatePKMacroDataMappings() {
        TrialDesign td = this.dom.getTrialDesign();
        if (td == null) {
            return;
        }
        List exds = td.getListOfExternalDataSet();
        if (exds == null) {
            return;
        }
        ModelDefinition def = this.dom.getModelDefinition();
        if (def == null) {
            return;
        }
        this.getAccessor();
        for (ExternalDataSet exd : exds) {
            if (exd == null) continue;
            TabularDataset table = new TabularDataset(exd.getDataSet(), (ILexer)this);
            for (PharmMLRootType element : exd.getListOfColumnMappingOrColumnTransformationOrMultipleDVMapping()) {
                if (!PharmMLTypeChecker.isColumnMapping((Object)element)) continue;
                this.remapColumnPostPKMacroTranslation((ColumnMapping)element, table);
            }
        }
    }

    public boolean useCachedDependencyList() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPlottingBlock() {
        return false;
    }

    public void setAddPlottingBlock(boolean addPlottingBlock) {
        throw new UnsupportedOperationException();
    }

    public static SymbolRef symbolRef(PharmMLRootType o, Accessor a) {
        String symbId = null;
        boolean addScope = false;
        if (PharmMLTypeChecker.isSymbolReference((Object)o)) {
            return (SymbolRef)o;
        }
        if (PharmMLTypeChecker.isCommonParameter((Object)o)) {
            symbId = ((CommonParameter)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isLocalVariable((Object)o)) {
            symbId = ((VariableDefinition)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isDerivative((Object)o)) {
            symbId = ((DerivativeVariable)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isIndividualParameter((Object)o)) {
            symbId = ((IndividualParameter)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isRandomVariable((Object)o)) {
            symbId = ((ParameterRandomVariable)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isIndependentVariable((Object)o)) {
            symbId = ((IndependentVariable)o).getSymbId();
        } else if (PharmMLTypeChecker.isCovariate((Object)o)) {
            symbId = ((CovariateDefinition)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isFunctionParameter((Object)o)) {
            symbId = ((FunctionParameter)o).getSymbId();
        } else if (PharmMLTypeChecker.isFunction((Object)o)) {
            symbId = ((FunctionDefinition)o).getSymbId();
        } else if (PharmMLTypeChecker.isObservationError((Object)o)) {
            symbId = ((ObservationError)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isColumnDefinition((Object)o)) {
            symbId = ((ColumnDefinition)o).getColumnId();
            addScope = false;
        } else if (PharmMLTypeChecker.isContinuousCovariate((Object)o)) {
            ContinuousCovariate ccov = (ContinuousCovariate)o;
            for (CovariateTransformation trans : ccov.getListOfTransformation()) {
                TransformedCovariate tc;
                if (trans == null || (tc = trans.getTransformedCovariate()) == null) continue;
                symbId = tc.getSymbId();
                addScope = true;
                break;
            }
        } else if (PharmMLTypeChecker.isVariabilityLevelDefinition((Object)o)) {
            VariabilityLevelDefinition level = (VariabilityLevelDefinition)o;
            symbId = level.getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isGeneralError((Object)o)) {
            GeneralObsError goe = (GeneralObsError)o;
            symbId = goe.getSymbId();
            addScope = true;
        } else {
            throw new UnsupportedOperationException("Unsupported Symbol reference (src='" + o + "')");
        }
        if (symbId == null) {
            throw new NullPointerException("SymbId is NULL.");
        }
        SymbolRef ref = new SymbolRef();
        ref.setSymbIdRef(symbId);
        if (addScope) {
            String blkId = a.getBlockId(o);
            if (blkId == null) {
                throw new NullPointerException("BlkId is not known (symbId='" + symbId + "', class='" + Utils.getClassName((Object)o) + "')");
            }
            ref.setBlkIdRef(blkId);
        }
        return ref;
    }

    public static LogicBinOp logicalBinaryOperator(String pharmml_symbol, Object[] elements, Accessor a) {
        if (elements == null || pharmml_symbol == null || a == null) {
            throw new NullPointerException("A function argument cannot be NULL.");
        }
        LogicBinOp op = new LogicBinOp();
        op.setOp(pharmml_symbol);
        int addedElements = 0;
        for (Object o : elements) {
            if (ConverterProvider.isInteger((Object)o)) {
                op.getContent().add(ConverterProvider.createScalar((Integer)o));
                ++addedElements;
                continue;
            }
            if (PharmMLTypeChecker.isLogicalBinaryOperation((Object)o)) {
                op.getContent().add(math_of.createLogicBinop((LogicBinOp)o));
                ++addedElements;
                continue;
            }
            if (!PharmMLTypeChecker.isColumnDefinition((Object)o)) continue;
            ColumnDefinition col = (ColumnDefinition)o;
            ColumnReference ref = new ColumnReference();
            ref.setColumnIdRef(col.getColumnId());
            op.getContent().add(ds_of.createColumnRef(ref));
            ++addedElements;
        }
        if (addedElements != 2) {
            throw new IllegalStateException("A binary operator can only contains 2 elements.");
        }
        return op;
    }

    private static JAXBElement<IntValue> createScalar(Integer value) {
        IntValue o = new IntValue(value);
        return cof.createInt(o);
    }

    public void checkForTrialDesignIfRandomisedModel() {
        boolean has_mixed_effect = false;
        for (StructuralBlock sb : this.getStructuralBlocks()) {
            if (!sb.isMixedEffect()) continue;
            has_mixed_effect = true;
            break;
        }
        if (has_mixed_effect && this.getTrialDesign() == null) {
            throw new IllegalStateException("Trial design not included in model even though contains individual parameter terms.");
        }
    }

    public void addIndexSymbol(Object key, String value) {
        if (key != null && value != null && !this.index_symbol_map.containsKey(key)) {
            this.index_symbol_map.put(key, value);
        }
    }

    public boolean isIndividualParameterSym(String symbol) {
        if (symbol != null && !this.sd.getParameterBlocks().isEmpty() && this.getParameterBlock() != null) {
            List ipL = this.getParameterBlock().getIndividualParameters();
            for (IndividualParameter ip : ipL) {
                String currentSymbol;
                if (ip == null || (currentSymbol = ip.getSymbId()) == null || !currentSymbol.equals(symbol)) continue;
                return true;
            }
        }
        return false;
    }

    private ConversionReport createWinBUGSModel(File outputDirectory, File src) {
        String run_id = "";
        try {
            if (run_id != null) {
                this.parser.setRunId(new Manager().generateRunId());
            } else {
                this.parser.setRunId(m.generateRunId());
            }
        }
        catch (Exception e) {
            return this.getExceptionReport(e);
        }
        try {
            this.setOutputDirectory(outputDirectory);
        }
        catch (Exception e) {
            return this.getExceptionReport(e);
        }
        try {
            this.loadPharmML(src);
        }
        catch (Exception e) {
            return this.getExceptionReport(e);
        }
        try {
            this.createBlocks(outputDirectory);
            File f = this.createScript(src, outputDirectory);
            return this.getCrxSuccessReport(f);
        }
        catch (Exception e) {
            return this.getExceptionReport(e);
        }
    }

    public EstimationStep getEstimationStep() {
        for (Object o : this.sd.getStepsMap().values()) {
            if (!(o instanceof EstimationStepImpl)) continue;
            return (EstimationStep)o;
        }
        return null;
    }

    public VariableDeclarationContext guessContext(VariableDefinition v) {
        VariableDefinition o;
        PharmMLRootType element;
        EstimationStep est;
        if (v == null) {
            return VariableDeclarationContext.UNKNOWN;
        }
        if (v.getAssign() != null) {
            return VariableDeclarationContext.ASSIGNED;
        }
        String symbol = v.getSymbId();
        if (symbol == null) {
            return VariableDeclarationContext.UNKNOWN;
        }
        if (this.hasEstimation() && (est = this.getEstimationStep()).hasTemporalDoseEvent() && PharmMLTypeChecker.isLocalVariable((Object)(element = est.getTemporalDoseEvent().getTargetElement())) && symbol.equals((o = (VariableDefinition)element).getSymbId())) {
            return VariableDeclarationContext.DT;
        }
        est = this.getEstimationStep();
        boolean isConditionalDoseEventTarget = false;
        if (est != null && est.isConditionalDoseEventTarget(v)) {
            isConditionalDoseEventTarget = true;
        }
        if (isConditionalDoseEventTarget) {
            return VariableDeclarationContext.DOSE;
        }
        if (this.guessColumnDoseContext((BaseStep)est, v)) {
            return VariableDeclarationContext.DOSE;
        }
        return VariableDeclarationContext.UNKNOWN;
    }

    public boolean hasDosing() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasTranslatedPKMacros() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasUntranslatedPKMacros() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isIsolateConditionalDoseVariable() {
        return this.isolate_conditional_dose_variable;
    }

    public boolean isIsolatingDoseTimingVariable() {
        return this.isolate_dt;
    }

    public boolean isMixedEffect() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isModelParameter(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isObservationParameter(PopulationParameter pp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isObservationParameter(SymbolRef sr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isPermitEmptyTrialDesignBlock() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isRemoveIllegalCharacters() {
        return this.remove_illegal_chars;
    }

    public boolean isSaveSimulationOutput() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isStateVariable(String name) {
        boolean isState;
        block1: {
            StructuralBlock sb;
            isState = false;
            if (this.sd.getStructuralBlocks().isEmpty() || name == null) break block1;
            Iterator i$ = this.sd.getStructuralBlocks().iterator();
            while (i$.hasNext() && ((sb = (StructuralBlock)i$.next()) == null || !(isState = sb.isStateVariable(name)))) {
            }
        }
        return isState;
    }

    public boolean isStructuralBlockWithDosing(StructuralBlock sb) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isTranslate() {
        return this.translate_macros;
    }

    public boolean isTTE() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isUseGlobalConditionalDoseVariable() {
        return this.useGlobalConditionalDoseVariable;
    }

    public boolean isUsePiecewiseAsEvents() {
        return this.usePiecewiseAsEvents;
    }

    public boolean loadFunctionLibrary(File file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void permitObjectiveETAs(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSortStructuralModelByClustering(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSortVariabilityLevels(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setTerminateWithInvalidXML(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setTranslate(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isIsolateGloballyScopedVariables() {
        return false;
    }

    public void setIsolateGloballyScopedVariables(boolean arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

