/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs;

import eu.ddmore.converters.unipv.winbugs.ConverterProvider;
import java.io.File;
import java.io.IOException;

public class ConverterTester {
    private String xmlFileName;
    private String propFile;
    private int parserType;
    private String solverType;
    private String outputDir;
    private static final int[] odeSolverTypeCodes = new int[]{1, 2};

    public ConverterTester(String propFile) {
        this.propFile = propFile;
    }

    public ConverterTester(int parserT, String solverT, String fileN) {
        this.parserType = parserT;
        this.solverType = solverT;
        this.xmlFileName = fileN;
        this.outputDir = "./";
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            ConverterTester.printHelp();
            return;
        }
        ConverterTester mt = new ConverterTester(2, args[1], args[0]);
        mt.runConversion();
    }

    private void runConversion() throws IOException {
        ConverterProvider c = new ConverterProvider();
        c.setParserType(2);
        c.setSolverType(Integer.parseInt(this.solverType));
        c.performConvert(new File(this.xmlFileName), new File(this.outputDir));
    }

    public String getPropFile() {
        return this.propFile;
    }

    public String toString() {
        return "Model Conversion\nxmlFileName=" + this.xmlFileName + "\nparserType=" + this.parserType + "\nsolverType=" + this.solverType + "\noutputDir=" + this.outputDir + "\n}";
    }

    public void setXmlFileName(String xmlFileName) {
        this.xmlFileName = xmlFileName;
    }

    private static void printHelp() {
        System.out.println("usage: java -jar jar_name file_name parserType [solverType]\n\twhere\n ");
        System.out.println("\tparser type can be ");
        System.out.println("\t in case of Pascal Ver 2 you have to specify also the solver type: ");
        System.out.println("\t\t" + odeSolverTypeCodes[0] + " " + "RK45");
        System.out.println("\t\t" + odeSolverTypeCodes[1] + " " + "LSODA");
    }
}

