/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs;

import crx.converter.engine.Accessor;
import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.spi.blocks.StructuralBlock;
import crx.converter.tree.BinaryTree;
import crx.converter.tree.Node;
import crx.converter.tree.TreeMaker;
import eu.ddmore.converters.unipv.winbugs.Parser;
import eu.ddmore.converters.unipv.winbugs.PascalParser2;
import eu.ddmore.converters.unipv.winbugs.Util;
import eu.ddmore.libpharmml.dom.commontypes.DerivativeVariable;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.VariableDefinition;
import eu.ddmore.libpharmml.dom.maths.Binop;
import eu.ddmore.libpharmml.dom.maths.Condition;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.FunctionCallType;
import eu.ddmore.libpharmml.dom.maths.Piece;
import eu.ddmore.libpharmml.dom.maths.Piecewise;
import eu.ddmore.libpharmml.dom.maths.Uniop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;

public abstract class PascalParser
extends Parser {
    protected static final String templateFile = "";
    protected static final String piecewiseTemplateFileName = "TemplatePiecewise.txt";
    protected static final String piecewiseFileName = "FunctionPiecewise";
    protected static final String covariateFileName = "FunctionCovariate";
    protected String outputDirPascal1;
    protected String outputDirPascal2;
    protected String outputDirPascal2Mod;
    protected String outputDirPiecewisePascal;
    protected String piecewisePascalName;
    protected String odeCallName;
    protected String icLabel = "IC";
    protected static String outputPascalFile = "";
    protected List<String> odeParamLines = new ArrayList<String>();
    protected String parName = "theta";
    protected String parContCovName = "p_cont";
    protected String parCatCovName = "p_cat";
    protected int indPAS0 = 0;
    protected int indWB0 = 1;
    protected File pascalFile;
    protected File pascalModFile;
    protected File pascalPMetricsFileName;
    protected static final String PMetricsFileName = "PKModels.txt";
    protected static final String pmetricsTemplate = "PKModels.txt";
    protected String pascalMod;
    protected String[] pascalPiecewise;
    protected List<String> pascalCatCov = new ArrayList<String>();
    protected String pascalPKmodel;
    protected String min_format = "MIN(%s, %s)";
    protected String max_format = "MAX(%s, %s)";
    protected String rem_format = "REM(%s, %s)";
    protected String logx_format = "(Math.Ln(%s)/Math.Ln(%s))";
    protected String root_format = "MathFunc.Power(%s,1.0/(%s))";

    public void setPiecewisePascalName(String piecewisePascalName) {
        this.piecewisePascalName = piecewisePascalName;
    }

    public String getPiecewisePascalName() {
        return this.piecewisePascalName;
    }

    public void setOutputDirPiecewisePascal(String outputDirPiecewisePascal) {
        this.outputDirPiecewisePascal = outputDirPiecewisePascal;
    }

    public String getOutputDirPiecewisePascal() {
        return this.outputDirPiecewisePascal;
    }

    protected abstract void pascalEquation(Object var1, Node var2);

    protected abstract void pascalPiecewiseEquation(Object var1, Node var2);

    @Override
    protected void manageStateVariables(StructuralBlock sb, int nSb) throws FileNotFoundException, IOException {
        List rvs = sb.getStateVariables();
        for (DerivativeVariable rv : rvs) {
            this.doDerivativeRef(rv.getSymbId());
        }
        if (this.derivativeSymbols.size() == 0) {
            return;
        }
        super.manageStateVariables(sb, nSb);
    }

    protected abstract List<String> pascalCodeFileGeneration() throws FileNotFoundException, IOException;

    protected abstract String pascalParametersDeclaration();

    protected String stateVarDecl(String format) {
        StringBuilder sbVar = new StringBuilder();
        String sep = templateFile;
        for (int i = 0; i < this.completeStateVariablesList.size(); ++i) {
            sbVar.append(sep + this.varLabel + i);
            sep = ", ";
        }
        String line1 = String.format(format, sbVar.toString());
        return line1;
    }

    protected String pascalCatCovCodeFileGeneration(int num, String catVal, String id) throws FileNotFoundException, IOException {
        String format = this.getPascalTemplate("TemplateCovariate.txt");
        String file = String.format(format, num, id, id, id, catVal, num);
        return file;
    }

    protected String pascalCatCovCodeBlockGeneration(String idInterp, String catVal, String idPiece) throws FileNotFoundException, IOException {
        String format = "IF %s = %s THEN;\n\t\t\t%s := 1;\n\t\tELSE;\n\t\t\t%s := 0;\n\t\tEND;";
        String file = String.format(format, this.delimit(idInterp), catVal, this.delimit(idPiece), this.delimit(idPiece));
        return file;
    }

    protected String stateICDecl(String format) {
        String sep = templateFile;
        StringBuilder sbIc = new StringBuilder();
        for (int i = 0; i < this.completeStateVariablesList.size(); ++i) {
            sbIc.append(sep + this.icLabel + i);
            sep = ", ";
        }
        String line2 = String.format(format, sbIc.toString());
        return line2;
    }

    private String generatePiecewiseVarDeclaration(String pwId) {
        ArrayList lines = new ArrayList();
        String format = "%s: REAL;\n\t\t";
        StringBuilder sb = new StringBuilder(templateFile);
        int num = this.pascalVarMap.values().size();
        for (Map.Entry pw : this.piecewiseIndexMap.entrySet()) {
            if (this.pascalVarMap.containsKey(pwId)) continue;
            this.pascalVarMap.put(pw.getKey(), num++);
        }
        this.vars = new ArrayList();
        this.vars = (List)this.parVariablesFromMap.get(pwId);
        for (SymbolRef sr : this.vars) {
            if (!this.parVariablesFromMap.containsKey(sr.getSymbIdRef())) {
                sb.append(String.format(format, sr.getSymbIdRef()));
                continue;
            }
            sb.append(String.format(format, sr.getSymbIdRef() + upperSuffixDerDepLabel));
        }
        List<SymbolRef> a = this.getPiecewiseParameters_Pascal(this.vars);
        for (SymbolRef s : a) {
            if (this.vars.contains(s)) continue;
            if (!this.parVariablesFromMap.containsKey(s.getSymbIdRef())) {
                sb.append(String.format(format, s.getSymbIdRef()));
                continue;
            }
            sb.append(String.format(format, s.getSymbIdRef() + upperSuffixDerDepLabel));
        }
        return Util.clean(sb.toString());
    }

    private String adjustPascalName(String s1) {
        if (this.parVariablesFromMap.containsKey(s1)) {
            s1 = s1.replaceAll(s1, this.delimit(s1 + upperSuffixDerDepLabel));
            s1 = Util.clean(s1);
        }
        return s1;
    }

    protected String pascalPiecewiseCodeFileGeneration(int num, String id) throws FileNotFoundException, IOException {
        String format = this.getPascalTemplate(piecewiseTemplateFileName);
        this.pascalPiecewise[num - 1] = String.format(format, num, this.generatePiecewiseVarDeclaration(id), Util.clean(this.generatePiecewiseBlocks(id)), num);
        return this.pascalPiecewise[num - 1];
    }

    String getModuleName(File f) {
        String out = templateFile;
        String path = f.getPath();
        String name = f.getName();
        out = path.contains("Pmetrics") ? "Pmetrics" : "WBDev";
        out = out + name;
        return out.substring(0, out.indexOf(".txt"));
    }

    String getRootModuleName(String f) {
        String out = templateFile;
        String path = f.substring(0, f.lastIndexOf("/"));
        String name = f.substring(f.lastIndexOf("/") + 1);
        out = path.contains("Pmetrics") ? "Pmetrics" : "WBDev";
        out = out + name;
        return out;
    }

    @Override
    public void writeModelFunction(PrintWriter fout, StructuralBlock sb) throws IOException {
        super.writeModelFunction(fout, sb);
        if (this.pascalBody != null && this instanceof PascalParser2) {
            this.output(this.pascalBody, this.pascalFile, true);
            this.output(this.pascalMod, this.pascalModFile, true);
            String pmetrics = this.getPascalTemplate("PKModels.txt");
            int ngrid = Integer.parseInt(((PascalParser2)this).getTotGrid());
            int nState = this.derivativeSymbols.size();
            int npar = (int)Math.min(Math.round(200000.0 / (double)ngrid), 1000L);
            String pkBody = String.format(pmetrics, ngrid, npar, nState);
            this.output(pkBody, this.pascalPMetricsFileName, true);
            PrintWriter out = new PrintWriter(new File(PascalParser.getWinbugsDir() + "/" + "toConv.txt"));
            if (this.hasDiffEquations) {
                out.println("Pmetrics " + Util.getFileName(this.pascalFile));
                out.println("Pmetrics " + Util.getFileName(this.pascalPMetricsFileName));
                out.println("WBDev " + Util.getFileName(this.pascalModFile));
                this.pmetricsList.add(this.getModuleName(this.pascalPMetricsFileName));
                this.pmetricsList.add(this.getModuleName(this.pascalFile));
                this.wbdevList.add(this.getModuleName(this.pascalModFile));
            }
            for (String string : this.pwList) {
                out.println("WBDev " + string.substring(string.indexOf("WBDev")));
            }
            for (Map.Entry entry : this.covFilesMap.entrySet()) {
                out.println("WBDev FunctionCovariate" + entry.getKey());
            }
            out.close();
            for (String string : this.pwList) {
                this.wbdevList.add(this.getRootModuleName(this.getPiecewisePascalName()) + string);
            }
            for (Map.Entry entry : this.covFilesMap.entrySet()) {
                this.wbdevList.add(this.getRootModuleName(this.getCovariatePascalName()) + entry.getKey());
            }
        }
        this.piecewiseCodeFileGeneration();
        this.createCompileScriptWinbugs();
    }

    protected void piecewiseCodeFileGeneration() throws FileNotFoundException, IOException {
        if (!this.piecewiseMap.isEmpty()) {
            this.pascalPiecewise = new String[this.piecewiseMap.size()];
            if (this instanceof PascalParser2) {
                for (Map.Entry pw : this.piecewiseMap.entrySet()) {
                    if (!this.pwBugsList.contains(Util.clean(this.removeIndexes((String)pw.getKey())))) continue;
                    int index = (Integer)this.piecewiseIndexMap.get(Util.clean(this.removeIndexes((String)pw.getKey())));
                    String piecewiseFile = piecewiseFileName + index + this.pascalFileNameSuffix;
                    this.inPW = true;
                    this.output(this.pascalPiecewiseCodeFileGeneration(index, Util.clean(this.removeIndexes((String)pw.getKey()))), new File(this.getPiecewisePascalName() + index + this.pascalFileNameSuffix), true);
                    this.pwList.add(this.getModuleName(new File(piecewiseFile)));
                    this.piecewiseFileList.add(piecewiseFile.substring(0, piecewiseFile.indexOf(".")));
                    this.inPW = false;
                }
                PrintWriter out = new PrintWriter(new FileWriter(PascalParser.getWinbugsDir() + "/" + "toConv.txt", true));
                out.close();
                out = new PrintWriter(new FileWriter(PascalParser.getWinbugsDir() + "/" + "toConv.txt", true));
                for (String nm : this.pwList) {
                    int p = nm.indexOf("Func");
                    out.println("WBDev " + nm.substring(p));
                }
                out.close();
            }
        }
    }

    public void setPascalFileName(File fileName) {
        this.pascalFile = fileName;
    }

    public void setPascalModFileName(File fileName) {
        this.pascalModFile = fileName;
    }

    public void setPascalPKmodel(String pascalPKmodel) {
        this.pascalPKmodel = pascalPKmodel;
    }

    public File getPascalPMetricsFileName() {
        return this.pascalPMetricsFileName;
    }

    protected void append(String body, File f) throws FileNotFoundException, IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));
        out.println(body);
        out.close();
    }

    public void setOutputDirPascal1(String outputDirPascal1) {
        this.outputDirPascal1 = outputDirPascal1;
    }

    String getPascalTemplate(String fName) throws FileNotFoundException, IOException {
        String line;
        this.outDebug.println("<-- template " + fName);
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new FileReader(new File(winbugsTemplateDir + fName)));
        while ((line = in.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    protected String doDerivativeRef(String id) {
        String symbol = templateFile;
        if (id != null) {
            Integer idx = this.getStateVarIndex(id);
            symbol = upperStateLabel + this.leftArrayBracket + "ind_subj" + "," + idx + this.rightArrayBracket;
            this.derivativeMap.put(id, symbol);
            this.derivativeMapNew.put(id, this.varLabel + idx);
        }
        return symbol;
    }

    protected boolean isInOdeParameters1(VariableDefinition v) {
        for (SymbolRef sr : this.odeParameters1) {
            if (!sr.getSymbIdRef().equals(v.getSymbId())) continue;
            return true;
        }
        return false;
    }

    protected boolean isInOdeParameters1(SymbolRef s) {
        for (SymbolRef sr : this.odeParameters1) {
            if (!sr.getSymbIdRef().equals(s.getSymbIdRef())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getStateVarIndex(String id) {
        DerivativeVariable var;
        int i = 0;
        Iterator i$ = this.completeStateVariablesList.iterator();
        while (i$.hasNext() && !(var = (DerivativeVariable)i$.next()).getSymbId().equals(id)) {
            ++i;
        }
        return i;
    }

    @Override
    protected String doUnaryOperation(Uniop u_op, String leftStatement) {
        String pascalUnaryOperator;
        try {
            pascalUnaryOperator = this.doPascalTransformation(u_op.getOperator().getOperator(), leftStatement);
        }
        catch (UnsupportedOperationException e) {
            pascalUnaryOperator = super.doUnaryOperation(u_op, leftStatement);
        }
        pascalUnaryOperator = "(" + pascalUnaryOperator + ")";
        String winbugsUnaryOperator = super.doUnaryOperation(u_op, leftStatement);
        if (!this.delimit(this.removeIndexes(winbugsUnaryOperator)).equals(this.delimit(this.removeIndexes(pascalUnaryOperator)))) {
            String in1 = this.removeIndexes(winbugsUnaryOperator);
            String in2 = this.adjustSuffix(pascalUnaryOperator);
            this.uniOpList.add(in1);
            this.unaryOpMap.put(in1, in2);
            this.updateUniopMap();
        }
        return winbugsUnaryOperator;
    }

    private String adjustSuffix(String in) {
        in = this.removeIndexes(in);
        for (SymbolRef s : this.stateV_Parameters) {
            if (PascalParser.isIn(s, this.theta_Parameters) || this.isCovariate(s) || !in.contains(this.delimit(s.getSymbIdRef())) || !this.parVariablesFromMap.containsKey(s.getSymbIdRef()) || this.isDerivativeVar(s.getSymbIdRef())) continue;
            String newId = this.delimit(s.getSymbIdRef() + upperSuffixDerDepLabel);
            in = in.replaceAll(this.delimit(s.getSymbIdRef()), this.delimit(newId));
        }
        return in;
    }

    @Override
    protected String doBinaryOperation(Binop b_op, String leftStatement, String rightStatement) {
        String pascalBinaryOperator;
        try {
            pascalBinaryOperator = this.doPascalTransformation(b_op.getOperator().toString(), leftStatement, rightStatement);
        }
        catch (UnsupportedOperationException e) {
            pascalBinaryOperator = super.doBinaryOperation(b_op, leftStatement, rightStatement);
        }
        String winbugsBinaryOperator = super.doBinaryOperation(b_op, leftStatement, rightStatement);
        if (!this.delimit(this.removeIndexes(winbugsBinaryOperator)).equals(this.delimit(this.removeIndexes(pascalBinaryOperator)))) {
            this.binOpMap.put(this.delimit(this.removeIndexes(winbugsBinaryOperator)), this.delimit(this.removeIndexes(pascalBinaryOperator)));
        }
        return winbugsBinaryOperator;
    }

    protected boolean checkIndiv() {
        boolean isIndividual = false;
        for (SymbolRef s : this.theta_Parameters) {
            String symbol = this.getSymbol(s);
            if (!symbol.contains("ind_subj")) continue;
            isIndividual = true;
        }
        return isIndividual;
    }

    @Override
    public String doPiecewise(Piecewise pw) {
        Piece piece;
        int i;
        String symbol = unassigned_symbol;
        List pieces = pw.getPiece();
        Piece else_block = null;
        BinaryTree[] assignment_trees = new BinaryTree[pieces.size()];
        BinaryTree[] conditional_trees = new BinaryTree[pieces.size()];
        String[] conditional_stmts = new String[pieces.size()];
        String[] assignment_stmts = new String[pieces.size()];
        TreeMaker tm = this.lexer.getTreeMaker();
        Accessor a = this.lexer.getAccessor();
        int assignment_count = 0;
        int else_index = -1;
        for (i = 0; i < pieces.size(); ++i) {
            piece = (Piece)pieces.get(i);
            if (piece == null) continue;
            Condition cond = piece.getCondition();
            if (cond != null) {
                conditional_trees[i] = tm.newInstance((Object)piece.getCondition());
                conditional_trees[i] = this.doPutCategory(conditional_trees[i]);
                if (cond.getOtherwise() != null) {
                    else_block = piece;
                    else_index = i;
                }
            }
            BinaryTree assignment_tree = null;
            ExpressionValue expr = piece.getValue();
            if (PharmMLTypeChecker.isBinaryOperation((Object)expr)) {
                assignment_tree = tm.newInstance((Object)PascalParser.rhs((Binop)expr, a));
                ++assignment_count;
            } else if (PharmMLTypeChecker.isConstant((Object)expr)) {
                assignment_tree = tm.newInstance((Object)expr);
                ++assignment_count;
            } else if (PharmMLTypeChecker.isFunctionCall((Object)expr)) {
                assignment_tree = tm.newInstance((Object)PascalParser.rhs((FunctionCallType)expr, a));
                ++assignment_count;
            } else if (PharmMLTypeChecker.isJAXBElement((Object)expr)) {
                assignment_tree = tm.newInstance((Object)PascalParser.rhs((JAXBElement)expr, a));
                ++assignment_count;
            } else if (PharmMLTypeChecker.isSymbolReference((Object)expr)) {
                assignment_tree = tm.newInstance((Object)expr);
                ++assignment_count;
            } else if (PharmMLTypeChecker.isScalarInterface((Object)expr)) {
                assignment_tree = tm.newInstance((Object)expr);
                ++assignment_count;
            } else {
                throw new IllegalStateException("Piecewise assignment failed (expr='" + expr + "')");
            }
            if (assignment_tree == null) continue;
            assignment_trees[i] = assignment_tree;
        }
        if (assignment_count == 0) {
            throw new IllegalStateException("A piecewise block has no assignment statements.");
        }
        for (i = 0; i < pieces.size(); ++i) {
            piece = (Piece)pieces.get(i);
            if (conditional_trees[i] == null || assignment_trees[i] == null) continue;
            if (!piece.equals(else_block)) {
                conditional_stmts[i] = "\t\t" + this.parse(piece, conditional_trees[i]);
            }
            assignment_stmts[i] = "\t\t" + this.parse(new Object(), assignment_trees[i]);
        }
        int block_assignment = 0;
        StringBuilder block = new StringBuilder(" NaN;\n");
        for (int i2 = 0; i2 < pieces.size(); ++i2) {
            Piece piece2 = (Piece)pieces.get(i2);
            if (piece2 == null || piece2.equals(else_block) || conditional_stmts[i2] == null || assignment_stmts[i2] == null) continue;
            String operator = "if";
            String format = "%s (%s) {\n %s <- %s \n";
            if (block_assignment > 0) {
                operator = "\t\t}\\t\\t else if ";
                format = "\t\t %s (%s) {\n %s <- %s \n";
            }
            block.append(String.format(format, operator, conditional_stmts[i2], this.field_tag, assignment_stmts[i2]));
            ++block_assignment;
        }
        if (else_block != null && else_index >= 0) {
            block.append("} else {\n");
            String format = " %s <- %s\n";
            block.append(String.format(format, this.field_tag, assignment_stmts[else_index]));
        }
        block.append("}");
        if (assignment_count == 0) {
            throw new IllegalStateException("Piecewise statement assigned no conditional blocks.");
        }
        symbol = block.toString();
        return templateFile;
    }
}

