/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs;

import eu.ddmore.converters.unipv.winbugs.ConverterProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class WinBugsConverterTester {
    private String xmlFileName;
    private String propFile;
    private int parserType;
    private String solverType;
    private int totCov;
    private int totGrid;
    private String outputDir;
    private static final int[] parserTypeCodes = new int[]{0, 1, 2};
    private static final int[] odeSolverTypeCodes = new int[]{1, 2};

    public WinBugsConverterTester(String propFile) {
        this.propFile = propFile;
    }

    public WinBugsConverterTester() {
        this.parserType = 1;
        this.solverType = "RK45";
        this.xmlFileName = "models-0.7.3/usecase01.xml";
        this.outputDir = "./";
    }

    public static void main(String[] args) throws Exception {
        PrintWriter out = new PrintWriter("tester.txt");
        out.println("ora: " + System.currentTimeMillis());
        out.close();
        WinBugsConverterTester mt = new WinBugsConverterTester(args[0]);
        System.out.println("propfile " + mt.getPropFile());
        File f = new File(mt.getPropFile());
        FileReader in = new FileReader(f);
        mt.loadProp(in);
        System.out.println(mt);
        File mF = new File(mt.xmlFileName);
        if (!mF.exists()) {
            throw new FileNotFoundException("model file " + mF.getAbsolutePath() + " does not exist.");
        }
        File dirF = new File(mt.outputDir);
        if (!dirF.exists()) {
            throw new FileNotFoundException("output directory " + dirF.getAbsolutePath() + " does not exist.");
        }
        System.out.println("opening model " + mF.getAbsolutePath());
        System.out.println("saving output files in " + dirF.getAbsolutePath());
        mt.runConversion();
    }

    public void loadProp(FileReader in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        this.parserType = Integer.parseInt(props.getProperty("parserType"));
        this.solverType = this.getSolver(props.getProperty("solverType"));
        this.totCov = Integer.parseInt(props.getProperty("totCov"));
        this.totGrid = Integer.parseInt(props.getProperty("totGrid"));
        this.outputDir = props.getProperty("outputDir");
        this.xmlFileName = props.getProperty("modelName");
        if (this.xmlFileName == null) {
            this.xmlFileName = System.getenv("modelName");
            System.out.println("var ambiente = " + System.getenv("modelName"));
            System.out.println("modello = " + this.xmlFileName);
        }
    }

    private String getSolver(String property) {
        switch (property) {
            case "RK45": {
                return "1";
            }
            case "LSODA": {
                return "2";
            }
        }
        System.out.println("Wrong or missing solver type. RK45 is selected as default.");
        return "1";
    }

    private void runConversion() throws IOException {
        ConverterProvider c = new ConverterProvider();
        if (this.parserType > 2) {
            throw new UnsupportedOperationException("parser type " + this.parserType + " not yet available!");
        }
        c.setParserType(this.parserType);
        if (this.parserType == 2) {
            c.setSolverType(Integer.parseInt(this.getSolver(this.solverType)));
        }
        c.setTotCov(this.totCov);
        c.performConvert(new File(this.xmlFileName), new File(this.outputDir));
    }

    public String getPropFile() {
        return this.propFile;
    }

    public String toString() {
        return "Model Conversion\nxmlFileName=" + this.xmlFileName + "\nparserType=" + this.parserType + "\nsolverType=" + this.solverType + "\ntotCov=" + this.totCov + "\ntotGrid=" + this.totGrid + "\noutputDir=" + this.outputDir + "\n}";
    }

    public void setXmlFileName(String xmlFileName) {
        this.xmlFileName = xmlFileName;
    }
}

