/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs.parts;

import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.engine.common.CorrelationRef;
import crx.converter.spi.blocks.BaseRandomVariableBlock;
import crx.converter.tree.BinaryTree;
import crx.converter.tree.NestedTreeRef;
import crx.converter.tree.Node;
import crx.converter.tree.TreeMaker;
import eu.ddmore.converters.unipv.winbugs.parts.IndividualParameterBlockImpl;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.modeldefn.CorrelatedRandomVariable;
import eu.ddmore.libpharmml.dom.modeldefn.Correlation;
import eu.ddmore.libpharmml.dom.modeldefn.Pairwise;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomVariable;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseRandomVariableBlockImpl
extends IndividualParameterBlockImpl
implements BaseRandomVariableBlock {
    protected List<CorrelationRef> correlations = new ArrayList<CorrelationRef>();
    protected List<ParameterRandomVariable> linked_rvs = new ArrayList<ParameterRandomVariable>();
    protected List<ParameterRandomVariable> rvs = new ArrayList<ParameterRandomVariable>();

    protected void buildTrees(CorrelationRef corr) {
        if (corr == null) {
            return;
        }
        TreeMaker tm = this.lexer.getTreeMaker();
        BinaryTree bt_ = new BinaryTree();
        Node root_node = new Node((Object)corr);
        root_node.root = true;
        this.lexer.addStatement((Object)corr, bt_);
        if (corr.is_pairwise) {
            BinaryTree bt;
            if (corr.rnd1 != null) {
                this.lexer.addStatement((Object)corr.rnd1, tm.newInstance((Object)corr.rnd1));
                this.lexer.updateNestedTrees();
            }
            if (corr.rnd2 != null) {
                this.lexer.addStatement((Object)corr.rnd2, tm.newInstance((Object)corr.rnd2));
                this.lexer.updateNestedTrees();
            }
            ArrayList<BinaryTree> trees = new ArrayList<BinaryTree>();
            if (corr.correlationCoefficient != null) {
                bt = tm.newInstance((Object)corr.correlationCoefficient);
                trees.add(bt);
                for (NestedTreeRef ntr : tm.getNestedTrees()) {
                    if (ntr == null) continue;
                    trees.add(ntr.bt);
                }
                this.lexer.addStatement((Object)corr.correlationCoefficient, bt);
                this.lexer.updateNestedTrees();
            }
            if (corr.covariance != null) {
                bt = tm.newInstance((Object)corr.covariance);
                trees.add(bt);
                for (NestedTreeRef ntr : tm.getNestedTrees()) {
                    if (ntr == null) continue;
                    trees.add(ntr.bt);
                }
                this.lexer.addStatement((Object)corr.covariance, bt);
                this.lexer.updateNestedTrees();
            }
            corr.findParameterReferences(trees);
        }
    }

    public List<CorrelationRef> getCorrelations() {
        return this.correlations;
    }

    public List<ParameterRandomVariable> getLinkedRandomVariables() {
        return this.linked_rvs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void register(Correlation corr) {
        if (corr == null) {
            return;
        }
        if (corr.getMatrix() != null) {
            CorrelationRef corr_ref = new CorrelationRef();
            corr_ref.matrix = corr.getMatrix();
            return;
        } else {
            if (corr.getPairwise() == null) return;
            Pairwise pw = corr.getPairwise();
            CorrelatedRandomVariable rnd1 = pw.getRandomVariable1();
            CorrelatedRandomVariable rnd2 = pw.getRandomVariable2();
            if (rnd1 == null || rnd2 == null) throw new NullPointerException("Correlation random variable is NULL.");
            PharmMLRootType v1 = null;
            PharmMLRootType v2 = null;
            if (rnd1.getSymbRef() != null) {
                v1 = this.lexer.getAccessor().fetchElement(rnd1.getSymbRef());
            }
            if (rnd2.getSymbRef() != null) {
                v2 = this.lexer.getAccessor().fetchElement(rnd2.getSymbRef());
            }
            if (!PharmMLTypeChecker.isRandomVariable(v1) || !PharmMLTypeChecker.isRandomVariable(v2)) throw new IllegalStateException("Random variable reference of wrong type.");
            ParameterRandomVariable rv1 = (ParameterRandomVariable)v1;
            ParameterRandomVariable rv2 = (ParameterRandomVariable)v2;
            if (this.rvs.contains(rv1)) {
                this.rvs.remove(rv1);
                this.linked_rvs.add(rv1);
            }
            if (this.rvs.contains(rv2)) {
                this.rvs.remove(rv2);
                this.linked_rvs.add(rv2);
            }
            this.correlations.add(new CorrelationRef(this.lexer, rv1, rv2, pw.getCorrelationCoefficient(), pw.getCovariance()));
        }
    }
}

