/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs.parts;

import crx.converter.engine.Accessor;
import crx.converter.engine.CategoryRef_;
import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.engine.common.BaseTabularDataset;
import crx.converter.engine.common.ConditionalDoseEvent;
import crx.converter.engine.common.ConditionalDoseEventRef;
import crx.converter.engine.common.MultipleDvRef;
import crx.converter.engine.common.TemporalDoseEvent;
import crx.converter.spi.steps.BaseStep;
import eu.ddmore.converters.unipv.winbugs.parts.PartImpl;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.SymbolType;
import eu.ddmore.libpharmml.dom.commontypes.VariableDefinition;
import eu.ddmore.libpharmml.dom.dataset.CategoryMapping;
import eu.ddmore.libpharmml.dom.dataset.ColumnDefinition;
import eu.ddmore.libpharmml.dom.dataset.ColumnMapping;
import eu.ddmore.libpharmml.dom.dataset.ColumnReference;
import eu.ddmore.libpharmml.dom.dataset.ColumnType;
import eu.ddmore.libpharmml.dom.dataset.DataSet;
import eu.ddmore.libpharmml.dom.dataset.HeaderColumnsDefinition;
import eu.ddmore.libpharmml.dom.dataset.IgnoreLine;
import eu.ddmore.libpharmml.dom.dataset.MapType;
import eu.ddmore.libpharmml.dom.maths.Piece;
import eu.ddmore.libpharmml.dom.maths.Piecewise;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateDefinition;
import eu.ddmore.libpharmml.dom.trialdesign.ExternalDataSet;
import eu.ddmore.libpharmml.dom.trialdesign.MultipleDVMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseStepImpl
extends PartImpl
implements BaseStep {
    protected Accessor a = null;
    private List<ConditionalDoseEvent> category_dose_evts = new ArrayList<ConditionalDoseEvent>();
    protected Map<String, ColumnDefinition> column_name_map = null;
    protected List<ConditionalDoseEvent> conditional_dose_events = new ArrayList<ConditionalDoseEvent>();
    private List<VariableDefinition> conditional_dose_evt_targets = new ArrayList<VariableDefinition>();
    private Map<VariableDefinition, ConditionalDoseEventRef> dose_ref_var_map = new HashMap<VariableDefinition, ConditionalDoseEventRef>();
    protected List<BaseTabularDataset.ElementMapping> element_mappings = new ArrayList<BaseTabularDataset.ElementMapping>();
    protected ExternalDataSet exd = null;
    private String ignoreLineSymbol = null;
    private ColumnDefinition infusion_column = null;
    private List<MultipleDvRef> mdv_refs = new ArrayList<MultipleDvRef>();
    private TemporalDoseEvent tde = null;

    protected void addElementMapping(BaseTabularDataset.ElementMapping mapping) {
        if (mapping != null) {
            this.element_mappings.add(mapping);
        }
    }

    protected void buildExternalDatasetMappings() {
        if (this.exd == null) {
            return;
        }
        DataSet ds = this.exd.getDataSet();
        this.createColumnNameMap(ds);
        for (PharmMLRootType o : this.exd.getListOfColumnMappingOrColumnTransformationOrMultipleDVMapping()) {
            if (PharmMLTypeChecker.isColumnMapping((Object)o)) {
                this.processColumnMapping((ColumnMapping)o);
                continue;
            }
            if (PharmMLTypeChecker.isMultipleDVMapping((Object)o)) {
                this.processMDVMapping((MultipleDVMapping)o);
                continue;
            }
            throw new UnsupportedOperationException("Data column bound with an unknown context (not support yet, object='" + o + "')");
        }
    }

    protected void createColumnNameMap(DataSet ds) {
        if (ds == null) {
            throw new NullPointerException("The dataset is NULL");
        }
        this.column_name_map = new HashMap<String, ColumnDefinition>();
        HeaderColumnsDefinition def = ds.getDefinition();
        if (def == null) {
            throw new NullPointerException("Column Definition list is NULL");
        }
        List cols = def.getListOfColumn();
        if (cols == null) {
            throw new NullPointerException("No columns defined.");
        }
        if (cols.isEmpty()) {
            throw new IllegalStateException("No data columns defined in the objective data set.");
        }
        for (ColumnDefinition col : cols) {
            if (col == null) continue;
            String name = col.getColumnId();
            Integer col_idx = col.getColumnNum();
            ColumnType usage = (ColumnType)col.getListOfColumnType().get(0);
            SymbolType datatype = col.getValueType();
            if (name == null) {
                throw new NullPointerException("Dataset column name is NULL");
            }
            if (col_idx == null) {
                throw new NullPointerException("Dataset column index is unspecified");
            }
            if (usage != null) {
                if (datatype == null) {
                    throw new IllegalStateException("The column data type is not specified");
                }
                if (ColumnType.RATE.equals((Object)usage)) {
                    this.infusion_column = col;
                }
            }
            if (this.column_name_map.containsKey(name)) {
                throw new IllegalStateException("Column name map contains duplicate key.");
            }
            this.column_name_map.put(name, col);
        }
    }

    public List<ConditionalDoseEvent> getCategoricalDoseEvents() {
        return this.category_dose_evts;
    }

    public ColumnDefinition getColumn(String name) {
        if (name == null) {
            return null;
        }
        if (this.column_name_map.containsKey(name)) {
            return this.column_name_map.get(name);
        }
        return null;
    }

    public List<ColumnDefinition> getColumns(ColumnType usage) {
        ArrayList<ColumnDefinition> list = new ArrayList<ColumnDefinition>();
        if (usage != null) {
            for (ColumnDefinition col : this.column_name_map.values()) {
                ColumnType type;
                if (col == null || !(type = (ColumnType)col.getListOfColumnType().get(0)).equals((Object)usage) || list.contains(col)) continue;
                list.add(col);
            }
        }
        return list;
    }

    public ConditionalDoseEventRef getConditionalDoseEventRef(VariableDefinition v) {
        if (v != null && this.dose_ref_var_map.containsKey(v)) {
            return this.dose_ref_var_map.get(v);
        }
        return null;
    }

    public List<ConditionalDoseEventRef> getConditionalDoseEventRefs() {
        ArrayList<ConditionalDoseEventRef> list = new ArrayList<ConditionalDoseEventRef>();
        for (ConditionalDoseEventRef ref : this.dose_ref_var_map.values()) {
            if (list.contains(ref)) continue;
            list.add(ref);
        }
        return list;
    }

    public List<ConditionalDoseEvent> getConditionalDoseEvents() {
        return this.conditional_dose_events;
    }

    public List<BaseTabularDataset.ElementMapping> getElementMappings() {
        return this.element_mappings;
    }

    public List<BaseTabularDataset.ElementMapping> getElementMappings(ColumnType usage) {
        ArrayList<BaseTabularDataset.ElementMapping> list = new ArrayList<BaseTabularDataset.ElementMapping>();
        if (usage != null) {
            for (BaseTabularDataset.ElementMapping element_mapping : this.element_mappings) {
                ColumnDefinition col;
                if (element_mapping == null || (col = element_mapping.getColumnDefinition()) == null || !usage.equals(col.getListOfColumnType().get(0))) continue;
                list.add(element_mapping);
            }
        }
        return list;
    }

    public List<PharmMLRootType> getElements(ColumnType usage) {
        ArrayList<PharmMLRootType> list = new ArrayList<PharmMLRootType>();
        if (usage != null) {
            for (BaseTabularDataset.ElementMapping element_mapping : this.element_mappings) {
                PharmMLRootType element;
                ColumnType type;
                ColumnDefinition col;
                if (element_mapping == null || (col = element_mapping.getColumnDefinition()) == null || !usage.equals((Object)(type = (ColumnType)col.getListOfColumnType().get(0))) || (element = element_mapping.getElement()) == null || list.contains(element)) continue;
                list.add(element);
            }
        }
        return list;
    }

    public ExternalDataSet getExternalDataSet() {
        return this.exd;
    }

    public String getIgnoreLineSymbol() {
        IgnoreLine igl;
        HeaderColumnsDefinition definition;
        DataSet ds;
        if (this.ignoreLineSymbol == null && this.exd != null && (ds = this.exd.getDataSet()) != null && (definition = ds.getDefinition()) != null && (igl = definition.getIgnoreLine()) != null) {
            this.ignoreLineSymbol = igl.getSymbol();
        }
        return this.ignoreLineSymbol;
    }

    public ColumnDefinition getInfusionColumn() {
        return this.infusion_column;
    }

    public List<MultipleDvRef> getMultipleDvRefs() {
        return this.mdv_refs;
    }

    public TemporalDoseEvent getTemporalDoseEvent() {
        return this.tde;
    }

    public boolean hasConditionalDoseEvents() {
        return this.conditional_dose_events.size() > 0;
    }

    public boolean hasMultipleDVRefs() {
        return this.mdv_refs.size() > 0;
    }

    public boolean hasTemporalDoseEvent() {
        return this.tde != null;
    }

    public boolean isCategoricalDoseTargetColumn(String colName) {
        throw new UnsupportedOperationException();
    }

    public boolean isConditionalDoseEventTarget(VariableDefinition v) {
        if (v == null) {
            return false;
        }
        return this.conditional_dose_evt_targets.contains(v);
    }

    public boolean isDoingInfusion() {
        throw new UnsupportedOperationException();
    }

    protected void processColumnMapping(ColumnMapping mapping) {
        ColumnDefinition col;
        ColumnReference colref = mapping.getColumnRef();
        if (colref == null) {
            throw new NullPointerException("Mapping column reference is NULL");
        }
        String colName = colref.getColumnIdRef();
        if (!this.column_name_map.containsKey(colName)) {
            throw new IllegalStateException("Data set does not contain mapped data column (col='" + colName + "')");
        }
        if (mapping.getSymbRef() != null) {
            CategoryMapping cat_mappings;
            PharmMLRootType element = this.a.fetchElement(mapping.getSymbRef());
            BaseTabularDataset.ElementMapping em = new BaseTabularDataset.ElementMapping(this.column_name_map.get(colName), element);
            this.addElementMapping(em);
            if (PharmMLTypeChecker.isCovariate((Object)element)) {
                this.registerCategoryMappings((CovariateDefinition)element, mapping);
            }
            if (!mapping.getListOfCategoryMapping().isEmpty() && (cat_mappings = (CategoryMapping)mapping.getListOfCategoryMapping().get(0)) != null) {
                for (MapType cat_map : cat_mappings.getListOfMap()) {
                    em.addCategoryMappings(cat_map);
                }
            }
        } else if (mapping.getPiecewise() != null && (col = this.column_name_map.get(colName)) != null) {
            ColumnType cxt = (ColumnType)col.getListOfColumnType().get(0);
            if (cxt == null) {
                throw new NullPointerException("The column context of usage is NULL.");
            }
            if (cxt.equals((Object)ColumnType.DOSE)) {
                this.processDosePiecewiseMappings(col, mapping.getPiecewise());
            } else if (cxt.equals((Object)ColumnType.IDV) || cxt.equals((Object)ColumnType.TIME)) {
                this.processTemporalDosePiecewiseMappings(col, mapping.getPiecewise());
            }
        }
    }

    private boolean processDosePiecewiseMappings(ColumnDefinition col, Piecewise pw) {
        List pieces = pw.getListOfPiece();
        if (pieces.isEmpty()) {
            throw new IllegalStateException("Piecewise block contains no conditional statements");
        }
        Integer idx = 1;
        Accessor a = this.lexer.getAccessor();
        ArrayList<ConditionalDoseEvent> evts_copy = new ArrayList<ConditionalDoseEvent>();
        for (Piece piece : pieces) {
            ConditionalDoseEvent evt = new ConditionalDoseEvent(this.lexer, col, piece);
            evts_copy.add(evt);
            PharmMLRootType element = evt.getTargetElement();
            if (element != null && PharmMLTypeChecker.isLocalVariable((Object)element)) {
                VariableDefinition v = (VariableDefinition)element;
                this.conditional_dose_evt_targets.add(v);
                if (this.lexer.isUseGlobalConditionalDoseVariable()) {
                    String format = "evt_%s_%s_%s";
                    String evt_id = String.format(format, col.getColumnId(), v.getSymbId(), idx);
                    ConditionalDoseEventRef ref = new ConditionalDoseEventRef(evt, evt_id);
                    a.register(evt_id, (PharmMLRootType)ref);
                    v.assign((SymbolRef)ref);
                    this.dose_ref_var_map.put(v, ref);
                    Integer n = idx;
                    Integer n2 = idx = Integer.valueOf(idx + 1);
                }
            }
            this.conditional_dose_events.add(evt);
        }
        if (evts_copy.size() > 1) {
            this.category_dose_evts.addAll(evts_copy);
        }
        return true;
    }

    private boolean processTemporalDosePiecewiseMappings(ColumnDefinition col, Piecewise pw) {
        List pieces = pw.getListOfPiece();
        if (pieces.isEmpty()) {
            throw new IllegalStateException("Piecewise block contains no conditional statements");
        }
        Piece piece = (Piece)pieces.get(0);
        if (piece == null) {
            return false;
        }
        ConditionalDoseEvent evt = new ConditionalDoseEvent(this.lexer, col, piece);
        PharmMLRootType element = evt.getTargetElement();
        if (element == null) {
            return false;
        }
        if (PharmMLTypeChecker.isLocalVariable((Object)element)) {
            this.tde = new TemporalDoseEvent(this.lexer, col, piece);
        }
        return true;
    }

    private void registerCategoryMappings(CovariateDefinition v, ColumnMapping mapping) {
        if (v == null || mapping == null) {
            return;
        }
        String blkId = this.a.getBlockId((PharmMLRootType)v);
        List cat_mappings = mapping.getListOfCategoryMapping();
        if (cat_mappings == null) {
            return;
        }
        if (cat_mappings.isEmpty()) {
            return;
        }
        ArrayList<CategoryRef_> element_category_list = new ArrayList<CategoryRef_>();
        for (CategoryMapping item : cat_mappings) {
            if (item == null) continue;
            for (MapType map : item.getListOfMap()) {
                if (map == null) continue;
                CategoryRef_ ref = new CategoryRef_(blkId, map.getModelSymbol(), map.getDataSymbol());
                ref.setElement((PharmMLRootType)v);
                this.a.register(ref);
                element_category_list.add(ref);
            }
        }
        if (element_category_list.size() > 0) {
            this.a.register((PharmMLRootType)v, element_category_list);
        }
    }

    protected void processMDVMapping(MultipleDVMapping mdv) {
        if (this.exd == null) {
            throw new NullPointerException("External data set is NULL");
        }
        DataSet ds = this.exd.getDataSet();
        if (ds == null) {
            throw new NullPointerException("Dataset definition is NULL");
        }
        Piecewise pw = mdv.getPiecewise();
        if (pw == null) {
            return;
        }
        Accessor a = this.lexer.getAccessor();
        ColumnDefinition col = a.fetchColumnDefinition(ds, mdv.getColumnRef());
        if (col == null) {
            throw new NullPointerException("An MDV column reference is NULL.");
        }
        List pieces = pw.getListOfPiece();
        if (pieces.isEmpty()) {
            return;
        }
        for (int i = 0; i < pieces.size(); ++i) {
            Piece piece = (Piece)pieces.get(i);
            if (piece == null) continue;
            this.mdv_refs.add(new MultipleDvRef(this.lexer, col, piece));
        }
    }
}

