/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs.parts;

import crx.converter.engine.Accessor;
import crx.converter.engine.FixedParameter;
import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.engine.parts.SortableElement;
import crx.converter.spi.ILexer;
import crx.converter.spi.blocks.ParameterBlock;
import crx.converter.spi.steps.EstimationStep;
import crx.converter.tree.TreeMaker;
import eu.ddmore.converters.unipv.winbugs.parts.BaseStepImpl;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.RealValue;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import eu.ddmore.libpharmml.dom.modellingsteps.Estimation;
import eu.ddmore.libpharmml.dom.modellingsteps.EstimationOpType;
import eu.ddmore.libpharmml.dom.modellingsteps.EstimationOperation;
import eu.ddmore.libpharmml.dom.modellingsteps.InitialEstimate;
import eu.ddmore.libpharmml.dom.modellingsteps.ParameterEstimate;
import eu.ddmore.libpharmml.dom.modellingsteps.ToEstimate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class EstimationStepImpl
extends BaseStepImpl
implements EstimationStep {
    private static double defaultParameterEstimateValue = 1.0;
    private static boolean useDefaultParameterEstimate = false;
    private Estimation est = null;
    private HashMap<ParameterEstimate, Integer> estimate_to_index = new HashMap();
    private List<FixedParameter> fixed_parameters = new ArrayList<FixedParameter>();
    private HashMap<ParameterEstimate, Integer> indiv_estimate_to_index = new HashMap();
    private EstimationOperation[] operations = null;
    private List<ParameterEstimate> params_to_estimate = new ArrayList<ParameterEstimate>();

    public static boolean isIndividualParameterEstimate(EstimationOperation op) {
        String type;
        EstimationOpType value;
        if (op != null && (value = EstimationOpType.fromValue((String)(type = op.getOpType()))) != null) {
            return value.equals((Object)EstimationOpType.EST_INDIV);
        }
        return false;
    }

    public static void setDefaultParameterEstimateValue(double value) {
        defaultParameterEstimateValue = value;
    }

    public static void setUseDefaultParameterEstimate(boolean decision) {
        useDefaultParameterEstimate = decision;
    }

    public EstimationStepImpl(Estimation est_, ILexer lexer_) {
        if (est_ == null) {
            throw new NullPointerException("The estimation step cannot be NULL");
        }
        if (est_.getOid() == null) {
            throw new IllegalStateException("THe estimation step must have a OID");
        }
        if (lexer_ == null) {
            throw new NullPointerException("Lexer reference is NULL");
        }
        this.est = est_;
        this.lexer = lexer_;
        this.a = this.lexer.getAccessor();
        this.exd = this.a.fetchExternalDataSet(this.est.getExternalDataSetReference());
    }

    private void buildOperationsArray() {
        List operations_ = this.est.getOperation();
        if (operations_ != null) {
            ArrayList<SortableElement> operation_refs = new ArrayList<SortableElement>();
            for (EstimationOperation operation : operations_) {
                if (operation == null || operation.getOrder() == null) continue;
                operation_refs.add(new SortableElement((Object)operation, (double)operation.getOrder().intValue()));
            }
            Collections.sort(operation_refs);
            this.operations = new EstimationOperation[operation_refs.size()];
            for (int i = 0; i < this.operations.length; ++i) {
                this.operations[i] = (EstimationOperation)((SortableElement)operation_refs.get(i)).getElement();
            }
        } else {
            this.operations = new EstimationOperation[0];
        }
    }

    private void buildParameterEstimateTrees() {
        Accessor a = this.lexer.getAccessor();
        ParameterBlock pb = this.lexer.getParameterBlock();
        if (pb == null) {
            throw new NullPointerException("Model has no defined parameter block.");
        }
        for (ParameterEstimate pe : this.params_to_estimate) {
            SymbolRef ref = pe.getSymbRef();
            if (ref == null) continue;
            PharmMLRootType element = a.fetchElement(ref);
            if (PharmMLTypeChecker.isPopulationParameter((Object)element)) {
                this.estimate_to_index.put(pe, pb.getParameterIndex(ref));
                continue;
            }
            if (!PharmMLTypeChecker.isIndividualParameter((Object)element)) continue;
            this.indiv_estimate_to_index.put(pe, pb.getParameterIndex(ref));
        }
    }

    @Override
    public void buildTrees() {
        if (this.est == null) {
            throw new NullPointerException("Estimation step in model is NULL");
        }
        this.categoriseParameterUsage();
        this.buildExternalDatasetMappings();
        this.buildOperationsArray();
        this.buildParameterEstimateTrees();
    }

    private void categoriseParameterUsage() {
        List param_list;
        TreeMaker tm = this.lexer.getTreeMaker();
        ToEstimate param_list_holder = this.est.getParametersToEstimate();
        if (param_list_holder != null && (param_list = param_list_holder.getParameterEstimation()) != null) {
            for (ParameterEstimate p : param_list) {
                if (p == null) continue;
                InitialEstimate ic = p.getInitialEstimate();
                if (ic == null && useDefaultParameterEstimate) {
                    ic = this.getDefaultInitialEstimate();
                }
                boolean isFixed = false;
                if (ic != null && ic.isFixed() != null) {
                    isFixed = ic.isFixed();
                }
                if (isFixed) {
                    FixedParameter fp = new FixedParameter(p);
                    this.fixed_parameters.add(fp);
                    this.lexer.addStatement((Object)fp, tm.newInstance((Object)fp));
                    this.lexer.updateNestedTrees();
                    continue;
                }
                this.lexer.addStatement((Object)p, tm.newInstance((Object)p));
                this.lexer.updateNestedTrees();
                this.params_to_estimate.add(p);
            }
            for (FixedParameter fp : this.fixed_parameters) {
                param_list.remove(fp.pe);
            }
        }
    }

    private InitialEstimate getDefaultInitialEstimate() {
        InitialEstimate ic = new InitialEstimate();
        ic.setFixed(Boolean.valueOf(false));
        ic.setScalar((Scalar)new RealValue(defaultParameterEstimateValue));
        return ic;
    }

    public FixedParameter getFixedParameter(PopulationParameter p) {
        FixedParameter fp = null;
        if (p != null) {
            for (FixedParameter fp_ : this.fixed_parameters) {
                PharmMLRootType o;
                if (fp_ == null || fp_.pe == null || !p.equals(o = this.a.fetchElement(fp_.pe.getSymbRef()))) continue;
                fp = fp_;
                break;
            }
        }
        return fp;
    }

    public List<FixedParameter> getFixedParameters() {
        return this.fixed_parameters;
    }

    public Integer getIndividualParameterIndex(ParameterEstimate pe) {
        Integer idx = -1;
        if (pe != null && this.indiv_estimate_to_index.containsKey(pe)) {
            idx = this.indiv_estimate_to_index.get(pe);
        }
        return idx;
    }

    @Override
    public String getName() {
        String blkId = "__RUBBISH_DEFAULT_VALUE_";
        if (this.est != null && this.est.getOid() != null) {
            blkId = this.est.getOid();
        }
        return blkId;
    }

    public EstimationOperation[] getOperations() {
        return this.operations;
    }

    public ParameterEstimate getParameterEstimate(PopulationParameter p) {
        ParameterEstimate pe = null;
        if (p != null) {
            for (ParameterEstimate pe_ : this.getParametersToEstimate()) {
                PharmMLRootType element;
                if (pe_ == null || (element = this.a.fetchElement(pe_.getSymbRef())) == null || !element.equals(p)) continue;
                pe = pe_;
                break;
            }
        }
        return pe;
    }

    public Integer getParameterIndex(ParameterEstimate pe) {
        Integer idx = -1;
        if (pe != null && this.estimate_to_index.containsKey(pe)) {
            idx = this.estimate_to_index.get(pe);
        }
        return idx;
    }

    public List<ParameterEstimate> getParametersToEstimate() {
        return this.params_to_estimate;
    }

    public Estimation getStep() {
        return this.est;
    }

    @Override
    public List<String> getSymbolIds() {
        return new ArrayList<String>();
    }

    public boolean hasFixedParameters() {
        return this.fixed_parameters.size() > 0;
    }

    public boolean hasParametersToEstimate() {
        return this.params_to_estimate.size() > 0;
    }

    public boolean hasSimpleParametersToEstimate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSymbolId(String name) {
        return false;
    }

    public boolean isConstrained() {
        throw new UnsupportedOperationException();
    }

    public boolean isFixedParameter(PopulationParameter p) {
        boolean isFixed = false;
        if (p != null) {
            for (FixedParameter fixed_parameter : this.fixed_parameters) {
                PharmMLRootType element;
                if (fixed_parameter == null || fixed_parameter.pe == null || (element = this.a.fetchElement(fixed_parameter.pe.getSymbRef())) == null || !p.equals(element)) continue;
                isFixed = true;
                break;
            }
        }
        return isFixed;
    }

    public void update() {
        ParameterBlock pb = this.lexer.getParameterBlock();
        if (pb == null) {
            return;
        }
        ArrayList<ParameterEstimate> pes = new ArrayList<ParameterEstimate>();
        pes.addAll(this.params_to_estimate);
        this.params_to_estimate.clear();
        this.estimate_to_index.clear();
        Accessor a = this.lexer.getAccessor();
        int idx = 0;
        for (PopulationParameter p : pb.getParameters()) {
            if (p == null) continue;
            ParameterEstimate pe_found = null;
            for (ParameterEstimate pe : pes) {
                PharmMLRootType o;
                SymbolRef ref;
                if (pe == null || (ref = pe.getSymbRef()) == null || !p.equals(o = a.fetchElement(ref))) continue;
                pe_found = pe;
                break;
            }
            if (pe_found == null) continue;
            this.params_to_estimate.add(pe_found);
            this.estimate_to_index.put(pe_found, idx++);
            pes.remove(pe_found);
        }
        for (ParameterEstimate pe : pes) {
            if (pe == null) continue;
            this.params_to_estimate.add(pe);
            this.estimate_to_index.put(pe, idx++);
        }
    }

    public String getToolName() {
        throw new UnsupportedOperationException();
    }
}

