/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs.parts;

import crx.converter.engine.Accessor;
import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.engine.common.CorrelationRef;
import crx.converter.engine.common.ObservationParameter;
import crx.converter.engine.common.SimulationOutput;
import crx.converter.spi.ILexer;
import crx.converter.spi.blocks.ObservationBlock;
import crx.converter.spi.blocks.StructuralBlock;
import crx.converter.tree.NestedTreeRef;
import crx.converter.tree.Node;
import crx.converter.tree.TreeMaker;
import eu.ddmore.converters.unipv.winbugs.parts.BaseRandomVariableBlockImpl;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.StandardAssignable;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.VariableDefinition;
import eu.ddmore.libpharmml.dom.maths.FunctionCallType;
import eu.ddmore.libpharmml.dom.modeldefn.CategoricalData;
import eu.ddmore.libpharmml.dom.modeldefn.CategoricalPMF;
import eu.ddmore.libpharmml.dom.modeldefn.Censoring;
import eu.ddmore.libpharmml.dom.modeldefn.CommonDiscreteVariable;
import eu.ddmore.libpharmml.dom.modeldefn.CommonObservationModel;
import eu.ddmore.libpharmml.dom.modeldefn.CommonParameter;
import eu.ddmore.libpharmml.dom.modeldefn.ContinuousObservationModel;
import eu.ddmore.libpharmml.dom.modeldefn.Correlation;
import eu.ddmore.libpharmml.dom.modeldefn.CountData;
import eu.ddmore.libpharmml.dom.modeldefn.CountPMF;
import eu.ddmore.libpharmml.dom.modeldefn.Dependance;
import eu.ddmore.libpharmml.dom.modeldefn.Discrete;
import eu.ddmore.libpharmml.dom.modeldefn.DiscreteDataParameter;
import eu.ddmore.libpharmml.dom.modeldefn.IndividualParameter;
import eu.ddmore.libpharmml.dom.modeldefn.ObservationError;
import eu.ddmore.libpharmml.dom.modeldefn.ObservationModel;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomVariable;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import eu.ddmore.libpharmml.dom.modeldefn.ProbabilityAssignment;
import eu.ddmore.libpharmml.dom.modeldefn.StructuredObsError;
import eu.ddmore.libpharmml.dom.modeldefn.TTEFunction;
import eu.ddmore.libpharmml.dom.modeldefn.TimeToEventData;
import java.util.ArrayList;
import java.util.List;

public class ObservationBlockImpl
extends BaseRandomVariableBlockImpl
implements ObservationBlock {
    private Accessor a = null;
    private CategoricalData categorical_data = null;
    private CountData count_data = null;
    private Dependance dependence = null;
    private Discrete discrete = null;
    private ObservationError error_model = null;
    private List<NestedTreeRef> error_trees = new ArrayList<NestedTreeRef>();
    private ArrayList<String> func_names = new ArrayList();
    private ArrayList<String> model_block_ids = new ArrayList();
    private ObservationModel ob = null;
    private ArrayList<ObservationParameter> param_refs = new ArrayList();
    private ArrayList<CommonParameter> params = new ArrayList();
    private ArrayList<ParameterRandomVariable> random_variables = new ArrayList();
    private ArrayList<SimulationOutput> simulation_outputs = new ArrayList();
    private TreeMaker tm = null;
    private TimeToEventData tte_data = null;

    public ObservationBlockImpl(ObservationModel ob_, ILexer lexer_) {
        if (lexer_ == null) {
            throw new NullPointerException("The lexer cannot be NULL.");
        }
        if (ob_ == null) {
            throw new NullPointerException("The observation model type cannot be NULL.");
        }
        this.ob = ob_;
        this.lexer = lexer_;
        this.a = this.lexer.getAccessor();
        this.tm = this.lexer.getTreeMaker();
        this.initErrorModel();
    }

    private void buildCategoricalData() {
        List pas;
        List previousStateVariables;
        List pmfs;
        if (this.categorical_data == null) {
            return;
        }
        CommonDiscreteVariable cv = this.categorical_data.getCategoryVariable();
        if (cv != null) {
            this.lexer.addStatement((Object)cv, this.tm.newInstance((Object)cv));
            this.lexer.updateNestedTrees();
        }
        this.dependence = this.categorical_data.getDependance();
        List categories = this.categorical_data.getListOfCategories();
        if (categories != null) {
            for (CommonDiscreteVariable category : categories) {
                if (category == null) continue;
                this.lexer.addStatement((Object)category, this.tm.newInstance((Object)category));
                this.lexer.updateNestedTrees();
            }
        }
        if ((pmfs = this.categorical_data.getListOfPMF()) != null) {
            for (CategoricalPMF pmf : pmfs) {
                if (pmf == null) continue;
                this.lexer.addStatement((Object)pmf, this.tm.newInstance((Object)pmf));
                this.lexer.updateNestedTrees();
            }
        }
        if ((previousStateVariables = this.categorical_data.getListOfPreviousStateVariable()) != null) {
            for (CommonDiscreteVariable previousStateVariable : previousStateVariables) {
                if (previousStateVariable == null) continue;
                this.lexer.addStatement((Object)previousStateVariable, this.tm.newInstance((Object)previousStateVariable));
                this.lexer.updateNestedTrees();
            }
        }
        if ((pas = this.categorical_data.getListOfProbabilityAssignment()) != null) {
            for (ProbabilityAssignment pa : pas) {
                if (pa == null) continue;
                this.lexer.addStatement((Object)pa, this.tm.newInstance((Object)pa));
                this.lexer.updateNestedTrees();
            }
        }
        this.buildDiscreteCommon((CommonObservationModel)this.categorical_data);
    }

    private void buildCorrelations() {
        for (CorrelationRef corr : this.correlations) {
            this.buildTrees(corr);
        }
    }

    private void buildCountData() {
        DiscreteDataParameter p;
        List previous_counts;
        List pmfs;
        List ips;
        if (this.count_data == null) {
            return;
        }
        CommonDiscreteVariable count_variable = this.count_data.getCountVariable();
        if (count_variable != null) {
            this.lexer.addStatement((Object)count_variable, this.tm.newInstance((Object)count_variable));
            this.lexer.updateNestedTrees();
        }
        this.dependence = this.count_data.getDependance();
        DiscreteDataParameter dp = this.count_data.getDispersionParameter();
        if (dp != null) {
            this.lexer.addStatement((Object)dp, this.tm.newInstance((Object)dp));
            this.lexer.updateNestedTrees();
        }
        if ((ips = this.count_data.getListOfIntensityParameter()) != null) {
            for (DiscreteDataParameter ip : ips) {
                if (ip == null) continue;
                this.lexer.addStatement((Object)ip, this.tm.newInstance((Object)ip));
                this.lexer.updateNestedTrees();
            }
        }
        if ((pmfs = this.count_data.getListOfPMF()) != null) {
            for (CountPMF pmf : pmfs) {
                if (pmf == null) continue;
                this.lexer.addStatement((Object)pmf, this.tm.newInstance((Object)pmf));
                this.lexer.updateNestedTrees();
            }
        }
        if ((previous_counts = this.count_data.getListOfPreviousCountVariable()) != null) {
            for (CommonDiscreteVariable previous_count : previous_counts) {
                if (previous_count == null) continue;
                this.lexer.addStatement((Object)previous_count, this.tm.newInstance((Object)previous_count));
                this.lexer.updateNestedTrees();
            }
        }
        if ((p = this.count_data.getMixtureProbabilityParameter()) != null) {
            this.lexer.addStatement((Object)p, this.tm.newInstance((Object)p));
            this.lexer.updateNestedTrees();
        }
        if ((p = this.count_data.getOverDispersionParameter()) != null) {
            this.lexer.addStatement((Object)p, this.tm.newInstance((Object)p));
            this.lexer.updateNestedTrees();
        }
        if ((p = this.count_data.getZeroProbabilityParameter()) != null) {
            this.lexer.addStatement((Object)p, this.tm.newInstance((Object)p));
            this.lexer.updateNestedTrees();
        }
        this.buildDiscreteCommon((CommonObservationModel)this.count_data);
    }

    private void buildDiscreteCommon(CommonObservationModel com) {
        if (com == null) {
            return;
        }
        ArrayList<VariableDefinition> vs = new ArrayList<VariableDefinition>();
        for (PharmMLElement o : com.getListOfObservationModelElement()) {
            if (PharmMLTypeChecker.isCommonParameter((Object)o)) {
                this.params.add((CommonParameter)o);
                continue;
            }
            if (PharmMLTypeChecker.isLocalVariable((Object)o)) {
                vs.add((VariableDefinition)o);
                continue;
            }
            if (!PharmMLTypeChecker.isCorrelation((Object)o)) continue;
            this.register((Correlation)o);
        }
    }

    private void buildErrorModel() {
        if (PharmMLTypeChecker.isStructuredError((Object)this.error_model)) {
            StructuredObsError goe = (StructuredObsError)this.error_model;
            this.error_trees.add(new NestedTreeRef((Object)goe, this.tm.newInstance((Object)goe)));
            StructuredObsError.ErrorModel error = goe.getErrorModel();
            if (error == null) {
                throw new NullPointerException("Gaussian erorr model not specified.");
            }
            this.error_trees.add(new NestedTreeRef((Object)error, this.tm.newInstance((Object)error.getAssign())));
            StructuredObsError.Output output = goe.getOutput();
            if (output == null) {
                throw new NullPointerException("Gaussian erorr model, output variable not specified.");
            }
            if (output.getSymbRef() == null) {
                throw new NullPointerException("Gaussian Output variable not specified (symbId='" + goe.getSymbId() + "')");
            }
            StructuredObsError.ResidualError residual_error = goe.getResidualError();
            if (residual_error == null) {
                throw new NullPointerException("Gaussian erorr model, residual variable not specified.");
            }
            if (residual_error.getSymbRef() == null) {
                throw new NullPointerException("Gaussian Residual error variable not specified (symbId='" + goe.getSymbId() + "')");
            }
            PharmMLRootType element = this.a.fetchElement(output.getSymbRef());
            if (element == null) {
                throw new NullPointerException("Element referenced by error model is NULL.");
            }
            this.createSimulationOutput(element);
        } else if (PharmMLTypeChecker.isGeneralError((Object)this.error_model)) {
            throw new UnsupportedOperationException("General Error not supported");
        }
    }

    private void buildNestedTrees() {
        ArrayList<String> func_names = new ArrayList<String>();
        for (NestedTreeRef nref : this.error_trees) {
            for (Node node : nref.bt.nodes) {
                List args;
                String func_name;
                if (node == null) continue;
                if (PharmMLTypeChecker.isSymbolReference((Object)node.data)) {
                    PharmMLRootType element = this.a.fetchElement((SymbolRef)node.data);
                    if (element == null) continue;
                    if (PharmMLTypeChecker.isDerivative((Object)element) || PharmMLTypeChecker.isLocalVariable((Object)element)) {
                        SimulationOutput simulation_output = this.createSimulationOutput(element);
                        node.data = simulation_output;
                        continue;
                    }
                    if (PharmMLTypeChecker.isRandomVariable((Object)element) || PharmMLTypeChecker.isPopulationParameter((Object)element) || PharmMLTypeChecker.isIndividualParameter((Object)element) || PharmMLTypeChecker.isCovariate((Object)element)) continue;
                    throw new UnsupportedOperationException("Class not supported in 'observation' error model (" + element + ")");
                }
                if (!PharmMLTypeChecker.isFunctionCall((Object)node.data)) continue;
                FunctionCallType call = (FunctionCallType)node.data;
                SymbolRef ref = call.getSymbRef();
                if (ref != null && (func_name = ref.getSymbIdRef()) != null && !func_names.contains(func_name)) {
                    func_names.add(func_name);
                }
                if ((args = call.getListOfFunctionArgument()) == null || args.isEmpty()) continue;
                for (FunctionCallType.FunctionArgument arg : args) {
                    PharmMLRootType element;
                    SymbolRef arg_ref;
                    if (arg == null || (arg_ref = arg.getSymbRef()) == null || !PharmMLTypeChecker.isDerivative((Object)(element = this.a.fetchElement(arg_ref))) && !PharmMLTypeChecker.isLocalVariable((Object)element)) continue;
                    SimulationOutput simulation_output = this.createSimulationOutput(element);
                    node.data = simulation_output;
                }
            }
            this.lexer.addStatement(nref);
        }
    }

    private void buildParameters() {
        for (CommonParameter param : this.params) {
            if (param == null) continue;
            if (PharmMLTypeChecker.isPopulationParameter((Object)param)) {
                PopulationParameter sp = (PopulationParameter)param;
                ObservationParameter param_ref = new ObservationParameter((ObservationBlock)this, sp);
                this.param_refs.add(param_ref);
                this.lexer.addStatement((Object)param_ref, this.tm.newInstance((Object)sp));
                continue;
            }
            if (!PharmMLTypeChecker.isRandomVariable((Object)param)) continue;
            ParameterRandomVariable rv = (ParameterRandomVariable)param;
            this.lexer.addStatement((Object)rv, this.tm.newInstance((Object)rv));
            this.lexer.updateNestedTrees();
        }
    }

    private void buildTimeToEventData() {
        List survival_funcs;
        List hazard_funcs;
        List features;
        List censorings;
        if (this.tte_data == null) {
            return;
        }
        CommonDiscreteVariable ev = this.tte_data.getEventVariable();
        if (ev != null) {
            this.lexer.addStatement((Object)ev, this.tm.newInstance((Object)ev));
            this.lexer.updateNestedTrees();
        }
        if ((censorings = this.tte_data.getListOfCensoring()) != null) {
            for (Censoring censoring : censorings) {
                if (censoring == null) continue;
                this.lexer.addStatement((Object)censoring, this.tm.newInstance((Object)censoring));
                this.lexer.updateNestedTrees();
            }
        }
        if ((features = this.tte_data.getListOfMaximumNumberEvents()) != null) {
            for (StandardAssignable feature : features) {
                if (feature == null) continue;
                this.lexer.addStatement((Object)feature, this.tm.newInstance((Object)feature));
                this.lexer.updateNestedTrees();
            }
        }
        if ((hazard_funcs = this.tte_data.getListOfHazardFunction()) != null) {
            for (TTEFunction hazard_func : hazard_funcs) {
                if (hazard_func == null) continue;
                this.lexer.addStatement((Object)hazard_func, this.tm.newInstance((Object)hazard_func));
                this.lexer.updateNestedTrees();
            }
        }
        if ((survival_funcs = this.tte_data.getListOfSurvivalFunction()) != null) {
            for (TTEFunction survival_func : survival_funcs) {
                if (survival_funcs == null) continue;
                this.lexer.addStatement((Object)survival_func, this.tm.newInstance((Object)survival_func));
                this.lexer.updateNestedTrees();
            }
        }
        this.buildDiscreteCommon((CommonObservationModel)this.count_data);
    }

    @Override
    public void buildTrees() {
        this.buildCountData();
        this.buildCategoricalData();
        this.buildTimeToEventData();
        this.buildParameters();
        this.buildCorrelations();
        this.buildIndividualParameterTrees();
        this.buildErrorModel();
        this.buildNestedTrees();
    }

    public boolean contains(PharmMLRootType v) {
        return PharmMLTypeChecker.isPopulationParameter((Object)v) ? this.params.contains(v) : PharmMLTypeChecker.isObservationError((Object)v) && this.error_model != null && this.error_model.equals(v);
    }

    private SimulationOutput createSimulationOutput(PharmMLRootType element) {
        if (element == null) {
            return null;
        }
        SimulationOutput output = null;
        for (SimulationOutput simulation_output : this.simulation_outputs) {
            if (simulation_output == null || !element.equals(simulation_output.v)) continue;
            output = simulation_output;
            break;
        }
        if (output == null) {
            String blkId = this.a.getBlockId(element);
            if (blkId != null && !this.model_block_ids.contains(blkId)) {
                this.model_block_ids.add(blkId);
            }
            output = new SimulationOutput(element);
            this.simulation_outputs.add(output);
        }
        return output;
    }

    public CategoricalData getCategoricalData() {
        return this.categorical_data;
    }

    public CountData getCountData() {
        return this.count_data;
    }

    public Dependance getDependance() {
        return this.dependence;
    }

    public List<String> getErrorFunctionNames() {
        return this.func_names;
    }

    public ObservationModel getModel() {
        return this.ob;
    }

    @Override
    public String getName() {
        String blkId = "__RUBBISH_DEFAULT_VALUE_";
        if (this.ob != null && this.ob.getBlkId() != null) {
            blkId = this.ob.getBlkId();
        }
        return blkId;
    }

    public ObservationError getObservationError() {
        return this.error_model;
    }

    public ObservationParameter getObservationParameter(PopulationParameter p) {
        ObservationParameter op = null;
        if (p != null) {
            for (ObservationParameter param_ref : this.param_refs) {
                if (param_ref == null || param_ref.param == null || !param_ref.param.equals(p)) continue;
                op = param_ref;
                break;
            }
        }
        return op;
    }

    public List<ObservationParameter> getObservationParameters() {
        return this.param_refs;
    }

    public List<ParameterRandomVariable> getRandomVariables() {
        return this.random_variables;
    }

    public List<SimulationOutput> getSimulationOutputs() {
        return this.simulation_outputs;
    }

    @Override
    public List<String> getSymbolIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (CommonParameter p : this.params) {
            if (p == null || p.getSymbId() == null) continue;
            ids.add(p.getSymbId());
        }
        return ids;
    }

    public TimeToEventData getTimeToEventData() {
        return this.tte_data;
    }

    public boolean hasCategoricalData() {
        return this.categorical_data != null;
    }

    public boolean hasCountData() {
        return this.count_data != null;
    }

    public boolean hasParameters() {
        return !this.param_refs.isEmpty();
    }

    @Override
    public boolean hasSymbolId(String name) {
        boolean has = false;
        if (name != null) {
            for (CommonParameter s : this.params) {
                String v_name = s.getSymbId();
                if (v_name == null || !v_name.equals(name)) continue;
                has = true;
                break;
            }
        }
        return has;
    }

    public boolean hasTimeToEventData() {
        return this.tte_data != null;
    }

    private void initErrorModel() {
        ContinuousObservationModel com = this.ob.getContinuousData();
        this.discrete = this.ob.getDiscrete();
        if (com != null) {
            List elements = com.getListOfObservationModelElement();
            if (this.params != null) {
                for (PharmMLElement o : elements) {
                    String symbolId;
                    if (o == null) continue;
                    if (PharmMLTypeChecker.isPopulationParameter((Object)o)) {
                        PopulationParameter p = (PopulationParameter)o;
                        this.checkAssignment(p);
                        symbolId = p.getSymbId();
                        if (!this.isSymbolIdOkay(symbolId)) {
                            throw new IllegalStateException("The node symbolId (" + symbolId + ") is not okay.");
                        }
                        this.params.add((CommonParameter)p);
                        continue;
                    }
                    if (PharmMLTypeChecker.isRandomVariable((Object)o)) {
                        ParameterRandomVariable rv = (ParameterRandomVariable)o;
                        symbolId = rv.getSymbId();
                        if (!this.isSymbolIdOkay(symbolId)) {
                            throw new IllegalStateException("The node symbolId (" + symbolId + ") is not okay.");
                        }
                        this.params.add((CommonParameter)rv);
                        this.random_variables.add((ParameterRandomVariable)o);
                        continue;
                    }
                    if (PharmMLTypeChecker.isIndividualParameter((Object)o)) {
                        IndividualParameter ip = (IndividualParameter)o;
                        symbolId = ip.getSymbId();
                        if (!this.isSymbolIdOkay(symbolId)) {
                            throw new IllegalStateException("The node symbolId (" + symbolId + ") is not okay.");
                        }
                        this.indiv_params.add(ip);
                        continue;
                    }
                    if (PharmMLTypeChecker.isLocalVariable((Object)o)) continue;
                    if (PharmMLTypeChecker.isCorrelation((Object)o)) {
                        this.register((Correlation)o);
                        continue;
                    }
                    throw new UnsupportedOperationException("Observation scope parameter type unsupported (" + o + ")");
                }
            }
            this.error_model = com.getObservationError();
        } else if (this.discrete != null) {
            this.count_data = this.discrete.getCountData();
            this.categorical_data = this.discrete.getCategoricalData();
            this.tte_data = this.discrete.getTimeToEventData();
        } else {
            throw new NullPointerException("The observation model (blkId='" + this.ob.getBlkId() + "') has no bound observation error model.");
        }
    }

    public boolean isApplicable(StructuralBlock sb) {
        String sb_name;
        return sb != null && (sb_name = sb.getName()) != null && this.model_block_ids.contains(sb_name);
    }

    public boolean isDiscrete() {
        return this.discrete != null;
    }

    public boolean isObservationParameter(PopulationParameter p) {
        if (p != null) {
            for (ObservationParameter param_ref : this.param_refs) {
                if (param_ref == null || param_ref.param == null || !param_ref.param.equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSimulationOutput(PharmMLRootType v) {
        if (v != null) {
            for (SimulationOutput simulation_output : this.simulation_outputs) {
                if (this.simulation_outputs == null || simulation_output.v == null || !v.equals(simulation_output.v)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUsing(VariableDefinition v) {
        if (v == null) {
            return false;
        }
        for (SimulationOutput output : this.simulation_outputs) {
            if (output == null || !v.equals(output.v)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

