/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.so.unipv.winbugs;

import eu.ddmore.converters.unipv.winbugs.parts.TaskParameters;
import eu.ddmore.libpharmml.dom.dataset.ColumnType;
import eu.ddmore.so.unipv.winbugs.parts.IndexElement;
import eu.ddmore.so.unipv.winbugs.parts.OutputParameters;
import eu.ddmore.so.unipv.winbugs.parts.Parameter;
import eu.ddmore.so.unipv.winbugs.parts.Sample;
import eu.ddmore.so.unipv.winbugs.parts.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.math3.stat.StatUtils;

public class CodaLoader {
    public static final double[] perc = new double[]{2.5, 5.0, 50.0, 95.0, 97.5};
    public static final String resName = "residual";
    public static final String predName = "pred";
    public static String indexSuffix = "Index";
    public static String codaPrefix = "output";
    private static String codaFilePath;
    private List<File> dataFile;
    private File indexFile;
    private OutputParameters popPar;
    private OutputParameters indivPar;
    private OutputParameters resPar;
    private OutputParameters predPar;
    private Map<String, Map<Integer, Parameter>> indivMap;
    private Map<String, Map<Integer, Map<Integer, Parameter>>> residMap;
    private Map<String, Map<Integer, Map<Integer, Parameter>>> predMap;
    private String modelName;
    private String solver;
    private String model;
    private String update;
    private String nchains;
    private String burnIn;
    private Long time;
    private List<String> residual;
    private List<String> prediction;

    public CodaLoader(String inP, String name) throws FileNotFoundException, IOException {
        this(inP);
        this.modelName = name;
    }

    public CodaLoader(String inP) throws FileNotFoundException, IOException {
        codaFilePath = inP;
        this.popPar = new OutputParameters();
        this.resPar = new OutputParameters();
        this.indivPar = new OutputParameters();
        this.predPar = new OutputParameters();
        this.indivMap = new HashMap<String, Map<Integer, Parameter>>();
        this.residMap = new HashMap<String, Map<Integer, Map<Integer, Parameter>>>();
        this.predMap = new HashMap<String, Map<Integer, Map<Integer, Parameter>>>();
        this.init();
    }

    private Integer getIndex(String label) {
        String s = label.substring(label.indexOf("[") + 1, label.indexOf("]"));
        return new Integer(s);
    }

    private Integer getIndex(String label, char pos) {
        String s = "";
        switch (pos) {
            case 's': {
                s = label.substring(label.indexOf("[") + 1, label.indexOf(","));
                break;
            }
            case 't': {
                s = label.substring(label.indexOf(",") + 1, label.indexOf("]"));
            }
        }
        return new Integer(s);
    }

    private void updateIndivMap(Map<String, Map<Integer, Parameter>> m, OutputParameters pars) {
        for (Map.Entry<String, Parameter> p : pars.getPars().entrySet()) {
            if (p.getKey().contains(",")) continue;
            Map<Integer, Parameter> map = m.get(p.getValue().getSymbId());
            if (map == null) {
                map = new HashMap<Integer, Parameter>();
            }
            map.put(this.getIndex(p.getKey()), p.getValue());
            m.put(p.getValue().getSymbId(), map);
        }
    }

    private void updateIndivTimeMap(Map<String, Map<Integer, Map<Integer, Parameter>>> m, OutputParameters pars) {
        for (Map.Entry<String, Parameter> p : pars.getPars().entrySet()) {
            Map<Integer, Map<Integer, Parameter>> map = m.get(p.getValue().getSymbId());
            if (map == null) {
                map = new HashMap<Integer, Map<Integer, Parameter>>();
                HashMap hashMap = new HashMap();
            }
            m.put(p.getValue().getSymbId(), map);
        }
    }

    public Map<String, Map<Integer, Parameter>> getIndivMap() {
        return this.indivMap;
    }

    public Map<String, Map<Integer, Map<Integer, Parameter>>> getResidMap() {
        return this.residMap;
    }

    public Map<String, Map<Integer, Map<Integer, Parameter>>> getPredMap() {
        return this.predMap;
    }

    private void updateMaps() {
        this.updateIndivMap(this.indivMap, this.indivPar);
        this.updateIndivTimeMap(this.predMap, this.predPar);
    }

    public String getOdeSolver() {
        return this.solver;
    }

    public String getNChains() {
        return this.nchains;
    }

    public String getUpdate() {
        return this.update;
    }

    public OutputParameters getPopPar() {
        return this.popPar;
    }

    public OutputParameters getPredPar() {
        return this.predPar;
    }

    public OutputParameters getResPar() {
        return this.resPar;
    }

    public OutputParameters getIndivPar() {
        return this.indivPar;
    }

    public int getPopParNum() {
        return this.popPar.getPars().size();
    }

    public double[] getVals(OutputParameters par, String name) {
        return par.getPars().get(name).getArrayValues();
    }

    public List<String> getCodaNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (File f : this.dataFile) {
            if (f.isDirectory()) continue;
            list.add(f.getName());
        }
        return list;
    }

    public void loadData() throws FileNotFoundException, IOException {
        BufferedReader fIndex = new BufferedReader(new FileReader(this.indexFile));
        for (File codaF : this.dataFile) {
            BufferedReader fData = new BufferedReader(new FileReader(codaF));
            while (fIndex.ready()) {
                String line = fIndex.readLine();
                String[] f = line.split("\t");
                IndexElement el = new IndexElement(f[0], Integer.parseInt(f[1]), Integer.parseInt(f[2]));
                if (el.getName().contains(",")) continue;
                int n = el.getSamplesNumber();
                Parameter pp = new Parameter();
                pp.setName(el.getName());
                ArrayList<Sample> values = new ArrayList<Sample>();
                for (int i = 0; i < n && fData.ready(); ++i) {
                    line = fData.readLine();
                    f = line.split("\t");
                    values.add(new Sample(Double.parseDouble(f[1])));
                }
                pp.setValues(values);
                if (Util.isInList(this.residual, Util.getName(pp.getName()))) {
                    this.resPar.putParameter(pp.getName(), pp);
                    continue;
                }
                if (Util.isInList(this.prediction, Util.getName(pp.getName()))) {
                    this.predPar.putParameter(pp.getName(), pp);
                    continue;
                }
                if (pp.getcType().equals((Object)ColumnType.POP_PARAMETER)) {
                    this.popPar.putParameter(el.getName(), pp);
                    continue;
                }
                if (!pp.getcType().equals((Object)ColumnType.INDIV_PARAMETER)) continue;
                this.indivPar.putParameter(el.getName(), pp);
            }
        }
        this.updateMaps();
    }

    public void setInPath(String inPath) {
        codaFilePath = inPath;
    }

    public void statistics(OutputParameters parameters) {
        for (Map.Entry<String, Parameter> pars : parameters.getPars().entrySet()) {
            Parameter v = pars.getValue();
            System.out.println(v.getName() + "\n" + v.statistics());
        }
    }

    public String getModelName() {
        return this.modelName;
    }

    private void decriptiveStatistics(String name, double[] v) {
        System.out.println("\n-- " + name + " --");
        System.out.println(" mean: " + StatUtils.mean(v));
        for (double pe : perc) {
            System.out.println(" percentile " + pe + ": " + StatUtils.percentile(v, pe));
        }
    }

    public String getInPath() {
        return codaFilePath;
    }

    public Long getTime() {
        return this.time;
    }

    private void loadParameters(FileReader in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        this.solver = props.getProperty("odesolver");
        this.update = props.getProperty("niter");
        this.nchains = props.getProperty("nchains");
        this.burnIn = props.getProperty("burnin");
        this.residual = this.getParList(props.getProperty("resName", ""));
        this.prediction = this.getParList(props.getProperty("predName", ""));
        if (props.getProperty("time") != null) {
            try {
                this.time = Long.parseLong(props.getProperty("time"));
            }
            catch (NumberFormatException e) {
                this.time = null;
            }
        }
        this.model = props.getProperty("model");
        if (this.model == null) {
            this.model = "model";
        }
    }

    private void loadParametersNew(FileReader in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        this.solver = props.getProperty(TaskParameters.ODE_SOLVER.label());
        this.update = props.getProperty(TaskParameters.N_ITER.label());
        this.nchains = props.getProperty(TaskParameters.N_CHAINS.label());
        this.burnIn = props.getProperty(TaskParameters.BURN_IN.label());
        this.model = props.getProperty(TaskParameters.MODEL_NAME.label());
        this.residual = this.getParList(props.getProperty(TaskParameters.RES_NAME.label(), TaskParameters.RES_NAME.defaultVal()));
        this.prediction = this.getParList(props.getProperty(TaskParameters.PRED_NAME.label(), TaskParameters.PRED_NAME.defaultVal()));
        if (props.getProperty(TaskParameters.TIME.label()) != null) {
            try {
                this.time = Long.parseLong(props.getProperty(TaskParameters.TIME.label()));
            }
            catch (NumberFormatException e) {
                this.time = null;
            }
        }
    }

    public String getModel() {
        return this.model;
    }

    private List<String> getParList(String list) {
        String[] el;
        ArrayList<String> out = new ArrayList<String>();
        for (String s : el = list.split(",")) {
            if (s.trim().length() <= 0) continue;
            out.add(s);
        }
        return out;
    }

    private void init() throws IOException {
        this.residual = new ArrayList<String>();
        this.prediction = new ArrayList<String>();
        this.loadParameters(new FileReader(new File(codaFilePath + "/SO.properties")));
        File[] dataFileList = null;
        File inDir = new File(codaFilePath);
        if (inDir.exists()) {
            dataFileList = inDir.listFiles();
        }
        FilenameFilter indexFN = CodaLoader.getIndexFileFilter();
        File[] a = inDir.listFiles(indexFN);
        if (inDir.listFiles(indexFN).length != 1) {
            throw new InvalidPathException(codaFilePath, "No index or more than one index file in the directory");
        }
        this.indexFile = inDir.listFiles(indexFN)[0];
        System.out.println("index file = " + this.indexFile.getAbsolutePath());
        this.dataFile = new ArrayList<File>();
        for (File n : dataFileList) {
            if (n.isDirectory() || n.equals(this.indexFile) || !n.getName().startsWith(codaPrefix)) continue;
            this.dataFile.add(n);
            System.out.println("data file " + n.getAbsolutePath());
        }
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    private static FilenameFilter getIndexFileFilter() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(indexSuffix);
            }
        };
        return filter;
    }

    private static FilenameFilter getCodaFile() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(codaPrefix) && !name.contains(indexSuffix);
            }
        };
        return filter;
    }
}

