/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.so.unipv.winbugs;

import eu.ddmore.so.unipv.winbugs.CodaLoader;
import eu.ddmore.so.unipv.winbugs.parts.SOGenerator;
import java.io.FileNotFoundException;
import java.io.IOException;

public class WinBugsSO {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        String ioPath = args.length == 1 ? args[0] : "./";
        System.out.println("SO generation START");
        System.out.println("inPath = " + ioPath);
        CodaLoader sg = new CodaLoader(ioPath);
        sg.loadData();
        SOGenerator tso = new SOGenerator("winbugs-SO", sg);
        tso.createSOBlock("blk1");
        tso.createRawResults("output");
        tso.createTaskInformation("success");
        tso.createEstimation();
        tso.createPopulationEstimates(null);
        tso.createPrecisionPopulationEstimates(ioPath + "/" + "popEstimates.csv");
        if (!sg.getIndivMap().isEmpty()) {
            tso.createIndividualEstimates();
            tso.createPrecisionIndividualEstimates(ioPath + "/" + "indivEstimates.csv");
        }
        String outXml = ioPath + "/" + sg.getModel() + ".SO.xml";
        tso.save(outXml);
        System.out.println("output saved in file  = " + outXml);
        System.out.println("tempo di esecuzione " + (System.currentTimeMillis() - sg.getTime()) / 6000L + " sec");
        System.out.println("SO generation END");
    }
}

