/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.so.unipv.winbugs.parts;

import eu.ddmore.so.unipv.winbugs.parts.Parameter;
import org.apache.commons.math3.stat.StatUtils;

public class DataStatistics {
    public static double[] perc = new double[]{2.5, 5.0, 25.0, 50.0, 75.0, 95.0, 97.5};
    private Parameter par;
    private double mean;
    private double median;
    private double[] percentiles = new double[perc.length];

    public DataStatistics(Parameter par) {
        this.par = par;
    }

    public void statistics() {
        this.mean = this.getMean();
        this.median = this.getMedian();
        this.percentiles = this.getPercentiles();
    }

    private double getMean() {
        return StatUtils.mean(this.par.getArrayValues());
    }

    private double getMedian() {
        return StatUtils.percentile(this.par.getArrayValues(), 50.0);
    }

    private double[] getPercentiles() {
        double[] vals = new double[perc.length];
        int i = 0;
        for (double pe : perc) {
            vals[i++] = StatUtils.percentile(this.par.getArrayValues(), pe);
        }
        return vals;
    }

    public String toString() {
        String s = "";
        s = s + "mean: " + this.mean + "\n";
        s = s + "median: " + this.median + "\n";
        for (int i = 0; i < perc.length; ++i) {
            s = s + perc[i] + " percentile: " + this.percentiles[i] + "\n";
        }
        return s;
    }
}

