/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.so.unipv.winbugs.parts;

import eu.ddmore.libpharmml.dom.dataset.ColumnType;
import eu.ddmore.so.unipv.winbugs.parts.DataStatistics;
import eu.ddmore.so.unipv.winbugs.parts.Sample;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;

public class Parameter {
    private String name;
    private String symbId;
    private String type;
    private ColumnType cType;
    private List<Sample> values = new ArrayList<Sample>();
    private DataStatistics ds;

    public Parameter() {
    }

    public Parameter(String type) {
        this();
        this.type = type;
    }

    public void add(String s) {
        String[] f = s.split("\t");
        this.add(Double.parseDouble(f[1]));
    }

    public void add(double v) {
        this.values.add(new Sample(v));
    }

    public String toString() {
        String ss = this.name + "\n";
        for (Sample s : this.values) {
            ss = ss + s + "\n";
        }
        return ss;
    }

    public void setValues(List<Sample> values) {
        this.values = values;
    }

    public ColumnType getcType() {
        return this.cType;
    }

    public void setName(String name) {
        this.name = name;
        if (name.contains("[")) {
            this.type = ColumnType.INDIV_PARAMETER.value();
            this.cType = ColumnType.INDIV_PARAMETER;
            this.symbId = name.substring(0, name.indexOf("["));
        } else {
            this.type = ColumnType.POP_PARAMETER.value();
            this.cType = ColumnType.POP_PARAMETER;
            this.symbId = name;
        }
    }

    private double[] getArray() {
        double[] vet = new double[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            vet[i] = this.values.get(i).getVal();
        }
        return vet;
    }

    public double getMean() {
        double[] vals = this.getArray();
        return StatUtils.mean(vals);
    }

    public double getVar() {
        double[] vals = this.getArray();
        return StatUtils.variance(vals);
    }

    public double getSD() {
        double[] vals = this.getArray();
        return Math.sqrt(StatUtils.variance(vals));
    }

    public double getPerc(double p) {
        double[] vals = this.getArray();
        return StatUtils.percentile(vals, p);
    }

    public double getMin() {
        double[] vals = this.getArray();
        return StatUtils.min(vals);
    }

    public String getName() {
        return this.name;
    }

    public String getSymbId() {
        return this.symbId;
    }

    public List<Sample> getValues() {
        return this.values;
    }

    public String getType() {
        return this.type;
    }

    public double[] getArrayValues() {
        double[] vals = new double[this.values.size()];
        int i = 0;
        for (Sample s : this.values) {
            vals[i] = s.getVal();
            ++i;
        }
        return vals;
    }

    public DataStatistics statistics() {
        this.ds = new DataStatistics(this);
        this.ds.statistics();
        return this.ds;
    }
}

