/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.so.unipv.winbugs.parts;

import eu.ddmore.libpharmml.dom.commontypes.AnnotationType;
import eu.ddmore.libpharmml.dom.dataset.DataSet;
import eu.ddmore.libpharmml.dom.dataset.ExternalFile;
import eu.ddmore.so.unipv.winbugs.parts.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.StatUtils;

public class Util {
    public static String createList(String[] ss, String sep) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            if (first) {
                first = false;
                sb.append(s);
                continue;
            }
            sb.append(sep).append(s);
        }
        return sb.toString();
    }

    public static String createList(boolean id, String[] ss, String sep) {
        if (id) {
            String[] sss = new String[ss.length + 1];
            sss[0] = "ID";
            int k = 1;
            for (String s : ss) {
                sss[k++] = s;
            }
            return Util.createList(sss, sep);
        }
        return Util.createList(ss, sep);
    }

    public static DataSet addRows(List<String[]> vals, DataSet ds) {
        for (String[] v : vals) {
            ds.createRow(v);
        }
        return ds;
    }

    public static List<String[]> getVals(Map<String, Parameter> pars, int nRows) {
        ArrayList<String[]> vals = new ArrayList<String[]>();
        for (int i = 0; i < nRows; ++i) {
            int k = 0;
            String[] val = new String[pars.size()];
            for (Map.Entry<String, Parameter> outPar : pars.entrySet()) {
                val[k++] = "" + outPar.getValue().getArrayValues()[i];
            }
            vals.add(val);
        }
        return vals;
    }

    public static List<String[]> getMedian(Map<String, Parameter> pars) {
        ArrayList<String[]> vals = new ArrayList<String[]>();
        int k = 0;
        String[] val = new String[pars.size()];
        for (Map.Entry<String, Parameter> outPar : pars.entrySet()) {
            val[k++] = "" + StatUtils.percentile(outPar.getValue().getArrayValues(), 50.0);
        }
        vals.add(val);
        return vals;
    }

    public static List<String[]> getMean(Map<String, Parameter> pars) {
        ArrayList<String[]> vals = new ArrayList<String[]>();
        int k = 0;
        String[] val = new String[pars.size()];
        for (Map.Entry<String, Parameter> outPar : pars.entrySet()) {
            val[k++] = "" + StatUtils.mean(outPar.getValue().getArrayValues());
        }
        vals.add(val);
        return vals;
    }

    public static boolean isInList(List<String> list, String s) {
        for (String s0 : list) {
            if (!s0.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInList(String[] list, String s) {
        for (String s0 : list) {
            if (!s0.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static ExternalFile createEF(String path, String id, String annotation) {
        ExternalFile ef = Util.createEF(path, id);
        AnnotationType at = new AnnotationType();
        at.setValue(annotation);
        ef.setDescription(at);
        return ef;
    }

    public static ExternalFile createEF(String path, String id) {
        ExternalFile ef = new ExternalFile();
        ef.setPath(path);
        ef.setOid(id);
        return ef;
    }

    public static String getName(String n) {
        if (!n.contains("[")) {
            return n;
        }
        return n.substring(0, n.indexOf("["));
    }

    public static String getSimpleFileName(String name) {
        int idx = name.lastIndexOf("/");
        name = idx >= 0 ? name.substring(idx + 1) : name;
        return name;
    }

    public static ExternalFile createEF(String path, String id, ExternalFile.Delimiter delim) {
        ExternalFile ef = new ExternalFile();
        ef.setPath(path);
        ef.setOid(id);
        ef.setDelimiter(delim);
        return ef;
    }
}

