/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs;

import crx.converter.engine.Accessor;
import crx.converter.engine.BaseEngine;
import crx.converter.engine.CategoryRef_;
import crx.converter.engine.ConversionDetail_;
import crx.converter.engine.FixedParameter;
import crx.converter.engine.Part;
import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.engine.ScriptDefinition;
import crx.converter.engine.SymbolReader;
import crx.converter.engine.Utils;
import crx.converter.engine.common.Continuous;
import crx.converter.engine.common.CorrelationRef;
import crx.converter.engine.common.IndividualParameterAssignment;
import crx.converter.engine.common.NestedPiecewiseParser;
import crx.converter.engine.common.ObservationParameter;
import crx.converter.engine.common.ParameterAssignmentFromEstimation;
import crx.converter.engine.common.SimulationOutput;
import crx.converter.spi.ILexer;
import crx.converter.spi.blocks.CovariateBlock;
import crx.converter.spi.blocks.ObservationBlock;
import crx.converter.spi.blocks.ParameterBlock;
import crx.converter.spi.blocks.StructuralBlock;
import crx.converter.spi.blocks.VariabilityBlock;
import crx.converter.spi.steps.EstimationStep;
import crx.converter.spi.steps.SimulationStep;
import crx.converter.tree.BinaryTree;
import crx.converter.tree.Node;
import crx.converter.tree.TreeMaker;
import eu.ddmore.converters.unipv.winbugs.ConverterProvider;
import eu.ddmore.converters.unipv.winbugs.PascalParser;
import eu.ddmore.converters.unipv.winbugs.PascalParser1;
import eu.ddmore.converters.unipv.winbugs.Util;
import eu.ddmore.converters.unipv.winbugs.parts.EstimationStepImpl;
import eu.ddmore.converters.unipv.winbugs.parts.TaskParameters;
import eu.ddmore.convertertoolbox.api.response.ConversionDetail;
import eu.ddmore.libpharmml.dom.IndependentVariable;
import eu.ddmore.libpharmml.dom.commontypes.AnnotationType;
import eu.ddmore.libpharmml.dom.commontypes.CategoryRef;
import eu.ddmore.libpharmml.dom.commontypes.CommonVariableDefinition;
import eu.ddmore.libpharmml.dom.commontypes.Delay;
import eu.ddmore.libpharmml.dom.commontypes.DerivativeVariable;
import eu.ddmore.libpharmml.dom.commontypes.FalseBoolean;
import eu.ddmore.libpharmml.dom.commontypes.FunctionDefinition;
import eu.ddmore.libpharmml.dom.commontypes.FunctionParameter;
import eu.ddmore.libpharmml.dom.commontypes.InitialCondition;
import eu.ddmore.libpharmml.dom.commontypes.IntValue;
import eu.ddmore.libpharmml.dom.commontypes.Interpolation;
import eu.ddmore.libpharmml.dom.commontypes.Interval;
import eu.ddmore.libpharmml.dom.commontypes.LevelReference;
import eu.ddmore.libpharmml.dom.commontypes.Matrix;
import eu.ddmore.libpharmml.dom.commontypes.MatrixRow;
import eu.ddmore.libpharmml.dom.commontypes.MatrixRowValue;
import eu.ddmore.libpharmml.dom.commontypes.MatrixSelector;
import eu.ddmore.libpharmml.dom.commontypes.MatrixVectorIndex;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.Product;
import eu.ddmore.libpharmml.dom.commontypes.RealValue;
import eu.ddmore.libpharmml.dom.commontypes.Rhs;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.dom.commontypes.Sequence;
import eu.ddmore.libpharmml.dom.commontypes.StandardAssignable;
import eu.ddmore.libpharmml.dom.commontypes.StringValue;
import eu.ddmore.libpharmml.dom.commontypes.Sum;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.TrueBoolean;
import eu.ddmore.libpharmml.dom.commontypes.VariableDefinition;
import eu.ddmore.libpharmml.dom.commontypes.Vector;
import eu.ddmore.libpharmml.dom.commontypes.VectorSelector;
import eu.ddmore.libpharmml.dom.commontypes.VectorValue;
import eu.ddmore.libpharmml.dom.dataset.ColumnDefinition;
import eu.ddmore.libpharmml.dom.dataset.ColumnMapping;
import eu.ddmore.libpharmml.dom.dataset.ColumnReference;
import eu.ddmore.libpharmml.dom.dataset.ColumnType;
import eu.ddmore.libpharmml.dom.maths.Binop;
import eu.ddmore.libpharmml.dom.maths.Condition;
import eu.ddmore.libpharmml.dom.maths.Constant;
import eu.ddmore.libpharmml.dom.maths.Equation;
import eu.ddmore.libpharmml.dom.maths.ExpressionValue;
import eu.ddmore.libpharmml.dom.maths.FunctionCallType;
import eu.ddmore.libpharmml.dom.maths.LogicBinOp;
import eu.ddmore.libpharmml.dom.maths.LogicUniOp;
import eu.ddmore.libpharmml.dom.maths.MatrixUniOp;
import eu.ddmore.libpharmml.dom.maths.Piece;
import eu.ddmore.libpharmml.dom.maths.Piecewise;
import eu.ddmore.libpharmml.dom.maths.Uniop;
import eu.ddmore.libpharmml.dom.modeldefn.CategoricalCovariate;
import eu.ddmore.libpharmml.dom.modeldefn.CommonParameter;
import eu.ddmore.libpharmml.dom.modeldefn.ContinuousCovariate;
import eu.ddmore.libpharmml.dom.modeldefn.Correlation;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateDefinition;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateRelation;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateTransformation;
import eu.ddmore.libpharmml.dom.modeldefn.Distribution;
import eu.ddmore.libpharmml.dom.modeldefn.FixedEffectRelation;
import eu.ddmore.libpharmml.dom.modeldefn.GeneralObsError;
import eu.ddmore.libpharmml.dom.modeldefn.IndividualParameter;
import eu.ddmore.libpharmml.dom.modeldefn.ObservationError;
import eu.ddmore.libpharmml.dom.modeldefn.Parameter;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomEffect;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomVariable;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import eu.ddmore.libpharmml.dom.modeldefn.Probability;
import eu.ddmore.libpharmml.dom.modeldefn.StructuralModel;
import eu.ddmore.libpharmml.dom.modeldefn.StructuredModel;
import eu.ddmore.libpharmml.dom.modeldefn.StructuredObsError;
import eu.ddmore.libpharmml.dom.modeldefn.TransformedCovariate;
import eu.ddmore.libpharmml.dom.modeldefn.UncertML;
import eu.ddmore.libpharmml.dom.modeldefn.VariabilityDefnBlock;
import eu.ddmore.libpharmml.dom.modeldefn.VariabilityLevelDefinition;
import eu.ddmore.libpharmml.dom.modellingsteps.Estimation;
import eu.ddmore.libpharmml.dom.modellingsteps.EstimationOperation;
import eu.ddmore.libpharmml.dom.modellingsteps.ModellingSteps;
import eu.ddmore.libpharmml.dom.modellingsteps.OperationProperty;
import eu.ddmore.libpharmml.dom.modellingsteps.ParameterEstimate;
import eu.ddmore.libpharmml.dom.probonto.DistributionName;
import eu.ddmore.libpharmml.dom.probonto.DistributionParameter;
import eu.ddmore.libpharmml.dom.probonto.ParameterName;
import eu.ddmore.libpharmml.dom.probonto.ProbOnto;
import eu.ddmore.libpharmml.dom.trialdesign.ExternalDataSet;
import eu.ddmore.libpharmml.dom.trialdesign.MultipleDVMapping;
import eu.ddmore.libpharmml.dom.uncertml.AbstractContinuousUnivariateDistributionType;
import eu.ddmore.libpharmml.dom.uncertml.AbstractDistributionType;
import eu.ddmore.libpharmml.dom.uncertml.CauchyDistribution;
import eu.ddmore.libpharmml.dom.uncertml.ContinuousValueType;
import eu.ddmore.libpharmml.dom.uncertml.GeometricDistribution;
import eu.ddmore.libpharmml.dom.uncertml.LogNormalDistribution;
import eu.ddmore.libpharmml.dom.uncertml.LogisticDistribution;
import eu.ddmore.libpharmml.dom.uncertml.NormalDistribution;
import eu.ddmore.libpharmml.dom.uncertml.NormalDistributionType;
import eu.ddmore.libpharmml.dom.uncertml.PoissonDistribution;
import eu.ddmore.libpharmml.dom.uncertml.PositiveRealValueType;
import eu.ddmore.libpharmml.dom.uncertml.VarRefType;
import eu.ddmore.libpharmml.pkmacro.translation.Input;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.UnsupportedDataTypeException;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Parser
extends NestedPiecewiseParser {
    protected static boolean DEBUG = false;
    protected PrintStream outDebug;
    protected String odeSolver;
    protected File tsoFile;
    protected PrintStream toSO;
    private String SODirName = "WinBugsSO/";
    private String toSOName = "SO.properties";
    private String resLabel = "residual";
    private String predLabel = "pred";
    protected String pascalFileNameSuffix = ".txt";
    protected String nCovContName = "n_cov_cont";
    protected String nCovCatName = "n_cov_cat";
    protected String[] dataCovKeywords = new String[]{"max_m_", "N_t_", "grid_"};
    protected List<String> dataToRemove = new ArrayList<String>();
    private List<String> resList = new ArrayList<String>();
    private List<String> predList = new ArrayList<String>();
    protected String num1Default = "0";
    protected String nIterDefault = "5000";
    protected String burnInDeafult = "1000";
    protected String nChainsDefault = "1";
    protected String thinUpdaterDefault = "1";
    protected String thinSamplesDefault = "1";
    protected String solverDefault = "RK45";
    protected String dicDefault = "false";
    protected String winbugsGUIDefault = "false";
    protected String thinUpdaterComment = "";
    protected String thinSamplesComment = "";
    protected String winBUgsGUIComment = "";
    protected String num1;
    protected String totGrid;
    protected String burnIn;
    protected String nIter;
    protected String nChains;
    protected String thinUpdater;
    protected String thinSamples;
    protected String dic;
    protected String winbugsGUI;
    private static final String parametersFile = "pascal.properties";
    protected String pascalAssignSymbol = ":=";
    protected String leftArrayBracket;
    protected String rightArrayBracket;
    private List<FixedParameter> fixed_parameters = new ArrayList<FixedParameter>();
    private HashMap<Object, String> transformation_stmt_map = new HashMap();
    protected ScriptDefinition sd = new ScriptDefinition();
    private ParameterBlock pb = null;
    public static String unassigned_symbol = "@";
    protected static final String WinbugsExecutionScriptName = "runWBScript.txt";
    protected static final String WinbugsCompileScriptTemplateName = "bbscript-BlackBox-WinBUGS-template.txt";
    protected static final String WinbugsCompileScriptName = "bbscript-BlackBox-WinBUGS.txt";
    protected static final String catCovTemplateFileName = "TemplateCovariate.txt";
    protected String covariatePascalName;
    protected static String winbugsTemplateDir;
    protected static String outputDir;
    protected static String bbCompileScriptDir;
    protected static String winbugsDir;
    protected static String jobDir;
    protected static String workingDir;
    protected String pascalBody;
    protected List<String> pmetricsList = new ArrayList<String>();
    protected List<String> wbdevList = new ArrayList<String>();
    protected List<String> pwList = new ArrayList<String>();
    protected List<String> priorList = new ArrayList<String>();
    private String binaryFormat = "(%s%s%s)";
    protected String modelName;
    protected int modelNum;
    protected static final String piecewiseSymb = "VECTOR";
    protected static final String piecePrefix = "piece_";
    protected int pwNum = 0;
    List<SymbolRef> listRefs = new ArrayList<SymbolRef>();
    protected boolean openAssign = false;
    protected boolean hasCovariate = false;
    protected boolean hasDiffEquations = false;
    protected boolean inPW = false;
    protected String pascalOdeCall = "";
    protected List<String> piecewiseFileList = new ArrayList<String>();
    protected VariabilityLevelDefinition priorLevel;
    protected Map<PharmMLRootType, String> priorPar = new HashMap<PharmMLRootType, String>();
    protected static final char INDIV_INDEX = 's';
    protected static final char TIME_INDEX = 't';
    protected static final char BOTH_INDEX = 'b';
    protected static final char NO_INDEX = ' ';
    protected static final char INDQ_INDEX = 'q';
    protected static final char INDM_INDEX = 'm';
    private File xmlFileName;
    private List<SymbolRef> simpleP_Parameters = new ArrayList<SymbolRef>();
    private List<SymbolRef> localV_Parameters = new ArrayList<SymbolRef>();
    private List<SymbolRef> population_Parameters = new ArrayList<SymbolRef>();
    private List<SymbolRef> randVar_Parameters = new ArrayList<SymbolRef>();
    protected int n_loops;
    protected static final String NT = "N_t";
    protected static final String NS = "N_subj";
    protected static final String IND_T = "ind_t";
    protected static final String IND_T2 = "ind_q";
    protected static final String IND_S = "ind_subj";
    protected static final String IND_max_m_W = "max_m_W";
    protected String interpSuffix = "interp";
    protected String piecewiseSuffix = "piecewise";
    protected String categSuffix = "categ";
    protected String piecewiseFunctionSuffix = "function." + this.piecewiseSuffix;
    protected String categFunctionSuffix = "function." + this.categSuffix;
    protected String maxNamePrefix = "max_m_";
    protected String NtNamePrefix = "N_t_";
    protected String gridPrefix = "grid_";
    protected String NT_INDIV;
    private static String[] listIndexes;
    protected String pow_format = "MathFunc.Power(%s,%s)";
    private boolean isCommonVariable = false;
    private boolean isDerivativeDependent = false;
    protected boolean odeInitialValueSubjDep = false;
    protected List<SymbolRef> vars = new ArrayList<SymbolRef>();
    private List<String> winbugs_unary_operators_list = new ArrayList<String>();
    private List<String> doseVar = new ArrayList<String>();
    private List<String> dosingTime = new ArrayList<String>();
    private Map<String, String> winbugsUnaryOperatorsMap = new HashMap<String, String>();
    protected Map<String, String> variablesAssignementMap = new HashMap<String, String>();
    private Map<String, String> tmpVariablesAssignementMap = new HashMap<String, String>();
    protected Map<String, Integer> piecewiseIndexMap = new HashMap<String, Integer>();
    protected Map<String, Boolean> piecewiseODE = new HashMap<String, Boolean>();
    protected Map<String, String> piecewiseMap = new HashMap<String, String>();
    protected Map<String, Map<Integer, String>> piecewiseVarToPascal = new HashMap<String, Map<Integer, String>>();
    protected Map<Object, String> parameterDefinitionMap = new HashMap<Object, String>();
    protected final Map<String, String> derivativeMap = new HashMap<String, String>();
    protected final Map<String, String> derivativeMapNew = new HashMap<String, String>();
    protected final Map<String, List<Piece>> doseTargetMap = new HashMap<String, List<Piece>>();
    protected final Map<String, String> cmtMap = new HashMap<String, String>();
    protected final Map<Integer, String> covFilesMap = new HashMap<Integer, String>();
    protected final Map<String, String> covBlockMap = new HashMap<String, String>();
    protected final Map<String, String> covCatMap = new HashMap<String, String>();
    private final Map<String, String> derivativeDefFromMap = new HashMap<String, String>();
    protected final Map<String, List<SymbolRef>> parVariablesFromMap = new HashMap<String, List<SymbolRef>>();
    protected final Map<String, List<SymbolRef>> randVariablesFromMap = new HashMap<String, List<SymbolRef>>();
    protected final Map<String, Integer[]> matrixMap = new HashMap<String, Integer[]>();
    protected final Map<String, Integer> vectorMap = new HashMap<String, Integer>();
    private Integer notAssignedIndex;
    private Integer vectorIndex = this.notAssignedIndex = Integer.valueOf(0);
    protected Map<Object, String> continuousCovariateIdMap = new HashMap<Object, String>();
    protected Map<Object, String> continuousMap = new HashMap<Object, String>();
    protected Map<Object, Integer> categoricalCovariateIdMap = new HashMap<Object, Integer>();
    protected Map<String, List<CategoryRef_>> categoricalMap = new HashMap<String, List<CategoryRef_>>();
    protected Map<Object, String> covariateTransformationMap = new HashMap<Object, String>();
    protected Map<Object, String> covariateDefinitionMap = new HashMap<Object, String>();
    protected Map<Object, String> covariateMap = new HashMap<Object, String>();
    protected Map<String, String> unaryOpMap = new HashMap<String, String>();
    protected Map<String, String> unaryOperandEqMap = new HashMap<String, String>();
    protected Map<String, String> transfMap = new HashMap<String, String>();
    protected Map<String, String> pascalIndivMap = new HashMap<String, String>();
    protected Map<String, String> binOpMap = new HashMap<String, String>();
    protected Map<String, Object> pascalVarMap = new TreeMap<String, Object>();
    protected int nOpenB = 0;
    protected String IND_BOTH;
    protected String IND_BOTH2;
    protected String IND_TIME;
    protected String IND_TIME2;
    protected String IND_SUBJ;
    protected static final String assignSymbol = "<-";
    protected static final String openModel = "model {";
    protected static final String dist_symb = "~";
    protected static final String forStartString = "for (";
    protected static final String forInString = " in 1:";
    protected static final String forEndString = ") {";
    protected String varLabel = "VAR";
    protected String timeLoop;
    protected String timeIndivLoop;
    protected static String time2Loop;
    protected static String time2IndivLoop;
    protected String indivLoop;
    private static final String meanSuffixLabel = "_mean";
    private static final String varianceSuffixLabel = "_prec";
    private static final String resSuffixLabel = "_res";
    private List<String> assignedSimpleParList = new ArrayList<String>();
    private List<String> parametersList = new ArrayList<String>();
    private List<String> parametersToEstimate = new ArrayList<String>();
    private Map<String, String> parametersMap = new HashMap<String, String>();
    private final String etaName = "ETA";
    private final String omegaName = "OMEGA";
    private final String muName = "mu";
    private final String tName = "T";
    private List<String> commonVarLines = new ArrayList<String>();
    private List<String> parameterLines = new ArrayList<String>();
    protected List<String> winbugsIndivLines = new ArrayList<String>();
    protected List<String> catCovFiles = new ArrayList<String>();
    protected List<String> correlationLines = new ArrayList<String>();
    protected List<String> pascalIndivLines = new ArrayList<String>();
    protected List<String> matrixVectorLines = new ArrayList<String>();
    protected List<String> pascalDiffEqLines = new ArrayList<String>();
    protected List<String> covToNotRemove = new ArrayList<String>();
    protected List<String> pwBugsList = new ArrayList<String>();
    protected Map<String, String> pascalAssignIndivEqLines = new HashMap<String, String>();
    protected Map<String, String> pascalAssignIndivEqLinesMap = new HashMap<String, String>();
    protected Map<String, String> pascalAssignVarEqLines = new HashMap<String, String>();
    protected String pascalAssignIndivEq = new String();
    protected String pascalAssignVarEq = new String();
    protected String pascalIndivEq = new String();
    protected List<SymbolRef> stateV_Parameters = new ArrayList<SymbolRef>();
    protected List<SymbolRef> indivV_Parameters = new ArrayList<SymbolRef>();
    protected List<SymbolRef> theta_Parameters = new ArrayList<SymbolRef>();
    protected List<SymbolRef> leafOdeParameters = new ArrayList<SymbolRef>();
    protected List<SymbolRef> leafVariables = new ArrayList<SymbolRef>();
    protected List<SymbolRef> leafPiecewiseParameters = new ArrayList<SymbolRef>();
    protected Map<String, List<SymbolRef>> piecewiseLeafParameters = new HashMap<String, List<SymbolRef>>();
    private List<String> variableLines = new ArrayList<String>();
    private List<String> variableCompleteList = new ArrayList<String>();
    protected List<SymbolRef> usedCovNames = new ArrayList<SymbolRef>();
    protected List<SymbolRef> usedOdeContCovNames = new ArrayList<SymbolRef>();
    protected List<SymbolRef> usedOdeCatCovNames = new ArrayList<SymbolRef>();
    protected List<SymbolRef> usedPwCovNames = new ArrayList<SymbolRef>();
    protected List<String> uniOpList = new ArrayList<String>();
    private List<String> obsModelLines = new ArrayList<String>();
    private List<String> indivParamsLines = new ArrayList<String>();
    private List<String> standardModelLines = new ArrayList<String>();
    private List<String> initialEstimatesLines = new ArrayList<String>();
    private List<String> randVarLines = new ArrayList<String>();
    private String errorTransformation = "";
    private final List<Object> reversePolishStack = new ArrayList<Object>();
    protected static int smNumber;
    private static final String suffixDerDepLabel = "_unipv";
    protected static final String upperSuffixDerDepLabel;
    protected static final String stateLabel = "der99wb_unipv";
    protected static final String upperStateLabel;
    protected List<String> derivativeModelLines = new ArrayList<String>();
    protected List<String> winbugsPiecewiseLines = new ArrayList<String>();
    protected List<String> winbugsCovariateLines = new ArrayList<String>();
    protected List<String> winbugsPiecewiseDerivDepLines = new ArrayList<String>();
    protected List<String> stateVarAssignementLines = new ArrayList<String>();
    protected List<String> initialValuesLines = new ArrayList<String>();
    protected final List<String> diffEqLines = new ArrayList<String>();
    protected List<String> populationParametersLines = new ArrayList<String>();
    protected List<String> populationParametersMatrixLines = new ArrayList<String>();
    protected List<SymbolRef> odeParameters = new ArrayList<SymbolRef>();
    protected List<SymbolRef> odeParametersOld = new ArrayList<SymbolRef>();
    protected Map<String, List<SymbolRef>> piecewiseParameters = new HashMap<String, List<SymbolRef>>();
    protected List<VariableDefinition> piecewiseVariables = new ArrayList<VariableDefinition>();
    protected List<PharmMLRootType> piecewiseCompleteList = new ArrayList<PharmMLRootType>();
    protected List<PopulationParameter> piecewisePopPars = new ArrayList<PopulationParameter>();
    protected List<String> piecewiseVariablesId = new ArrayList<String>();
    protected List<SymbolRef> odeParameters1 = new ArrayList<SymbolRef>();
    protected List<SymbolRef> piecewiseParameters1 = new ArrayList<SymbolRef>();
    List<SymbolRef> odeParameters2 = new ArrayList<SymbolRef>();
    List<SymbolRef> piecewiseParameters2 = new ArrayList<SymbolRef>();
    protected List<SymbolRef> covPascalList = new ArrayList<SymbolRef>();
    protected String odeLine = "";
    protected List<DerivativeVariable> completeStateVariablesList = new ArrayList<DerivativeVariable>();
    protected List<StructuralBlock> stateVariablesStructuralBlockList = new ArrayList<StructuralBlock>();
    protected static final String gridLabel = "grid";
    protected static final String initLabel = "initial_value";
    protected static final String originLabel = "origin";
    protected static final String tolVal = "0.001";
    String defaultInitialTime = "0.0";
    protected static final String odeName = "ode";
    List<String> derivativeSymbols = new ArrayList<String>();
    Map<Object, BinaryTree> functionMap = new HashMap<Object, BinaryTree>();
    Map<Object, String> functionDefinition = new HashMap<Object, String>();

    public Parser() throws IOException {
        this.init();
        this.num1 = "0";
        this.winbugs_unary_operators_list = new ArrayList<String>();
        Properties props = new Properties();
        props.load(((Object)((Object)this)).getClass().getResourceAsStream("Parser.properties"));
        this.binary_operator_format_minus = this.binaryFormat;
        this.binary_operator_format_plus = this.binaryFormat;
        this.binary_operator_format_power = this.binaryFormat;
        this.binary_operator_format_times = this.binaryFormat;
        this.binary_operator_format_divide = this.binaryFormat;
    }

    public static String getJobDir() {
        return jobDir;
    }

    public static void setJobDir(String jobDir) {
        Parser.jobDir = jobDir;
    }

    public String getOdeSolver() {
        return this.odeSolver;
    }

    public void setOdeSolver(String odeSolver) {
        this.odeSolver = odeSolver;
    }

    public void setTotGrid(int totGrid) {
        this.totGrid = "" + totGrid;
    }

    public String getTotGrid() {
        return this.totGrid;
    }

    public String getFVal(String id) {
        String val = null;
        for (StructuralBlock sb : this.lexer.getScriptDefinition().getStructuralBlocks()) {
            if (sb.getPKMacroOutput() == null) continue;
            for (Input el : sb.getPKMacroOutput().getListOfInput()) {
                if (!el.getTarget().getSymbId().equals(id) || el.getP() == null) continue;
                if (el.getP() instanceof SymbolRef) {
                    val = this.delimit(((SymbolRef)el.getP()).getSymbIdRef());
                    if (this.variablesAssignementMap.containsKey(val)) {
                        val = this.variablesAssignementMap.get(val);
                    }
                    return val;
                }
                if (!(el.getP() instanceof Scalar)) continue;
                return ((Scalar)el.getP()).asString();
            }
        }
        return val;
    }

    public String getTlagVal(String id) {
        String val = null;
        for (StructuralBlock sb : this.lexer.getScriptDefinition().getStructuralBlocks()) {
            if (sb.getPKMacroOutput() == null) continue;
            for (Input el : sb.getPKMacroOutput().getListOfInput()) {
                if (!el.getTarget().getSymbId().equals(id) || el.getTlag() == null) continue;
                if (el.getTlag() instanceof SymbolRef) {
                    val = this.delimit(((SymbolRef)el.getTlag()).getSymbIdRef());
                    if (this.variablesAssignementMap.containsKey(val)) {
                        val = this.variablesAssignementMap.get(val);
                    }
                    return val;
                }
                if (!(el.getTlag() instanceof Scalar)) continue;
                val = ((Scalar)el.getTlag()).asString();
                return val;
            }
        }
        return val;
    }

    protected void writeScriptHeader(PrintWriter fout, String model_file) throws IOException {
        if (fout == null) {
            return;
        }
        String format = "%s Script generated by the UniPV WinBUGS converter\n";
        fout.write(String.format(format, this.comment_char));
        format = "%s 'WinBUGSConverter' copyright (c) BMS - University of Pavia (2016)\n";
        fout.write(String.format(format, this.comment_char));
        format = "%s Converter Version: %s\n";
        fout.write(String.format(format, this.comment_char, this.lexer.getConverterVersion()));
        format = "%s Source: %s\n";
        fout.write(String.format(format, this.comment_char, this.lexer.getSource()));
        format = "%s Target: %s\n";
        fout.write(String.format(format, this.comment_char, this.lexer.getTarget()));
        format = "%s Run ID: %s\n";
        fout.write(String.format(format, this.comment_char, this.run_id));
        String title = this.lexer.getModelName();
        if (title != null) {
            format = "%s Model: %s\n";
            fout.write(String.format(format, this.comment_char, title));
        }
        format = "%s File: %s\n";
        fout.write(String.format(format, this.comment_char, model_file));
        format = "%s Dated: %s\n\n";
        fout.write(String.format(format, this.comment_char, new Date()));
    }

    private static String getBbCompileScriptDir() {
        return bbCompileScriptDir;
    }

    public static void setOutputDir(String outputDir) {
        Parser.outputDir = outputDir;
    }

    public static void setBbCompileScriptDir(String bbCompileScriptDir) {
        Parser.bbCompileScriptDir = bbCompileScriptDir;
    }

    protected void init() {
        smNumber = 0;
        this.isCommonVariable = false;
        this.isDerivativeDependent = false;
        this.comment_char = "#";
        this.script_file_suffix = "txt";
        this.objective_dataset_file_suffix = "csv";
        this.output_file_suffix = "csv";
        this.solver = odeName;
        this.leftArrayBracket = "[";
        this.rightArrayBracket = "]";
        this.IND_BOTH = this.leftArrayBracket + IND_S + "," + IND_T + this.rightArrayBracket;
        this.IND_BOTH2 = this.leftArrayBracket + IND_S + "," + IND_T2 + this.rightArrayBracket;
        this.IND_TIME = this.leftArrayBracket + IND_T + this.rightArrayBracket;
        this.IND_TIME2 = this.leftArrayBracket + IND_T2 + this.rightArrayBracket;
        this.IND_SUBJ = this.leftArrayBracket + IND_S + this.rightArrayBracket;
        this.NT_INDIV = NT + this.leftArrayBracket + IND_S + this.rightArrayBracket;
        Parser.listIndexes[0] = IND_S;
        Parser.listIndexes[1] = IND_T;
        this.timeLoop = "for (ind_t in 1:N_t) {";
        this.timeIndivLoop = "for (ind_t in 1:" + this.NT_INDIV + forEndString;
        time2Loop = "for (ind_q in 1:N_t) {";
        time2IndivLoop = "for (ind_q in 1:" + this.NT_INDIV + forEndString;
        this.indivLoop = "for (ind_subj in 1:N_subj) {";
        this.initSupportedWinBugsUnaryOperators();
        super.init();
    }

    private static void setWorkingDir(String workingDir) {
        Parser.workingDir = workingDir;
    }

    protected void setModelName() {
        this.modelName = this.lexer.getModelName();
        String c = "" + this.modelName.charAt(0);
        this.modelName = c.toUpperCase() + this.modelName.substring(1);
    }

    public void setNum1(int num1) {
        this.num1 = "" + num1;
    }

    protected static void setWinbugsTemplateDir(String winbugsTemplateDir) {
        Parser.winbugsTemplateDir = winbugsTemplateDir;
    }

    protected void setXmlFileName(File xmlFileName) {
        this.xmlFileName = xmlFileName;
    }

    private File getXmlFileName() {
        return this.xmlFileName;
    }

    protected void setModelNum(int modelNum) {
        this.modelNum = modelNum;
    }

    List<String> toMonitor() throws FileNotFoundException {
        List<String> out = new ArrayList<String>();
        ArrayList<String> outEstim = new ArrayList<String>();
        ArrayList<String> outParameters = new ArrayList<String>();
        ArrayList<ParameterEstimate> list = new ArrayList<ParameterEstimate>();
        Map tmp = this.lexer.getScriptDefinition().getStepsMap();
        for (Part ms : tmp.values()) {
            if (!(ms instanceof EstimationStepImpl)) continue;
            list.addAll(((EstimationStepImpl)ms).getParametersToEstimate());
        }
        for (ParameterEstimate l : list) {
            outEstim.add(l.getSymbRef().getSymbIdRef());
            if (!DEBUG) continue;
            this.outDebug.print("parametersToEstimate to monitor: " + l.getSymbRef().getId());
        }
        List<OperationProperty> prop = this.getOperation("BUGS");
        if (prop != null) {
            for (OperationProperty pr : prop) {
                String[] pars;
                if (!pr.getName().equals("parameters")) continue;
                for (String p : pars = pr.getAssign().getScalar().valueToString().split(",")) {
                    outParameters.add(p.trim());
                }
            }
        }
        out.addAll(outEstim);
        out.addAll(outParameters);
        out.addAll(this.resList);
        out.addAll(this.predList);
        out = Util.getUniqueString(out);
        return out;
    }

    protected File createScriptWinbugs(File src, File name, String outputDir) throws IOException {
        this.outDebug = new PrintStream(new FileOutputStream(new File(winbugsDir + "/log" + "/winbugs-converter.log"), true));
        this.outDebug.println("script name: " + name.getAbsolutePath());
        this.outDebug.println("PharmML model name: " + src.getAbsolutePath());
        String template = this.getTemplate(WinbugsExecutionScriptName);
        this.outDebug.println("output directory: " + outputDir + "\n");
        outputDir = outputDir + "/";
        String modelName = src.getName().substring(0, src.getName().indexOf(".xml"));
        StringBuilder sb = new StringBuilder();
        List<String> toMonitor = Util.getUniqueString(this.toMonitor());
        for (String l : toMonitor) {
            sb.append(String.format("set(%s)\n", l));
        }
        String outputS = String.format(template, modelName, Util.clean(this.nChains), this.thinSamplesComment, Util.clean(this.thinSamples), this.thinUpdaterComment, Util.clean(this.thinUpdater), Util.clean(this.burnIn), sb.toString(), Util.clean(this.nIter), this.winBUgsGUIComment);
        this.output(outputS, name, true);
        this.outDebug.close();
        return name;
    }

    private void setTaskObjectDeafult() {
        this.thinUpdaterComment = this.comment_char;
        this.thinSamplesComment = this.comment_char;
        String msg = " - WARNING: set to default value";
        String msg1 = " --|";
        if (this.nChains == null) {
            this.outDebug.println(msg1 + " nChains = " + "1" + msg);
            this.nChains = "1";
        }
        if (this.odeSolver == null) {
            this.outDebug.println(msg1 + " odesolver = " + "RK45" + msg);
            this.odeSolver = "RK45";
        }
        if (this.burnIn == null) {
            this.outDebug.println(msg1 + " burnin = " + "1000" + msg);
            this.burnIn = "1000";
        }
        if (this.nIter == null) {
            this.outDebug.println(msg1 + " niter = " + "5000" + msg);
            this.nIter = "5000";
        }
        if (this.thinUpdater == null) {
            this.thinUpdaterComment = this.comment_char;
            this.outDebug.println(msg1 + " thinpdater = " + "1" + msg);
            this.thinUpdater = "1";
        } else {
            this.thinUpdaterComment = "";
        }
        if (this.thinSamples == null) {
            this.outDebug.println(msg1 + " thinsamples = " + "1" + msg);
            this.thinSamplesComment = this.comment_char;
            this.thinSamples = "1";
        } else {
            this.thinSamplesComment = "";
        }
        if (this.winbugsGUI == null) {
            this.outDebug.println(msg1 + " winbugsgui = " + "false" + msg);
            this.winBUgsGUIComment = "";
            this.winbugsGUI = "false";
        } else if (this.winbugsGUI.equals("true")) {
            this.winBUgsGUIComment = this.comment_char;
        }
        if (this.dic == null) {
            this.outDebug.println(msg1 + " dic = " + "false" + msg);
            this.dic = "false";
        }
    }

    private void setTaskObjectDeafultNew() {
        this.thinUpdaterComment = this.comment_char;
        this.thinSamplesComment = this.comment_char;
        String msg = " - WARNING: set to default value";
        String msg1 = " --|";
        if (this.nChains == null) {
            this.nChains = TaskParameters.N_CHAINS.defaultVal();
            this.outDebug.println(msg1 + " nChains = " + this.nChains + msg);
        }
        if (this.odeSolver == null) {
            this.odeSolver = TaskParameters.ODE_SOLVER.defaultVal();
            this.outDebug.println(msg1 + " odesolver = " + this.odeSolver + msg);
        }
        if (this.burnIn == null) {
            this.burnIn = TaskParameters.BURN_IN.defaultVal();
            this.outDebug.println(msg1 + " burnin = " + this.burnIn + msg);
        }
        if (this.nIter == null) {
            this.nIter = TaskParameters.N_ITER.defaultVal();
            this.outDebug.println(msg1 + " niter = " + this.nIter + msg);
        }
        if (this.thinUpdater == null) {
            this.thinUpdater = TaskParameters.THIN_UPDATER.defaultVal();
            this.thinUpdaterComment = this.comment_char;
            this.outDebug.println(msg1 + " thinpdater = " + this.thinUpdater + msg);
        } else {
            this.thinUpdaterComment = "";
        }
        if (this.thinSamples == null) {
            this.thinSamples = TaskParameters.THIN_SAMPLES.defaultVal();
            this.outDebug.println(msg1 + " thinsamples = " + this.thinSamples + msg);
            this.thinSamplesComment = this.comment_char;
        } else {
            this.thinSamplesComment = "";
        }
        if (this.winbugsGUI == null) {
            this.winbugsGUI = TaskParameters.WINBUGS_GUI.defaultVal();
            this.outDebug.println(msg1 + " winbugsgui = " + this.winbugsGUI + msg);
            this.winBUgsGUIComment = "";
        } else if (this.winbugsGUI.equals("true")) {
            this.winBUgsGUIComment = this.comment_char;
        }
        if (this.dic == null) {
            this.dic = TaskParameters.DIC.defaultVal();
            this.outDebug.println(msg1 + " dic = " + this.dic + msg);
        }
    }

    private boolean getTaskObject() {
        String msg = " - INFO: assigned";
        String msg1 = " --| ";
        List<OperationProperty> prop = this.getOperation("BUGS");
        if (prop == null) {
            return false;
        }
        this.outDebug.println("---------------\nTaskObject parameters\n---------------");
        block22: for (OperationProperty pr : prop) {
            this.outDebug.print(msg1 + pr.getName() + " = " + pr.getAssign().getScalar() + " ");
            switch (pr.getName()) {
                case "nchains": {
                    this.nChains = pr.getAssign().getScalar().valueToString();
                    this.outDebug.println(msg);
                    continue block22;
                }
                case "odesolver": {
                    this.odeSolver = pr.getAssign().getScalar().valueToString();
                    this.outDebug.println(msg);
                    continue block22;
                }
                case "burnin": {
                    this.burnIn = this.parse(pr, this.lexer.getTreeMaker().newInstance((Object)pr));
                    this.outDebug.println(msg);
                    continue block22;
                }
                case "niter": {
                    this.nIter = this.parse(pr, this.lexer.getTreeMaker().newInstance((Object)pr));
                    this.outDebug.println(msg);
                    continue block22;
                }
                case "thinupdater": {
                    this.thinUpdater = this.parse(pr, this.lexer.getTreeMaker().newInstance((Object)pr));
                    this.outDebug.println(msg);
                    continue block22;
                }
                case "thinsamples": {
                    this.thinSamples = this.parse(pr, this.lexer.getTreeMaker().newInstance((Object)pr));
                    this.outDebug.println(msg);
                    continue block22;
                }
                case "dic": {
                    this.dic = pr.getAssign().getScalar().valueToString();
                    this.outDebug.println(msg);
                    continue block22;
                }
                case "winbugsgui": {
                    this.winbugsGUI = pr.getAssign().getScalar().valueToString();
                    this.outDebug.println(msg);
                    continue block22;
                }
                case "parameters": {
                    this.outDebug.println();
                    continue block22;
                }
            }
            this.outDebug.println(" - WARNING: not recognized");
        }
        this.setTaskObjectDeafult();
        return true;
    }

    private boolean getTaskObjectNew() {
        String msg = " - INFO: assigned";
        String msg1 = " --| ";
        List<OperationProperty> prop = this.getOperation("BUGS");
        if (prop == null) {
            return false;
        }
        this.outDebug.println("---------------\nTaskObject parameters\n---------------");
        for (OperationProperty pr : prop) {
            this.outDebug.print(msg1 + pr.getName() + " = " + pr.getAssign().getScalar() + " ");
            if (pr.getName().equals((Object)TaskParameters.N_CHAINS)) {
                this.nChains = pr.getAssign().getScalar().valueToString();
            }
            this.outDebug.println(msg);
            if (pr.getName().equals((Object)TaskParameters.ODE_SOLVER)) {
                this.odeSolver = pr.getAssign().getScalar().valueToString();
                this.outDebug.println(msg);
                continue;
            }
            if (pr.getName().equals((Object)TaskParameters.BURN_IN)) {
                this.burnIn = this.parse(pr, this.lexer.getTreeMaker().newInstance((Object)pr));
                this.outDebug.println(msg);
                continue;
            }
            if (pr.getName().equals((Object)TaskParameters.N_ITER)) {
                this.nIter = this.parse(pr, this.lexer.getTreeMaker().newInstance((Object)pr));
                this.outDebug.println(msg);
                continue;
            }
            if (pr.getName().equals((Object)TaskParameters.THIN_UPDATER)) {
                this.thinUpdater = this.parse(pr, this.lexer.getTreeMaker().newInstance((Object)pr));
                this.outDebug.println(msg);
                continue;
            }
            if (pr.getName().equals((Object)TaskParameters.THIN_SAMPLES)) {
                this.thinSamples = this.parse(pr, this.lexer.getTreeMaker().newInstance((Object)pr));
                this.outDebug.println(msg);
                continue;
            }
            if (pr.getName().equals((Object)TaskParameters.DIC)) {
                this.dic = pr.getAssign().getScalar().valueToString();
                this.outDebug.println(msg);
                continue;
            }
            if (pr.getName().equals((Object)TaskParameters.WINBUGS_GUI)) {
                this.winbugsGUI = pr.getAssign().getScalar().valueToString();
                this.outDebug.println(msg);
                continue;
            }
            if (pr.getName().equals((Object)TaskParameters.PARAMETERS)) {
                this.outDebug.println();
                continue;
            }
            this.outDebug.println(" - WARNING: not recognized");
        }
        this.setTaskObjectDeafult();
        return true;
    }

    protected void createCompileScriptWinbugs() throws IOException {
        String templateCompilazione = this.getTemplate(WinbugsCompileScriptTemplateName);
        StringBuilder srcList = new StringBuilder();
        StringBuilder pmetricsModulesList = new StringBuilder();
        StringBuilder wbdevModulesList = new StringBuilder();
        StringBuilder wbdevPwCovList = new StringBuilder();
        for (int i = 0; i < this.piecewiseFileList.size(); ++i) {
            wbdevPwCovList.append(" WBDevFunctionPiecewise" + (i + 1));
        }
        for (Map.Entry<Integer, String> el : this.covFilesMap.entrySet()) {
            wbdevPwCovList.append(" WBDevFunctionCovariate" + el.getKey());
        }
        srcList.append(this.concat(" ", this.pmetricsList) + this.concat(" ", this.wbdevList) + this.concat(" ", this.pwList));
        if (this.hasDiffEquations) {
            pmetricsModulesList.append("PmetricsPKModels PmetricsFunctionModel1");
        }
        if (this.hasDiffEquations) {
            wbdevModulesList.append("WBDevModelPascal1 ");
        }
        wbdevModulesList.append((CharSequence)wbdevPwCovList);
        this.output(String.format(templateCompilazione, srcList.toString(), pmetricsModulesList.toString(), wbdevModulesList.toString()), new File(Parser.getWinbugsDir() + "/" + WinbugsCompileScriptName), false);
        PrintWriter outDelete = new PrintWriter(new File(Parser.getWinbugsDir() + "/" + "toDel.txt"));
        if (this.hasDiffEquations) {
            for (String s : pmetricsModulesList.toString().split(" ")) {
                if (s.trim().length() < 1) continue;
                outDelete.println("Pmetrics " + s.substring("Pmetrics".length()));
            }
        }
        for (String s : wbdevModulesList.toString().split(" ")) {
            if (s.trim().length() < 1) continue;
            outDelete.println("WBDev " + s.substring("WBDev".length()));
        }
        outDelete.close();
    }

    protected void output(String body, File f, boolean toSO) throws FileNotFoundException {
        this.outDebug.println("--> file " + f.getAbsolutePath() + " created");
        if (f.exists()) {
            f.delete();
        }
        PrintStream out = new PrintStream(f);
        out.println(body);
        out.close();
        if (toSO) {
            File fout = new File(jobDir + "/" + Util.getFileName(f) + ".txt");
            out = new PrintStream(fout);
            out.println(body);
            out.close();
            this.outDebug.println("--> file " + fout.getAbsolutePath() + " created");
        }
    }

    public void cleanUp() throws IOException {
        super.cleanUp();
        this.outDebug.println("=========================================");
        this.outDebug.println(new Date(System.currentTimeMillis()) + " conversion END ");
        this.outDebug.println("=========================================");
        this.outDebug.close();
    }

    protected String getTemplate(String fName) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(new File(winbugsTemplateDir + "/" + fName)));
        return this.getStringFile(in);
    }

    protected String getStringFile(BufferedReader in) throws FileNotFoundException, IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = in.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    protected boolean isPopulationModel() {
        List variability = this.lexer.getScriptDefinition().getVariabilityBlocks();
        for (VariabilityBlock v : variability) {
            for (String s : v.getSymbolIds()) {
                if (!s.equals("indiv")) continue;
                return true;
            }
        }
        return false;
    }

    private String adjustStatement(String line) {
        String left;
        String symbol = " ";
        if (line.contains(assignSymbol)) {
            symbol = " <- ";
        } else if (line.contains(dist_symb)) {
            symbol = " ~ ";
        }
        String oldLeft = left = this.getLeft(line, symbol.trim());
        String right = this.getRight(line, symbol.trim());
        if (!left.contains("(")) {
            if (!(oldLeft.equals(left = this.adjustIndexes(left, right)) || this.variablesAssignementMap.get(oldLeft) != null && this.variablesAssignementMap.get(oldLeft).equals(left))) {
                this.tmpVariablesAssignementMap.put(oldLeft, left);
            }
            if (left.contains(IND_T2)) {
                right = right.replace(IND_T, IND_T2);
            }
            return left + symbol + right;
        }
        line = this.adjustTransformedIndexes(line, symbol);
        return line;
    }

    private String getLeft(String line) {
        if (line.contains(assignSymbol)) {
            return this.getLeft(line, assignSymbol);
        }
        if (line.contains(dist_symb)) {
            return this.getLeft(line, dist_symb);
        }
        return line;
    }

    private String getLeft(String line, String symbol) {
        int pos = 0;
        if (line.contains(symbol)) {
            pos = line.indexOf(symbol);
        }
        String left = line.substring(0, pos);
        return left.trim();
    }

    private String getRight(String line, String symbol) {
        int pos = 0;
        if (line.contains(symbol)) {
            pos = line.indexOf(symbol);
        }
        String right = line.substring(pos + symbol.length());
        return right.trim();
    }

    String adjustIndexes(String left, String right) {
        String adjusted = left;
        if (left.contains(this.leftArrayBracket) && !right.contains(this.leftArrayBracket)) {
            return left;
        }
        if (left.contains(this.IND_BOTH) || left.contains(this.IND_BOTH2) || left.contains(IND_S) && left.contains(IND_T) || left.contains(IND_S) && left.contains(IND_T2)) {
            return left;
        }
        if (right == null) {
            return left;
        }
        if (!left.contains(this.leftArrayBracket) && right.contains(this.leftArrayBracket)) {
            if (right.contains(this.IND_BOTH) || right.contains(IND_S) && right.contains(IND_T)) {
                adjusted = this.removeIndexes(left) + this.IND_BOTH;
            } else if (right.contains(this.IND_BOTH2) || right.contains(IND_S) && right.contains(IND_T2)) {
                adjusted = this.removeIndexes(left) + this.IND_BOTH2;
            } else if (right.contains(this.IND_SUBJ)) {
                adjusted = this.removeIndexes(left) + this.IND_SUBJ;
            }
        } else if (right.contains(this.IND_BOTH) || right.contains(IND_S) && right.contains(IND_T)) {
            adjusted = this.delimit(Util.clean(this.removeIndexes(left)) + this.IND_BOTH);
        } else if (right.contains(this.IND_BOTH2) || right.contains(IND_S) && right.contains(IND_T2)) {
            adjusted = this.removeIndexes(left) + this.IND_BOTH2;
        }
        return adjusted;
    }

    String adjustTransformedIndexes(String line, String symbol) {
        String left = this.getLeft(line, symbol.trim());
        String right = this.getRight(line, symbol.trim());
        String pre = left.substring(0, left.indexOf("(") + 1);
        String post = left.substring(left.indexOf(")"));
        String oldLeft = left = left.substring(left.indexOf("(") + 1, left.indexOf(")"));
        if (!oldLeft.equals(left = this.adjustIndexes(left, right))) {
            this.tmpVariablesAssignementMap.put(oldLeft, left);
        }
        return pre + left + post + symbol + right;
    }

    private String changeIndexes(String in, String index) {
        String toReplace = "";
        if (in.contains(this.IND_SUBJ)) {
            toReplace = this.IND_SUBJ;
        } else if (in.contains(this.IND_TIME)) {
            toReplace = this.IND_TIME;
        }
        return in.replace(toReplace, index);
    }

    protected boolean isObservationParameter(Object p) {
        if (p != null) {
            for (ObservationBlock ob : this.getLexer().getObservationBlocks()) {
                if (ob == null || !this.isPopulationParameter(p) || !ob.isObservationParameter((PopulationParameter)p)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean toBeInPascal(Object context, String id) {
        return this.isInList(context, this.leafOdeParameters) && !this.isInList(context, this.theta_Parameters) && !this.isPiecewiseVar(id) || this.isInList(context, this.odeParameters);
    }

    protected boolean toBeInFuncPW(Object context, String id) {
        return this.isInList(context, this.piecewiseLeafParameters) && !this.isPiecewiseVar(id);
    }

    private void generatePascalEquation(Object context, Node leaf) {
        if (this instanceof PascalParser) {
            ((PascalParser)this).pascalEquation(context, leaf);
            ((PascalParser)this).pascalPiecewiseEquation(context, leaf);
        }
    }

    protected void rootLeafHandler(Object context, Node leaf, PrintWriter fout) {
        String oldSymbol = "";
        if (leaf == null) {
            throw new NullPointerException("Tree leaf is NULL.");
        }
        if (leaf.data != null) {
            boolean inPiecewise = false;
            if (PharmMLTypeChecker.isPiecewise((Object)leaf.data)) {
                inPiecewise = true;
            }
            if (!Parser.isString_((Object)leaf.data)) {
                leaf.data = this.delimit(this.getSymbol(leaf.data));
            }
            String current_value = "";
            String current_symbol = "_FAKE_FAKE_FAKE_FAKE_";
            String comment = "";
            if (this.isPopulationParameter(context)) {
                oldSymbol = ((PopulationParameter)context).getSymbId();
            } else if (PharmMLTypeChecker.isLocalVariable((Object)context)) {
                oldSymbol = ((VariableDefinition)context).getSymbId();
            }
            if (this.isPopulationParameter(context) || PharmMLTypeChecker.isLocalVariable((Object)context)) {
                if (this.isPopulationParameter(context)) {
                    comment = this.comment_char + " PopPar";
                    PopulationParameter pp = (PopulationParameter)context;
                    if (pp.getAssign() != null && pp.getAssign().getMatrixUniop() != null) {
                        String format = "%s <- %s";
                        current_symbol = this.delimit(pp.getSymbId());
                    } else {
                        String format = "%s <- %s";
                        current_symbol = this.getSymbol(context);
                        if (!oldSymbol.equals(current_symbol = this.adjustIndexes(current_symbol, leaf.data.toString()))) {
                            this.putVariableMap(this.delimit(oldSymbol), this.delimit(current_symbol));
                        }
                        this.generatePascalEquation(context, leaf);
                        if (Util.clean((String)leaf.data).trim().length() > 0) {
                            current_value = String.format(format, this.delimit(current_symbol), leaf.data, comment);
                        }
                    }
                    this.parameterDefinitionMap.put(context, current_symbol);
                    this.populationParametersLines.add(current_value);
                } else if (PharmMLTypeChecker.isLocalVariable((Object)context)) {
                    VariableDefinition var = (VariableDefinition)context;
                    if (this instanceof PascalParser) {
                        String tmp = leaf.data.toString();
                        if (var.getAssign() != null && var.getAssign().getPiecewise() == null) {
                            this.derivativeDefFromMap.put(((VariableDefinition)context).getSymbId(), tmp);
                        }
                        this.generatePascalEquation(context, leaf);
                    }
                    if (this.odeParameters.size() == 0) {
                        if (!inPiecewise) {
                            current_symbol = this.getSymbol(context);
                            String format = "%s <- %s";
                            current_value = String.format(format, current_symbol, leaf.data, comment);
                            this.variableLines.add(current_value);
                        }
                        this.generatePascalEquation(context, leaf);
                    }
                } else if (context instanceof StructuredModel) {
                    StructuredModel gm = (StructuredModel)context;
                    StructuredModel.GeneralCovariate gc = gm.getGeneralCovariate();
                    StructuredModel.LinearCovariate lc = gm.getLinearCovariate();
                    if (gc != null) {
                        String format = "%s <- %s + %s";
                        current_value = String.format(format, gm.getId(), gm.getGeneralCovariate(), gm.getListOfRandomEffects());
                    } else if (lc != null) {
                        String format = "%s <- %s + %s + %s";
                        current_value = String.format(format, gm.getId(), gm.getGeneralCovariate(), lc.getListOfCovariate(), gm.getListOfRandomEffects());
                    }
                } else {
                    this.generatePascalEquation(context, leaf);
                    if (!this.variableLines.contains(current_value)) {
                        this.variableLines.add(current_value);
                    }
                }
                current_value = null;
            } else if (this.isPopulationParameter(context) && this.isObservationParameter((PopulationParameter)context)) {
                ObservationParameter op = (ObservationParameter)context;
                String format = "%s <- %s";
                oldSymbol = this.extract(op.getName());
                oldSymbol = this.delimit(oldSymbol);
                current_symbol = this.adjustIndexes(this.extract(op.getName()), leaf.data.toString());
                if (!this.delimit(oldSymbol).equals(current_symbol)) {
                    this.putVariableMap(this.delimit(oldSymbol), this.delimit(current_symbol));
                }
                this.parameterDefinitionMap.put(context, current_symbol);
                if (Parser.isInList(this.assignedSimpleParList, this.extract(op.getName()))) {
                    current_value = String.format(format, current_symbol, leaf.data, comment);
                }
                this.variableLines.add(current_value);
                if (this instanceof PascalParser) {
                    if (this.isInOdeParameters1((ObservationParameter)context)) {
                        this.variableLines.add(current_value);
                    }
                    this.derivativeDefFromMap.put(((ObservationParameter)context).getName(), leaf.data.toString());
                } else {
                    this.variableLines.add(current_value);
                }
                this.generatePascalEquation(context, leaf);
                current_value = null;
            } else if (PharmMLTypeChecker.isDerivative((Object)context)) {
                if (this instanceof PascalParser) {
                    ((PascalParser)this).pascalEquation(context, leaf);
                } else {
                    this.diffEqLines.add(this.winbugsOnLineDiffEquation(context, leaf));
                }
                current_value = null;
            } else if (PharmMLTypeChecker.isIndividualParameter((Object)context)) {
                String format = "%s <- %s";
                current_symbol = this.delimit(this.getSymbol(context));
                current_symbol = this.adjustIndexes(current_symbol, leaf.data.toString());
                oldSymbol = ((CommonParameter)context).getSymbId();
                if (!this.delimit(oldSymbol).equals(current_symbol)) {
                    this.putVariableMap(this.delimit(oldSymbol), this.delimit(current_symbol));
                }
                current_value = String.format(format, current_symbol, leaf.data);
                if (this instanceof PascalParser) {
                    if (this.isInList(context, this.odeParameters1)) {
                        this.variableLines.add(current_value);
                    }
                    this.derivativeDefFromMap.put(((IndividualParameter)context).getSymbId(), leaf.data.toString());
                } else {
                    this.variableLines.add(current_value);
                }
                this.indivParamsLines.add(current_value);
                this.generatePascalEquation(context, leaf);
                current_value = null;
            } else if (PharmMLTypeChecker.isInitialCondition((Object)context) || PharmMLTypeChecker.isFunction((Object)context) || PharmMLTypeChecker.isSequence((Object)context) || PharmMLTypeChecker.isVector((Object)context)) {
                String format = "(%s) ";
                current_value = String.format(format, (String)leaf.data);
                if (PharmMLTypeChecker.isFunction((Object)context)) {
                    this.functionDefinition.put(context, current_value);
                }
            } else if (PharmMLTypeChecker.isPiece((Object)context)) {
                String format = "%s ";
                current_value = String.format(format, (String)leaf.data);
            } else if (PharmMLTypeChecker.isParameter((Object)context)) {
                String format = "%s ";
                current_value = String.format(format, (String)leaf.data);
            } else if (this.isContinuous(context)) {
                current_symbol = this.delimit(this.getSymbol(context));
                String format = "%s <- %s;";
                current_value = String.format(format, current_symbol, leaf.data);
            } else if (PharmMLTypeChecker.isRandomVariable((Object)context)) {
                LevelReference level_ref = ((ParameterRandomVariable)context).getVariabilityReference();
                VariabilityBlock vb = this.lexer.getVariabilityBlock(level_ref.getSymbRef());
                if (vb.isParameterVariability()) {
                    if (((ParameterRandomVariable)context).getDistribution().getUncertML() != null) {
                        if (this.priorPar.get(context) == null) {
                            this.randVarLines.addAll(this.writeRandomVarDistribution((ParameterRandomVariable)context));
                        }
                    } else if (((ParameterRandomVariable)context).getDistribution().getProbOnto() != null && this.priorPar.get(context) == null) {
                        this.randVarLines.addAll(this.writeRandomVarProbOntoDistribution((ParameterRandomVariable)context));
                    }
                }
                this.generatePascalEquation(context, leaf);
                current_value = null;
            } else if (PharmMLTypeChecker.isCovariateTransform((Object)context)) {
                current_value = (String)leaf.data;
                this.covariateTransformationMap.put(context, current_value);
                ((PascalParser)this).pascalEquation(context, leaf);
            } else if (this.isCovariate(context)) {
                current_value = (String)leaf.data;
                this.covariateMap.put(context, current_value);
            } else if (PharmMLTypeChecker.isCorrelation((Object)context)) {
                current_value = (String)leaf.data;
            } else if (this.isCategoricalCovariate(context)) {
                current_value = (String)leaf.data;
            } else if (PharmMLTypeChecker.isObservationModel((Object)context)) {
                current_value = ((String)leaf.data).trim();
            } else if (PharmMLTypeChecker.isParameterEstimate((Object)context) || this.isFixedParameter(context) || this.isObjectiveFunctionParameter(context)) {
                current_value = (String)leaf.data;
            } else if (PharmMLTypeChecker.isIndependentVariable((Object)context)) {
                String format = "%s";
                current_value = String.format(format, ((IndependentVariable)context).getSymbId());
            } else if (PharmMLTypeChecker.isStructuredError((Object)context)) {
                try {
                    List<String> tmp = this.writeObsStandardModelDistribution((StructuredObsError)context);
                    this.standardModelLines.addAll(tmp);
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                    Logger.getLogger(Parser.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                String format = "%s";
                current_value = String.format(format, (String)leaf.data);
            }
            if (current_value != null) {
                if (inPiecewise && current_symbol != null) {
                    current_value = current_value.replaceAll(this.field_tag, current_symbol) + "\n";
                }
                if (!current_value.trim().equals("")) {
                    fout.write(current_value);
                }
            }
        } else {
            throw new IllegalStateException("Should be a statement string bound to the root.data element.");
        }
    }

    String delimit(String in) {
        if (!in.startsWith(Util.delimiter) && !in.endsWith(Util.delimiter)) {
            return Util.delimiter + in + Util.delimiter;
        }
        return in;
    }

    String cleanPascal(String in) {
        for (Map.Entry<String, String> s : this.derivativeMap.entrySet()) {
            String key = s.getKey().toString();
            String value = this.removeIndexes(s.getValue().toString());
            if (!in.contains(value)) continue;
            in = in.replace(this.delimit(value), this.delimit(this.varLabel + this.getStateVarIndex(key)));
        }
        return in.replaceAll(Util.delimiter, "");
    }

    protected String winbugsOnLineDiffEquation(Object context, Node leaf) {
        String format = "%s <- %s # %s";
        String current_symbol = this.getSymbol(context);
        String comment = this.getDerivativeSymbol((DerivativeVariable)context);
        this.derivativeSymbols.add(this.getDerivativeSymbol((DerivativeVariable)context));
        String line = String.format(format, current_symbol, leaf.data, comment);
        return line;
    }

    protected String doIndividualParameterAssignment(IndividualParameterAssignment ipa) {
        IndividualParameter ip = ipa.parameter;
        StringBuilder stmt = new StringBuilder();
        String variableSymbol = this.z.get((Object)ip);
        if (ip.getAssign() != null) {
            stmt.append(String.format("%s <- " + variableSymbol, new Object[0]));
            String assignment = this.parse(ip, this.lexer.getStatement((Object)ip.getAssign()));
            stmt.append(assignment);
        }
        return stmt.toString();
    }

    protected String doIndividualParameter(IndividualParameter value) {
        return this.z.get((Object)value.getSymbId());
    }

    protected String doDerivative(DerivativeVariable o) {
        String symbol = unassigned_symbol;
        String format = "";
        Integer idx = this.getStateVarIndex(o.getSymbId());
        if (this.n_loops == 1) {
            format = "D(" + upperStateLabel + this.leftArrayBracket + "%s" + this.rightArrayBracket + ", " + this.getIndependentVariableOriginalSymbol() + ")";
        } else if (this.n_loops == 2) {
            format = "D(" + upperStateLabel + this.leftArrayBracket + IND_S + ",%s" + this.rightArrayBracket + "," + this.getIndependentVariableOriginalSymbol() + ")";
        }
        symbol = String.format(format, idx);
        return symbol;
    }

    protected String doDerivative(SymbolRef s) {
        String symbol = upperStateLabel;
        Integer idx = this.getStateVarIndex(s.getSymbIdRef());
        String format = "%s" + this.leftArrayBracket + "%s" + this.rightArrayBracket;
        symbol = String.format(format, symbol, idx);
        return symbol;
    }

    protected int getStateVarIndex(String id) {
        int i = 1;
        for (DerivativeVariable var : this.completeStateVariablesList) {
            if (var.getSymbId().equals(id)) break;
            ++i;
        }
        return i;
    }

    protected String getDerivativeSymbol(DerivativeVariable o) {
        return o.getSymbId();
    }

    protected String doParameter(PopulationParameter p) {
        return p.getSymbId();
    }

    protected String doVectorSelector(VectorSelector p) {
        String ind = ((MatrixVectorIndex)p.getCellOrSegment().get(0)).getAssign().toMathExpression();
        return p.getSymbRef().getSymbIdRef() + "[" + ind + "]";
    }

    protected String doFalse() {
        return "FALSE";
    }

    protected String doTrue() {
        return "TRUE";
    }

    protected String getIndependentVariableOriginalSymbol() {
        return ((IndependentVariable)this.lexer.getDom().getListOfIndependentVariable().get(0)).getSymbId();
    }

    protected IndependentVariable getIndependentVariable() {
        return (IndependentVariable)this.lexer.getDom().getListOfIndependentVariable().get(0);
    }

    protected void openLoops(PrintWriter fout) {
        switch (this.n_loops) {
            case 2: {
                fout.write(this.getTab(this.nOpenB++) + this.indivLoop + "\n");
                fout.write(this.getTab(this.nOpenB++) + this.timeIndivLoop + "\n");
                break;
            }
            case 1: {
                fout.write(this.getTab(this.nOpenB++) + this.timeLoop + "\n");
            }
        }
    }

    private void printLines(PrintWriter fout, List<String> lines, char loop) {
        for (String l : lines) {
            if (l.trim().length() <= 0 || this.getIndexes(l) != loop) continue;
            fout.write(this.getTab(this.nOpenB));
            if (l.contains("{")) {
                ++this.nOpenB;
            }
            fout.write(Util.clean(l).trim() + "\n");
            if (!l.contains(time2IndivLoop) && !l.contains(time2Loop)) continue;
            this.openAssign = true;
        }
    }

    private void closeLoop(PrintWriter fout) {
        if (this.nOpenB > 1) {
            fout.write(this.getTab(--this.nOpenB));
            fout.write("}");
            fout.write("\n");
        }
    }

    List<String> adjustTmpLines() {
        List<String> lines = new ArrayList<String>();
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.variableLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.standardModelLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.obsModelLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.indivParamsLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.randVarLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.commonVarLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.winbugsIndivLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.correlationLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.initialEstimatesLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.winbugsPiecewiseLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.derivativeModelLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.initialValuesLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.stateVarAssignementLines)));
        if (!(this instanceof PascalParser)) {
            lines = Util.getUniqueString(Util.append(lines, this.parseScriptLines(this.adjustDerivativeModelLines())));
        }
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.populationParametersLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.populationParametersMatrixLines)));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.winbugsCovariateLines)));
        for (String l : lines) {
            for (Map.Entry<String, String> pair : this.variablesAssignementMap.entrySet()) {
                if (!l.contains(pair.getKey())) continue;
                String tmp = pair.getValue().toString().trim();
                String oldtmp = tmp;
                if (this.variablesAssignementMap.get(oldtmp) != null) {
                    while (tmp != null) {
                        oldtmp = tmp;
                        tmp = this.variablesAssignementMap.get(oldtmp);
                    }
                }
                l = l.replace(pair.getKey().toString(), oldtmp);
            }
        }
        return lines;
    }

    protected void closeLoops(PrintWriter fout, int nSb) {
        List<String> lines = new ArrayList<String>();
        ArrayList<String> tmpLines = new ArrayList();
        this.generateCovariateLines();
        tmpLines = this.adjustTmpLines();
        lines = Util.append(lines, Util.getUniqueString(Util.clean(this.parseScriptLines(tmpLines))));
        lines.add("# PRIORS");
        lines = Util.append(lines, Util.clean(this.genPrior()));
        lines = Util.append(lines, Util.getUniqueString(this.parseScriptLines(this.matrixVectorLines)));
        if (nSb == this.lexer.getStructuralBlocks().size()) {
            lines = Util.getUniqueString(Util.getUniqueString(lines));
        }
        ArrayList<String> uniqueLines = new ArrayList<String>();
        for (String l : lines) {
            if (uniqueLines.contains(l.trim())) continue;
            uniqueLines.add(l);
        }
        switch (this.n_loops) {
            case 2: {
                this.printLines(fout, uniqueLines, 'b');
                this.closeLoop(fout);
                this.printLines(fout, uniqueLines, 's');
                this.closeLoop(fout);
                break;
            }
            case 1: {
                this.printLines(fout, uniqueLines, 't');
                this.closeLoop(fout);
            }
        }
        this.closeLoop(fout);
        this.printLines(fout, uniqueLines, ' ');
        this.printLines(fout, uniqueLines, 'q');
    }

    protected StructuralModel manageSimulationSteps(SimulationStep step, PrintWriter fout, StructuralBlock sb) {
        Object format = null;
        StructuralModel smt = sb.getModel();
        return smt;
    }

    protected void manageCommonVariables(StructuralModel smt) throws FileNotFoundException, IOException {
        List tmp = smt.getListOfStructuralModelElements();
        for (PharmMLElement el : smt.getListOfStructuralModelElements()) {
            if (!(el instanceof CommonVariableDefinition)) continue;
            CommonVariableDefinition value = (CommonVariableDefinition)el;
            if (value == null) {
                throw new NullPointerException("Structural model component is NULL");
            }
            if (PharmMLTypeChecker.isDerivative((Object)value) || PharmMLTypeChecker.isGeneralError((Object)value) || PharmMLTypeChecker.isRandomVariable((Object)value)) {
                if (!this.lexer.hasStatement((Object)value)) continue;
                BinaryTree bt = this.lexer.getStatement((Object)value);
                String derivExp = this.parse(value, bt);
                this.commonVarLines.add(derivExp);
                continue;
            }
            if (!PharmMLTypeChecker.isLocalVariable((Object)value) && !this.isPopulationParameter(value.getSymbId()) || !this.lexer.hasStatement((Object)value)) continue;
            this.isCommonVariable = true;
            if (this.isDerivativeDependentVariable(value.getSymbId())) {
                this.isDerivativeDependent = true;
            }
            this.commonVarLines.add(this.parse(value, this.lexer.getTreeMaker().newInstance((Object)value)));
            this.isCommonVariable = false;
            this.isDerivativeDependent = false;
            this.commonVarLines = Util.clean(this.commonVarLines);
        }
    }

    protected void manageParameters(StructuralModel smt) throws FileNotFoundException, IOException {
        for (String name : this.parametersList) {
            if (Util.getList(this.leafOdeParameters).contains(name)) continue;
            PharmMLRootType o = this.lexer.getAccessor().fetchElement(name);
            if (this.isPiecewiseVar(name)) continue;
            this.parameterLines.add(this.parse(o, this.lexer.getTreeMaker().newInstance((Object)o)));
        }
        this.parameterLines = Util.clean(this.commonVarLines);
    }

    protected void manageCovariates() throws FileNotFoundException, IOException {
        String symb = "@";
        int index = 1;
        for (CovariateDefinition cd : this.lexer.getCovariates()) {
            if (cd.getCategorical() != null) {
                CategoricalCovariate cc = cd.getCategorical();
                this.categoricalCovariateIdMap.put(cd, index++);
                if (cc.getListOfCategory().size() > 1) {
                    this.categoricalMap.put(cd.getSymbId(), this.lexer.getAccessor().fetchCategoryList((PharmMLRootType)cd));
                }
            }
            if (cd.getContinuous() == null || !this.toBeInFuncPW(cd, cd.getSymbId()) || cd.getContinuous().getListOfTransformation() == null || cd.getContinuous().getListOfTransformation().isEmpty()) continue;
            this.getParse(cd.getContinuous().getListOfTransformation().get(0));
        }
    }

    private void generateCovariateLines() {
        for (Map.Entry<Object, String> pair : this.covariateTransformationMap.entrySet()) {
            String id = ((CovariateTransformation)pair.getKey()).getTransformedCovariate().getSymbId();
            if (this.variablesAssignementMap.get(this.delimit(id)) != null) {
                id = this.variablesAssignementMap.get(this.delimit(id));
            }
            this.variableLines.add(String.format("%s %s %s", id, assignSymbol, pair.getValue().toString()));
        }
    }

    protected void manageStateVariables(StructuralBlock sb, int nSb) throws FileNotFoundException, IOException {
        if (nSb == this.lexer.getStructuralBlocks().size()) {
            List<String> sts = this.winbugsOdeInitialValues(sb);
            this.initialValuesLines.addAll(sts);
            sts = this.winbugsPascalOdeCallGen();
            this.derivativeModelLines.addAll(sts);
            this.stateVarAssignementLines.addAll(this.winbugsDerivativeVariableAssignement(sb));
        }
    }

    protected List<String> winbugsPascalOdeCallGen() throws FileNotFoundException, IOException {
        ArrayList<String> lines = new ArrayList<String>();
        int derivativeNumber = this.completeStateVariablesList.size();
        String NT_loop = NT;
        if (this.n_loops == 2) {
            NT_loop = this.NT_INDIV;
        }
        String odeFormat = "%s[%s, 1:%s, 1:%s]<- ode(%s[1:%s], %s[%s, 1:%s], D(%s[%s, 1:%s],%s), %s, %s)";
        this.odeLine = String.format(odeFormat, stateLabel, IND_S, NT_loop, derivativeNumber + "", initLabel, derivativeNumber + "", gridLabel, IND_S, NT_loop, upperStateLabel, IND_S, derivativeNumber + "", this.getIndependentVariableOriginalSymbol(), originLabel, tolVal);
        lines.add(this.odeLine);
        return lines;
    }

    protected String getStateInitialCondition(DerivativeVariable v) {
        String initialCondition = "";
        InitialCondition ic = v.getInitialCondition();
        StandardAssignable initV = ic.getInitialValue();
        if (initV != null && initV.getAssign() != null) {
            if (initV.getAssign().getScalar() != null) {
                initialCondition = "" + initV.getAssign().getScalar().valueToString();
            } else if (initV.getAssign().getSymbRef() != null) {
                initialCondition = "" + this.doSymbolRef(initV.getAssign().getSymbRef());
            } else if (initV.getAssign() != null) {
                BinaryTree bt = this.lexer.getTreeMaker().newInstance((Object)ic);
                initialCondition = this.parse(initV, bt);
            }
        }
        return initialCondition;
    }

    protected String getStateInitialTime(DerivativeVariable v) {
        String initialTime = "";
        InitialCondition ic = v.getInitialCondition();
        StandardAssignable initT = ic.getInitialTime();
        if (initT.getAssign() != null) {
            if (initT.getAssign().getScalar() != null) {
                initialTime = "" + initT.getAssign().getScalar().valueToString();
            } else if (initT.getAssign().getSymbRef() != null) {
                initialTime = "" + initT.getAssign().getSymbRef().getSymbIdRef();
            } else if (initT.getAssign() != null && initT.getAssign().getSymbRef() != null) {
                initialTime = initT.getAssign().getSymbRef().asString();
            }
        }
        return initialTime;
    }

    protected List<String> winbugsDerivativeVariableAssignement(StructuralBlock _sb) {
        ArrayList<String> lines = new ArrayList<String>();
        String format = "%s[%s] <- %s[%s,%s] + %s\n";
        String formatIndiv = "%s[%s,%s] <- %s[%s,%s,%s] + %s\n";
        if (this.n_loops == 1) {
            lines.add(time2Loop + "\n");
        } else {
            lines.add(time2IndivLoop + "\n");
        }
        int i = 1;
        for (DerivativeVariable dv : _sb.getStateVariables()) {
            String s = dv.getSymbId();
            if (this.n_loops == 1) {
                lines.add(String.format(format, s, IND_T2, stateLabel, IND_T2, i, this.getStateInitialCondition(dv)));
            } else {
                lines.add(String.format(formatIndiv, s, IND_S, IND_T2, stateLabel, IND_S, IND_T2, i, this.getStateInitialCondition(dv)));
            }
            ++i;
        }
        lines.addAll(this.winbugsPiecewiseDerivDepLines);
        lines.addAll(this.winbugsDerivativeDepVarAssignement());
        return lines;
    }

    List<String> winbugsDerivativeDepVarAssignement() {
        ArrayList<String> lines = new ArrayList<String>();
        String formatVar = "%s[%s] <- %s\n";
        String formatVarIndiv = "%s[%s,%s] <- %s\n";
        List listV = this.lexer.getLocalVariables();
        for (VariableDefinition var : listV) {
            String fromLabel = this.derivativeDefFromMap.get(var.getSymbId());
            if (fromLabel == null) continue;
            String toLabel = fromLabel;
            for (String id : this.derivativeSymbols) {
                String toName;
                String fromName = this.delimit(this.derivativeMap.get(id));
                if (!fromName.equals(toName = this.delimit(id))) {
                    toLabel = toLabel.replace(fromName, toName);
                }
                if (this.n_loops == 1) {
                    toLabel = toLabel.replace(this.delimit(id), this.delimit(id + this.leftArrayBracket + IND_T2 + this.rightArrayBracket));
                    continue;
                }
                toLabel = toLabel.replace(this.delimit(id), this.delimit(id + this.leftArrayBracket + IND_S + "," + IND_T2 + this.rightArrayBracket));
            }
            toLabel = toLabel.replaceAll(IND_T, IND_T2);
            if (this.n_loops == 1) {
                lines.add(String.format(formatVar, var.getSymbId(), IND_T2, toLabel));
                continue;
            }
            lines.add(String.format(formatVarIndiv, var.getSymbId(), IND_S, IND_T2, toLabel));
        }
        return lines;
    }

    protected String getValue(JAXBElement el) throws UnsupportedDataTypeException {
        Object o = el.getValue();
        if (o instanceof RealValue) {
            return "" + ((RealValue)o).getValue();
        }
        if (o instanceof IntValue) {
            return "" + ((IntValue)o).getValue();
        }
        throw new UnsupportedDataTypeException(o.getClass().getSimpleName());
    }

    protected List<String> winbugsOdeInitialValues(StructuralBlock _sb) throws UnsupportedDataTypeException {
        List<String> linesV = new ArrayList<String>();
        List<String> linesT = new ArrayList<String>();
        String formatInit = "%s[%s] <- %s";
        String formatOrigin = "%s <- %s";
        String formatIndivInit = "%s[%s,%s] <- %s";
        String formatIndivOrigin = "%s[%s] <- %s";
        int nInitTime = 0;
        String oldInitTime = "";
        for (int i = 0; i < _sb.getStateVariables().size(); ++i) {
            DerivativeVariable var = (DerivativeVariable)_sb.getStateVariables().get(i);
            this.lexer.setCurrentStructuralBlock(_sb);
            int index = this.getStateVarIndex(var.getSymbId());
            if (this instanceof PascalParser) {
                ++index;
            }
            InitialCondition ic = var.getInitialCondition();
            StandardAssignable initV = ic.getInitialValue();
            StandardAssignable initT = ic.getInitialTime();
            String initialCondition = "0.0";
            String initialTime = this.defaultInitialTime;
            if (initV != null) {
                initialCondition = this.parse(initV, this.lexer.getStatement((Object)ic));
                if (!initialCondition.contains(IND_S)) {
                    linesV.add(String.format(formatInit, initLabel, index, initialCondition));
                } else {
                    this.odeInitialValueSubjDep = true;
                    linesV.add(String.format(formatIndivInit, initLabel, IND_S, index, initialCondition));
                }
            }
            if (initT == null) continue;
            BinaryTree btT = this.lexer.getTreeMaker().newInstance((Object)initT);
            if (btT != null) {
                initialTime = this.parse(ic, btT);
            }
            ++nInitTime;
            if (!initialTime.contains(IND_S)) {
                linesT.add(String.format(formatOrigin, originLabel, initialTime));
            } else {
                this.odeInitialValueSubjDep = true;
                linesT.add(String.format(formatIndivOrigin, originLabel, IND_S, initialTime));
            }
            if (nInitTime > 1 && !oldInitTime.equals(initialTime)) {
                throw new IllegalStateException("Multiple ODE initial times are not allowed.");
            }
            oldInitTime = initialTime;
        }
        if (nInitTime == 0) {
            linesT.add(String.format(formatOrigin, originLabel, this.defaultInitialTime));
        }
        linesV = this.setInitValIndex(Util.getUniqueString(linesV));
        linesT = this.setInitValIndex(Util.getUniqueString(linesT));
        linesV.addAll(linesT);
        return linesV;
    }

    private List<String> setInitValIndex(List<String> ls) {
        boolean indiv = false;
        for (String l : ls) {
            if (!l.contains(IND_S)) continue;
            indiv = true;
            this.odeInitialValueSubjDep = true;
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (indiv) {
            for (String l : ls) {
                if (!l.contains(IND_S)) {
                    int pos = l.indexOf(this.leftArrayBracket);
                    lines.add(l.substring(0, pos + 1) + IND_S + "," + l.substring(pos + 1));
                    continue;
                }
                lines.add(l);
                this.odeInitialValueSubjDep = true;
            }
        } else {
            lines.addAll(ls);
        }
        return lines;
    }

    protected List<PopulationParameter> getModelParameters() {
        ArrayList<PopulationParameter> sps = new ArrayList<PopulationParameter>();
        for (ParameterBlock pb : this.lexer.getScriptDefinition().getParameterBlocks()) {
            List tmp = pb.getParameters();
            sps.addAll(pb.getParameters());
        }
        for (StructuralBlock sb : this.lexer.getScriptDefinition().getStructuralBlocks()) {
            sps.addAll(sb.getParameters());
            sb.buildTrees();
        }
        for (CovariateBlock ct : this.lexer.getScriptDefinition().getCovariateBlocks()) {
            sps.addAll(ct.getParameters());
        }
        return sps;
    }

    private String extract(String format) {
        return format.substring(format.indexOf("_") + 1);
    }

    protected void manageRandomVariables(ParameterBlock pb) throws UnsupportedDataTypeException {
        List rvs = pb.getRandomVariables();
        for (ParameterRandomVariable value : rvs) {
            if (PharmMLTypeChecker.isRandomVariable((Object)value)) {
                if (!this.lexer.hasStatement((Object)value)) continue;
                String tmp = this.parse(value, this.lexer.getTreeMaker().newInstance((Object)value));
                if (tmp.trim().length() > 0) {
                    this.randVarLines.add(tmp);
                }
            }
            this.reUpdateMatrixVectorMapsWithAllMaps();
            this.updatePriorList((PharmMLRootType)value);
        }
    }

    protected void manageRandomVariables(ObservationBlock ob) throws UnsupportedDataTypeException {
        List rvs = ob.getRandomVariables();
        for (ParameterRandomVariable value : rvs) {
            if (PharmMLTypeChecker.isRandomVariable((Object)value)) {
                if (!this.lexer.hasStatement((Object)value)) continue;
                this.randVarLines.add(this.parse(value, this.lexer.getStatement((Object)value)));
            }
            this.updatePriorList((PharmMLRootType)value);
        }
    }

    protected void manageObservationBlocks(PrintWriter fout) throws UnsupportedDataTypeException {
        List ot = this.lexer.getObservationBlocks();
        for (ObservationBlock ob : ot) {
            this.manageRandomVariables(ob);
            ObservationError value = ob.getObservationError();
            if (value != null && ob.getModel().getContinuousData() != null) {
                value = ob.getModel().getContinuousData().getObservationError();
            }
            if (PharmMLTypeChecker.isGeneralError((Object)ob)) {
                Object o = this.parseObservationErrorModel(((GeneralObsError)value).getAssign(), null);
                this.outDebug.println("\nfrom Recursive: = " + o.getClass());
                this.outDebug.println("o = " + ((SymbolRef)((JAXBElement)o).getValue()).getSymbIdRef());
                if (!this.lexer.hasStatement((Object)value)) continue;
                this.updatePriorList((PharmMLRootType)((GeneralObsError)value));
                this.obsModelLines.add(this.parse(value, this.lexer.getStatement((Object)value)));
                continue;
            }
            if (PharmMLTypeChecker.isStructuredError((Object)value)) {
                StructuredObsError tmp = (StructuredObsError)value;
                if (tmp.getTransformation() != null) {
                    BinaryTree bt = this.lexer.getTreeMaker().newInstance((Object)tmp);
                    this.errorTransformation = this.parse(tmp, bt);
                }
                this.updatePriorList((PharmMLRootType)value);
                this.rootLeafHandler(value, new Node((Object)""), fout);
                continue;
            }
            if (!PharmMLTypeChecker.isDistribution((Object)value)) continue;
            throw new UnsupportedOperationException("Distrinution Observation Model not supported");
        }
    }

    protected void scriptPrepare(PrintWriter fout, StructuralBlock sb) throws IOException {
        PrintWriter out = new PrintWriter(new File(Parser.getWinbugsDir() + "/" + "toConv.txt"));
        out.close();
        out = new PrintWriter(new File(Parser.getWinbugsDir() + "/" + "toDel.txt"));
        out.close();
        StructuralModel smt = sb.getModel();
        ++smNumber;
        if (fout == null) {
            throw new NullPointerException();
        }
        this.createUsefulStructures();
        this.writeScriptHeader(fout, this.lexer.getModelFilename());
        fout.write("model {\n");
        ++this.nOpenB;
        this.n_loops = 2;
        this.openLoops(fout);
        if (DEBUG) {
            this.outDebug.println(" manageCovariates \n------------------------\n");
        }
        this.manageCovariates();
        if (smNumber == 1) {
            if (DEBUG) {
                this.outDebug.println(" managePopulationParameters \n------------------------\n");
            }
            try {
                this.managePopulationParameters();
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(Parser.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(Parser.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (DEBUG) {
            this.outDebug.println(" manageCommonVariables \n------------------------\n");
        }
        this.manageCommonVariables(smt);
        this.manageParameters(smt);
        if (smNumber == 1) {
            if (DEBUG) {
                this.outDebug.println(" manageObservationBlocks \n------------------------\n");
            }
            this.manageObservationBlocks(fout);
            List<ParameterBlock> pbs = this.getParameterBlocks();
            for (ParameterBlock pb : pbs) {
                if (DEBUG) {
                    this.outDebug.println(" manageRandomVariables \n------------------------\n");
                }
                this.manageRandomVariables(pb);
                if (DEBUG) {
                    this.outDebug.println(" manageParameterBlocks \n------------------------\n");
                }
                this.manageParameterBlocks(pb);
                this.manageCorrelations(pb);
            }
        }
        this.managePiecewiseVariables();
        if (DEBUG) {
            this.outDebug.println(" manageStateVariables \n------------------------\n");
        }
        this.updateNum1();
        this.manageStateVariables(sb, smNumber);
        this.manageInitialEstimates();
    }

    protected void updateNum1() throws IOException {
        this.toRemoveCovariates();
        this.num1 = "" + this.removeNotUsedCovariatesFromDataFile(true);
    }

    public void writePreMainBlockElements(PrintWriter fout, File src) throws IOException {
        if (fout == null) {
            return;
        }
        this.writeScriptHeader(fout, this.lexer.getModelFilename());
        ScriptDefinition sd = this.lexer.getScriptDefinition();
        for (FunctionDefinition function : sd.getFunctions()) {
            this.writeFunction(function);
        }
        this.writeScriptLibraryReferences(fout);
    }

    private void loadParameters(FileReader in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        this.num1 = props.getProperty("NUM1", this.num1Default);
        if (props.getProperty("NUM2") == null) {
            throw new RuntimeException("Grid dimension not specified");
        }
        this.totGrid = props.getProperty("NUM2");
        if (!this.getTaskObject()) {
            this.outDebug.println("WARNING: TaskObject not found.\nDefault values  assigned to parameters");
            this.setTaskObjectDeafult();
        }
        this.toSO = new PrintStream(new FileOutputStream(this.tsoFile, true));
        this.toSO.println("solver=" + this.odeSolver);
        this.toSO.println("burnin=" + Integer.parseInt(Util.clean(this.burnIn)));
        this.toSO.println("niter=" + Integer.parseInt(Util.clean(this.nIter)));
        this.toSO.println("nchains=" + Integer.parseInt(Util.clean(this.nChains)));
        this.toSO.println("winbugsgui=" + this.winbugsGUI);
        this.toSO.close();
    }

    private void loadParametersNew(FileReader in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        this.num1 = props.getProperty(TaskParameters.N_COV.label(), TaskParameters.N_COV.defaultVal());
        if (props.getProperty(TaskParameters.N_GRID.label()) == null) {
            throw new RuntimeException("Grid dimension not specified");
        }
        this.totGrid = props.getProperty(TaskParameters.N_GRID.label());
        if (!this.getTaskObjectNew()) {
            this.outDebug.println("WARNING: TaskObject not found.\nDefault values  assigned to parameters");
            this.setTaskObjectDeafultNew();
        }
        this.toSO = new PrintStream(new FileOutputStream(this.tsoFile, true));
        this.toSO.println(TaskParameters.ODE_SOLVER.label() + "=" + this.odeSolver);
        this.toSO.println(TaskParameters.BURN_IN.label() + "=" + Integer.parseInt(Util.clean(this.burnIn)));
        this.toSO.println(TaskParameters.N_ITER.label() + "=" + Integer.parseInt(Util.clean(this.nIter)));
        this.toSO.println(TaskParameters.N_CHAINS.label() + "=" + Integer.parseInt(Util.clean(this.nChains)));
        this.toSO.println(TaskParameters.WINBUGS_GUI.label() + "=" + this.winbugsGUI);
        this.toSO.close();
    }

    protected void writeAllModelFunctions(File output_dir) throws IOException {
        this.tsoFile = new File(jobDir + "/" + this.toSOName);
        this.outDebug = new PrintStream(new FileOutputStream(new File(winbugsDir + "/log" + "/winbugs-converter.log"), true));
        this.outDebug.println("open file " + this.tsoFile.getAbsolutePath());
        Calendar cal = Calendar.getInstance();
        this.toSO = new PrintStream(new FileOutputStream(this.tsoFile));
        this.toSO.println("time=" + cal.getTimeInMillis());
        this.toSO.close();
        this.outDebug.println("=========================================");
        this.outDebug.println(new Date(System.currentTimeMillis()) + " conversion START ");
        this.outDebug.println("model: " + this.xmlFileName.getAbsolutePath());
        this.outDebug.println("=========================================");
        this.outDebug.println("winbugsDir: " + winbugsDir);
        this.outDebug.println("winbugsTemplateDir: " + winbugsTemplateDir);
        this.outDebug.println("outputDir: " + outputDir);
        this.outDebug.println("bbCompileScriptDir: " + bbCompileScriptDir);
        this.outDebug.println("jobDir: " + jobDir);
        this.outDebug.println("workingDir: " + workingDir);
        this.loadParameters(new FileReader(jobDir + "/" + parametersFile));
        List sbs = this.lexer.getStructuralBlocks();
        for (StructuralBlock sb : sbs) {
            if (sb == null) continue;
            this.lexer.setCurrentStructuralBlock(sb);
            String output_filename = this.getModelFunctionFilename(output_dir.getAbsolutePath(), sb);
            this.outDebug.println("output Winbugs model file: " + output_filename);
            PrintWriter mout = new PrintWriter(output_filename);
            this.writeModelFunction(mout, sb);
            mout.close();
            mout = null;
            this.toSO = new PrintStream(new FileOutputStream(this.tsoFile, true));
            this.toSO.println(this.resLabel + "=" + Util.createList(this.resList, ","));
            this.toSO.println(this.predLabel + "=" + Util.createList(Util.clean(this.predList), ","));
            this.toSO.println("model=" + this.getModelName());
            this.toSO.close();
        }
    }

    public void writeModelFunction(PrintWriter fout, StructuralBlock sb) throws IOException {
        this.scriptPrepare(fout, sb);
        this.closeLoops(fout, smNumber);
        fout.write("}\n");
    }

    public String getModelFunctionFilename(String output_dir, StructuralBlock sb) {
        String format = "%s%s%s_BUGS.%s";
        return winbugsDir + "/" + "model_BUGS.txt";
    }

    public void initialise() {
        if (!this.lexer.hasExternalDatasets()) {
            this.lexer.checkForTrialDesignIfRandomisedModel();
        }
        this.lexer.setRemoveIllegalCharacters(true);
        this.z.setReplacementCharacter('_');
        this.z.setIllegalCharacters(new char[]{'~', '@', '+', '*', '-', '/', '$', '!', '.', '(', ')', '[', ']', ',', '#', '%', "\n".charAt(0), " ".charAt(0)});
        this.lexer.setFilterReservedWords(true);
        try {
            this.z.loadReservedWords();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("WARNING: Failed to read reserved word map for SymbolReader.");
        }
    }

    protected String doRandomVariable(ParameterRandomVariable rv) {
        String symbol = this.getSymbol(Parser.getDist(rv));
        return symbol;
    }

    protected String doDerivativeRef(String id) {
        String symbol = "";
        if (id != null) {
            Integer idx = this.getStateVarIndex(id);
            if (this.n_loops == 1) {
                symbol = upperStateLabel + this.leftArrayBracket + idx + this.rightArrayBracket;
            } else if (this.n_loops == 2) {
                symbol = upperStateLabel + this.leftArrayBracket + IND_S + "," + idx + this.rightArrayBracket;
            }
            this.derivativeMap.put(id, symbol);
        }
        return symbol;
    }

    protected String doStateSymbolRef(SymbolRef s) {
        String symbol = s.getSymbIdRef();
        symbol = s.getSymbIdRef();
        if (this.n_loops == 2) {
            symbol = symbol + this.IND_BOTH;
        }
        return symbol;
    }

    protected String doSymbolRef(SymbolRef s) {
        String symbol = s.getSymbIdRef();
        if (this.lexer.isStateVariable(symbol)) {
            if (this.isCommonVariable && !PharmMLTypeChecker.isDerivative((Object)s) && !this.isDerivativeDependent) {
                if (this.n_loops == 1) {
                    symbol = symbol + this.IND_TIME;
                } else if (this.n_loops == 2) {
                    symbol = symbol + this.IND_BOTH;
                }
            } else {
                symbol = this.isDerivativeDependentVariable(symbol) && Parser.isInList(this.odeParameters1, s) ? this.doAppendSuffix(s) : this.doStateSymbolRef(s);
            }
        } else if (this.isPopulationParameter(symbol)) {
            if (this.isPiecewiseVar(symbol)) {
                String oldSymbol = symbol;
                this.updatepiecewiseIndexMap(symbol);
                String tmpOld = oldSymbol;
                symbol = this.piecewiseSuffix + "_" + symbol;
                if (this.n_loops == 1) {
                    oldSymbol = oldSymbol + this.IND_TIME;
                    symbol = symbol + this.IND_TIME;
                } else if (this.n_loops == 2) {
                    oldSymbol = oldSymbol + this.IND_BOTH;
                    symbol = symbol + this.IND_BOTH;
                }
                this.piecewiseMap.put(this.delimit(oldSymbol), this.delimit(symbol));
                this.variablesAssignementMap.put(this.delimit(tmpOld), this.delimit(oldSymbol));
            }
            if (this.parameterDefinitionMap.get(this.getParameter(symbol)) != null) {
                symbol = this.parameterDefinitionMap.get(this.getParameter(symbol));
            }
            if (this.variablesAssignementMap.get(symbol) != null) {
                symbol = this.variablesAssignementMap.get(symbol);
            } else if (this.variablesAssignementMap.get(this.delimit(symbol)) != null) {
                symbol = this.variablesAssignementMap.get(this.delimit(symbol));
            }
        } else if (this.isCovariate(s) && !this.isTransformedCovariate(s)) {
            CovariateDefinition cd = this.getCovariate(symbol);
            String oldSymbol = symbol;
            if (cd.getContinuous() != null) {
                if (!Util.getList(this.usedCovNames).contains(symbol)) {
                    this.usedCovNames.add(s);
                }
                symbol = symbol + this.interpSuffix;
                symbol = symbol + this.IND_BOTH;
                this.doInterpLine(oldSymbol, symbol);
            } else if (cd.getCategorical() != null) {
                if (!Util.getList(this.usedCovNames).contains(symbol)) {
                    this.usedCovNames.add(s);
                }
                symbol = symbol + this.interpSuffix;
                symbol = symbol + this.IND_BOTH;
                this.doInterpLineCat(oldSymbol, symbol);
            }
        } else if (this.isTransformedCovariate(s)) {
            CovariateDefinition cd = this.getCovariate(symbol);
            String oldSymbol = symbol;
            if (cd.getContinuous() != null && !cd.getContinuous().getListOfTransformation().isEmpty()) {
                if (DEBUG) {
                    this.outDebug.println("doSymbolRef covariate symbol = " + symbol);
                }
                symbol = symbol + this.IND_BOTH;
                this.variablesAssignementMap.put(this.delimit(oldSymbol), this.delimit(symbol));
            }
        } else if (this.lexer.isIndividualParameter_(symbol)) {
            symbol = symbol + this.IND_SUBJ;
        } else if (this.isIndependentVariableSym(symbol)) {
            symbol = gridLabel;
            if (this.n_loops == 1) {
                symbol = symbol + this.IND_TIME;
            } else if (this.n_loops == 2) {
                symbol = symbol + this.IND_BOTH;
            }
        } else if (this.isVariable(symbol)) {
            if (this.isDerivativeDependentVariable(symbol)) {
                if (Parser.isInList(this.odeParameters1, s)) {
                    symbol = this.doAppendSuffix(s);
                } else if (this.n_loops == 1) {
                    symbol = symbol + this.IND_TIME;
                } else if (this.n_loops == 2) {
                    symbol = symbol + this.IND_BOTH;
                }
            }
            if (this.isPiecewiseVar(symbol)) {
                String oldSymbol = symbol;
                this.updatepiecewiseIndexMap(symbol);
                symbol = this.piecewiseSuffix + "_" + symbol;
                if (this.n_loops == 1) {
                    oldSymbol = oldSymbol + this.IND_TIME;
                    symbol = symbol + this.IND_TIME;
                } else if (this.n_loops == 2) {
                    oldSymbol = oldSymbol + this.IND_BOTH;
                    symbol = symbol + this.IND_BOTH;
                }
                this.piecewiseMap.put(this.delimit(oldSymbol), this.delimit(symbol));
            } else if (this.n_loops == 1) {
                symbol = symbol + this.IND_TIME;
            } else if (this.n_loops == 2) {
                symbol = symbol + this.IND_BOTH;
            } else if (!this.hasDiffEquations && this.isDoseVariable(symbol)) {
                symbol = symbol + this.leftArrayBracket + IND_S + ",1" + this.rightArrayBracket;
            }
        } else if (this.isRandomVar(symbol)) {
            ParameterRandomVariable rv = this.getRandomVar(symbol);
            LevelReference level_ref = rv.getVariabilityReference();
            VariabilityBlock vb = this.lexer.getVariabilityBlock(level_ref.getSymbRef());
            if (vb.isResidualError()) {
                if (this.n_loops == 1) {
                    symbol = symbol + this.IND_TIME;
                } else if (this.n_loops == 2) {
                    symbol = symbol + this.IND_BOTH;
                }
            } else if (vb.isParameterVariability()) {
                symbol = symbol + this.IND_SUBJ;
            }
        } else if (!this.hasDiffEquations && this.isDoseVariable(symbol)) {
            symbol = symbol + this.leftArrayBracket + IND_S + ",1" + this.rightArrayBracket;
        } else {
            SymbolReader.ModifiedSymbol result;
            if (this.lexer.isRemoveIllegalCharacters() && (result = this.z.removeIllegalCharacters((Object)s, symbol)).isModified()) {
                symbol = result.modified_value;
            }
            if (this.lexer.isFilterReservedWords() && this.z.isReservedWord(symbol)) {
                Accessor a = this.lexer.getAccessor();
                PharmMLRootType element = a.fetchElement(s);
                if (element == null) {
                    throw new NullPointerException("Unable to resolve symbol (symbIdRef=('" + s.getSymbIdRef() + "') for reserved word filtering.");
                }
                symbol = this.z.replacement4ReservedWord(s.getSymbIdRef());
                if (symbol == null) {
                    throw new NullPointerException("Replacement symbol for reserved word (symbIdRef=('" + s.getSymbIdRef() + "') undefined.");
                }
                SymbolReader.ModifiedSymbol result2 = new SymbolReader.ModifiedSymbol((Object)element, s.getSymbIdRef(), symbol);
                if (result2.isModified()) {
                    this.z.add(result2);
                }
            }
        }
        if (!this.delimit(symbol).equals(this.delimit(s.getSymbIdRef()))) {
            this.putVariableMap(this.delimit(s.getSymbIdRef()), this.delimit(symbol));
        }
        return this.delimit(symbol);
    }

    protected static boolean isIn(SymbolRef s, List<SymbolRef> l) {
        for (SymbolRef sr : l) {
            if (!sr.getSymbIdRef().equals(s.getSymbIdRef())) continue;
            return true;
        }
        return false;
    }

    private boolean isDoseVariable(String symbol) {
        Object pi = null;
        String var = null;
        ExternalDataSet eds = (ExternalDataSet)this.lexer.getScriptDefinition().getTrialDesignBlock().getModel().getListOfExternalDataSet().get(0);
        for (ColumnDefinition cd : eds.getDataSet().getDefinition().getListOfColumn()) {
            if (cd.getListOfColumnType().get(0) == null || !((ColumnType)cd.getListOfColumnType().get(0)).value().equalsIgnoreCase("dose")) continue;
            var = cd.getColumnId();
            break;
        }
        if (var != null) {
            List ext = eds.getListOfColumnMappingOrColumnTransformationOrMultipleDVMapping();
            for (PharmMLRootType el : ext) {
                MultipleDVMapping mdvm;
                if (el instanceof ColumnMapping) {
                    ColumnMapping cm = (ColumnMapping)el;
                    if (!cm.getColumnRef().getColumnIdRef().equals(var) || cm.getPiecewise() == null) continue;
                    for (Piece piece : cm.getPiecewise().getListOfPiece()) {
                        if (!(piece.getValue() instanceof SymbolRef) || !((SymbolRef)piece.getValue()).getSymbIdRef().equals(symbol)) continue;
                        this.doseVar.add(symbol);
                        return true;
                    }
                    continue;
                }
                if (!(el instanceof MultipleDVMapping) || !(mdvm = (MultipleDVMapping)el).getColumnRef().getColumnIdRef().equals(var) || mdvm.getPiecewise() == null) continue;
                for (Piece piece : mdvm.getPiecewise().getListOfPiece()) {
                    if (!(piece.getValue() instanceof SymbolRef) || !((SymbolRef)piece.getValue()).getSymbIdRef().equals(symbol)) continue;
                    this.doseVar.add(symbol);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isDosingTime(String symbol) {
        Object pi = null;
        String var = null;
        ExternalDataSet eds = (ExternalDataSet)this.lexer.getScriptDefinition().getTrialDesignBlock().getModel().getListOfExternalDataSet().get(0);
        for (ColumnDefinition cd : eds.getDataSet().getDefinition().getListOfColumn()) {
            if (cd.getListOfColumnType().get(0) == null || !((ColumnType)cd.getListOfColumnType().get(0)).value().equalsIgnoreCase("idv")) continue;
            var = cd.getColumnId();
            break;
        }
        if (var != null) {
            List ext = eds.getListOfColumnMappingOrColumnTransformationOrMultipleDVMapping();
            for (PharmMLRootType el : ext) {
                ColumnMapping cm;
                if (el instanceof ColumnMapping) {
                    cm = (ColumnMapping)el;
                    if (!cm.getColumnRef().getColumnIdRef().equals(var) || cm.getPiecewise() == null) continue;
                    for (Piece piece : cm.getPiecewise().getListOfPiece()) {
                        if (!(piece.getValue() instanceof SymbolRef) || !((SymbolRef)piece.getValue()).getSymbIdRef().equals(symbol)) continue;
                        this.dosingTime.add(symbol);
                        return true;
                    }
                    continue;
                }
                if (!(el instanceof MultipleDVMapping) || !(cm = (MultipleDVMapping)el).getColumnRef().getColumnIdRef().equals(var) || cm.getPiecewise() == null) continue;
                for (Piece piece : cm.getPiecewise().getListOfPiece()) {
                    if (!(piece.getValue() instanceof SymbolRef) || !((SymbolRef)piece.getValue()).getSymbIdRef().equals(symbol)) continue;
                    this.dosingTime.add(symbol);
                    return true;
                }
            }
        }
        return false;
    }

    private String doLocalVariable(VariableDefinition v) {
        return this.z.get((Object)v.getSymbId());
    }

    public String getSymbol(Object o) {
        String symbol = unassigned_symbol;
        int indexType = 32;
        if (PharmMLTypeChecker.isSymbolReference((Object)o)) {
            symbol = this.doSymbolRef((SymbolRef)o);
        } else if (PharmMLTypeChecker.isLocalVariable((Object)o)) {
            if (!this.isDerivativeDependentVariable(((VariableDefinition)o).getSymbId())) {
                symbol = this.doLocalVariable((VariableDefinition)o);
                indexType = this.n_loops == 1 ? 116 : 98;
            } else {
                symbol = this.doDerivativeDependentVariable((VariableDefinition)o);
                if (!(this instanceof PascalParser)) {
                    indexType = this.n_loops == 1 ? 116 : 98;
                }
            }
        } else if (PharmMLTypeChecker.isIndividualParameter((Object)o)) {
            symbol = ((IndividualParameter)o).getSymbId();
            indexType = 115;
        } else if (this.isIndividualParameterAssignment(o)) {
            IndividualParameter par = ((IndividualParameterAssignment)o).parameter;
            String s1 = this.getSymbol(par);
            symbol = s1 + assignSymbol + this.doIndividualParameterAssignment((IndividualParameterAssignment)o);
        } else if (PharmMLTypeChecker.isParameter((Object)o)) {
            symbol = ((Parameter)o).getSymbId();
        } else if (PharmMLTypeChecker.isIndependentVariable((Object)o)) {
            symbol = this.doIndependentVariable((IndependentVariable)o);
            indexType = this.n_loops == 1 ? 116 : 98;
        } else if (PharmMLTypeChecker.isGeneralError((Object)o)) {
            symbol = this.doGeneralObservationError((GeneralObsError)o);
            indexType = this.n_loops == 1 ? 116 : 98;
        } else if (PharmMLTypeChecker.isStructuredError((Object)o)) {
            symbol = this.doGaussianObservationError((StructuredObsError)o);
            indexType = this.n_loops == 1 ? 116 : 98;
        } else if (this.isCovariate(o)) {
            symbol = this.doCovariate((CovariateDefinition)o);
            indexType = 98;
        } else if (this.isCategoricalCovariate(o)) {
            symbol = this.doCovariate((CovariateDefinition)o);
            indexType = 98;
        } else if (this.isContinuousCovariate(o)) {
            symbol = this.doContinuousCovariate((ContinuousCovariate)o);
            indexType = 98;
        } else if (PharmMLTypeChecker.isCovariateTransform((Object)o)) {
            symbol = this.doCovariateTransformationNew((CovariateTransformation)o);
            indexType = 98;
        } else if (PharmMLTypeChecker.isRandomVariable((Object)o)) {
            symbol = ((ParameterRandomVariable)o).getSymbId();
            LevelReference level_ref = ((ParameterRandomVariable)o).getVariabilityReference();
            VariabilityBlock vb = this.lexer.getVariabilityBlock(level_ref.getSymbRef());
            if (vb.isResidualError()) {
                indexType = this.n_loops == 1 ? 116 : 98;
            } else if (vb.isParameterVariability()) {
                indexType = 115;
            }
        } else if (PharmMLTypeChecker.isDerivative((Object)o)) {
            symbol = this.doDerivative((DerivativeVariable)o);
        } else if (this.isPopulationParameter(o)) {
            symbol = this.doParameter((PopulationParameter)o);
        } else if (this.isObservationParameter(o)) {
            symbol = this.doParameter((PopulationParameter)o);
        } else if (Parser.isString_((Object)o)) {
            symbol = this.doString((String)o);
        } else if (PharmMLTypeChecker.isVectorSelector((Object)o)) {
            symbol = this.doVectorSelector((VectorSelector)o);
        } else if (PharmMLTypeChecker.isReal((Object)o)) {
            symbol = this.doReal((RealValue)o);
        } else if (PharmMLTypeChecker.isFalse((Object)o)) {
            symbol = this.doFalse();
        } else if (PharmMLTypeChecker.isTrue((Object)o)) {
            symbol = this.doTrue();
        } else if (PharmMLTypeChecker.isString((Object)o)) {
            symbol = this.doStringValue((StringValue)o);
        } else if (PharmMLTypeChecker.isInt((Object)o)) {
            symbol = this.doInt((IntValue)o);
        } else if (PharmMLTypeChecker.isConstant((Object)o)) {
            symbol = this.doConstant((Constant)o);
        } else if (PharmMLTypeChecker.isFunctionCall((Object)o)) {
            symbol = this.doFunctionCallNew((FunctionCallType)o);
        } else if (PharmMLTypeChecker.isSequence((Object)o)) {
            symbol = this.doSequence((Sequence)o);
        } else if (PharmMLTypeChecker.isVector((Object)o)) {
            symbol = this.doVector((Vector)o);
        } else if (PharmMLTypeChecker.isPiecewise((Object)o)) {
            symbol = this.doPiecewise((Piecewise)o);
        } else if (PharmMLTypeChecker.isLogicalBinaryOperation((Object)o)) {
            symbol = this.doLogicalBinaryOperator((LogicBinOp)o);
        } else if (PharmMLTypeChecker.isLogicalUnaryOperation((Object)o)) {
            symbol = this.doLogicalUnaryOperator((LogicUniOp)o);
        } else if (PharmMLTypeChecker.isParameterEstimate((Object)o)) {
            symbol = this.doParameterEstimate((ParameterEstimate)o);
        } else if (PharmMLTypeChecker.isJAXBElement((Object)o)) {
            symbol = this.doElement((JAXBElement)o);
        } else if (PharmMLTypeChecker.isUnivariateDistribution((Object)o)) {
            symbol = this.doUnivariateDistribution((AbstractContinuousUnivariateDistributionType)o);
        } else if (PharmMLTypeChecker.isProbOnto((Object)o)) {
            symbol = this.doProbonto((ProbOnto)o);
        } else if (PharmMLTypeChecker.isVariableReference((Object)o)) {
            symbol = this.doVarRef((VarRefType)o);
        } else if (PharmMLTypeChecker.isCorrelation((Object)o)) {
            symbol = this.doCorrelation((CorrelationRef)o);
        } else if (o instanceof CategoryRef) {
            symbol = ((CategoryRef)o).getCatIdRef();
        } else if (PharmMLTypeChecker.isStructuredError((Object)o)) {
            symbol = this.doGaussianObservationError((StructuredObsError)o);
        } else if (Parser.isBigInteger((Object)o)) {
            symbol = this.doBigInteger((BigInteger)o);
        } else if (this.isFixedParameter(o)) {
            symbol = this.doFixedParameter((FixedParameter)o);
        } else if (this.isObjectiveFunctionParameter(o)) {
            symbol = this.doParameterAssignmentFromEstimation((ParameterAssignmentFromEstimation)o);
            indexType = this.n_loops == 1 ? 116 : 98;
        } else if (PharmMLTypeChecker.isCommonVariable((Object)o)) {
            symbol = this.doCommonVariable((CommonVariableDefinition)o);
            indexType = this.n_loops == 1 ? 116 : 98;
        } else if (PharmMLTypeChecker.isMatrixSelector((Object)o)) {
            symbol = this.doMatrixSelector((MatrixSelector)o);
        } else if (PharmMLTypeChecker.isPiece((Object)o)) {
            symbol = this.doPiece((Piece)o);
        } else if (PharmMLTypeChecker.isMatrixUnaryOperation((Object)o)) {
            symbol = this.doMatrixUniOp((MatrixUniOp)o);
        } else {
            String format = "WARNING: Unknown symbol, %s\n";
            String msg = String.format(format, o.toString());
            ConversionDetail_ detail = new ConversionDetail_();
            detail.setSeverity(ConversionDetail.Severity.WARNING);
            detail.addInfo("warning", msg);
            System.err.println(msg);
        }
        switch (indexType) {
            case 116: {
                symbol = symbol + this.IND_TIME;
                break;
            }
            case 98: {
                symbol = symbol + this.IND_BOTH;
                break;
            }
            case 115: {
                symbol = symbol + this.IND_SUBJ;
            }
        }
        return symbol;
    }

    protected void parseBinaryOperation(BinaryTree bt, Node leaf) {
        Binop b_op = (Binop)leaf.parent.data;
        Node parent = leaf.parent;
        if (parent.left != null && parent.right != null) {
            String leftStatement = "";
            leftStatement = parent.left.stmt != null ? this.delimit(parent.left.stmt) : this.delimit(this.getSymbol(parent.left.data));
            parent.left = null;
            String rightStatement = "";
            rightStatement = parent.right.stmt != null ? this.delimit(parent.right.stmt) : this.delimit(this.getSymbol(parent.right.data));
            parent.right = null;
            parent.data = this.doBinaryOperation(b_op, leftStatement, rightStatement);
        }
    }

    protected void parseUnaryOperation(BinaryTree bt, Node leaf) {
        Uniop u_op = (Uniop)leaf.parent.data;
        Node parent = leaf.parent;
        if (parent.left != null) {
            String leftStatement = "";
            leftStatement = parent.left.stmt != null ? this.delimit(parent.left.stmt) : this.delimit(this.getSymbol(parent.left.data));
            parent.left = null;
            parent.data = this.doUnaryOperation(u_op, leftStatement);
        }
    }

    protected String doGeneralObservationError(GeneralObsError goe) {
        return goe.getSymbId();
    }

    protected String doUnaryOperation(Uniop u_op, String leftStatement) {
        String winbugsUnaryOperator;
        switch (u_op.getOperator().getOperator()) {
            case "factorial": {
                winbugsUnaryOperator = String.format("exp(logfact(%s))", leftStatement);
                break;
            }
            case "ceiling": {
                winbugsUnaryOperator = String.format("trunc(%s)+1", leftStatement);
                break;
            }
            case "logistic": {
                winbugsUnaryOperator = String.format("1/(1+exp(-%s))", leftStatement);
                break;
            }
            case "tan": {
                winbugsUnaryOperator = String.format("sin(%s)/cos(%s)", leftStatement, leftStatement);
                break;
            }
            case "sec": {
                winbugsUnaryOperator = String.format("1/cos(%s)", leftStatement);
                break;
            }
            case "csc": {
                winbugsUnaryOperator = String.format("1/sin(%s)", leftStatement);
                break;
            }
            case "cot": {
                winbugsUnaryOperator = String.format("cos(%s)/sin(%s)", leftStatement, leftStatement);
                break;
            }
            case "sinh": {
                winbugsUnaryOperator = String.format("(exp(%s)-exp(-%s))/2", leftStatement, leftStatement);
                break;
            }
            case "cosh": {
                winbugsUnaryOperator = String.format("(exp(%s)+exp(-%s))/2", leftStatement, leftStatement);
                break;
            }
            case "tanh": {
                winbugsUnaryOperator = String.format("(exp(%s)-exp(-%s))/(exp(%s)+exp(-%s))", leftStatement, leftStatement, leftStatement, leftStatement);
                break;
            }
            case "coth": {
                winbugsUnaryOperator = String.format("(exp(%s)+exp(-%s))/(exp(%s)-exp(-%s))", leftStatement, leftStatement, leftStatement, leftStatement);
                break;
            }
            case "sech": {
                winbugsUnaryOperator = String.format("2/(exp(%s)+exp(-%s))", leftStatement, leftStatement);
                break;
            }
            case "csch": {
                winbugsUnaryOperator = String.format("2/(exp(%s)-exp(-%s))", leftStatement, leftStatement);
                break;
            }
            case "arcsinh": {
                winbugsUnaryOperator = String.format("log((%s)+sqrt(pow(%s,2)+1))", leftStatement, leftStatement);
                break;
            }
            case "arccosh": {
                winbugsUnaryOperator = String.format("log((%s)+sqrt(pow(%s,2)-1))", leftStatement, leftStatement);
                break;
            }
            case "arctanh": {
                winbugsUnaryOperator = String.format("1/2*log((1+%s)/(1-%s))", leftStatement, leftStatement);
                break;
            }
            case "arccoth": {
                winbugsUnaryOperator = String.format("1/2*log((%s+1)/(%s-1))", leftStatement, leftStatement);
                break;
            }
            default: {
                winbugsUnaryOperator = super.doUnaryOperation(u_op, leftStatement);
            }
        }
        return "(" + winbugsUnaryOperator.trim() + ")";
    }

    protected String doBinaryOperation(Binop b_op, String leftStatement, String rightStatement) {
        String winbugsBinOp = super.doBinaryOperation(b_op, leftStatement, rightStatement);
        String op = b_op.getOperator().toString();
        if (op == null) {
            throw new NullPointerException("The binary operator is NULL.");
        }
        if (op.equals(BaseEngine.POWER)) {
            winbugsBinOp = String.format("pow(%s,%s)", leftStatement, rightStatement);
        } else if (op.equals(BaseEngine.ROOT)) {
            winbugsBinOp = String.format("pow(%s,1/%s)", leftStatement, rightStatement);
        } else if (op.equals(BaseEngine.LOGX)) {
            winbugsBinOp = String.format("log(%s)/log(%s)", leftStatement, rightStatement);
        } else if (op.equals(BaseEngine.MAX)) {
            winbugsBinOp = String.format("max(%s,%s)", leftStatement, rightStatement);
        } else if (op.equals(BaseEngine.MIN)) {
            winbugsBinOp = String.format("min(%s,%s)", leftStatement, rightStatement);
        }
        return this.delimit(winbugsBinOp);
    }

    protected String getRootFormat() {
        return super.getRootFormat();
    }

    protected String getPowFormat() {
        return this.pow_format;
    }

    protected String getRemFormat() {
        return super.getRemFormat();
    }

    protected String getMinFormat() {
        return super.getMinFormat();
    }

    protected String getMaxFormat() {
        return super.getMaxFormat();
    }

    protected String getLogXFormat() {
        return super.getLogXFormat();
    }

    protected String doBinaryLogicalOperation(LogicBinOp l_b_op, String leftStatement, String rightStatement) {
        return super.doBinaryLogicalOperation(l_b_op, leftStatement, rightStatement);
    }

    protected String doGaussianObservationError(StructuredObsError goe) {
        return goe.getSymbId();
    }

    public boolean isVariable(String symbol) {
        if (symbol != null && !this.lexer.getStructuralBlocks().isEmpty()) {
            List sbs = this.lexer.getStructuralBlocks();
            for (StructuralBlock sb : sbs) {
                if (sb == null) continue;
                List ips = sb.getLocalVariables();
                for (VariableDefinition ip : ips) {
                    String currentSymbol;
                    if (ip == null || (currentSymbol = ip.getSymbId()) == null || !currentSymbol.equals(symbol)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPiecewiseVar(String symbol) {
        if (symbol != null) {
            if (!this.lexer.getStructuralBlocks().isEmpty()) {
                List sbs = this.lexer.getStructuralBlocks();
                for (StructuralBlock sb : sbs) {
                    if (sb == null) continue;
                    List ips = sb.getLocalVariables();
                    for (VariableDefinition ip : ips) {
                        VariableDefinition var;
                        String currentSymbol;
                        if (ip == null || (currentSymbol = ip.getSymbId()) == null || !currentSymbol.equals(symbol) || (var = this.getVariable(symbol)).getAssign() == null || var.getAssign().getPiecewise() == null) continue;
                        return true;
                    }
                }
            }
            if (this.lexer.getParameterBlock() != null) {
                PopulationParameter var;
                String currentSymbol;
                for (PopulationParameter par : this.lexer.getParameterBlock().getParameters()) {
                    if (par == null || (currentSymbol = par.getSymbId()) == null || !currentSymbol.equals(symbol) || (var = this.getPopulationParameter(symbol)).getAssign() == null || var.getAssign().getPiecewise() == null) continue;
                    return true;
                }
                for (PopulationParameter par : this.lexer.getParameterBlock().getModel().getListOfParameterModelElements()) {
                    if (par == null) continue;
                    currentSymbol = null;
                    if (par instanceof CommonParameter) {
                        currentSymbol = ((CommonParameter)par).getSymbId();
                    }
                    if (currentSymbol == null || !currentSymbol.equals(symbol) || !((var = this.lexer.getAccessor().fetchElement(symbol)) instanceof Parameter) || ((Parameter)var).getAssign() == null || ((Parameter)var).getAssign().getPiecewise() == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPopulationParameter(Object o) {
        return o instanceof PopulationParameter;
    }

    public boolean isPopulationParameter(String symbol) {
        if (symbol != null) {
            for (PopulationParameter par : this.lexer.getModelParameters()) {
                String currentSymbol;
                if (par == null || (currentSymbol = par.getSymbId()) == null || !currentSymbol.equals(symbol)) continue;
                return true;
            }
            List obs = this.lexer.getObservationBlocks();
            for (ObservationBlock ob : obs) {
                for (ObservationParameter par : ob.getObservationParameters()) {
                    String currentSymbol;
                    if (par == null || (currentSymbol = this.extract(par.getName())) == null || !currentSymbol.equals(symbol)) continue;
                    return true;
                }
            }
            if (!this.lexer.getStructuralBlocks().isEmpty()) {
                List sbs = this.lexer.getStructuralBlocks();
                for (StructuralBlock sb : sbs) {
                    if (sb == null) continue;
                    for (PopulationParameter par : sb.getParameters()) {
                        String currentSymbol;
                        if (par == null || (currentSymbol = par.getSymbId()) == null || !currentSymbol.equals(symbol)) continue;
                        return true;
                    }
                }
                if (!this.lexer.getStructuralBlocks().isEmpty() && this.lexer.getParameterBlock() != null) {
                    for (PopulationParameter par : this.lexer.getParameterBlock().getParameters()) {
                        String currentSymbol;
                        if (par == null || (currentSymbol = par.getSymbId()) == null || !currentSymbol.equals(symbol)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isRandomVar(String symbol) {
        if (symbol != null) {
            List<ParameterBlock> pbs = this.getParameterBlocks();
            for (ParameterBlock pb : pbs) {
                List rvs = pb.getRandomVariables();
                for (ParameterRandomVariable rv : rvs) {
                    if (!symbol.equals(rv.getSymbId())) continue;
                    return true;
                }
            }
            List obs = this.lexer.getObservationBlocks();
            for (ObservationBlock ob : obs) {
                List rvs = ob.getRandomVariables();
                for (ParameterRandomVariable rv : rvs) {
                    if (!symbol.equals(rv.getSymbId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isLinkedRandomVar(String symbol) {
        if (symbol != null) {
            List<ParameterBlock> pbs = this.getParameterBlocks();
            for (ParameterBlock pb : pbs) {
                List rvs = pb.getLinkedRandomVariables();
                for (ParameterRandomVariable rv : rvs) {
                    if (!symbol.equals(rv.getSymbId())) continue;
                    return true;
                }
            }
            List obs = this.lexer.getObservationBlocks();
            for (ObservationBlock ob : obs) {
                List rvs = ob.getLinkedRandomVariables();
                for (ParameterRandomVariable rv : rvs) {
                    if (!symbol.equals(rv.getSymbId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCovariate(Object o) {
        return o instanceof CovariateDefinition;
    }

    public boolean isCategoricalCovariate(Object o) {
        return o instanceof CovariateDefinition && ((CovariateDefinition)o).getCategorical() != null;
    }

    public boolean isCategoricalCovariateType(SymbolRef symbol) {
        if (symbol != null && !this.lexer.getCovariateBlocks().isEmpty()) {
            for (CovariateBlock cb : this.lexer.getCovariateBlocks()) {
                if (cb == null) continue;
                List cds = cb.getCovariates();
                for (CovariateDefinition cc : cds) {
                    String currentSymbol;
                    if (cc == null || (currentSymbol = cc.getSymbId()) == null || !currentSymbol.equals(symbol.getSymbIdRef()) || cc.getCategorical() == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isContinuousCovariate(Object o) {
        return o instanceof ContinuousCovariate;
    }

    public boolean isCovariate(SymbolRef symbol) {
        if (symbol != null && !this.lexer.getCovariateBlocks().isEmpty()) {
            for (CovariateBlock cb : this.lexer.getCovariateBlocks()) {
                if (cb == null) continue;
                List cds = cb.getCovariates();
                for (CovariateDefinition cc : cds) {
                    String currentSymbol;
                    if (cc == null || (currentSymbol = cc.getSymbId()) == null || !currentSymbol.equals(symbol.getSymbIdRef())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCategoricalCovariate(SymbolRef symbol) {
        if (symbol != null && !this.lexer.getCovariateBlocks().isEmpty()) {
            for (CovariateBlock cb : this.lexer.getCovariateBlocks()) {
                if (cb == null) continue;
                List cds = cb.getCovariates();
                for (CovariateDefinition cc : cds) {
                    String currentSymbol;
                    if (cc == null || (currentSymbol = cc.getSymbId()) == null || !currentSymbol.equals(symbol.getSymbIdRef())) continue;
                    return cc.getCategorical() != null;
                }
            }
        }
        return false;
    }

    public boolean isContinuousCovariate(SymbolRef symbol) {
        if (symbol != null && !this.lexer.getCovariateBlocks().isEmpty()) {
            for (CovariateBlock cb : this.lexer.getCovariateBlocks()) {
                if (cb == null) continue;
                List cds = cb.getCovariates();
                for (CovariateDefinition cc : cds) {
                    String currentSymbol;
                    if (cc == null || (currentSymbol = cc.getSymbId()) == null || !currentSymbol.equals(symbol.getSymbIdRef())) continue;
                    return cc.getContinuous() != null;
                }
            }
        }
        return false;
    }

    public boolean isTransformedCovariate(SymbolRef symbol) {
        if (symbol != null && !this.lexer.getCovariateBlocks().isEmpty()) {
            for (CovariateBlock cb : this.lexer.getCovariateBlocks()) {
                if (cb == null) continue;
                List cds = cb.getCovariates();
                for (CovariateDefinition cc : cds) {
                    String currentSymbol;
                    if (cc == null || (currentSymbol = cc.getSymbId()) == null || cc.getContinuous() == null || cc.getContinuous().getListOfTransformation().isEmpty()) continue;
                    for (CovariateTransformation ct : cc.getContinuous().getListOfTransformation()) {
                        if (!ct.getTransformedCovariate().getSymbId().equals(symbol.getSymbIdRef())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected boolean isDerivativeVar(String symbol) {
        if (symbol != null) {
            List sbs = this.lexer.getStructuralBlocks();
            for (StructuralBlock sb : sbs) {
                List rvs = sb.getStateVariables();
                for (DerivativeVariable rv : rvs) {
                    if (!symbol.equals(rv.getSymbId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isVariableDefinition(String symbol) {
        if (symbol != null) {
            List sbs = this.lexer.getStructuralBlocks();
            for (StructuralBlock sb : sbs) {
                List rvs = sb.getLocalVariables();
                for (VariableDefinition rv : rvs) {
                    if (!symbol.equals(rv.getSymbId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public CovariateDefinition getCovariate(String symbol) {
        if (symbol != null) {
            for (CovariateDefinition cd : this.lexer.getCovariates()) {
                if (cd.getSymbId().equals(symbol)) {
                    return cd;
                }
                if (cd.getContinuous() == null || cd.getContinuous().getListOfTransformation().isEmpty()) continue;
                for (CovariateTransformation ct : cd.getContinuous().getListOfTransformation()) {
                    if (!ct.getTransformedCovariate().getSymbId().equals(symbol)) continue;
                    return cd;
                }
            }
        }
        return null;
    }

    public CovariateDefinition getCategoricalCovariate(String symbol) {
        if (symbol != null) {
            for (CovariateDefinition cd : this.lexer.getCovariates()) {
                if (cd.getSymbId().equals(symbol)) {
                    return cd;
                }
                if (cd.getCategorical() == null) continue;
                return cd;
            }
        }
        return null;
    }

    public DerivativeVariable getDerivativeVariable(String symbol) {
        if (symbol != null) {
            for (StructuralModel sb : this.dom.getModelDefinition().getListOfStructuralModel()) {
                for (DerivativeVariable cd : sb.fetchDerivativeVariables()) {
                    if (!cd.getSymbId().equals(symbol)) continue;
                    return cd;
                }
            }
        }
        return null;
    }

    public PopulationParameter getParameter(String symbol) {
        if (symbol != null) {
            for (PopulationParameter cd : this.lexer.getModelParameters()) {
                if (!cd.getSymbId().equals(symbol)) continue;
                return cd;
            }
        }
        return null;
    }

    public ParameterRandomVariable getRandomVar(String symbol) {
        if (symbol != null) {
            List<ParameterBlock> pbs = this.getParameterBlocks();
            for (ParameterBlock pb : pbs) {
                List rvs = pb.getRandomVariables();
                for (ParameterRandomVariable rv : rvs) {
                    if (!symbol.equals(rv.getSymbId())) continue;
                    return rv;
                }
            }
            List obs = this.lexer.getObservationBlocks();
            for (ObservationBlock ob : obs) {
                List rvs = ob.getRandomVariables();
                for (ParameterRandomVariable rv : rvs) {
                    if (!symbol.equals(rv.getSymbId())) continue;
                    return rv;
                }
            }
        }
        return null;
    }

    public FunctionDefinition getFunctionByName(String symbol) {
        if (symbol != null) {
            List fd = this.lexer.getScriptDefinition().getFunctions();
            for (FunctionDefinition f : fd) {
                if (!symbol.equals(f.getSymbId())) continue;
                return f;
            }
        }
        return null;
    }

    public ILexer getLexer() {
        return this.lexer;
    }

    private List<JAXBElement<?>> getBinopContent(Binop bop) {
        ArrayList cont = new ArrayList();
        cont.add(bop.getOperand1().toJAXBElement());
        cont.add(bop.getOperand2().toJAXBElement());
        return cont;
    }

    private List<JAXBElement<?>> getMatrixContent(MatrixUniOp mat) {
        ArrayList cont = new ArrayList();
        if (mat.getValue() instanceof Matrix) {
            if (((Matrix)mat.getValue()).getListOfMatrixElements() != null) {
                List list = ((Matrix)mat.getValue()).getListOfMatrixElements();
                for (PharmMLRootType el : list) {
                    for (MatrixRowValue e : ((MatrixRow)el).getListOfValues()) {
                        if (!(e instanceof SymbolRef)) continue;
                        cont.add(((SymbolRef)e).toJAXBElement());
                        String tmp = ((SymbolRef)e).getSymbIdRef();
                    }
                }
            }
        } else if (mat.getValue() instanceof SymbolRef) {
            cont.add(((SymbolRef)mat.getValue()).toJAXBElement());
        }
        return cont;
    }

    private JAXBElement<? extends AbstractContinuousUnivariateDistributionType> getDistributionType(Object context) {
        String s = null;
        if (context instanceof ParameterRandomVariable) {
            BinaryTree tmp = this.lexer.getTreeMaker().newInstance((Object)((ParameterRandomVariable)context).getDistribution());
            Distribution distr = ((ParameterRandomVariable)context).getDistribution();
            if (distr.getUncertML() != null) {
                return distr.getUncertML().getAbstractContinuousUnivariateDistribution();
            }
            if (distr.getProbOnto() != null) {
                return null;
            }
        } else if (context instanceof StructuredObsError && this.isRandomVar(s = ((StructuredObsError)context).getResidualError().getSymbRef().getSymbIdRef())) {
            ParameterRandomVariable rv = this.getRandomVar(s);
            BinaryTree tmp = this.lexer.getTreeMaker().newInstance((Object)rv.getDistribution());
            if (rv.getDistribution().getUncertML() != null) {
                return rv.getDistribution().getUncertML().getAbstractContinuousUnivariateDistribution();
            }
            return null;
        }
        return null;
    }

    private ProbOnto getProbOntoDistributionType(Object context) {
        String s = null;
        if (context instanceof ParameterRandomVariable) {
            BinaryTree tmp = this.lexer.getTreeMaker().newInstance((Object)((ParameterRandomVariable)context).getDistribution());
            return (ProbOnto)((Node)tmp.nodes.get((int)0)).data;
        }
        if (context instanceof StructuredObsError) {
            s = ((StructuredObsError)context).getResidualError().getSymbRef().getSymbIdRef();
            if (this.isRandomVar(s)) {
                ParameterRandomVariable rv = this.getRandomVar(s);
                BinaryTree tmp = this.lexer.getTreeMaker().newInstance((Object)rv);
                return (ProbOnto)((Node)tmp.nodes.get((int)0)).data;
            }
        } else if (context instanceof PopulationParameter) {
            BinaryTree tmp = this.lexer.getTreeMaker().newInstance((Object)((PopulationParameter)context).getDistribution());
            return (ProbOnto)((Node)tmp.nodes.get((int)0)).data;
        }
        return null;
    }

    List<VariableDefinition> getVariables(StructuralBlock sb) {
        ArrayList<VariableDefinition> l0 = new ArrayList<VariableDefinition>();
        for (VariableDefinition sr : sb.getLocalVariables()) {
            if (!Parser.isInList(Util.getList(this.odeParameters1), sr.getSymbId())) continue;
            l0.add(sr);
        }
        return l0;
    }

    List<PharmMLRootType> getPiecewiseList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (StructuralBlock _sb : this.lexer.getStructuralBlocks()) {
            list.addAll(this.getPiecewiseList(this.getSymbIdList(_sb.getLocalVariables())));
        }
        for (PopulationParameter ppar : this.piecewisePopPars) {
            list.add(ppar);
        }
        list.addAll(this.piecewisePopPars);
        HashSet ls = new HashSet(list);
        return new ArrayList<PharmMLRootType>(ls);
    }

    List<VariableDefinition> getPiecewiseList(List<String> vars) {
        ArrayList<VariableDefinition> l0 = new ArrayList<VariableDefinition>();
        for (String sr : vars) {
            VariableDefinition var = this.getVariable(sr);
            if (var.getAssign() == null || var.getAssign().getPiecewise() == null) continue;
            l0.add(this.getVariable(sr));
        }
        return l0;
    }

    public static void setWinbugsDir(String winbugsDir) {
        Parser.winbugsDir = winbugsDir;
    }

    public static String getWinbugsDir() {
        return winbugsDir;
    }

    protected List<SymbolRef> getDerLeafs() {
        List<SymbolRef> list = this.odeParameters;
        List<Object> tmp = new ArrayList();
        ArrayList<SymbolRef> toRemove = new ArrayList<SymbolRef>();
        ArrayList<Object> toAdd = new ArrayList<Object>();
        list.addAll(this.completeList(this.odeParameters));
        list = Util.getUniqueSymbolRef(list);
        for (SymbolRef s : list) {
            if (this.isCovariate(s)) {
                tmp.clear();
                CovariateDefinition cov = this.getCovariate(s.getSymbIdRef());
                if (cov.getContinuous() != null && !cov.getContinuous().getListOfTransformation().isEmpty() && cov.getContinuous().getListOfTransformation().get(0) != null) {
                    tmp = this.getParSubList(cov);
                }
                if (tmp.isEmpty()) continue;
                toRemove.add(s);
                toAdd.addAll(tmp);
                continue;
            }
            tmp = this.parVariablesFromMap.get(s.getSymbIdRef());
            if (tmp != null && !tmp.isEmpty()) {
                toRemove.add(s);
                toAdd.addAll(tmp);
                continue;
            }
            tmp = new ArrayList();
        }
        list.removeAll(toRemove);
        list.addAll(toAdd);
        list = this.completeList(list);
        return Util.getUniqueSymbolRef(list);
    }

    protected List<SymbolRef> getPiecewiseLeafs(String id) {
        List<SymbolRef> list = new ArrayList<SymbolRef>();
        list.addAll((Collection)this.piecewiseParameters.get(id));
        List<Object> tmp = new ArrayList();
        ArrayList toRemove = new ArrayList();
        ArrayList<Object> toAdd = new ArrayList<Object>();
        list = Util.getUniqueSymbolRef(list);
        for (SymbolRef s : list) {
            tmp = this.parVariablesFromMap.get(s.getSymbIdRef());
            if (tmp != null && !tmp.isEmpty()) {
                toAdd.addAll(tmp);
                continue;
            }
            tmp = new ArrayList();
        }
        list.addAll(toAdd);
        list = this.completeList(list);
        return Util.getUniqueSymbolRef(list);
    }

    protected List<SymbolRef> getDerLeafs(List<SymbolRef> list) {
        List<Object> tmp = new ArrayList();
        ArrayList<SymbolRef> toRemove = new ArrayList<SymbolRef>();
        ArrayList<Object> toAdd = new ArrayList<Object>();
        list.addAll(this.completeList(list));
        list = Util.getUniqueSymbolRef(list);
        for (SymbolRef s : list) {
            tmp.clear();
            tmp = this.getParSubList(this.getVariable(s.getSymbIdRef()));
            if (!tmp.isEmpty()) {
                toRemove.add(s);
                toAdd.addAll(tmp);
            }
            if ((tmp = this.parVariablesFromMap.get(s.getSymbIdRef())) != null && !tmp.isEmpty()) {
                toAdd.addAll(tmp);
                continue;
            }
            tmp = new ArrayList();
        }
        list.removeAll(toRemove);
        list.addAll(toAdd);
        list = this.completeList(list);
        return Util.getUniqueSymbolRef(list);
    }

    private List<SymbolRef> getThetaParameters() {
        ArrayList<SymbolRef> list = new ArrayList<SymbolRef>();
        ArrayList<SymbolRef> toRemove = new ArrayList<SymbolRef>();
        for (SymbolRef s : this.stateV_Parameters) {
            if (this.parVariablesFromMap.containsKey(s.getSymbIdRef())) {
                for (SymbolRef s1 : this.parVariablesFromMap.get(s.getSymbIdRef())) {
                    if (this.parVariablesFromMap.containsKey(s1.getSymbIdRef())) continue;
                    if (!this.isCovariate(s1)) {
                        if (list.contains(s1)) continue;
                        list.add(s1);
                        continue;
                    }
                    if (this.covPascalList.contains(s1)) continue;
                    this.covPascalList.add(s1);
                }
                continue;
            }
            if (!this.isCovariate(s)) {
                if (list.contains(s)) continue;
                list.add(s);
                continue;
            }
            if (this.covPascalList.contains(s)) continue;
            this.covPascalList.add(s);
        }
        for (SymbolRef s : list) {
            if (s.getSymbIdRef().equals(((IndependentVariable)this.lexer.getDom().getListOfIndependentVariable().get(0)).getSymbId())) {
                toRemove.add(s);
                continue;
            }
            if (!this.isVariableDefinition(s.getSymbIdRef())) continue;
            toRemove.add(s);
        }
        list.removeAll(toRemove);
        return list;
    }

    private List<SymbolRef> getThetaParameters_NEW() {
        List<SymbolRef> list = this.leafOdeParameters;
        ArrayList<SymbolRef> toReturn = new ArrayList<SymbolRef>();
        ArrayList<SymbolRef> toRemove = new ArrayList<SymbolRef>();
        for (SymbolRef s : list) {
            if (!this.isCovariate(s)) {
                toReturn.add(s);
            }
            if (this.parVariablesFromMap.containsKey(s.getSymbIdRef())) {
                toRemove.add(s);
                continue;
            }
            if (!this.isVariableDefinition(s.getSymbIdRef())) continue;
            toRemove.add(s);
        }
        toReturn.removeAll(toRemove);
        return toReturn;
    }

    protected List<SymbolRef> getPiecewiseParameters_NEW(List<SymbolRef> list) {
        ArrayList<SymbolRef> toReturn = new ArrayList<SymbolRef>();
        ArrayList<SymbolRef> toRemove = new ArrayList<SymbolRef>();
        for (SymbolRef s : list) {
            toReturn.add(s);
            if (!this.parVariablesFromMap.containsKey(s.getSymbIdRef())) continue;
            toRemove.add(s);
        }
        toReturn.removeAll(toRemove);
        return toReturn;
    }

    protected List<SymbolRef> getPiecewiseParameters_Pascal(List<SymbolRef> list) {
        List<Object> tmp = new ArrayList();
        ArrayList toRemove = new ArrayList();
        ArrayList<Object> toAdd = new ArrayList<Object>();
        list = Util.getUniqueSymbolRef(list);
        for (SymbolRef s : list) {
            tmp = this.parVariablesFromMap.get(s.getSymbIdRef());
            if (tmp != null && !tmp.isEmpty()) {
                toAdd.addAll(tmp);
                continue;
            }
            tmp = new ArrayList();
        }
        list.removeAll(toRemove);
        list.addAll(toAdd);
        list = this.completeList(list);
        return Util.getUniqueSymbolRef(list);
    }

    private SymbolRef getEl(List<SymbolRef> l, String sym) {
        for (SymbolRef s : l) {
            if (!s.getSymbIdRef().equals(sym)) continue;
            return s;
        }
        return null;
    }

    private List<SymbolRef> getOdeUsedContCov() {
        List<SymbolRef> list = this.leafOdeParameters;
        ArrayList<SymbolRef> used = new ArrayList<SymbolRef>();
        for (SymbolRef s : list) {
            if (!this.isCovariate(s) || ((CovariateDefinition)this.lexer.getAccessor().fetchElement(s)).getContinuous() == null) continue;
            used.add(s);
        }
        return used;
    }

    private List<SymbolRef> getOdeUsedCatCov() {
        List<SymbolRef> list = this.leafOdeParameters;
        ArrayList<SymbolRef> used = new ArrayList<SymbolRef>();
        for (SymbolRef s : list) {
            if (!this.isCovariate(s) || ((CovariateDefinition)this.lexer.getAccessor().fetchElement(s)).getCategorical() == null) continue;
            used.add(s);
        }
        return used;
    }

    private List<SymbolRef> getPwUsedCov() {
        List<SymbolRef> list = this.leafPiecewiseParameters;
        ArrayList<SymbolRef> used = new ArrayList<SymbolRef>();
        for (SymbolRef s : list) {
            if (!this.isCovariate(s)) continue;
            used.add(s);
        }
        return used;
    }

    protected boolean isUsedCov(CovariateDefinition cov) {
        for (SymbolRef s : this.usedOdeContCovNames) {
            if (!s.getSymbIdRef().equals(cov.getSymbId())) continue;
            return true;
        }
        return false;
    }

    protected String getModelName() {
        return ConverterProvider.getModelName(this.xmlFileName);
    }

    private void printList(List<Object> list, String name) {
        if (!DEBUG) {
            return;
        }
        if (list.size() > 0) {
            if (list.get(0) instanceof VariableDefinition) {
                this.outDebug.println("----  " + list.size() + " " + name + " " + this.concatVars(list) + "\n");
            } else if (list.get(0) instanceof StructuralBlock) {
                this.outDebug.println("----  " + list.size() + " " + name + " " + this.concatSblocks(list) + "\n");
            } else {
                this.outDebug.println("----  " + list.size() + " " + name + " " + this.concat(list) + "\n");
            }
        } else {
            this.outDebug.println("----  " + list.size() + " " + name + "\n");
        }
    }

    private void printCompleteList(List<Object> list, String name) {
        if (!DEBUG) {
            return;
        }
        this.outDebug.println("----  " + list.size() + " " + name + " ");
        if (list.size() > 0) {
            if (list.get(0) instanceof CommonVariableDefinition) {
                for (CommonVariableDefinition commonVariableDefinition : list) {
                    this.outDebug.print(commonVariableDefinition.getSymbId() + " ");
                }
            } else if (list.get(0) instanceof SymbolRef) {
                for (SymbolRef symbolRef : list) {
                    this.outDebug.print(symbolRef.getId() + " ");
                }
            }
        }
        this.outDebug.println("");
    }

    private void updateCovariateLists() {
        for (SymbolRef cv : this.usedCovNames) {
            if (!Util.getList(this.usedOdeContCovNames).contains(cv.getSymbIdRef()) && this.isContinuousCovariate(cv)) {
                this.usedOdeContCovNames.add(cv);
                continue;
            }
            if (Util.getList(this.usedOdeCatCovNames).contains(cv.getSymbIdRef()) || !this.isCategoricalCovariate(cv)) continue;
            this.usedOdeCatCovNames.add(cv);
        }
    }

    protected void createUsefulStructures() throws UnsupportedDataTypeException {
        this.setModelName();
        VariabilityDefnBlock vmPrior = null;
        for (VariabilityDefnBlock variabilityDefnBlock : this.lexer.getDom().getModelDefinition().getListOfVariabilityModel()) {
            if (!variabilityDefnBlock.getType().value().equals("parameterVariability")) continue;
            vmPrior = variabilityDefnBlock;
            break;
        }
        if (vmPrior == null) {
            System.err.println("No priors provided");
        } else {
            List varLevDef = vmPrior.getLevel();
            for (VariabilityLevelDefinition variabilityLevelDefinition : varLevDef) {
                if (variabilityLevelDefinition.getParentLevel() != null) continue;
                this.priorLevel = variabilityLevelDefinition;
            }
        }
        this.completeStateVariablesList = new ArrayList<DerivativeVariable>();
        this.stateVariablesStructuralBlockList = new ArrayList<StructuralBlock>();
        boolean bl = this.hasCovariate = this.lexer.getCovariates().size() > 0;
        if (DEBUG) {
            this.outDebug.println("----  " + this.lexer.getCovariates().size() + " covariates ");
            for (CovariateDefinition covariateDefinition : this.lexer.getCovariates()) {
                this.outDebug.print(covariateDefinition.getSymbId() + " ");
            }
            this.outDebug.println("");
        }
        for (StructuralBlock structuralBlock : this.lexer.getStructuralBlocks()) {
            this.hasDiffEquations = structuralBlock.getStateVariables().size() > 0;
        }
        for (StructuralBlock structuralBlock : this.lexer.getStructuralBlocks()) {
            this.completeStateVariablesList.addAll(structuralBlock.getStateVariables());
            this.stateV_Parameters = this.getAllCommonTypesList(structuralBlock.getStateVariables());
            this.simpleP_Parameters = this.getAllCommonTypesList(structuralBlock.getParameters());
            this.localV_Parameters = this.getAllCommonTypesList(structuralBlock.getLocalVariables());
            List<ParameterBlock> pbs = this.getParameterBlocks();
            for (ParameterBlock pb : pbs) {
                this.indivV_Parameters = this.getAllCommonTypesList(pb.getIndividualParameters());
                this.simpleP_Parameters.addAll(this.getAllCommonTypesList(pb.getParameters()));
                this.randVar_Parameters.addAll(this.getAllCommonTypesList(pb.getRandomVariables()));
            }
            ArrayList<SymbolRef> covVarList = new ArrayList<SymbolRef>();
            covVarList.addAll(this.getAllCommonTypesList(this.lexer.getCovariates()));
            this.stateV_Parameters = this.completeList(this.stateV_Parameters);
            this.indivV_Parameters = this.completeList(this.indivV_Parameters);
            this.outDebug.println("");
            this.printList(this.stateV_Parameters, "stateV_Parameters");
            this.printList(this.indivV_Parameters, "indivV_Parameters");
            this.simpleP_Parameters = this.completeList(this.simpleP_Parameters);
            this.localV_Parameters = this.completeList(this.localV_Parameters);
            this.printList(this.simpleP_Parameters, "simpleP_Parameters");
            this.printList(this.localV_Parameters, "localV_Parameters");
            this.stateVariablesStructuralBlockList.add(structuralBlock);
            this.piecewiseVariables.addAll(this.getPiecewiseList(this.getSymbIdList(structuralBlock.getLocalVariables())));
            this.printList(this.stateVariablesStructuralBlockList, "stateVariablesStructuralBlockList");
            this.printList(this.piecewiseVariables, "piecewiseVariables");
            this.piecewiseCompleteList = this.getPiecewiseList();
            if (!(this instanceof PascalParser)) continue;
            String id = "";
            this.odeParameters.addAll(this.getAllDerLeafVariable(structuralBlock.getStateVariables()));
            for (PharmMLRootType pw : this.piecewiseCompleteList) {
                if (pw instanceof VariableDefinition) {
                    id = ((VariableDefinition)pw).getSymbId();
                } else if (pw instanceof PopulationParameter) {
                    id = ((PopulationParameter)pw).getSymbId();
                }
                ArrayList<String> srl = new ArrayList<String>();
                srl.add(id);
                this.piecewiseParameters.put(id, this.getAllPiecewiseLeafVariable(srl));
            }
            this.odeParameters1.addAll(this.getDerPurgedList(this.odeParameters));
            List<VariableDefinition> vl = this.getVariables(structuralBlock);
            List sbl = structuralBlock.getLocalVariables();
            this.odeParameters1.addAll(this.getAllVarLeafVariable(vl));
            this.odeParameters2.addAll(this.getAllVarLeafVariable(sbl));
        }
        this.odeParameters = Util.getUniqueSymbolRef(this.odeParameters);
        this.odeParameters1 = Util.getUniqueSymbolRef(this.odeParameters1);
        this.odeParameters2 = Util.getUniqueSymbolRef(this.odeParameters2);
        this.piecewiseParameters2 = Util.getUniqueSymbolRef(this.piecewiseParameters2);
        this.printList(this.odeParameters, "odeParameters");
        this.printList(this.odeParameters1, "odeParameters1");
        this.printList(this.odeParameters2, "odeParameters2");
        this.odeParametersOld.addAll(this.odeParameters);
        for (Map.Entry entry : this.piecewiseParameters.entrySet()) {
            this.printList((List)entry.getValue(), "piecewiseParameters di " + (String)entry.getKey());
        }
        this.printList(this.piecewiseParameters2, "piecewiseParameters2");
        this.printCompleteList(this.piecewiseCompleteList, "piecewiseCompleteList");
        if (this instanceof PascalParser) {
            this.leafOdeParameters = this.getDerLeafs();
            for (Map.Entry entry : this.piecewiseParameters.entrySet()) {
                this.leafPiecewiseParameters.addAll(this.getPiecewiseLeafs((String)entry.getKey()));
            }
            this.leafPiecewiseParameters = Util.getUniqueSymbolRef(this.leafPiecewiseParameters);
            this.printList(this.leafOdeParameters, "leafOdeParameters");
            this.printList(this.leafPiecewiseParameters, "leafPiecewiseParameters");
            this.theta_Parameters = this.getThetaParameters_NEW();
            for (Object object : this.piecewiseCompleteList) {
                String id = this.getId(object);
                this.piecewiseLeafParameters.put(id, this.getPiecewiseParameters_NEW(this.piecewiseParameters.get(id)));
            }
            this.theta_Parameters = Util.getUniqueSymbolRef(this.theta_Parameters);
            this.printList(this.theta_Parameters, "theta_Parameters");
            for (Map.Entry entry : this.piecewiseLeafParameters.entrySet()) {
                this.printList((List)entry.getValue(), "piecewiseLeafParameters di " + (String)entry.getKey());
            }
            boolean isOdeCovDep = false;
            for (CovariateDefinition cd : this.lexer.getCovariates()) {
                if (!this.isInList((Object)cd, this.odeParameters) && !this.isInList((Object)cd, this.odeParameters1) && !this.isInList((Object)cd, this.odeParameters2) && !this.isInList((Object)cd, this.theta_Parameters) && !this.isInList((Object)cd, this.covPascalList) && !this.isInList((Object)cd, this.leafOdeParameters)) continue;
                isOdeCovDep = true;
                break;
            }
            for (CovariateDefinition cd : this.lexer.getCovariates()) {
                if (cd.getContinuous() == null || cd.getContinuous().getListOfTransformation().isEmpty()) continue;
                CovariateTransformation ts = (CovariateTransformation)cd.getContinuous().getListOfTransformation().get(0);
                String sym = ts.getTransformedCovariate().getSymbId();
                if (!Parser.isInList(Util.getList(this.odeParameters), sym) && !Parser.isInList(Util.getList(this.odeParameters1), sym) && !Parser.isInList(Util.getList(this.odeParameters2), sym) && !Parser.isInList(Util.getList(this.theta_Parameters), sym) && !Parser.isInList(Util.getList(this.covPascalList), sym) && !Parser.isInList(Util.getList(this.leafOdeParameters), sym)) continue;
                isOdeCovDep = true;
                break;
            }
            this.usedOdeContCovNames = this.getOdeUsedContCov();
            this.usedOdeCatCovNames = this.getOdeUsedCatCov();
            this.usedPwCovNames = this.getPwUsedCov();
            this.printList(this.usedOdeContCovNames, "usedOdeCovNames");
            this.printList(this.usedPwCovNames, "usedPwCovNames");
            this.hasCovariate = isOdeCovDep && (!this.usedOdeContCovNames.isEmpty() || !this.usedOdeCatCovNames.isEmpty());
            List<SymbolRef> list = this.getThetaParameters_NEW();
            if (DEBUG) {
                this.outDebug.println("----  " + list.size() + " thetaTest " + this.concat(list) + "\n");
                if (list.size() != this.theta_Parameters.size()) {
                    this.outDebug.println("*** ERROR ***");
                }
                this.outDebug.println("----  " + this.parVariablesFromMap.size() + " Variables Map ");
                for (Map.Entry<String, List<SymbolRef>> v : this.parVariablesFromMap.entrySet()) {
                    this.outDebug.print(String.format("\n\t %s:\n\t\t", v.getKey()));
                    for (SymbolRef sr : v.getValue()) {
                        this.outDebug.print(sr.getSymbIdRef() + " ");
                    }
                }
                this.outDebug.println("");
            }
        }
    }

    String getId(Object o) {
        if (o instanceof VariableDefinition) {
            return ((VariableDefinition)o).getSymbId();
        }
        if (o instanceof IndividualParameter) {
            return ((IndividualParameter)o).getSymbId();
        }
        if (o instanceof CommonVariableDefinition) {
            return ((CommonVariableDefinition)o).getSymbId();
        }
        if (o instanceof PopulationParameter) {
            return ((PopulationParameter)o).getSymbId();
        }
        if (o instanceof ParameterRandomVariable) {
            return ((ParameterRandomVariable)o).getSymbId();
        }
        if (o instanceof VariableDefinition) {
            return ((VariableDefinition)o).getSymbId();
        }
        return "@";
    }

    protected List<SymbolRef> getAllDerLeafVariable(List<DerivativeVariable> derivatives) {
        ArrayList<SymbolRef> list = new ArrayList<SymbolRef>();
        List<Object> subList = new ArrayList();
        for (DerivativeVariable dv : derivatives) {
            if (dv.getAssign() != null) {
                subList = this.getParSubList(dv.getAssign());
            }
            list.addAll(subList);
        }
        return Util.getUniqueSymbolRef(list);
    }

    protected List<SymbolRef> getAllPiecewiseLeafVariable(List<String> vars) {
        List<SymbolRef> list = new ArrayList<SymbolRef>();
        List<Object> subList = new ArrayList();
        for (String dv : vars) {
            VariableDefinition v;
            if (this.getVariable(dv) instanceof VariableDefinition) {
                v = this.getVariable(dv);
                subList = this.getParSubList(v.getAssign());
            } else if (this.getPopulationParameter(dv) instanceof PopulationParameter) {
                v = this.getPopulationParameter(dv);
                subList = this.getParSubList(v.getAssign());
            }
            list.addAll(subList);
        }
        list = this.completeList(list);
        return Util.getUniqueSymbolRef(list);
    }

    protected List<SymbolRef> getAllVarLeafVariable(List<VariableDefinition> vars) {
        ArrayList<SymbolRef> list = new ArrayList<SymbolRef>();
        List<Object> subList = new ArrayList();
        for (VariableDefinition vd : vars) {
            if (vd.getAssign() != null) {
                subList = this.getParSubList(vd.getAssign());
            }
            list.addAll(subList);
        }
        return Util.getUniqueSymbolRef(list);
    }

    protected List<SymbolRef> getAllParLeafVariable(List<PopulationParameter> pars) {
        ArrayList<SymbolRef> list = new ArrayList<SymbolRef>();
        List<Object> subList = new ArrayList();
        for (PopulationParameter sp : pars) {
            if (sp.getAssign() != null) {
                subList = this.getParSubList(sp.getAssign());
            }
            list.addAll(subList);
        }
        return Util.getUniqueSymbolRef(list);
    }

    private List<SymbolRef> getDerPurgedList(List<SymbolRef> list) {
        ArrayList<SymbolRef> toRemove = new ArrayList<SymbolRef>();
        for (SymbolRef s : list) {
            if (!this.isDerivativeVar(s.getSymbIdRef())) continue;
            toRemove.add(s);
        }
        list.removeAll(toRemove);
        return Util.getUniqueSymbolRef(list);
    }

    private List<SymbolRef> getPiecewisePurgedList(List<SymbolRef> list) {
        ArrayList<SymbolRef> toRemove = new ArrayList<SymbolRef>();
        for (SymbolRef s : list) {
            if (!this.isPiecewiseVar(s.getSymbIdRef())) continue;
            toRemove.add(s);
        }
        list.removeAll(toRemove);
        return Util.getUniqueSymbolRef(list);
    }

    protected void updatepiecewiseIndexMap(String id) {
        if (this.piecewiseIndexMap.get(id) == null && !this.piecewiseIndexMap.containsKey(id)) {
            this.piecewiseIndexMap.put(id, ++this.pwNum);
        }
    }

    protected List<SymbolRef> getAllCommonTypesList(List<PharmMLRootType> t) throws UnsupportedDataTypeException {
        ArrayList<SymbolRef> list = new ArrayList<SymbolRef>();
        List<Object> subList = new ArrayList();
        if (t == null) {
            return list;
        }
        for (PharmMLRootType element : t) {
            CovariateTransformation covT;
            List parList;
            if (element instanceof IndependentVariable) continue;
            if (element instanceof PopulationParameter) {
                PopulationParameter sp = (PopulationParameter)element;
                if (sp.getAssign() != null && sp.getAssign().getPiecewise() != null) {
                    this.piecewisePopPars.add(sp);
                    this.updatepiecewiseIndexMap(sp.getSymbId());
                }
                if (sp.getDistribution() != null) {
                    subList = new ArrayList();
                    parList = sp.getDistribution().getProbOnto().getListOfParameter();
                    for (DistributionParameter dp : parList) {
                        subList.addAll(this.getParSubList(dp.getAssign()));
                    }
                    this.randVariablesFromMap.put(sp.getSymbId(), subList);
                }
                if ((subList = this.getParSubList(sp)).size() > 0) {
                    this.parVariablesFromMap.put(sp.getSymbId(), subList);
                }
            } else if (element instanceof IndividualParameter) {
                IndividualParameter ip = (IndividualParameter)element;
                subList = this.getParSubList(ip);
                if (subList.size() > 0) {
                    this.parVariablesFromMap.put(ip.getSymbId(), subList);
                }
                if (ip.getDistribution() != null) {
                    subList = new ArrayList();
                    parList = ip.getDistribution().getProbOnto().getListOfParameter();
                    for (DistributionParameter dp : parList) {
                        subList.addAll(this.getParSubList(dp.getAssign()));
                    }
                    this.randVariablesFromMap.put(ip.getSymbId(), subList);
                }
            } else if (element instanceof VariableDefinition) {
                VariableDefinition vd = (VariableDefinition)element;
                subList = this.getParSubList(vd);
                if (subList.size() > 0) {
                    this.parVariablesFromMap.put(vd.getSymbId(), subList);
                }
            } else if (element instanceof CovariateTransformation) {
                covT = (CovariateTransformation)element;
                subList = this.getParSubList(covT);
                if (subList.size() > 0) {
                    this.parVariablesFromMap.put(covT.getTransformedCovariate().getSymbId(), subList);
                }
            } else if (element instanceof CovariateDefinition) {
                CovariateDefinition cov = (CovariateDefinition)element;
                String id = cov.getSymbId();
                if (cov.getContinuous() != null && !cov.getContinuous().getListOfTransformation().isEmpty()) {
                    covT = (CovariateTransformation)cov.getContinuous().getListOfTransformation().get(0);
                    id = covT.getTransformedCovariate().getSymbId();
                }
                if ((subList = this.getParSubList(cov)).size() > 0) {
                    this.parVariablesFromMap.put(id, subList);
                }
            } else if (element instanceof DerivativeVariable) {
                DerivativeVariable dv = (DerivativeVariable)element;
                this.doDerivativeRef(dv.getSymbId());
                subList = this.getParSubList(dv);
                if (subList.size() > 0) {
                    this.parVariablesFromMap.put(dv.getSymbId(), subList);
                }
            } else if (element instanceof ParameterRandomVariable) {
                ParameterRandomVariable rv = (ParameterRandomVariable)element;
                this.doRandomVariable(rv);
                subList = new ArrayList();
                if (rv.getDistribution() != null) {
                    parList = rv.getDistribution().getProbOnto().getListOfParameter();
                    for (DistributionParameter dp : parList) {
                        subList.addAll(this.getParSubList(dp.getAssign()));
                    }
                    this.randVariablesFromMap.put(rv.getSymbId(), subList);
                }
            } else {
                throw new UnsupportedDataTypeException(t.getClass().getSimpleName());
            }
            list.addAll(subList);
        }
        List<SymbolRef> newList = Util.getUniqueSymbolRef(list);
        return newList;
    }

    List<SymbolRef> completeList(List<SymbolRef> l) {
        ArrayList<SymbolRef> completeList = new ArrayList<SymbolRef>();
        completeList.addAll(l);
        ArrayList<SymbolRef> tmpList = new ArrayList<SymbolRef>();
        do {
            tmpList.clear();
            for (SymbolRef sr : completeList) {
                List<SymbolRef> currList = this.parVariablesFromMap.get(sr.getSymbIdRef());
                if (currList == null) continue;
                for (SymbolRef r : currList) {
                    if (completeList.contains(r) || this.isIndependentVariableSym(r.getSymbIdRef())) continue;
                    tmpList.add(r);
                }
            }
            l = tmpList;
            completeList.addAll(Util.getUniqueSymbolRef(tmpList));
        } while (!tmpList.isEmpty());
        completeList.addAll(tmpList);
        return Util.getUniqueSymbolRef(completeList);
    }

    List<String> completeIdList(List<String> l) {
        ArrayList<String> completeList = new ArrayList<String>();
        completeList.addAll(l);
        ArrayList<String> tmpList = new ArrayList<String>();
        do {
            tmpList.clear();
            for (String sr : l) {
                List<String> currList;
                if (this.parVariablesFromMap.get(sr) == null || (currList = Util.getList(this.parVariablesFromMap.get(sr))) == null || currList.size() <= 0) continue;
                for (String r : currList) {
                    if (completeList.contains(r) || this.isIndependentVariableSym(r)) continue;
                    tmpList.add(r);
                }
            }
            l = tmpList;
            completeList.addAll(Util.getUniqueString(tmpList));
        } while (!tmpList.isEmpty());
        completeList.addAll(tmpList);
        return Util.getUniqueString(completeList);
    }

    List<SymbolRef> getFunParameters(FunctionCallType fun) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        for (FunctionCallType.FunctionArgument arg : fun.getListOfFunctionArgument()) {
            if (arg.getSymbRef() != null) {
                subList.add(arg.getSymbRef());
                continue;
            }
            if (arg.getAssign() == null) continue;
            subList.addAll(this.getParSubList(arg.getAssign()));
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(Rhs eq) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        if (eq.getBinop() != null) {
            subList.addAll(this.getJaXBParList(this.getBinopContent(eq.getBinop())));
        } else if (eq.getUniop() != null) {
            subList.addAll(this.getParSubList(eq.getUniop()));
        } else if (eq.getSymbRef() != null) {
            subList.add(eq.getSymbRef());
        } else if (eq.getMatrixUniop() != null) {
            subList.addAll(this.getParSubList((ExpressionValue)eq.getMatrixUniop()));
        } else if (eq.getFunctionCall() != null) {
            subList.addAll(this.getFunParameters(eq.getFunctionCall()));
        } else if (eq.getPiecewise() != null) {
            subList.addAll(this.getParSubList(eq.getPiecewise()));
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(Equation eq) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        if (eq.getBinop() != null) {
            subList.addAll(this.getJaXBParList(this.getBinopContent(eq.getBinop())));
        } else if (eq.getUniop() != null) {
            subList.addAll(this.getParSubList(eq.getUniop()));
        } else if (eq.getSymbRef() != null) {
            subList.add(eq.getSymbRef());
        } else if (eq.getFunctionCall() != null) {
            subList.addAll(this.getFunParameters(eq.getFunctionCall()));
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(ExpressionValue ev) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        if (ev instanceof Binop) {
            subList.addAll(this.getJaXBParList(this.getBinopContent((Binop)ev)));
        } else if (ev instanceof Uniop) {
            subList.addAll(this.getParSubList((Uniop)ev));
        } else if (ev instanceof SymbolRef) {
            subList.add((SymbolRef)ev);
        } else if (ev instanceof MatrixUniOp) {
            subList.addAll(this.getJaXBParList(this.getMatrixContent((MatrixUniOp)ev)));
        } else if (ev instanceof FunctionCallType) {
            subList.addAll(this.getFunParameters((FunctionCallType)ev));
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(Uniop uOp) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        ExpressionValue ev = uOp.getValue();
        if (ev instanceof Binop) {
            subList.addAll(this.getJaXBParList(this.getBinopContent((Binop)uOp.getValue())));
        } else if (ev instanceof Uniop) {
            subList.addAll(this.getParSubList((Uniop)uOp.getValue()));
        } else if (ev instanceof SymbolRef) {
            subList.add((SymbolRef)ev);
        } else if (ev instanceof FunctionCallType) {
            subList.addAll(this.getFunParameters((FunctionCallType)ev));
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(Piecewise pw) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        for (Piece piece : pw.getPiece()) {
            ExpressionValue pv = piece.getValue();
            subList.addAll(this.getParSubList(pv));
            Condition pc = piece.getCondition();
            if (pc.getLogicBinop() != null) {
                List content = pc.getLogicBinop().getContent();
                for (JAXBElement el : content) {
                    subList.addAll(this.getParSubList(el));
                }
                continue;
            }
            if (pc.getLogicUniop() == null) continue;
        }
        return Util.getUniqueSymbolRef(subList);
    }

    protected List<SymbolRef> getParSubList(JAXBElement je) {
        return this.getParSubList(je.getValue());
    }

    protected List<SymbolRef> getParSubList(Object o) {
        ArrayList<SymbolRef> list0 = new ArrayList<SymbolRef>();
        if (o instanceof Uniop) {
            return this.getParSubList(((Uniop)o).getValue());
        }
        if (o instanceof PopulationParameter) {
            return this.getParSubList((PopulationParameter)o);
        }
        if (o instanceof IndividualParameter) {
            return this.getParSubList((IndividualParameter)o);
        }
        if (o instanceof DerivativeVariable) {
            return this.getParSubList((DerivativeVariable)o);
        }
        if (o instanceof CovariateDefinition) {
            return this.getParSubList((CovariateDefinition)o);
        }
        if (o instanceof ContinuousCovariate) {
            return this.getParSubList((ContinuousCovariate)o);
        }
        if (o instanceof Rhs) {
            return this.getParSubList((Rhs)o);
        }
        if (o instanceof VariableDefinition) {
            return this.getParSubList((VariableDefinition)o);
        }
        if (o instanceof Binop) {
            return this.getParSubList((ExpressionValue)((Binop)o));
        }
        if (o instanceof FunctionCallType) {
            return this.getParSubList((ExpressionValue)((FunctionCallType)o));
        }
        if (o instanceof Piecewise) {
            return this.getParSubList((Piecewise)o);
        }
        if (o instanceof Distribution) {
            return this.getParSubList((Distribution)o);
        }
        if (o instanceof SymbolRef) {
            list0.add((SymbolRef)o);
            return list0;
        }
        if (o instanceof IntValue) {
            return list0;
        }
        if (o instanceof CategoryRef) {
            return list0;
        }
        throw new UnsupportedOperationException(o.getClass().getSimpleName());
    }

    protected List<SymbolRef> getParSubList(PopulationParameter sp) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        if (sp.getDistribution() != null && sp.getDistribution().getProbOnto() != null) {
            ProbOnto value = sp.getDistribution().getProbOnto();
            List parList = value.getListOfParameter();
        } else if (sp.getAssign() != null) {
            subList.addAll(this.getParSubList(sp.getAssign()));
        } else if (sp.getAssign().getSymbRef() != null) {
            subList.add(sp.getAssign().getSymbRef());
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(DerivativeVariable der) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        if (der.getAssign() != null) {
            if (der.getAssign() != null) {
                subList.addAll(this.getParSubList(der.getAssign()));
            } else if (der.getAssign().getSymbRef() != null) {
                subList.add(der.getAssign().getSymbRef());
            }
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(IndividualParameter ip) {
        StructuredModel.GeneralCovariate ipGC = null;
        String transf = null;
        StructuredModel ipGM = ip.getStructuredModel();
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        if (ipGM != null) {
            subList.add((SymbolRef)((ParameterRandomEffect)ipGM.getListOfRandomEffects().get(0)).getSymbRef().get(0));
        }
        if (ip.getAssign() != null) {
            subList.addAll(this.getParSubList(ip.getAssign()));
        } else if (ipGM != null) {
            ipGC = ipGM.getGeneralCovariate();
            StructuredModel.LinearCovariate ipLC = ipGM.getLinearCovariate();
            if (ipGC != null) {
                if (ipGC.getAssign() != null) {
                    subList.addAll(this.getParSubList(ipGC.getAssign()));
                }
            } else if (ipLC != null) {
                StructuredModel.LinearCovariate.PopulationValue pp = ipLC.getPopulationValue();
                List cov = ipLC.getListOfCovariate();
                subList.addAll(this.getParSubList(pp.getAssign()));
                if (cov.size() > 0) {
                    for (CovariateRelation c : cov) {
                        for (FixedEffectRelation fe : c.getListOfFixedEffect()) {
                            if (fe.getSymbRef() != null) {
                                subList.add(fe.getSymbRef());
                            }
                            if (c.getSymbRef() == null) continue;
                            subList.add(c.getSymbRef());
                        }
                    }
                }
            }
            if (ipGM.getTransformation() != null && (transf = ipGM.getTransformation().getType().toString().toLowerCase()).equals("identity")) {
                transf = null;
            }
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(VariableDefinition var) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        if (var != null && var.getAssign() != null) {
            if (var.getAssign() != null) {
                subList.addAll(this.getParSubList(var.getAssign()));
            } else if (var.getAssign().getSymbRef() != null) {
                subList.add(var.getAssign().getSymbRef());
            }
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(Distribution var) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        List dpList = var.getProbOnto().getListOfParameter();
        for (DistributionParameter dp : dpList) {
            subList.addAll(this.getParSubList(dp));
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(CovariateDefinition cov) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        ContinuousCovariate cc = cov.getContinuous();
        CovariateTransformation ct = null;
        if (cc != null && !cc.getListOfTransformation().isEmpty() && (ct = (CovariateTransformation)cov.getContinuous().getListOfTransformation().get(0)) != null && ct.getAssign() != null) {
            subList.addAll(this.getParSubList(ct.getAssign()));
        }
        return subList;
    }

    protected List<SymbolRef> getParSubList(CategoricalCovariate cov) {
        ArrayList<SymbolRef> subList = new ArrayList<SymbolRef>();
        List<CategoryRef_> list = this.categoricalMap.get(cov.getId());
        return subList;
    }

    protected List<SymbolRef> getJaXBParList(List<JAXBElement<?>> cont) {
        ArrayList<SymbolRef> list0 = new ArrayList<SymbolRef>();
        if (cont != null) {
            for (JAXBElement<?> c : cont) {
                list0.addAll(this.getJaXBParList(c));
            }
        }
        return list0;
    }

    private List<SymbolRef> getJaXBParList(JAXBElement<?> c) {
        ArrayList<SymbolRef> list0 = new ArrayList<SymbolRef>();
        Object el = c.getValue();
        if (el instanceof SymbolRef) {
            if (!this.isDerivativeVar(((SymbolRef)el).getSymbIdRef()) || this.isRandomVar(((SymbolRef)el).getSymbIdRef())) {
                list0.add((SymbolRef)el);
            }
            if (this.isDerivativeVar(((SymbolRef)el).getSymbIdRef()) && Util.getList(this.piecewiseParameters2).contains(((SymbolRef)el).getSymbIdRef())) {
                list0.add((SymbolRef)el);
            }
        } else if (el instanceof Binop) {
            list0.addAll(this.getJaXBParList(this.getBinopContent((Binop)el)));
        } else if (el instanceof Uniop) {
            list0.addAll(this.getParSubList((Uniop)el));
        } else if (el instanceof FunctionCallType) {
            list0.addAll(this.getFunParameters((FunctionCallType)el));
        }
        return list0;
    }

    protected boolean isodeParIndividual() {
        for (SymbolRef s : this.odeParameters) {
            if (!this.lexer.isIndividualParameter_(s.getSymbIdRef())) continue;
            return true;
        }
        return false;
    }

    protected boolean isDerivativeDependentVariable(String s) {
        for (DerivativeVariable var : this.completeStateVariablesList) {
            if (!var.getSymbId().equals(s)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInOdeParameters1(ObservationParameter v) {
        for (SymbolRef sr : this.odeParameters1) {
            if (!sr.getSymbIdRef().equals(this.extract(v.getName()))) continue;
            return true;
        }
        return false;
    }

    protected static boolean isInList(List<SymbolRef> list, SymbolRef s) {
        for (SymbolRef s0 : list) {
            if (!s0.getSymbIdRef().equals(s.getSymbIdRef())) continue;
            return true;
        }
        return false;
    }

    protected static boolean isInList(List<String> list, String s) {
        for (String s0 : list) {
            if (!s0.equals(s)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getSymbIdList(List<VariableDefinition> list) {
        ArrayList<String> sList = new ArrayList<String>();
        for (VariableDefinition sr : list) {
            sList.add(sr.getSymbId());
        }
        return sList;
    }

    protected List<String> getPopSymbIdList(List<PopulationParameter> list) {
        ArrayList<String> sList = new ArrayList<String>();
        for (PopulationParameter sr : list) {
            sList.add(sr.getSymbId());
        }
        return sList;
    }

    protected boolean isInList(Object o, List<SymbolRef> l) {
        String id1 = "";
        for (SymbolRef s : l) {
            String id0 = s.getSymbIdRef();
            if (o instanceof IndividualParameter) {
                id1 = ((IndividualParameter)o).getSymbId();
            } else if (o instanceof VariableDefinition) {
                id1 = ((VariableDefinition)o).getSymbId();
            } else if (o instanceof PopulationParameter) {
                id1 = ((PopulationParameter)o).getSymbId();
            } else if (o instanceof CovariateDefinition) {
                id1 = ((CovariateDefinition)o).getSymbId();
            } else if (o instanceof CovariateTransformation) {
                id1 = ((CovariateTransformation)o).getTransformedCovariate().getSymbId();
            }
            if (!id0.equals(id1)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInList(Object o, Map<String, List<SymbolRef>> l) {
        String id1 = "";
        for (Map.Entry<String, List<SymbolRef>> pair : l.entrySet()) {
            List<SymbolRef> list = pair.getValue();
            for (SymbolRef s : list) {
                String id0 = s.getSymbIdRef();
                if (o instanceof IndividualParameter) {
                    id1 = ((IndividualParameter)o).getSymbId();
                } else if (o instanceof VariableDefinition) {
                    id1 = ((VariableDefinition)o).getSymbId();
                } else if (o instanceof PopulationParameter) {
                    id1 = ((PopulationParameter)o).getSymbId();
                } else if (o instanceof CovariateDefinition) {
                    id1 = ((CovariateDefinition)o).getSymbId();
                }
                if (!id0.equals(id1)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isInNameList(List<String> list, String s) {
        for (String s0 : list) {
            if (!s0.equals(s)) continue;
            return true;
        }
        return false;
    }

    private Object parseObservationErrorModel(Object context, PharmMLRootType pt) {
        Object res = context;
        if (context instanceof PharmMLRootType) {
            PharmMLRootType o = (PharmMLRootType)context;
            if (o instanceof Binop) {
                Binop bin = (Binop)o;
                this.reversePolishStack.add(bin);
                res = this.parseObservationErrorModel(bin.getOperand1(), (PharmMLRootType)bin);
                res = this.parseObservationErrorModel(bin.getOperand2(), (PharmMLRootType)bin);
            } else if (o instanceof Rhs) {
                res = this.parseObservationErrorModel(this.getNotNull(o), null);
            } else if (o instanceof Equation) {
                res = this.parseObservationErrorModel(this.getNotNull(o), null);
            } else if (o instanceof Uniop) {
                res = this.parseObservationErrorModel(this.getNotNull(o), (PharmMLRootType)((Uniop)o));
                this.reversePolishStack.add(o);
                this.reversePolishStack.add(this.getNotNull(o));
            } else if (o instanceof SymbolRef) {
                SymbolRef ref = (SymbolRef)o;
                this.reversePolishStack.add(o);
                if (this.isRandomVar(ref.getSymbIdRef())) {
                    this.outDebug.println("parametro " + o.getClass() + " id " + o.getId());
                    this.outDebug.println("variabile " + ref.getSymbIdRef() + " random");
                    this.outDebug.println("pt " + pt.getId());
                    return o;
                }
                return null;
            }
        } else if (context instanceof JAXBElement) {
            JAXBElement el = (JAXBElement)context;
            if (el.getValue() instanceof SymbolRef) {
                SymbolRef refVar = (SymbolRef)el.getValue();
                this.reversePolishStack.add(refVar);
                if (this.isRandomVar(refVar.getSymbIdRef())) {
                    if (DEBUG) {
                        this.outDebug.println("\nJAXB - RANDOM \"" + refVar.getSymbIdRef() + "\"");
                    }
                    return context;
                }
                if (DEBUG) {
                    this.outDebug.println("\nJAXB - ALGEBRICA \"" + refVar.getSymbIdRef() + "\"");
                }
                return null;
            }
            if (el.getValue() instanceof Binop) {
                Binop bin = (Binop)el.getValue();
                this.reversePolishStack.add(bin);
                res = this.parseObservationErrorModel(bin.getOperand1(), (PharmMLRootType)bin);
                res = this.parseObservationErrorModel(bin.getOperand2(), (PharmMLRootType)bin);
            } else if (el.getValue() instanceof Uniop) {
                Uniop uniop = (Uniop)el.getValue();
                this.reversePolishStack.add(uniop);
                res = this.parseObservationErrorModel(uniop.toJAXBElement(), (PharmMLRootType)uniop);
            }
        }
        return res;
    }

    private Object getNotNull(PharmMLRootType ob) {
        return ob;
    }

    private boolean isNormalDistribution(AbstractContinuousUnivariateDistributionType d) {
        return d instanceof NormalDistributionType;
    }

    private String getDistName(Object context) {
        if (context instanceof ParameterRandomVariable) {
            Distribution dist = ((ParameterRandomVariable)context).getDistribution();
            if (dist.getUncertML() != null) {
                if (dist.getUncertML().getAbstractContinuousUnivariateDistribution() != null) {
                    return dist.getUncertML().getAbstractContinuousUnivariateDistribution().getName().toString();
                }
                return ((ProbOnto)context).getName().value();
            }
            if (dist.getProbOnto() != null) {
                return dist.getProbOnto().getName().value();
            }
        } else if (context instanceof StructuredObsError) {
            String s = ((StructuredObsError)context).getResidualError().getSymbRef().getSymbIdRef();
            if (this.isRandomVar(s)) {
                ParameterRandomVariable rv = this.getRandomVar(s);
                BinaryTree tmp = this.lexer.getStatement((Object)rv);
                if (((Node)tmp.nodes.get((int)0)).data instanceof ProbOnto) {
                    return ((ProbOnto)((Node)tmp.nodes.get((int)0)).data).getName().value();
                }
                if (((Node)tmp.nodes.get((int)0)).data instanceof AbstractContinuousUnivariateDistributionType) {
                    return rv.getDistribution().getUncertML().getAbstractContinuousUnivariateDistribution().getName().toString();
                }
            } else {
                return ((ProbOnto)context).getName().value();
            }
        }
        return "Distribution unknown";
    }

    private String getDistName(ProbOnto context) {
        String name;
        switch (name = context.getName().value()) {
            case "Normal1": 
            case "Normal2": 
            case "Normal3": {
                return "dnorm";
            }
            case "Beta1": {
                return "dbeta";
            }
            case "Exponential1": 
            case "Exponential2": {
                return "dexp";
            }
            case "Gamma1": 
            case "Gamma2": 
            case "InverseGamma1": {
                return "dgamma";
            }
            case "LogNormal1": 
            case "LogNormal2": 
            case "LogNormal3": 
            case "LogNormal4": 
            case "LogNormal5": 
            case "LogNormal6": {
                return "dlnorm";
            }
            case "StudentT1": 
            case "StudentT2": {
                return "dt";
            }
            case "Uniform1": {
                return "dunif";
            }
            case "Weibull1": 
            case "Weibull2": {
                return "dweib";
            }
            case "Wishart1": 
            case "Wishart2": 
            case "InverseWishart1": 
            case "InverseWishart2": {
                return "dwish";
            }
            case "MultivariateNormal1": 
            case "MultivariateNormal2": {
                return "dmnorm";
            }
            case "MultivariateStudentT1": 
            case "MultivariateStudentT2": {
                return "dmt";
            }
        }
        throw new UnsupportedOperationException("Distribution " + name + " not suppported");
    }

    private String getDistName(JAXBElement<? extends AbstractContinuousUnivariateDistributionType> value) {
        String name;
        switch (name = value.getDeclaredType().getSimpleName()) {
            case "NormalDistribution": {
                return "dnorm";
            }
            case "LogisticDistribution": {
                return "logistic(";
            }
            case "CauchyDistribution": {
                return "cauchy";
            }
            case "GeometricDistribution": {
                return "geometric";
            }
            case "LogNormalDistribution": {
                return "logNormal";
            }
            case "PoissonDistribution": {
                return "poisson";
            }
        }
        return null;
    }

    private String getDistName(AbstractDistributionType value) {
        String name = value.getDefinition();
        if (value instanceof NormalDistribution) {
            return "dnorm";
        }
        if (value instanceof LogisticDistribution) {
            return "logistic(";
        }
        if (value instanceof CauchyDistribution) {
            return "cauchy";
        }
        if (value instanceof GeometricDistribution) {
            return "geometric";
        }
        if (value instanceof LogNormalDistribution) {
            return "logNormal";
        }
        if (value instanceof PoissonDistribution) {
            return "poisson";
        }
        return null;
    }

    private String getVariance(PositiveRealValueType variance) {
        if (variance == null) {
            return "";
        }
        if (variance.getPrVal() != null) {
            return "" + variance.getPrVal();
        }
        return "" + variance.getVar().getVarId();
    }

    private String doVarTransformation(String errorTransformation, String current_symbol, String formatErrTransf, List<String> lines) {
        if ((errorTransformation = Util.clean(errorTransformation).trim()).length() > 0) {
            switch (errorTransformation.trim()) {
                case "identity": {
                    errorTransformation = "";
                }
                case "log": 
                case "logit": {
                    String tmp = errorTransformation + current_symbol;
                    String tmp1 = String.format(formatErrTransf, errorTransformation, current_symbol);
                    lines.add(String.format("%s %s %s", tmp, assignSymbol, tmp1));
                    current_symbol = tmp;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(errorTransformation.trim() + " transformation " + " not allowed");
                }
            }
        }
        return current_symbol;
    }

    private List<String> selectErrorModel(StructuredObsError context) throws FileNotFoundException {
        if (this.getDistributionType(context) != null) {
            return this.doErrorModel(context);
        }
        return this.doErrorModelProbOnto(context);
    }

    private List<String> doErrorModel(StructuredObsError context) throws FileNotFoundException {
        JAXBElement<? extends AbstractContinuousUnivariateDistributionType> distribution;
        StructuredObsError.Output output = context.getOutput();
        StructuredObsError.ErrorModel error = context.getErrorModel();
        String formatDistMeanVal = " %s + %s";
        String formatDistVarVal = "%s 1 / ((pow(%s,2))*%s)";
        String formatErrTransf = "%s(%s)";
        if (context.getTransformation() != null && context.getTransformation().getListOfParameter().size() > 0) {
            BinaryTree bt = this.lexer.getTreeMaker().newInstance((Object)context);
            this.errorTransformation = this.parse(context, bt);
        } else {
            this.errorTransformation = "";
        }
        ArrayList<String> lines = new ArrayList<String>();
        BinaryTree bt = this.lexer.getTreeMaker().newInstance((Object)error.getAssign());
        String errStr = "";
        if (bt != null) {
            errStr = this.parse(error.getAssign(), bt);
        }
        if (error.getAssign() != null && error.getAssign().getFunctionCall() != null) {
            FunctionCallType fc = error.getAssign().getFunctionCall();
            errStr = this.doFunctionCallNew(fc);
        }
        if ((distribution = this.getDistributionType(context)) != null) {
            String meanCompleteLabel;
            String distName = this.getDistName(distribution);
            ContinuousValueType mean = ((NormalDistribution)distribution.getValue()).getMean();
            String meanAssign = this.delimit("" + (mean.getVar() == null ? mean.getRVal() : mean.getVar().getVarId()));
            NormalDistribution value = (NormalDistribution)distribution.getValue();
            String varianceAssign = this.getVarAssign(value);
            String rhsMeanExpression = this.delimit(String.format(formatDistMeanVal, this.doSymbolRef(output.getSymbRef()), meanAssign));
            String rhsVarExpression = String.format(formatDistVarVal, assignSymbol, errStr, varianceAssign);
            String current_symbol = this.getSymbol(context);
            String res_symbol = this.addSuffix(this.getSymbol(context), resSuffixLabel);
            this.resList.add(Util.clean(this.removeIndexes(res_symbol)));
            String meanTmpName = this.delimit(context.getSymbId() + meanSuffixLabel);
            this.errorTransformation = this.delimit(Util.clean(this.checkTransformation(this.errorTransformation)));
            String oldString = meanCompleteLabel = this.delimit(Util.clean(this.doMeanLabel(this.errorTransformation, rhsMeanExpression, meanTmpName)));
            meanCompleteLabel = this.adjustIndexes(meanCompleteLabel, current_symbol);
            this.resList.add(Util.clean(this.removeIndexes(res_symbol)));
            String residual_value = String.format("%s-%s", this.delimit(current_symbol), meanCompleteLabel);
            if (!this.delimit(meanCompleteLabel).equals(oldString)) {
                this.putVariableMap(this.delimit(oldString), this.delimit(Util.clean(meanCompleteLabel)));
            }
            String meanAssignStmt = this.doMeanTransformation(this.errorTransformation, meanTmpName, rhsMeanExpression, formatErrTransf);
            lines.add(meanAssignStmt);
            current_symbol = this.doVarTransformation(this.errorTransformation, current_symbol, formatErrTransf, lines);
            String brackets = this.getIndexes(rhsVarExpression) == 32 ? "" : this.getBracketsGen(rhsVarExpression);
            String varTmpName = context.getSymbId() + varianceSuffixLabel;
            String formatDistVarAssignement = varTmpName + "%s %s";
            String varAssignStmt = String.format(formatDistVarAssignement, brackets, rhsVarExpression);
            String varCompleteLabel = this.delimit(Util.clean(varTmpName + brackets));
            lines.add(varAssignStmt);
            String statementDistFormat = "%s ~ %s(%s, %s)";
            String current_value = String.format(statementDistFormat, this.delimit(current_symbol), distName, meanCompleteLabel, varCompleteLabel);
            lines.add(current_value);
            String res_line = String.format("%s %s %s", res_symbol, assignSymbol, residual_value);
            lines.add(res_line);
        }
        return lines;
    }

    private List<String> doErrorModelProbOnto(StructuredObsError context) throws FileNotFoundException {
        ProbOnto distribution;
        StructuredObsError.Output output = context.getOutput();
        StructuredObsError.ErrorModel error = context.getErrorModel();
        String formatDistMeanVal = " %s + %s";
        String formatDistVarVal = "%s 1 / ((pow(%s,2))*%s)";
        String formatDistStdVal = "pow(%s,2)";
        String formatDistVarianceVal = "%s";
        String formatDistPrecVal = "1/(%s)";
        String formatErrTransf = "%s(%s)";
        if (context.getTransformation() != null && context.getTransformation().getListOfParameter().size() > 0) {
            BinaryTree bt = this.lexer.getTreeMaker().newInstance((Object)context);
            this.errorTransformation = this.parse(context, bt);
        } else {
            this.errorTransformation = "";
        }
        ArrayList<String> lines = new ArrayList<String>();
        BinaryTree bt = this.lexer.getTreeMaker().newInstance((Object)error.getAssign());
        String errStr = "";
        if (bt != null) {
            errStr = this.parse(error.getAssign(), bt);
        }
        if (error.getAssign() != null && error.getAssign().getFunctionCall() != null) {
            FunctionCallType fc = error.getAssign().getFunctionCall();
            errStr = this.doFunctionCallNew(fc);
        }
        if ((distribution = this.getProbOntoDistributionType(context)) != null) {
            String distName = this.getDistName(distribution);
            switch (distribution.getName().value()) {
                case "Normal1": 
                case "Normal2": 
                case "Normal3": {
                    String meanCompleteLabel;
                    DistributionParameter mean = distribution.getParameter(ParameterName.MEAN);
                    String varianceAssign = "";
                    String meanAssign = this.delimit(this.parse(mean, this.lexer.getTreeMaker().newInstance((Object)mean)));
                    if (distribution.getName().value().toString().equals("Normal1")) {
                        DistributionParameter var = distribution.getParameter(ParameterName.STDEV);
                        varianceAssign = String.format(formatDistStdVal, this.delimit(this.parse(var, this.lexer.getTreeMaker().newInstance((Object)var))));
                    } else if (distribution.getName().value().toString().equals("Normal2")) {
                        DistributionParameter var = distribution.getParameter(ParameterName.VAR);
                        varianceAssign = String.format(formatDistVarianceVal, this.delimit(this.parse(var, this.lexer.getTreeMaker().newInstance((Object)var))));
                    } else if (distribution.getName().value().toString().equals("Normal3")) {
                        DistributionParameter var = distribution.getParameter(ParameterName.PRECISION);
                        varianceAssign = String.format(formatDistPrecVal, this.delimit(this.parse(var, this.lexer.getTreeMaker().newInstance((Object)var))));
                    }
                    String rhsMeanExpression = this.delimit(String.format(formatDistMeanVal, this.doSymbolRef(output.getSymbRef()), meanAssign));
                    String rhsVarExpression = String.format(formatDistVarVal, assignSymbol, errStr, varianceAssign);
                    String current_symbol = this.getSymbol(context);
                    String res_symbol = this.addSuffix(this.getSymbol(context), resSuffixLabel);
                    this.resList.add(Util.clean(this.removeIndexes(res_symbol)));
                    String meanTmpName = this.delimit(context.getSymbId() + meanSuffixLabel);
                    this.errorTransformation = this.delimit(Util.clean(this.checkTransformation(this.errorTransformation)));
                    String oldString = meanCompleteLabel = this.delimit(Util.clean(this.doMeanLabel(this.errorTransformation, rhsMeanExpression, meanTmpName)));
                    meanCompleteLabel = this.delimit(this.adjustIndexes(Util.clean(meanCompleteLabel), current_symbol));
                    this.predList.add(Util.clean(this.removeIndexes(meanCompleteLabel)));
                    String residual_value = String.format("%s-%s", this.delimit(current_symbol), meanCompleteLabel);
                    if (!this.delimit(meanCompleteLabel).equals(oldString)) {
                        this.putVariableMap(this.delimit(oldString), this.delimit(Util.clean(meanCompleteLabel)));
                    }
                    String meanAssignStmt = this.doMeanTransformation(this.errorTransformation, meanTmpName, rhsMeanExpression, formatErrTransf);
                    lines.add(meanAssignStmt);
                    current_symbol = this.doVarTransformation(this.errorTransformation, current_symbol, formatErrTransf, lines);
                    String brackets = this.getIndexes(rhsVarExpression) == 32 ? "" : this.getBracketsGen(rhsVarExpression);
                    String varTmpName = context.getSymbId() + varianceSuffixLabel;
                    String formatDistVarAssignement = varTmpName + "%s %s";
                    String varAssignStmt = String.format(formatDistVarAssignement, brackets, rhsVarExpression);
                    String varCompleteLabel = this.delimit(Util.clean(varTmpName + brackets));
                    lines.add(varAssignStmt);
                    String statementDistFormat = "%s ~ %s(%s, %s)";
                    String current_value = String.format(statementDistFormat, this.delimit(current_symbol), distName, meanCompleteLabel, varCompleteLabel);
                    lines.add(current_value);
                    String res_line = String.format("%s %s %s", res_symbol, assignSymbol, residual_value);
                    lines.add(res_line);
                    break;
                }
                default: {
                    String par1CompleteLabel;
                    DistributionParameter par1 = distribution.getParameter(ParameterName.MEAN);
                    String par1Assign = this.delimit(this.parse(par1, this.lexer.getTreeMaker().newInstance((Object)par1)));
                    String par2Assign = this.delimit(this.parse(par1, this.lexer.getTreeMaker().newInstance((Object)distribution.getParameter(ParameterName.VAR))));
                    String rhsPar1Expression = this.delimit(String.format(formatDistMeanVal, this.doSymbolRef(output.getSymbRef()), par1Assign));
                    String rhsPar2Expression = String.format(formatDistVarVal, assignSymbol, errStr, par2Assign);
                    String curr_sym = this.getSymbol(context);
                    String res_sym = this.addSuffix(this.getSymbol(context), resSuffixLabel);
                    this.resList.add(Util.clean(this.removeIndexes(res_sym)));
                    String par1TmpName = this.delimit(context.getSymbId() + meanSuffixLabel);
                    this.errorTransformation = this.delimit(Util.clean(this.checkTransformation(this.errorTransformation)));
                    String oldStr = par1CompleteLabel = this.delimit(Util.clean(this.doPar1Label(this.errorTransformation, rhsPar1Expression, par1TmpName)));
                    par1CompleteLabel = this.adjustIndexes(par1CompleteLabel, curr_sym);
                    this.predList.add(Util.clean(this.removeIndexes(par1CompleteLabel)));
                    String res_value = String.format("%s-%s", this.delimit(curr_sym), par1CompleteLabel);
                    if (!this.delimit(par1CompleteLabel).equals(oldStr)) {
                        this.putVariableMap(this.delimit(oldStr), this.delimit(Util.clean(par1CompleteLabel)));
                    }
                    String par1AssignStmt = this.doMeanTransformation(this.errorTransformation, par1TmpName, rhsPar1Expression, formatErrTransf);
                    lines.add(par1AssignStmt);
                    curr_sym = this.doVarTransformation(this.errorTransformation, curr_sym, formatErrTransf, lines);
                    String brackets = this.getIndexes(rhsPar2Expression) == 32 ? "" : this.getBracketsGen(rhsPar2Expression);
                    String varTmpName = context.getSymbId() + varianceSuffixLabel;
                    String formatDistVarAssignement = varTmpName + "%s %s";
                    String varAssignStmt = String.format(formatDistVarAssignement, brackets, rhsPar2Expression);
                    String par2CompleteLabel = this.delimit(Util.clean(varTmpName + brackets));
                    lines.add(varAssignStmt);
                    String statementDistFormat = "%s ~ %s(%s, %s)";
                    String current_value = String.format(statementDistFormat, this.delimit(curr_sym), distName, par1CompleteLabel, par2CompleteLabel);
                    lines.add(current_value);
                    String res_line = String.format("%s %s %s", res_sym, assignSymbol, res_value);
                    lines.add(res_line);
                }
            }
        }
        return lines;
    }

    private List<String> writeObsStandardModelDistribution(StructuredObsError context) throws FileNotFoundException {
        ArrayList<String> lines = new ArrayList<String>();
        StructuredObsError.ErrorModel error = context.getErrorModel();
        if (error != null) {
            return this.selectErrorModel(context);
        }
        return lines;
    }

    private void writeFunctions(PrintWriter fout, List<FunctionDefinition> functions) throws IOException {
        if (fout == null) {
            return;
        }
        if (functions == null) {
            throw new NullPointerException("The Function list is NULL.");
        }
        if (functions.size() == 0) {
            return;
        }
        for (FunctionDefinition f : functions) {
            AnnotationType annotation;
            String value;
            if (f == null) continue;
            if (this.functionMap.get(f) == null) {
                throw new IllegalStateException("Function " + f.getSymbId() + " declaration has no binary tree.");
            }
            if (f.getDescription() != null && (value = (annotation = f.getDescription()).getValue()) != null) {
                String format = "%s %s";
                fout.write(Util.clean(String.format(format, this.comment_char, value)));
            }
            String format = "function [value] = %s(";
            fout.write(Util.clean(String.format(format, this.z.get((Object)f))));
            int i = 0;
            List args = f.getFunctionArgument();
            for (FunctionParameter arg : args) {
                if (i > 0) {
                    fout.write(", ");
                }
                fout.write(Util.clean(this.z.get((Object)arg)));
                ++i;
            }
            fout.write(")\n");
            fout.write("value = ");
            this.parse(f, this.functionMap.get(f), fout);
            fout.write(";\nend\n\n");
        }
    }

    private void checkMap(String before, String after) {
        if (!this.delimit(after).equals(this.delimit(before))) {
            this.putVariableMap(this.delimit(before), this.delimit(after));
        }
    }

    protected String doInverseTransformation(String transf, String arg) {
        String t;
        arg = this.pascalNamesTransform(arg);
        switch (transf) {
            case "logit": {
                t = String.format("Math.Exp(%s)/(1+Math.Exp(%s))", arg, arg);
                break;
            }
            case "probit": {
                t = String.format("%s(%s)", "MathFunc.Phi", arg);
                break;
            }
            case "log": {
                t = String.format("%s(%s)", "Math.Exp", arg);
                break;
            }
            default: {
                throw new UnsupportedOperationException(transf);
            }
        }
        return t;
    }

    private String manageGC(IndividualParameter ip) {
        String format = "%s <- %s";
        String formatTransf = "%s(%s)<- %s";
        String indivTransformation = null;
        StructuredModel ipGM = ip.getStructuredModel();
        SymbolRef randEff = (SymbolRef)((ParameterRandomEffect)ipGM.getListOfRandomEffects().get(0)).getSymbRef().get(0);
        StructuredModel.GeneralCovariate ipGC = ipGM.getGeneralCovariate();
        if (ipGM.getTransformation() != null && (indivTransformation = ipGM.getTransformation().getType().toString().toLowerCase()).equals("identity")) {
            indivTransformation = null;
        }
        String indivEquation = this.parse(ipGM, this.lexer.getStatement((Object)ipGC));
        indivEquation = this.delimit(indivEquation);
        String randEffId = this.doSymbolRef(randEff);
        indivEquation = indivEquation + " + " + randEffId;
        String oldString = ip.getSymbId();
        randEffId = this.adjustIndexes(ip.getSymbId(), indivEquation);
        this.checkMap(ip.getSymbId(), randEffId);
        String indivPascalEquation = this.pascalNamesTransform(indivEquation);
        if (indivTransformation == null) {
            this.pascalIndivMap.put(this.delimit(randEffId), indivPascalEquation);
            this.unaryOperandEqMap.put(this.delimit(Util.clean(randEffId)), indivEquation);
            return String.format(format, this.delimit(randEffId), indivEquation);
        }
        this.pascalIndivMap.put(this.delimit(randEffId), indivPascalEquation);
        this.unaryOperandEqMap.put(this.delimit(Util.clean(randEffId)), indivEquation);
        this.transfMap.put(this.delimit(String.format("%s(%s)", indivTransformation, randEffId)), this.delimit(Util.clean(randEffId)));
        return String.format(formatTransf, indivTransformation, randEffId, indivEquation);
    }

    private String getCategoryVal(List<CategoryRef_> list, String cat) {
        for (CategoryRef_ s : list) {
            if (!s.getModelSymbol().equals(cat)) continue;
            return s.getDataSymbol();
        }
        return null;
    }

    private String manageLC(IndividualParameter ip) throws IOException {
        String indivPascalEquation;
        String indivWinbugsEquation;
        String format = "%s <- %s";
        String formatTransf = "%s(%s)<- %s";
        String indivTransformation = null;
        String pascalPopPar = "";
        StructuredModel ipGM = ip.getStructuredModel();
        SymbolRef randEff = (SymbolRef)((ParameterRandomEffect)ipGM.getListOfRandomEffects().get(0)).getSymbRef().get(0);
        StructuredModel.LinearCovariate ipLC = ipGM.getLinearCovariate();
        ipLC = ipGM.getLinearCovariate();
        if (ipGM.getTransformation() != null) {
            indivTransformation = ipGM.getTransformation().getType().toString().toLowerCase();
            if (indivTransformation.equals("identity")) {
                indivTransformation = null;
            } else if (indivTransformation.equals("probit")) {
                throw new UnsupportedOperationException("Probit transformation is not allowed at the right end side.");
            }
        }
        String popPar = this.parse(ipLC, this.lexer.getStatement((Object)ipLC.getPopulationValue()));
        String randEffId = this.delimit(this.doSymbolRef(randEff));
        if (indivTransformation != null) {
            pascalPopPar = this.doPascalTransformation(indivTransformation, popPar);
            popPar = indivTransformation + "(" + this.delimit(popPar) + ")";
        } else {
            pascalPopPar = popPar;
        }
        String prod = "";
        String left = "";
        String symbol = "";
        if (ipLC.getListOfCovariate() != null && ipLC.getListOfCovariate().size() > 0) {
            for (CovariateRelation cov : ipLC.getListOfCovariate()) {
                SymbolRef fixedEff = ((FixedEffectRelation)cov.getListOfFixedEffect().get(0)).getSymbRef();
                SymbolRef linCov = cov.getSymbRef();
                String pieceName = piecePrefix + linCov.getSymbIdRef();
                if (this.isCategoricalCovariateType(linCov)) {
                    this.covCatMap.put(linCov.getSymbIdRef(), pieceName);
                    int num = this.categoricalCovariateIdMap.get(this.lexer.getAccessor().fetchElement(linCov));
                    String id = this.getCategoryVal(this.categoricalMap.get(linCov.getSymbIdRef()), ((FixedEffectRelation)cov.getListOfFixedEffect().get(0)).getCategory().getCatId());
                    this.covFilesMap.put(num, ((PascalParser)this).pascalCatCovCodeFileGeneration(num, id, linCov.getSymbIdRef()));
                    this.covBlockMap.put(linCov.getSymbIdRef(), ((PascalParser)this).pascalCatCovCodeBlockGeneration(linCov.getSymbIdRef(), id, pieceName));
                    String tmp = this.adjustStatement(String.format("%s %s function.covariate%s(%s)", this.covCatMap.get(linCov.getSymbIdRef()), assignSymbol, num, this.doSymbolRef(linCov)));
                    this.winbugsCovariateLines.add(tmp);
                    left = tmp.substring(0, tmp.indexOf(assignSymbol));
                } else {
                    String oldSymbol = linCov.getSymbIdRef();
                    symbol = oldSymbol + this.interpSuffix;
                    symbol = symbol + this.IND_BOTH;
                    this.variablesAssignementMap.put(this.delimit(oldSymbol), this.delimit(symbol));
                    this.doInterpLine(oldSymbol, symbol);
                    left = linCov.getSymbIdRef();
                }
                prod = prod + " + " + this.delimit(this.doSymbolRef(fixedEff)) + " * " + this.delimit(left);
            }
            String prodpascal = this.pascalNamesTransform(prod);
            indivWinbugsEquation = popPar + prod + " + " + randEffId;
            indivPascalEquation = pascalPopPar + prodpascal + " + " + randEffId;
        } else {
            indivWinbugsEquation = popPar + " + " + randEffId;
            indivPascalEquation = pascalPopPar + " + " + randEffId;
        }
        indivPascalEquation = this.pascalNamesTransform(indivPascalEquation);
        String oldSymb = this.variablesAssignementMap.get(this.delimit(ip.getSymbId())) != null ? this.variablesAssignementMap.get(this.delimit(ip.getSymbId())) : ip.getSymbId();
        randEffId = this.delimit(this.adjustIndexes(oldSymb, indivWinbugsEquation));
        this.checkMap(ip.getSymbId(), randEffId);
        if (indivTransformation == null || indivTransformation.equals("identity")) {
            this.pascalIndivMap.put(this.delimit(randEffId), indivPascalEquation);
            return String.format(format, randEffId, indivWinbugsEquation);
        }
        this.unaryOperandEqMap.put(this.delimit(Util.clean(randEffId)), indivWinbugsEquation);
        this.transfMap.put(this.delimit(String.format("%s(%s)", indivTransformation, randEffId)), this.delimit(Util.clean(randEffId)));
        this.pascalIndivMap.put(this.delimit(randEffId), indivPascalEquation);
        return String.format(formatTransf, indivTransformation, randEffId, indivWinbugsEquation);
    }

    private String managePV(IndividualParameter ip) {
        String indivPascalEquation;
        String indivWinbugsEquation;
        String format = "%s <- %s";
        String formatTransf = "%s(%s)<- %s";
        String indivTransformation = null;
        String pascalPopPar = "";
        StructuredModel ipGM = ip.getStructuredModel();
        SymbolRef randEff = (SymbolRef)((ParameterRandomEffect)ipGM.getListOfRandomEffects().get(0)).getSymbRef().get(0);
        StructuredModel.PopulationValue ipPV = ipGM.getPopulationValue();
        if (ipGM.getTransformation() != null) {
            indivTransformation = ipGM.getTransformation().getType().toString().toLowerCase();
            if (indivTransformation.equals("identity")) {
                indivTransformation = null;
            } else if (indivTransformation.equals("probit")) {
                throw new UnsupportedOperationException("Probit transformation is not allowed at the right end side.");
            }
        }
        String popPar = this.parse(ipGM, this.lexer.getTreeMaker().newInstance((Object)ipPV.getAssign()));
        String randEffId = this.doSymbolRef(randEff);
        if (indivTransformation != null) {
            pascalPopPar = this.doPascalTransformation(indivTransformation, popPar);
            popPar = indivTransformation + "(" + popPar + ")";
        } else {
            pascalPopPar = popPar;
        }
        if (ipPV.getAssign() != null) {
            String fixedEff = this.parse(ipPV, this.lexer.getTreeMaker().newInstance((Object)ipPV.getAssign()));
            String prod = "" + fixedEff;
            String prodpascal = this.pascalNamesTransform(prod);
            indivWinbugsEquation = popPar + " + " + randEffId;
            indivPascalEquation = pascalPopPar + " + " + randEffId;
        } else {
            indivWinbugsEquation = popPar + " + " + randEffId;
            indivPascalEquation = pascalPopPar + " + " + randEffId;
        }
        indivPascalEquation = this.pascalNamesTransform(indivPascalEquation);
        randEffId = this.adjustIndexes(ip.getSymbId(), indivWinbugsEquation);
        this.checkMap(ip.getSymbId(), randEffId);
        if (indivTransformation == null || indivTransformation.equals("identity")) {
            this.pascalIndivMap.put(this.delimit(randEffId), indivPascalEquation);
            return String.format(format, randEffId, indivWinbugsEquation);
        }
        this.unaryOperandEqMap.put(this.delimit(Util.clean(randEffId)), indivWinbugsEquation);
        this.transfMap.put(this.delimit(String.format("%s(%s)", indivTransformation, randEffId)), this.delimit(Util.clean(randEffId)));
        this.pascalIndivMap.put(this.delimit(randEffId), indivPascalEquation);
        return String.format(formatTransf, indivTransformation, randEffId, indivWinbugsEquation);
    }

    private String manageGM(IndividualParameter ip) throws IOException {
        StructuredModel ipGM = ip.getStructuredModel();
        if (ipGM.getGeneralCovariate() != null) {
            this.winbugsIndivLines.add(this.manageGC(ip));
        } else if (ipGM.getLinearCovariate() != null) {
            this.winbugsIndivLines.add(this.manageLC(ip));
        } else if (ipGM.getPopulationValue() != null) {
            this.winbugsIndivLines.add(this.managePV(ip));
        }
        return "";
    }

    public void setCovariatePascalName(String name) {
        this.covariatePascalName = name;
    }

    public String getCovariatePascalName() {
        return this.covariatePascalName;
    }

    protected void manageParameterBlocks(ParameterBlock pb) throws UnsupportedDataTypeException, FileNotFoundException, IOException {
        List pbs = pb.getIndividualParameters();
        for (IndividualParameter individualParameter : pbs) {
            if (!this.lexer.hasStatement((Object)individualParameter)) continue;
            if (individualParameter.getAssign() != null) {
                this.winbugsIndivLines.add(this.parse(individualParameter, this.lexer.getStatement((Object)individualParameter.getAssign())));
                continue;
            }
            if (individualParameter.getStructuredModel() == null) continue;
            this.manageGM(individualParameter);
        }
        for (Map.Entry entry : this.covFilesMap.entrySet()) {
            this.output((String)entry.getValue(), new File(this.covariatePascalName + entry.getKey() + this.pascalFileNameSuffix), true);
        }
    }

    protected String doPascalTransformation(String u_op, String leftStatement) {
        String pascalUnaryOperator2;
        switch (u_op) {
            case "abs": {
                pascalUnaryOperator2 = String.format("ABS(%s)", leftStatement);
                break;
            }
            case "log": {
                pascalUnaryOperator2 = String.format("Math.Ln(%s)", leftStatement);
                break;
            }
            case "logit": {
                pascalUnaryOperator2 = String.format("Math.Ln(%s)-Math.Ln(1-%s)", leftStatement, leftStatement);
                break;
            }
            case "sqrt": {
                pascalUnaryOperator2 = String.format("Math.Sqrt(%s)", leftStatement);
                break;
            }
            case "exp": {
                pascalUnaryOperator2 = String.format("Math.Exp(%s)", leftStatement);
                break;
            }
            case "factln": {
                pascalUnaryOperator2 = String.format("MathFunc.LogFactorial(%s)", leftStatement);
                break;
            }
            case "floor": {
                pascalUnaryOperator2 = String.format("Math.Floor(%s)", leftStatement);
                break;
            }
            case "gammaln": {
                pascalUnaryOperator2 = String.format("MathFunc.LogGammaFunc(%s))", leftStatement);
                break;
            }
            case "minus": {
                pascalUnaryOperator2 = String.format("-(%s)", leftStatement);
                break;
            }
            case "normcdf": {
                pascalUnaryOperator2 = String.format("MathFunc.Phi(%s)", leftStatement);
                break;
            }
            case "factorial": {
                pascalUnaryOperator2 = String.format("Math.Exp(MathFunc.LogFactorial(%s))", leftStatement);
                break;
            }
            case "ceiling": {
                pascalUnaryOperator2 = String.format("Math.Ceiling(%s)", leftStatement);
                break;
            }
            case "logistic": {
                pascalUnaryOperator2 = String.format("1/(1+Math.Exp(-%s))", leftStatement);
                break;
            }
            case "sim": {
                pascalUnaryOperator2 = String.format("Math.Sin(%s)", leftStatement);
                break;
            }
            case "cos": {
                pascalUnaryOperator2 = String.format("Math.Cos(%s)", leftStatement);
                break;
            }
            case "tan": {
                pascalUnaryOperator2 = String.format("Math.Tan(%s)", leftStatement);
                break;
            }
            case "sec": {
                pascalUnaryOperator2 = String.format("1/Math.Cos(%s)", leftStatement);
                break;
            }
            case "csc": {
                pascalUnaryOperator2 = String.format("1/Math.Sin(%s)", leftStatement);
                break;
            }
            case "cot": {
                pascalUnaryOperator2 = String.format("Math.Cos(%s)/Math.Sin(%s)", leftStatement, leftStatement);
                break;
            }
            case "sinh": {
                pascalUnaryOperator2 = String.format("(Math.Sinh(%s)", leftStatement);
                break;
            }
            case "cosh": {
                pascalUnaryOperator2 = String.format("(Math.Cosh(%s)", leftStatement);
                break;
            }
            case "tanh": {
                pascalUnaryOperator2 = String.format("Math.Tanh(%s)", leftStatement);
                break;
            }
            case "coth": {
                pascalUnaryOperator2 = String.format("(Math.Exp(%s)+Math.Exp(-%s))/(Math.Exp(%s)-Math.Exp(-%s))", leftStatement, leftStatement, leftStatement, leftStatement);
                break;
            }
            case "sech": {
                pascalUnaryOperator2 = String.format("2/(Math.Exp(%s)+Math.Exp(-%s))", leftStatement, leftStatement);
                break;
            }
            case "csch": {
                pascalUnaryOperator2 = String.format("2/(Math.Exp(%s)-Math.Exp(-%s))", leftStatement, leftStatement);
                break;
            }
            case "arcsinh": {
                pascalUnaryOperator2 = String.format("Math.ArcSinh(%s)", leftStatement);
                break;
            }
            case "arccosh": {
                pascalUnaryOperator2 = String.format("Math.ArcCosh(%s)", leftStatement);
                break;
            }
            case "arctanh": {
                pascalUnaryOperator2 = String.format("Math.ArcTanh(%s)", leftStatement);
                break;
            }
            case "arccoth": {
                String pascalUnaryOperator2 = String.format("1/2*Math.Ln((%s+1)/(%s-1))", leftStatement, leftStatement);
            }
            default: {
                throw new UnsupportedOperationException(u_op);
            }
        }
        return pascalUnaryOperator2;
    }

    protected String doPascalTransformation(String b_op, String leftStatement, String rightStatement) {
        String pascalBinaryOperator;
        if (b_op == null) {
            throw new NullPointerException("The binary operator is NULL.");
        }
        if (b_op.equals(BaseEngine.POWER)) {
            pascalBinaryOperator = String.format("MathFunc.Power(%s,%s)", leftStatement, rightStatement);
        } else if (b_op.equals(BaseEngine.ROOT)) {
            pascalBinaryOperator = String.format("MathFunc.Power(%s,1/%s)", leftStatement, rightStatement);
        } else if (b_op.equals(BaseEngine.LOGX)) {
            pascalBinaryOperator = String.format("Math.Ln(%s)/Math.Ln(%s)", leftStatement, rightStatement);
        } else if (b_op.equals(BaseEngine.MAX)) {
            pascalBinaryOperator = String.format("MAX(%s,%s)", leftStatement, rightStatement);
        } else if (b_op.equals(BaseEngine.MIN)) {
            pascalBinaryOperator = String.format("min(%s,%s)", leftStatement, rightStatement);
        } else {
            throw new UnsupportedOperationException(b_op);
        }
        return pascalBinaryOperator;
    }

    private int getIndexes(String value) {
        if (!value.contains(this.leftArrayBracket) && !value.contains(IND_T2)) {
            return 32;
        }
        if (value.contains(IND_T2)) {
            if (value.contains(IND_S)) {
                return 115;
            }
            return 113;
        }
        if (value.contains(IND_T)) {
            if (value.contains(IND_S)) {
                return 98;
            }
            return 116;
        }
        if (value.contains(IND_S)) {
            return 115;
        }
        return 32;
    }

    private String getBrackets(String value) {
        int i1 = value.indexOf(this.leftArrayBracket);
        int i2 = value.indexOf(this.rightArrayBracket, i1);
        return value.substring(i1, i2 + 1);
    }

    private String getBracketsGen(String value) {
        StringBuilder s = new StringBuilder();
        for (String t : listIndexes) {
            if (!value.contains(t)) continue;
            s.append(t);
            s.append(',');
        }
        String ind = s.toString();
        return this.leftArrayBracket + ind.substring(0, ind.length() - 1) + this.rightArrayBracket;
    }

    protected String doSequence(Sequence o) {
        throw new UnsupportedOperationException();
    }

    protected String doConstant(Constant c) {
        throw new UnsupportedOperationException();
    }

    protected String doVector(Vector v) {
        return v.getId();
    }

    protected String doFunctionCall(FunctionCallType call) {
        if (call == null) {
            throw new NullPointerException("A function call definition is null.");
        }
        ArrayList<String> arg_symbols = new ArrayList<String>();
        for (FunctionCallType.FunctionArgument arg : call.getFunctionArgument()) {
            String arg_symbol = "0.0";
            if (arg.getScalar() != null) {
                Object v = arg.getScalar().getValue();
                arg_symbol = this.getSymbol(v);
            } else if (arg.getSymbRef() != null) {
                arg_symbol = this.getSymbol(arg.getSymbRef());
            } else if (arg != null) {
                arg_symbol = this.getSymbol(arg);
            }
            arg_symbols.add(arg_symbol);
        }
        StringBuffer args_string = new StringBuffer();
        int i = 0;
        for (String symbol : arg_symbols) {
            if (i > 0) {
                args_string.append(",");
            }
            args_string.append(symbol);
            ++i;
        }
        String format = "(%s(%s))";
        return String.format(format, call.getSymbRef().getSymbIdRef(), args_string);
    }

    protected String doIndependentVariable(IndependentVariable v) {
        return gridLabel;
    }

    protected String doFunctionCallNew(FunctionCallType call) {
        if (call == null) {
            throw new NullPointerException("A function call definition is null.");
        }
        FunctionDefinition func = this.getFunctionByName(call.getSymbRef().getSymbIdRef());
        ArrayList<String> formalList = new ArrayList<String>();
        ArrayList<String> actualIds = new ArrayList<String>();
        this.doFunctionCall(call, formalList, actualIds);
        this.updateBinopMap(formalList, actualIds);
        return this.doFunctionDefinition(func, formalList, actualIds);
    }

    String doFunctionDefinition(FunctionDefinition func, List<String> formalList, List<String> actualIds) {
        String funcS = this.getFunction(func);
        String definition = funcS.substring(funcS.indexOf("=") + 1).trim();
        for (int i = 0; i < formalList.size(); ++i) {
            definition = definition.replace(formalList.get(i), actualIds.get(i)).trim();
        }
        return definition;
    }

    void doFunctionCall(FunctionCallType call, List<String> formalList, List<String> actualIds) {
        String actualArg = "";
        for (FunctionCallType.FunctionArgument arg : call.getListOfFunctionArgument()) {
            formalList.add(this.delimit(arg.getSymbId()));
            actualArg = this.getArg(arg);
            actualIds.add(this.delimit(actualArg));
        }
    }

    private String getArg(JAXBElement arg) {
        if (arg.getValue() instanceof SymbolRef) {
            return this.delimit(this.doSymbolRef((SymbolRef)arg.getValue()));
        }
        if (arg.getValue() instanceof Scalar) {
            return ((Scalar)arg.getValue()).asString();
        }
        if (arg.getValue() instanceof Uniop) {
            Uniop ut = (Uniop)arg.getValue();
            return this.delimit(this.doUnaryOperation(ut, this.getArg(ut)));
        }
        if (arg.getValue() instanceof Binop) {
            return this.getArg((Binop)arg.getValue());
        }
        if (arg.getValue() instanceof FunctionCallType) {
            return this.doFunctionCallNew((FunctionCallType)arg.getValue());
        }
        return "@";
    }

    private String getArg(Binop arg) {
        String s0 = this.delimit(this.getArg(arg.getOperand1().toJAXBElement()));
        String s1 = this.delimit(this.getArg(arg.getOperand2().toJAXBElement()));
        return this.delimit(this.doBinaryOperation(arg, s0, s1));
    }

    private String getArg(Uniop arg) {
        return this.getArg(((Uniop)arg.getValue()).toJAXBElement());
    }

    private String getArg(FunctionCallType.FunctionArgument arg) {
        if (arg.getSymbRef() != null) {
            return this.delimit(this.doSymbolRef(arg.getSymbRef()));
        }
        if (arg.getScalar() != null) {
            if (arg.getScalar().getValue() instanceof RealValue) {
                return this.delimit(((RealValue)arg.getScalar().getValue()).getValue() + "");
            }
            if (arg.getScalar().getValue() instanceof IntValue) {
                return this.delimit(((IntValue)arg.getScalar().getValue()).getValue() + "");
            }
        } else if (arg != null) {
            return this.getArg(arg);
        }
        return "@";
    }

    protected String doCovariate(CovariateDefinition cov) {
        String symbol = unassigned_symbol;
        if (cov.getCategorical() != null) {
            throw new UnsupportedOperationException("CovariateDefinition::categorical not supported yet.");
        }
        if (cov.getContinuous() != null) {
            if (!cov.getContinuous().getListOfTransformation().isEmpty()) {
                symbol = this.covariateTransformationMap.get(cov);
            } else {
                TreeMaker tm = this.lexer.getTreeMaker();
                symbol = this.parse(cov, tm.newInstance((Object)cov));
            }
        }
        return symbol;
    }

    private String doContinuousCovariate(ContinuousCovariate continuous) {
        return continuous.getId();
    }

    private String doCovariateTransformationNew(CovariateTransformation cov) {
        String symbol = unassigned_symbol;
        if (this.transformation_stmt_map.containsKey(cov)) {
            symbol = this.transformation_stmt_map.get(cov);
        } else {
            symbol = cov.getTransformedCovariate().getSymbId();
            this.transformation_stmt_map.put(cov, symbol);
        }
        return symbol;
    }

    public void writeFunction(FunctionDefinition func) {
        BinaryTree bt = this.lexer.getStatement((Object)func);
        this.functionMap.put(func, bt);
        this.parse(func, bt);
    }

    private String getFunctionParametersString(FunctionDefinition func) {
        List params = func.getFunctionArgument();
        StringBuilder sb = new StringBuilder();
        for (FunctionParameter p : params) {
            sb.append(p.getSymbId());
            sb.append(',');
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    private List<String> getFunctionParametersId(FunctionDefinition func) {
        List params = func.getFunctionArgument();
        ArrayList<String> idList = new ArrayList<String>();
        for (FunctionParameter p : params) {
            idList.add(p.getSymbId());
        }
        return idList;
    }

    public String getFunction(FunctionDefinition func) {
        List params = func.getFunctionArgument();
        StringBuilder sb = new StringBuilder();
        for (FunctionParameter p : params) {
            sb.append(this.delimit(p.getSymbId()));
            sb.append(',');
        }
        String parList = sb.toString().substring(0, sb.toString().length() - 1);
        String formatF = "%s(" + parList + ") = %s";
        return String.format(formatF, func.getSymbId(), this.functionDefinition.get(func));
    }

    protected void writeFunction(FunctionDefinition func, String output_dir, boolean t) throws IOException {
        if (func == null) {
            return;
        }
        String format = "%s%s%s.m";
        String output_filename = String.format(format, output_dir, File.separator, this.z.get((Object)func));
        ArrayList<FunctionDefinition> list = new ArrayList<FunctionDefinition>();
        list.add(func);
        PrintWriter fout = new PrintWriter(output_filename);
        this.writeScriptHeader(fout, this.lexer.getModelFilename());
        this.writeFunctions(fout, list);
        fout.close();
    }

    public void writeInterpreterPath(PrintWriter fout) {
        throw new UnsupportedOperationException();
    }

    public void writeADMESimulationBlock(PrintWriter fout, File output_dir, SimulationStep ss) throws IOException {
    }

    public void writeParameters(PrintWriter fout) {
        throw new UnsupportedOperationException();
    }

    public void writeScriptLibraryReferences(PrintWriter fout) throws IOException {
        if (fout == null) {
            return;
        }
    }

    private List<String> writeRandomVarDistribution(ParameterRandomVariable context) {
        ArrayList<String> lines = new ArrayList<String>();
        String formatDistMeanValAssign = "<- %s";
        String formatDistVarValAssign = "<- (1/(%s))";
        String formatDistMeanVal = "%s";
        Distribution distrib = context.getDistribution();
        BinaryTree tmpstmt = this.lexer.getStatement((Object)distrib);
        UncertML uDist = distrib.getUncertML();
        if (uDist != null && uDist.getAbstractContinuousUnivariateDistribution() != null) {
            if (uDist.getAbstractContinuousUnivariateDistribution().getValue() != null) {
                Object oDist = uDist.getAbstractContinuousUnivariateDistribution().getValue();
                if (oDist instanceof NormalDistribution) {
                    NormalDistribution value = (NormalDistribution)oDist;
                    String distName = this.getDistName((AbstractDistributionType)value);
                    ContinuousValueType mean = value.getMean();
                    SymbolRef srM = new SymbolRef();
                    if (mean.getVar() != null) {
                        srM.setSymbIdRef(mean.getVar().getVarId());
                    }
                    String meanAssign = this.delimit("" + (mean.getVar() == null ? mean.getRVal() : this.getSymbol(srM)));
                    String varianceAssign = "";
                    varianceAssign = this.delimit(this.getVarAssign(value));
                    String rhsVarExpression = String.format(formatDistVarValAssign, varianceAssign);
                    String rhsMeanExpression = String.format(formatDistMeanValAssign, meanAssign);
                    String meanExpression = this.delimit(String.format(formatDistMeanVal, meanAssign));
                    String brackets = this.getIndexes(rhsMeanExpression) == 32 ? "" : this.getBrackets(rhsMeanExpression);
                    brackets = this.getIndexes(rhsVarExpression) == 32 ? "" : this.getBracketsGen(rhsVarExpression);
                    String varTmpName = context.getSymbId() + varianceSuffixLabel;
                    String formatDistVarAssignement = varTmpName + "%s %s";
                    String varAssignStmt = String.format(formatDistVarAssignement, brackets, rhsVarExpression);
                    String varCompleteLabel = this.delimit(Util.clean(varTmpName + brackets));
                    lines.add(varAssignStmt);
                    String current_symbol = this.getSymbol(context);
                    String statementDistFormat = "%s ~ %s(%s, %s)";
                    String current_value = String.format(statementDistFormat, this.delimit(current_symbol), distName, meanExpression, varCompleteLabel);
                    lines.add(current_value);
                }
            } else {
                throw new RuntimeException("Distribution not supported");
            }
            return lines;
        }
        throw new RuntimeException("Distribution not supported");
    }

    private List<String> doProbOntoDistributionPrior(PharmMLRootType el) {
        ProbOnto pb;
        PopulationParameter context;
        ArrayList<String> lines = new ArrayList<String>();
        String name = "";
        List<Object> ret = new ArrayList();
        if (el instanceof PopulationParameter) {
            context = (PopulationParameter)el;
            pb = context.getDistribution().getProbOnto();
            name = pb.getName().value();
        } else if (el instanceof ParameterRandomVariable) {
            context = (ParameterRandomVariable)el;
            pb = context.getDistribution().getProbOnto();
            name = pb.getName().value();
        }
        switch (name) {
            case "Normal1": 
            case "Normal2": 
            case "Normal3": {
                ret = this.doNormalPriors(el);
                break;
            }
            case "Gamma1": 
            case "Gamma2": {
                ret = this.doGammaPriors(el);
                break;
            }
            case "Exponential1": 
            case "Exponential2": {
                ret = this.doExponentialPriors(el);
                break;
            }
            case "LogNormal1": 
            case "LogNormal2": 
            case "LogNormal3": 
            case "LogNormal4": 
            case "LogNormal5": 
            case "LogNormal6": {
                ret = this.doLogNormalPriors(el);
                break;
            }
            case "Beta1": {
                ret = this.doBetaPriors(el);
                break;
            }
            case "StudentT1": 
            case "StudentT2": {
                ret = this.doStudentPriors(el);
                break;
            }
            case "Uniform1": {
                ret = this.doUniformPriors(el);
                break;
            }
            case "Weibull1": 
            case "Weibull12": {
                ret = this.doWeibullPriors(el);
                break;
            }
            case "InverseGamma1": {
                ret = this.doInverseGammaPriors(el);
                break;
            }
            case "Wishart1": 
            case "Wishart2": {
                ret = this.doWishartPriors(el);
                break;
            }
            case "InverseWishart1": 
            case "InverseWishart2": {
                ret = this.doInverseWishartPriors(el);
                break;
            }
            case "MultivariateNormal1": 
            case "MultivariateNormal2": {
                ret = this.doMultivariateNormalPriors(el);
                break;
            }
            case "MultivariateStudentT1": 
            case "MultivariateStudentT2": {
                ret = this.doMultivariateStudentTPriors(el);
                break;
            }
            default: {
                throw new UnsupportedOperationException("ProbOnto distribution " + name + " not supported");
            }
        }
        lines.addAll(ret);
        return lines;
    }

    private List<String> writeRandomVarProbOntoDistribution(ParameterRandomVariable context) {
        ArrayList<String> lines = new ArrayList<String>();
        ProbOnto pb = context.getDistribution().getProbOnto();
        String name = pb.getName().value();
        String ret = null;
        switch (name) {
            case "Normal1": 
            case "Normal2": 
            case "Normal3": {
                ret = this.doNormalProbOntoDist(context, lines);
                break;
            }
            case "Gamma1": 
            case "Gamma2": {
                ret = this.doGamma(context, lines);
                break;
            }
            case "Exponential1": 
            case "Exponential2": {
                ret = this.doExponential(context, lines);
                break;
            }
            case "LogNormal1": 
            case "LogNormal2": 
            case "LogNormal3": 
            case "LogNormal4": 
            case "LogNormal5": 
            case "LogNormal6": {
                ret = this.doLogNormal(context, lines);
                break;
            }
            case "Beta1": {
                ret = this.doBeta(context, lines);
                break;
            }
            case "StudentT1": 
            case "StudentT2": {
                ret = this.doStudent(context, lines);
                break;
            }
            case "Uniform1": {
                ret = this.doUniform(context, lines);
                break;
            }
            case "Weibull1": 
            case "Weibull12": {
                ret = this.doWeibull(context, lines);
                break;
            }
            case "InverseGamma1": {
                ret = this.doInverseGamma(context, lines);
                break;
            }
            case "Wishart1": 
            case "Wishart2": {
                ret = this.doWishart((CommonParameter)context, lines, false);
                break;
            }
            case "InverseWishart1": 
            case "InverseWishart2": {
                ret = this.doInverseWishart((CommonParameter)context, lines, false);
                break;
            }
            case "MultivariateNormal1": 
            case "MultivariateNormal2": {
                ret = this.doMultivariateNormal((CommonParameter)context, lines, false);
                break;
            }
            case "MultivariateStudentT1": 
            case "MultivariateStudentT2": {
                ret = this.doMultivariateTStudent((CommonParameter)context, lines, false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("ProbOnto distribution " + name + " not supported");
            }
        }
        lines.add(ret);
        return lines;
    }

    private String doGamma(ParameterRandomVariable context, List<String> lines) {
        String formatDist = "%s %s %s(%s,%s)";
        String formatPar1 = "%s %s 1/%s";
        String formatPar2 = "%s %s %s";
        ProbOnto value = context.getDistribution().getProbOnto();
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        String par1 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(0)));
        String par2 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(1)));
        String id = context.getSymbId() + "_rate";
        lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), par1, id));
        if (distName.equals("Gamma1")) {
            lines.add(String.format(formatPar1, id, assignSymbol, par2));
        } else {
            lines.add(String.format(formatPar2, id, assignSymbol, par2));
        }
        return distName + "(" + par1 + "," + par2 + ")";
    }

    private String doBeta(ParameterRandomVariable context, List<String> lines) {
        String formatDist = "%s %s %s(%s,%s)";
        String formatPar2 = "%s %s %s";
        ProbOnto value = context.getDistribution().getProbOnto();
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        String par1 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(0)));
        String par2 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(1)));
        String id = context.getSymbId() + "_rate";
        lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), par1, id));
        lines.add(String.format(formatPar2, id, assignSymbol, par2));
        return distName + "(" + par1 + "," + par2 + ")";
    }

    private String doExponential(ParameterRandomVariable context, List<String> lines) {
        String formatDist = "%s %s %s(%s,%s)";
        String formatPar1 = "%s %s 1/%s";
        ProbOnto value = context.getDistribution().getProbOnto();
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        String par1 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(0)));
        String id = context.getSymbId() + "_rate";
        if (distName.equals("Exponential1")) {
            lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), par1));
        } else {
            lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), id));
            lines.add(String.format(formatPar1, id, assignSymbol, par1));
        }
        return distName + "(" + par1 + ")";
    }

    private String doLogNormal(ParameterRandomVariable context, List<String> lines) {
        String formatDist = "%s %s %s(%s,%s)";
        String formatPar1 = "%s %s";
        ProbOnto value = context.getDistribution().getProbOnto();
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        String par1 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(0)));
        String par2 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(1)));
        String id1 = context.getSymbId() + varianceSuffixLabel;
        String id2 = context.getSymbId() + "_meanLog";
        if (distName.equals("LogNormal5")) {
            lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), par1, par2));
        }
        if (distName.equals("LogNormal3")) {
            lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), id2, id1));
            lines.add(String.format(formatPar1 + "1/pow(%s,2)", id1, assignSymbol, par2));
            lines.add(String.format(formatPar1 + "log(%s)", id2, assignSymbol, par1));
        } else if (distName.equals("LogNormal6")) {
            lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), id2, id1));
            lines.add(String.format(formatPar1 + "log(%s)", id2, assignSymbol, par1));
            lines.add(String.format(formatPar1 + "1/pow(log(%s),2)", id1, assignSymbol, par2));
        } else {
            lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), par1, id1));
            if (distName.equals("LogNormal1")) {
                lines.add(String.format(formatPar1 + "1/pow(%s,2)", id1, assignSymbol, par2));
            } else if (distName.equals("LogNormal2")) {
                lines.add(String.format(formatPar1 + "(1/(%s))", id1, assignSymbol, par2));
            } else if (distName.equals("LogNormal4")) {
                lines.add(String.format(formatPar1 + "1/(log(pow(%s,2)+1))", id1, assignSymbol, par2));
            }
        }
        return distName + "(" + par1 + "," + par2 + ")";
    }

    private String doStudent(ParameterRandomVariable context, List<String> lines) {
        String formatDist = "%s %s %s(%s,%s,%s)";
        String formatPar2 = "%s %s %s";
        ProbOnto value = context.getDistribution().getProbOnto();
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        String par1 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(0)));
        String par2 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(1)));
        String par3 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(2)));
        String id = context.getSymbId() + "_rate";
        if (distName.equals("StudentT1")) {
            lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), "mean", "scale", par1));
            lines.add(String.format(formatPar2, "mean", assignSymbol, 0));
            lines.add(String.format(formatPar2, "scale", assignSymbol, 1));
        } else {
            lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), "mean", "scale", par1));
            lines.add(String.format(formatPar2, "mean", assignSymbol, par2));
            lines.add(String.format(formatPar2, "scale", assignSymbol, par3));
        }
        return distName + "(" + par1 + "," + par2 + ")";
    }

    private String doUniform(ParameterRandomVariable context, List<String> lines) {
        String formatDist = "%s %s %s(%s,%s)";
        ProbOnto value = context.getDistribution().getProbOnto();
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        String par1 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(0)));
        String par2 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(1)));
        lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), par1, par2));
        return distName + "(" + par1 + "," + par2 + ")";
    }

    private String doInverseGamma(ParameterRandomVariable context, List<String> lines) {
        String formatDist = "%s %s %s(%s,%s)";
        ProbOnto value = context.getDistribution().getProbOnto();
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        String par1 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(0)));
        String par2 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(1)));
        lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), par1, "rate"));
        lines.add(String.format("%s %s -1/%s", "rate", assignSymbol, par2));
        return distName + "(" + par1 + "," + par2 + ")";
    }

    private String doWishart(CommonParameter cp, List<String> lines, boolean addToPriorList) {
        String formatDist = "%s[1:%s,1:%s] %s %s(%s_inverseScaleMatrix[,],%s)";
        ProbOnto value = (ProbOnto)Util.getDistribution(cp);
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        DistributionParameter doF = value.getParameter(ParameterName.DEGREES_OF_FREEDOM);
        String par1 = this.getParameter(doF);
        switch (distName) {
            case "Wishart1": {
                DistributionParameter scaleMat = value.getParameter(ParameterName.SCALE_MATRIX);
                String scalePar = this.getParameter(scaleMat);
                Integer dim = this.matrixMap.get(cp.getSymbId())[0];
                lines.add(String.format(formatDist, cp.getSymbId(), dim, dim, dist_symb, this.getDistName(value), cp.getSymbId(), par1));
                lines.add(String.format("%s_inverseScaleMatrix[1:%s,1:%s] %s inverse(%s[,])", cp.getSymbId(), dim, dim, assignSymbol, scalePar));
                break;
            }
            case "Wishart2": {
                DistributionParameter invScaleMat = value.getParameter(ParameterName.INVERSE_SCALE_MATRIX);
                String par2 = this.getParameter(invScaleMat);
                Integer dim = this.matrixMap.get(cp.getSymbId())[0];
                lines.add(String.format("%s[1:%s, 1:%s] %s %s(%s[,],%s)", cp.getSymbId(), dim, dim, dist_symb, this.getDistName(value), par2, par1));
            }
        }
        if (addToPriorList) {
            this.priorList.add(cp.getSymbId());
            lines.addAll(this.addPrior(cp.getSymbId(), par1));
        }
        return "";
    }

    private String doInverseWishart(CommonParameter cp, List<String> lines, boolean addToPriorList) {
        String formatDist = "inverse%s[1:%s,1:%s] %s %s(%s_inverseScaleMatrix[,],%s)";
        ProbOnto value = (ProbOnto)Util.getDistribution(cp);
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        DistributionParameter doF = value.getParameter(ParameterName.DEGREES_OF_FREEDOM);
        String par1 = this.getParameter(doF);
        DistributionParameter scaleMat = value.getParameter(ParameterName.SCALE_MATRIX);
        String par2 = this.getParameter(scaleMat);
        Integer dim = this.matrixMap.get(par2)[0];
        lines.add(String.format(formatDist, cp.getSymbId(), dim, dim, dist_symb, this.getDistName(value), cp.getSymbId(), par1));
        lines.add(String.format("%s_inverseScaleMatrix[1:%s,1:%s] %s inverse(%s[,])", cp.getSymbId(), dim, dim, assignSymbol, par2));
        lines.add(String.format("%s[1:%s,1:%s] %s inverse(inverse%s[,])", cp.getSymbId(), dim, dim, assignSymbol, cp.getSymbId()));
        if (addToPriorList) {
            this.priorList.add(cp.getSymbId());
            lines.addAll(this.addPrior(cp.getSymbId(), par1));
        }
        return "";
    }

    private String getParse(Object o) {
        String tmp = this.parse(o, this.lexer.getTreeMaker().newInstance(o));
        return tmp;
    }

    private List<String> getMeanVector(DistributionParameter o, String idVect, Integer len) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 1;
        if (o.getAssign().getVector() != null) {
            Vector vet = o.getAssign().getVector();
            if (vet.getVectorElements().getListOfElements().size() > 1) {
                for (VectorValue ve : vet.getVectorElements().getListOfElements()) {
                    list.add(String.format("%s[%s] %s %s", idVect, i++, assignSymbol, this.myParse(ve)));
                }
            } else if (vet.getVectorElements().getListOfElements().size() == 1) {
                VectorValue sr = (VectorValue)vet.getVectorElements().getListOfElements().get(0);
                if (sr instanceof SymbolRef) {
                    for (int k = 1; k <= len; ++k) {
                        list.add(String.format("%s[%s] %s %s[%s]", idVect, k, assignSymbol, ((SymbolRef)sr).getSymbIdRef(), k));
                    }
                }
            } else {
                System.out.println("Vector " + idVect + " empty.");
                this.outDebug.println("Vector " + idVect + " empty.");
            }
        } else if (o.getAssign().getSymbRef() != null) {
            list.addAll(this.genVector(idVect, this.getParameter(o), len));
        }
        return list;
    }

    List<String> genMatrix(String idLeft, String idRigth, int len) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= len; ++i) {
            for (int j = 1; j <= len; ++j) {
                list.add(String.format("%s[%s,%s] %s %s[%s,%s]", idLeft, i, j, assignSymbol, idRigth, i, j));
            }
        }
        return list;
    }

    List<String> genVector(String idLeft, String idRigth, int len) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= len; ++i) {
            list.add(String.format("%s[%s] %s %s[%s]", idLeft, i, assignSymbol, idRigth, i));
        }
        return list;
    }

    private List<String> getVectorElements(Vector o, String idVect) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 1;
        for (VectorValue ve : o.getVectorElements().getListOfElements()) {
            list.add(String.format("%s[%s] %s %s", idVect, i, assignSymbol, this.getVectorValue(ve), i));
            ++i;
        }
        return list;
    }

    private String doMultivariateNormal(CommonParameter cp, List<String> lines, boolean addToPriorList) {
        String formatDist = "%s[1:%s] %s %s(%s[],%s[,])";
        ProbOnto value = (ProbOnto)Util.getDistribution(cp);
        String distName = value.getName().value();
        String id1 = cp.getSymbId() + meanSuffixLabel;
        String id2 = cp.getSymbId() + varianceSuffixLabel;
        String par1 = "";
        String par2 = "";
        DistributionParameter mean = value.getParameter(ParameterName.MEAN);
        switch (distName) {
            case "MultivariateNormal1": {
                DistributionParameter covMat = value.getParameter(ParameterName.COVARIANCE_MATRIX);
                String covPar = this.getParameter(covMat);
                int mDim = this.matrixMap.get(covPar)[0];
                lines.add(String.format(formatDist, cp.getSymbId(), mDim, dist_symb, this.getDistName(value), id1, id2));
                lines.addAll(this.getMeanVector(mean, id1, mDim));
                lines.add(String.format("%s[1:%s,1:%s] %s inverse(%s[,])", id2, mDim, mDim, assignSymbol, covPar));
                break;
            }
            case "MultivariateNormal2": {
                DistributionParameter precMat = value.getParameter(ParameterName.PRECISION_MATRIX);
                String precPar = this.getParameter(precMat);
                int mDim = this.matrixMap.get(precPar)[0];
                lines.add(String.format(formatDist, cp.getSymbId(), mDim, dist_symb, this.getDistName(value), id1, precPar));
                lines.addAll(this.getMeanVector(mean, id1, mDim));
            }
        }
        if (addToPriorList) {
            this.priorList.add(cp.getSymbId());
        }
        return "";
    }

    private String doMultivariateTStudent(CommonParameter cp, List<String> lines, boolean addToPriorList) {
        String formatDist = "%s[1:%s] %s %s(%s[],%s[,],%s)";
        ProbOnto value = (ProbOnto)Util.getDistribution(cp);
        String distName = value.getName().value();
        String par1 = "";
        String par2 = "";
        DistributionParameter mean = value.getParameter(ParameterName.MEAN);
        DistributionParameter deg = value.getParameter(ParameterName.DEGREES_OF_FREEDOM);
        String meanId = cp.getSymbId() + meanSuffixLabel;
        String precId = cp.getSymbId() + varianceSuffixLabel;
        String degId = this.getParameter(deg);
        switch (distName) {
            case "MultivariateStudentT1": {
                DistributionParameter covMat = value.getParameter(ParameterName.COVARIANCE_MATRIX);
                String covPar = this.getParameter(covMat);
                int mDim = this.matrixMap.get(covPar)[0];
                lines.add(String.format(formatDist, cp.getSymbId(), mDim, dist_symb, this.getDistName(value), meanId, precId, degId));
                lines.addAll(this.getMeanVector(mean, meanId, mDim));
                lines.add(String.format("%s[1:%s,1:%s] %s inverse(%s[,])", precId, mDim, mDim, assignSymbol, covPar));
                break;
            }
            case "MultivariateStudentT2": {
                DistributionParameter precMat = value.getParameter(ParameterName.PRECISION_MATRIX);
                String precPar = this.getParameter(precMat);
                int mDim = this.matrixMap.get(precPar)[0];
                lines.add(String.format(formatDist, cp.getSymbId(), mDim, dist_symb, this.getDistName(value), meanId, this.getParameter(precMat), degId));
                lines.addAll(this.getMeanVector(mean, meanId, mDim));
            }
        }
        if (addToPriorList) {
            this.priorList.add(cp.getSymbId());
        }
        return "";
    }

    private String doWeibull(ParameterRandomVariable context, List<String> lines) {
        String formatDist = "%s %s %s(%s,%s)";
        String formatPar1 = "lambda %s pow(%s,(-1/%s))";
        ProbOnto value = context.getDistribution().getProbOnto();
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        String par1 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(0)));
        String par2 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(1)));
        String id = context.getSymbId() + "_rate";
        if (distName.equals("Weibull1")) {
            lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), "lambda", par2));
            lines.add(String.format(formatPar1, assignSymbol, par1, par2));
        } else {
            lines.add(String.format(formatDist, context.getSymbId(), dist_symb, this.getDistName(this.getProbOntoDistributionType(context)), par1, par2));
        }
        return distName + "(" + par1 + "," + par2 + ")";
    }

    String doNormalProbOntoDist(ParameterRandomVariable context, List<String> lines) {
        String formatDistMeanValAssign = "<- %s";
        String formatDistVarValAssign = "<- (1/(%s))";
        String formatDistMeanVal = "%s";
        ProbOnto value = context.getDistribution().getProbOnto();
        String distName = this.getDistName(value);
        DistributionParameter mean = value.getParameter(ParameterName.MEAN);
        DistributionParameter par2 = null;
        String varAss = "";
        switch (value.getName().value()) {
            case "Normal1": {
                par2 = value.getParameter(ParameterName.STDEV);
                varAss = String.format("pow(%s,2)", this.parse(par2, this.lexer.getTreeMaker().newInstance((Object)par2)));
                break;
            }
            case "Normal2": {
                par2 = value.getParameter(ParameterName.VAR);
                varAss = this.parse(par2, this.lexer.getTreeMaker().newInstance((Object)par2));
                break;
            }
            case "Normal3": {
                par2 = value.getParameter(ParameterName.PRECISION);
                varAss = String.format(" (1/(%s))", this.parse(par2, this.lexer.getTreeMaker().newInstance((Object)par2)));
            }
        }
        SymbolRef srM = new SymbolRef();
        String meanAss = this.parse(mean, this.lexer.getTreeMaker().newInstance((Object)mean));
        String meanAssign = null;
        if (mean.getAssign() != null) {
            srM.setSymbIdRef(meanAss);
            meanAssign = this.delimit(meanAss);
        }
        String varianceAssign = this.delimit(varAss);
        String rhsVarExpression = String.format(formatDistVarValAssign, varianceAssign);
        String rhsMeanExpression = String.format(formatDistMeanValAssign, meanAssign);
        String meanExpression = this.delimit(String.format(formatDistMeanVal, meanAssign));
        String brackets = this.getIndexes(rhsMeanExpression) == 32 ? "" : this.getBrackets(rhsMeanExpression);
        brackets = this.getIndexes(rhsVarExpression) == 32 ? "" : this.getBracketsGen(rhsVarExpression);
        String varTmpName = context.getSymbId() + varianceSuffixLabel;
        String formatDistVarAssignement = varTmpName + "%s %s";
        String varAssignStmt = String.format(formatDistVarAssignement, brackets, rhsVarExpression);
        String varCompleteLabel = this.delimit(Util.clean(varTmpName + brackets));
        lines.add(varAssignStmt);
        String current_symbol = this.getSymbol(context);
        String statementDistFormat = "%s ~ %s(%s, %s)";
        return String.format(statementDistFormat, this.delimit(current_symbol), distName, meanExpression, varCompleteLabel);
    }

    private Object findElement(BinaryTree bk) {
        Object[] elements;
        ScriptDefinition sd = this.lexer.getScriptDefinition();
        Map stm = sd.getStatementsMap();
        for (Object o : elements = stm.keySet().toArray(new Object[0])) {
            if (!((BinaryTree)stm.get(o)).equals(bk)) continue;
            return o;
        }
        return null;
    }

    private String doCommonVariable(CommonVariableDefinition v) {
        return this.z.get((Object)v.getSymbId());
    }

    private String doMatrixSelector(MatrixSelector v) {
        return v.getSymbRef().getSymbIdRef();
    }

    private String doMatrixUniOp(MatrixUniOp v) {
        return "@";
    }

    protected boolean isIndependentVariableSym(String symbol) {
        String currentSymbol;
        IndependentVariable ip;
        return symbol != null && (ip = (IndependentVariable)this.lexer.getDom().getListOfIndependentVariable().get(0)) != null && (currentSymbol = ip.getSymbId()) != null && currentSymbol.equals(symbol);
    }

    private void updatePriorList(PharmMLRootType par) {
        block8: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            if (this.priorLevel == null) break block8;
                            if (!(par instanceof PopulationParameter)) break block9;
                            PopulationParameter p = (PopulationParameter)par;
                            for (LevelReference vRef : p.getListOfVariabilityReference()) {
                                if (!vRef.getSymbRef().getSymbIdRef().equals(this.priorLevel.getSymbId())) continue;
                                this.priorPar.put(par, p.getSymbId());
                            }
                            break block8;
                        }
                        if (!(par instanceof IndividualParameter)) break block10;
                        IndividualParameter p = (IndividualParameter)par;
                        for (LevelReference vRef : p.getListOfVariabilityReference()) {
                            if (!vRef.getSymbRef().getSymbIdRef().equals(this.priorLevel.getSymbId())) continue;
                            this.priorPar.put(par, p.getSymbId());
                        }
                        break block8;
                    }
                    if (!(par instanceof CategoricalCovariate)) break block11;
                    CategoricalCovariate p = (CategoricalCovariate)par;
                    for (LevelReference vRef : p.getListOfVariabilityReference()) {
                        if (!vRef.getSymbRef().getSymbIdRef().equals(this.priorLevel.getSymbId())) continue;
                        this.priorPar.put(par, p.getId());
                    }
                    break block8;
                }
                if (!(par instanceof Correlation)) break block12;
                Correlation p = (Correlation)par;
                LevelReference vRef = p.getVariabilityReference();
                if (!vRef.getSymbRef().getSymbIdRef().equals(this.priorLevel.getSymbId())) break block8;
                this.priorPar.put(par, p.getId());
                break block8;
            }
            if (par instanceof ParameterRandomVariable) {
                ParameterRandomVariable p = (ParameterRandomVariable)par;
                for (LevelReference vRef : p.getListOfVariabilityReference()) {
                    if (!vRef.getSymbRef().getSymbIdRef().equals(this.priorLevel.getSymbId())) continue;
                    this.priorPar.put(par, p.getSymbId());
                }
            } else if (par instanceof GeneralObsError) {
                GeneralObsError p = (GeneralObsError)par;
                for (LevelReference vRef : p.getListOfVariabilityReference()) {
                    if (!vRef.getSymbRef().getSymbIdRef().equals(this.priorLevel.getSymbId())) continue;
                    this.priorPar.put(par, p.getSymbId());
                }
            }
        }
    }

    protected List<String> getMatrixElementsAny(Matrix mat, String id) {
        ArrayList<String> lines = new ArrayList<String>();
        List list = mat.getListOfMatrixElements();
        int i = 1;
        int j = 1;
        for (PharmMLRootType el : list) {
            for (MatrixRowValue e : ((MatrixRow)el).getListOfValues()) {
                lines.add(String.format("%s[%d,%d] %s %s", id, i, j, assignSymbol, this.myParse(e)));
                ++j;
            }
            ++i;
            j = 1;
        }
        Integer[] dim = new Integer[]{i - 1, i - 1};
        this.matrixMap.put(id, dim);
        this.reUpdateMatrixMapWithAllMaps();
        return lines;
    }

    protected List<String> getMatrixElementsLT(Matrix mat, String id) {
        ArrayList<String> lines = new ArrayList<String>();
        List list = mat.getListOfMatrixElements();
        int i = 1;
        int j = 1;
        int mDim = mat.getListOfMatrixElements().size();
        for (PharmMLRootType el : list) {
            j = 1;
            for (MatrixRowValue e : ((MatrixRow)el).getListOfValues()) {
                if (j < i) {
                    lines.add(String.format("%s[%d,%d] %s %s", id, j, i, assignSymbol, this.myParse(e)));
                }
                lines.add(String.format("%s[%d,%d] %s %s", id, i, j, assignSymbol, this.myParse(e)));
                ++j;
            }
            ++i;
        }
        Integer[] dim = new Integer[]{mDim, mDim};
        this.matrixMap.put(id, dim);
        this.reUpdateMatrixMapWithAllMaps();
        return lines;
    }

    protected List<String> getMatrixElementsUT(Matrix mat, String id) {
        ArrayList<String> lines = new ArrayList<String>();
        List list = mat.getListOfMatrixElements();
        int i = 1;
        int j = 1;
        int mDim = mat.getListOfMatrixElements().size();
        for (PharmMLRootType el : list) {
            j = 1;
            for (MatrixRowValue e : ((MatrixRow)el).getListOfValues()) {
                if (j > i) {
                    lines.add(String.format("%s[%d,%d] %s %s", id, j, i, assignSymbol, this.myParse(e)));
                }
                lines.add(String.format("%s[%d,%d] %s %s", id, i, j, assignSymbol, this.myParse(e)));
                ++j;
            }
            ++i;
        }
        Integer[] dim = new Integer[]{i - 1, i - 1};
        this.matrixMap.put(id, dim);
        this.reUpdateMatrixMapWithAllMaps();
        return lines;
    }

    protected List<String> getMatrix(Matrix mat, String id) {
        ArrayList<String> lines = new ArrayList<String>();
        switch (mat.getMatrixType()) {
            case "Any": {
                lines.addAll(this.getMatrixElementsAny(mat, id));
                break;
            }
            case "LowerTriangular": {
                lines.addAll(this.getMatrixElementsLT(mat, id));
                break;
            }
            case "UpperTriangular": {
                lines.addAll(this.getMatrixElementsUT(mat, id));
            }
        }
        return lines;
    }

    private void updateMatrixMap() {
        Matrix mat = null;
        for (PopulationParameter p : this.getModelParameters()) {
            if (p.getAssign() == null) continue;
            if (p.getAssign().getMatrix() != null) {
                mat = p.getAssign().getMatrix();
            } else {
                if (p.getAssign().getMatrixUniop() == null) continue;
                MatrixUniOp muo = p.getAssign().getMatrixUniop();
                if (muo.getValue() instanceof Matrix) {
                    mat = (Matrix)muo.getValue();
                }
            }
            int nR = mat.getListOfMatrixElements().size();
            int nC = ((MatrixRow)mat.getListOfMatrixElements().get(0)).getListOfValues().size();
            Integer[] dim = new Integer[]{nR, nC};
            this.matrixMap.put(p.getSymbId(), dim);
            this.reUpdateMatrixMapWithAllMaps();
        }
        this.reUpdateMatrixVectorMapsWithAllMaps();
    }

    private void updateVectorMap() {
        for (PopulationParameter p : this.getModelParameters()) {
            if (p.getAssign() == null || p.getAssign().getVector() == null) continue;
            Vector vet = p.getAssign().getVector();
            int nR = vet.getVectorElements().getListOfElements().size();
            this.vectorMap.put(p.getSymbId(), nR);
        }
        this.reUpdateMatrixVectorMapsWithAllMaps();
    }

    private boolean checkMatrix(PopulationParameter p, BinaryTree bt) {
        int nR = 0;
        int nC = 0;
        String name = null;
        String tmp = "";
        for (Node node : bt.nodes) {
            if (node.data instanceof MatrixSelector) {
                MatrixSelector ms = (MatrixSelector)node.data;
                String value = ms.getSymbRef().getSymbIdRef() + "[" + ms.getCell().getRowIndex().getAssign().toMathExpression() + "," + ms.getCell().getColumnIndex().getAssign().toMathExpression() + "]";
                String current_value = String.format("%s <- %s", this.delimit(p.getSymbId()), this.delimit(value));
                this.populationParametersMatrixLines.add(current_value);
                return true;
            }
            if (node.data instanceof Matrix) {
                ArrayList<String> lines = new ArrayList<String>();
                switch (((Matrix)node.data).getMatrixType()) {
                    case "Any": {
                        lines.addAll(this.getMatrixElementsAny((Matrix)node.data, p.getSymbId()));
                        break;
                    }
                    case "LowerTriangular": {
                        lines.addAll(this.getMatrixElementsLT((Matrix)node.data, p.getSymbId()));
                        break;
                    }
                    case "UpperTriangular": {
                        lines.addAll(this.getMatrixElementsUT((Matrix)node.data, p.getSymbId()));
                    }
                }
                this.populationParametersLines.addAll(lines);
                return true;
            }
            if (!(node.data instanceof MatrixUniOp)) continue;
            MatrixUniOp muo = (MatrixUniOp)node.data;
            if (muo.getValue() instanceof Matrix) {
                Matrix mat = (Matrix)muo.getValue();
                name = p.getSymbId() + muo.getOp().value().substring(0, 3);
                Integer dim = this.matrixMap.get(p.getSymbId())[0];
                ArrayList<String> lines = new ArrayList<String>();
                lines.addAll(this.getMatrix(mat, name));
                this.matrixVectorLines.addAll(lines);
                this.populationParametersMatrixLines.add(String.format("%s[1:%s,1:%s] %s %s(%s[,])", p.getSymbId(), dim, dim, assignSymbol, muo.getOp().value(), name));
                String current_value = "";
                if (p.getAssign() != null && p.getAssign().getMatrixUniop() != null) {
                    if (muo.getValue() instanceof SymbolRef) {
                        String value = this.delimit(muo.getOp().value() + "(" + ((SymbolRef)muo.getValue()).getSymbIdRef() + ")");
                        current_value = String.format("%s <- %s", name, value);
                    }
                    this.populationParametersMatrixLines.add(current_value);
                }
            } else if (muo.getValue() instanceof SymbolRef) {
                String ob;
                PopulationParameter pp = null;
                name = ((SymbolRef)p.getAssign().getMatrixUniop().getValue()).getSymbIdRef();
                PharmMLRootType o = this.lexer.getAccessor().fetchElement(name);
                if (o instanceof PopulationParameter) {
                    pp = (PopulationParameter)o;
                    if (pp.getAssign() != null && pp.getAssign().getMatrix() != null) {
                        nR = pp.getAssign().getMatrix().getNumbRows();
                        nC = pp.getAssign().getMatrix().getNumbCols();
                        Integer[] dim = new Integer[]{nR, nC};
                        this.matrixMap.put(pp.getSymbId(), dim);
                        this.reUpdateMatrixMapWithAllMaps();
                        String value = this.delimit(muo.getOp().value() + "(" + ((SymbolRef)muo.getValue()).getSymbIdRef() + "[,])");
                        String current_value = String.format("%s[1:%s,1:%s] <- %s", p.getSymbId(), nR, nC, value);
                        this.populationParametersMatrixLines.add(current_value);
                    } else if (pp.getAssign() != null && pp.getDistribution() != null) {
                        List dps = pp.getDistribution().getProbOnto().getListOfParameter();
                        for (DistributionParameter par : dps) {
                            String distPar = this.getParameter(par);
                            PopulationParameter ppar = (PopulationParameter)this.lexer.getAccessor().fetchElement(distPar);
                            if (ppar.getAssign().getMatrix() != null) {
                                this.addToMatrixMap(ppar.getAssign().getMatrix(), pp.getSymbId());
                                continue;
                            }
                            if (ppar.getAssign().getVector() == null) continue;
                            this.addToVectorMap(ppar.getAssign().getVector(), pp.getSymbId());
                        }
                        Integer[] mDim = this.matrixMap.get(p.getSymbId());
                        this.populationParametersMatrixLines.add(String.format("%s[1:%s,1:%s] %s %s(%s[,])", p.getSymbId(), mDim[0], mDim[1], assignSymbol, muo.getOp().value(), name));
                    }
                } else if (o instanceof SymbolRef && (ob = this.lexer.getAccessor().fetchElement((SymbolRef)o).getId()) instanceof PopulationParameter && (pp = (PopulationParameter)ob).getAssign() != null && pp.getAssign().getMatrix() != null) {
                    nR = pp.getAssign().getMatrix().getNumbRows();
                    nC = pp.getAssign().getMatrix().getNumbCols();
                    Integer[] dim = new Integer[]{nR, nC};
                    this.matrixMap.put(pp.getSymbId(), dim);
                    this.reUpdateMatrixMapWithAllMaps();
                    String value = this.delimit(muo.getOp().value() + "(" + ((SymbolRef)muo.getValue()).getSymbIdRef() + "[,])");
                    String current_value = String.format("%s[1:%s,1:%s] <- %s", p.getSymbId(), nR, nC, value);
                    this.populationParametersMatrixLines.add(current_value);
                }
            } else {
                String id = p.getSymbId();
                return true;
            }
            return false;
        }
        return false;
    }

    private void addToMatrixMap(Matrix mat, String idVar) {
        int nR = mat.getListOfMatrixElements().size();
        int nC = ((MatrixRow)mat.getListOfMatrixElements().get(0)).getListOfValues().size();
        Integer[] dim = new Integer[]{nR, nC};
        this.matrixMap.put(idVar, dim);
        this.reUpdateMatrixVectorMapsWithAllMaps();
    }

    private void addToVectorMap(Vector vet, String idVar) {
        int nR = vet.getListOfVectorCellAndSegment().size();
        this.vectorMap.put(idVar, nR);
        this.reUpdateMatrixVectorMapsWithAllMaps();
    }

    private void reUpdateMatrixMapWithMap(Map<String, List<SymbolRef>> map) {
        Set<String> es = map.keySet();
        for (String s : es) {
            List<SymbolRef> depV = map.get(s);
            for (String sv : Util.getList(depV)) {
                if (this.matrixMap.containsKey(s) || this.matrixMap.get(sv) == null) continue;
                this.matrixMap.put(s, this.matrixMap.get(sv));
                this.reUpdateMatrixMapWithAllMaps();
            }
        }
    }

    private void reUpdateMatrixVectorMapsWithAllMaps() {
        this.reUpdateMatrixMapWithAllMaps();
        this.reUpdateVectorMapWithAllMaps();
    }

    private void reUpdateMatrixMapWithAllMaps() {
        this.reUpdateMatrixMapWithMap(this.parVariablesFromMap);
        this.reUpdateMatrixMapWithMap(this.randVariablesFromMap);
    }

    private void reUpdateVectorMapWithAllMaps() {
        this.reUpdateVectorMapWithMap(this.parVariablesFromMap);
        this.reUpdateVectorMapWithMap(this.randVariablesFromMap);
    }

    private void reUpdateVectorMapWithMap(Map<String, List<SymbolRef>> map) {
        Set<String> es = map.keySet();
        for (String s : es) {
            List<SymbolRef> depV = map.get(s);
            for (String sv : Util.getList(depV)) {
                if (this.vectorMap.containsKey(s) || this.vectorMap.get(sv) == null) continue;
                this.vectorMap.put(s, this.vectorMap.get(sv));
            }
        }
    }

    protected void managePopulationParameters() throws ParserConfigurationException, SAXException, IOException {
        this.variableCompleteList = this.loadXML(this.xmlFileName);
        String rightPart = "";
        this.updateMatrixMap();
        this.updateVectorMap();
        List<PopulationParameter> mpList = this.getModelParameters();
        for (PopulationParameter p : mpList) {
            if (Parser.isInList(this.assignedSimpleParList, p.getSymbId())) {
                TreeMaker tm = this.lexer.getTreeMaker();
                BinaryTree bt = tm.newInstance((Object)p);
                if (this.checkMatrix(p, bt)) continue;
                if (p.getAssign() != null) {
                    if (p.getAssign().getVector() != null) {
                        this.vectorMap.put(p.getSymbId(), p.getAssign().getVector().getVectorElements().getListOfElements().size());
                        this.populationParametersLines.addAll(this.getVectorElements(p.getAssign().getVector(), p.getSymbId()));
                    } else {
                        rightPart = this.parse(p, bt);
                        if (rightPart.trim().length() > 0) {
                            this.populationParametersLines.add(rightPart);
                        }
                    }
                }
            }
            this.updatePriorList((PharmMLRootType)p);
        }
        for (ObservationBlock ob : this.lexer.getScriptDefinition().getObservationBlocks()) {
            for (ObservationParameter sp : ob.getObservationParameters()) {
                if (!Parser.isInList(this.assignedSimpleParList, this.extract(sp.getName()))) continue;
                BinaryTree bt = this.lexer.getStatement((Object)sp);
                if (bt != null) {
                    rightPart = this.parse(sp, bt);
                }
                if (rightPart.trim().length() <= 0) continue;
                this.populationParametersLines.add(rightPart);
            }
        }
    }

    List<String> parseScriptLines(List<String> lines) {
        ArrayList toRemove = new ArrayList();
        List<String> output = new ArrayList<String>();
        boolean modified = true;
        for (String string : lines) {
            modified = true;
            String newLine = new String(string.trim());
            while (modified) {
                for (Map.Entry<String, String> pairs : this.variablesAssignementMap.entrySet()) {
                    modified = false;
                    if (!newLine.contains(pairs.getKey().toString().trim())) continue;
                    String tmp = pairs.getValue().toString().trim();
                    String oldTmp = tmp;
                    if (oldTmp != null && this.variablesAssignementMap.get(oldTmp) != null) {
                        while (tmp != null) {
                            oldTmp = tmp;
                            tmp = this.variablesAssignementMap.get(oldTmp);
                        }
                        newLine = newLine.replace(pairs.getKey().toString(), oldTmp);
                    } else {
                        newLine = newLine.replace(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                    newLine = this.adjustStatement(newLine);
                    if (!string.equals(newLine)) {
                        modified = true;
                    }
                    if (this.tmpVariablesAssignementMap.get(this.delimit(pairs.getKey().toString())) != null || this.variablesAssignementMap.get(this.delimit(pairs.getKey().toString())) != null) continue;
                    this.tmpVariablesAssignementMap.put(this.delimit(pairs.getKey().toString()), this.delimit(this.getLeft(newLine)));
                }
                if (modified) {
                    newLine = this.adjustStatement(newLine);
                    continue;
                }
                output.add(newLine);
            }
        }
        while (!this.tmpVariablesAssignementMap.isEmpty()) {
            for (Map.Entry entry : this.tmpVariablesAssignementMap.entrySet()) {
                String k = entry.getKey().toString().trim();
                String v = this.tmpVariablesAssignementMap.get(k);
                this.variablesAssignementMap.put(this.delimit(k), this.delimit(v));
            }
            this.tmpVariablesAssignementMap.clear();
            this.updateVariableAssMap();
            output = this.parseScriptLines(output);
        }
        return output;
    }

    private void updateVariableAssMap() {
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.variablesAssignementMap.entrySet()) {
            String k = entry.getKey().toString();
            String v = entry.getValue().toString();
            if (!v.contains(this.IND_BOTH)) continue;
            tmpMap.put(v.replace(this.IND_BOTH, this.IND_SUBJ), v);
            tmpMap.put(v.replace(this.IND_BOTH, this.IND_TIME), v);
        }
        for (Map.Entry<String, String> entry : tmpMap.entrySet()) {
            this.variablesAssignementMap.put(this.delimit(Util.clean(entry.getKey().toString())), this.delimit(Util.clean(entry.getValue().toString())));
        }
    }

    List<String> getValIndexes(String in) {
        ArrayList<String> list = new ArrayList<String>();
        if (in.contains(this.IND_BOTH)) {
            list.add(IND_S);
            list.add(IND_T);
        } else if (in.contains(IND_T)) {
            list.add(IND_T);
        } else if (in.contains(IND_S)) {
            list.add(IND_S);
        }
        return list;
    }

    private void putVariableMap(String key, String newVal) {
        if (this.isPiecewiseVar(Util.clean(key))) {
            return;
        }
        String oldVal = this.variablesAssignementMap.get(key);
        if (oldVal != null) {
            oldVal = this.delimit(Util.clean(oldVal));
            if (this.getValIndexes(newVal = this.delimit(Util.clean(newVal))).size() < this.getValIndexes(oldVal).size()) {
                this.variablesAssignementMap.put(newVal, oldVal);
                return;
            }
            if (this.getValIndexes(newVal).size() > this.getValIndexes(oldVal).size()) {
                this.variablesAssignementMap.put(oldVal, newVal);
                return;
            }
        }
        if (!Util.clean(key).equals(Util.clean(newVal))) {
            this.variablesAssignementMap.put(this.delimit(this.removeIndexes(Util.clean(key))), newVal);
        }
    }

    private List<String> loadXML(File nameFile) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<String> list = new ArrayList<String>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(nameFile);
        this.assignedSimpleParList = Util.getObjectsList(doc, "PopulationParameter");
        if (DEBUG) {
            this.outDebug.println("assignedSimpleParList = " + this.assignedSimpleParList);
        }
        this.parametersList = Util.getObjectsList(doc, "Parameter");
        if (DEBUG) {
            this.outDebug.println("parametersList = " + this.parametersList);
        }
        return list;
    }

    private void getSimplePar(NodeList nList) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nList.getLength(); ++i) {
            Node node = (Node)nList.item(i);
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                org.w3c.dom.Node child;
                Element eElement;
                NodeList children;
                org.w3c.dom.Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1 || (children = (eElement = (Element)nNode).getChildNodes()).getLength() <= 0 || (child = eElement.getFirstChild()) == null || child.getNextSibling() == null || !child.getNextSibling().getNodeName().equals("ct:Assign")) continue;
                if (!this.assignedSimpleParList.contains(eElement.getAttribute("symbId"))) {
                    this.assignedSimpleParList.add(eElement.getAttribute("symbId"));
                }
                if (list.contains(eElement.getAttribute("symbId"))) continue;
                list.add(eElement.getAttribute("symbId"));
            }
        }
    }

    private static List<String> getUniqueNameList(List<String> list0) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : list0) {
            if (Parser.isInNameList(list, s)) continue;
            list.add(s);
        }
        return list;
    }

    private String getTab(int n) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            s.append("  ");
        }
        return s.toString();
    }

    protected List<ParameterBlock> getParameterBlocks() {
        if (!this.lexer.getScriptDefinition().getParameterBlocks().isEmpty()) {
            return this.lexer.getScriptDefinition().getParameterBlocks();
        }
        return new ArrayList<ParameterBlock>();
    }

    protected boolean isSupportedUnaryOp(String op) {
        boolean isSupported = false;
        if (op != null) {
            isSupported = this.winbugs_unary_operators_list.contains(op);
        }
        if (isSupported) {
            return isSupported;
        }
        return super.isSupportedUnaryOp(op);
    }

    protected void initSupportedWinBugsUnaryOperators() {
        try {
            this.winbugs_unary_operators_list = new ArrayList<String>();
            this.winbugsUnaryOperatorsMap = new HashMap<String, String>();
            Class<?> cl = ((Object)((Object)this)).getClass();
            InputStream is = cl.getResourceAsStream("unary_operators_list.txt");
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String line = null;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            in.close();
            in = null;
            for (String line_ : lines) {
                String[] uniOperator;
                if (line_ == null || (uniOperator = (line_ = line_.trim()).split(" ")).length != 2) continue;
                uniOperator[0] = uniOperator[0].trim();
                uniOperator[1] = uniOperator[1].trim();
                if (this.winbugs_unary_operators_list.contains(uniOperator[0])) continue;
                this.winbugs_unary_operators_list.add(uniOperator[0]);
                this.winbugsUnaryOperatorsMap.put(uniOperator[0], uniOperator[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getUnaryOperator(String name) {
        String op = null;
        if (this.winbugsUnaryOperatorsMap.containsKey(name)) {
            op = this.winbugsUnaryOperatorsMap.get(name);
        }
        if (op != null) {
            return op;
        }
        return super.getUnaryOperator(name);
    }

    protected String doDerivativeDependentVariable(VariableDefinition var) {
        String s = var.getSymbId() + upperSuffixDerDepLabel;
        return s;
    }

    protected String doAppendSuffix(SymbolRef sr) {
        String s = sr.getSymbIdRef() + upperSuffixDerDepLabel;
        return s;
    }

    private List<String> makeCompactDerivativeModelLines() {
        ArrayList<String> newLines = new ArrayList<String>();
        for (String l : this.diffEqLines) {
            List vars = this.lexer.getLocalVariables();
            for (VariableDefinition v : vars) {
                String fromLabel = this.derivativeDefFromMap.get(v.getSymbId());
                String toLabel = this.doDerivativeDependentVariable(v);
                l = l.replace(fromLabel, toLabel);
            }
            newLines.add(l);
        }
        return newLines;
    }

    private List<String> adjustDerivativeModelLines() {
        ArrayList<String> newLines = new ArrayList<String>();
        String toAdd = "";
        for (String l : this.diffEqLines) {
            if (l.contains(IND_S) && l.contains(IND_T)) {
                toAdd = this.IND_BOTH;
            } else if (l.contains(IND_S)) {
                toAdd = this.IND_SUBJ;
            } else if (l.contains(IND_T)) {
                toAdd = this.IND_TIME;
            }
            List vars = this.lexer.getLocalVariables();
            for (VariableDefinition v : vars) {
                String fromLabel = this.doDerivativeDependentVariable(v);
                String toLabel = this.doDerivativeDependentVariable(v) + toAdd;
                l = l.replace(fromLabel, toLabel);
            }
            newLines.add(l);
        }
        return newLines;
    }

    private void doInterpLine(String oldSymbol, String newSymbol) {
        if (this.parVariablesFromMap.containsKey(oldSymbol)) {
            return;
        }
        this.covToNotRemove.add(oldSymbol);
        String format = "%s <- interp.function(%s[ind_subj,ind_t], %s_%s[ind_subj,1:%s%s[ind_subj]], %s[ind_subj,1:%s%s[ind_subj]])";
        this.variableLines.add(String.format(format, newSymbol, gridLabel, gridLabel, oldSymbol, this.NtNamePrefix, oldSymbol, oldSymbol, this.NtNamePrefix, oldSymbol));
    }

    private void doInterpLineCat(String oldSymbol, String newSymbol) {
        this.covToNotRemove.add(oldSymbol);
        String format = "%s <- interp.function.cost(%s[ind_subj,ind_t], %s_%s[ind_subj,1:%s%s[ind_subj]], %s[ind_subj,1:%s%s[ind_subj]])";
        this.variableLines.add(String.format(format, newSymbol, gridLabel, gridLabel, oldSymbol, this.NtNamePrefix, oldSymbol, oldSymbol, this.NtNamePrefix, oldSymbol));
    }

    private String doMeanTransformation(String errorTransformation, String meanTmpName, String rhsMeanExpression, String formatErrTransf) {
        if (errorTransformation.trim().length() > 0) {
            meanTmpName = errorTransformation + meanTmpName;
            rhsMeanExpression = String.format(formatErrTransf, errorTransformation, rhsMeanExpression.trim());
        }
        String formatDistMeanAssignement = Util.clean(meanTmpName) + "%s %s %s";
        String brackets = this.getIndexes(rhsMeanExpression) == 32 ? "" : this.getBrackets(rhsMeanExpression);
        String meanAssignStmt = String.format(formatDistMeanAssignement, brackets, assignSymbol, rhsMeanExpression);
        return meanAssignStmt;
    }

    private String getVarAssign(NormalDistribution value) {
        String varianceAssign;
        if (value.getVariance() != null) {
            varianceAssign = this.getVariance(value.getVariance());
        } else {
            String std = "";
            if (value.getStddev().getPrVal() != null) {
                std = value.getStddev().getPrVal().toString();
            } else if (value.getStddev().getVar() != null) {
                std = this.delimit(value.getStddev().getVar().getVarId());
            }
            varianceAssign = String.format("pow(%s,2)", std);
        }
        return this.delimit(varianceAssign);
    }

    private String getLinkedVarAssign(NormalDistribution value) {
        String varianceAssign;
        if (value.getVariance() != null) {
            varianceAssign = this.getVariance(value.getVariance());
        } else {
            String std = "";
            if (value.getStddev().getPrVal() != null) {
                std = value.getStddev().getPrVal().toString();
            } else if (value.getStddev().getVar() != null) {
                std = this.delimit(value.getStddev().getVar().getVarId());
            }
            varianceAssign = String.format("pow(%s,2)", std);
        }
        return this.delimit(varianceAssign);
    }

    private String doMeanLabel(String errorTransformation, String rhsMeanExpression, String meanTmpName) {
        String brackets = this.getIndexes(rhsMeanExpression) == 32 ? "" : this.getBrackets(rhsMeanExpression);
        return errorTransformation + meanTmpName + brackets;
    }

    private String doPar1Label(String errorTransformation, String rhsMeanExpression, String meanTmpName) {
        String brackets = this.getIndexes(rhsMeanExpression) == 32 ? "" : this.getBrackets(rhsMeanExpression);
        return errorTransformation + meanTmpName + brackets;
    }

    private String checkTransformation(String errorTransformation) {
        if (errorTransformation.trim().length() > 0) {
            switch (errorTransformation) {
                case "identity": {
                    return "";
                }
                case "log": 
                case "logit": {
                    return errorTransformation;
                }
            }
            throw new UnsupportedOperationException(errorTransformation.trim() + " transformation " + " not allowed");
        }
        return "";
    }

    void updateUniopMap() {
        for (int i = 0; i < this.uniOpList.size(); ++i) {
            String oK = this.uniOpList.get(i);
            String oV = this.unaryOpMap.get(oK);
            for (int j = i + 1; j < this.uniOpList.size(); ++j) {
                String nV = this.unaryOpMap.get(this.uniOpList.get(j)).replace(oK, oV);
                this.unaryOpMap.put(this.uniOpList.get(j), nV);
            }
        }
    }

    void updateBinopMap(List<String> formalPar, List<String> actualPar) {
        HashMap<String, String> toAdd = new HashMap<String, String>();
        for (Map.Entry<String, String> pairs : this.binOpMap.entrySet()) {
            if (!this.checkFormal(formalPar, pairs.getKey().toString())) continue;
            String k = pairs.getKey().toString();
            String v = pairs.getValue().toString();
            for (int j = 0; j < formalPar.size(); ++j) {
                k = k.replace(formalPar.get(j), actualPar.get(j));
                v = v.replace(formalPar.get(j), actualPar.get(j));
            }
            toAdd.put(this.delimit(k), this.delimit(v));
        }
        this.binOpMap.putAll(toAdd);
    }

    private boolean checkFormal(List<String> formalPar, String k) {
        for (String s : formalPar) {
            if (!k.contains(s)) continue;
            return true;
        }
        return false;
    }

    protected String pascalNamesTransform(String in) {
        String newId;
        if (in.trim().length() == 0) {
            return "";
        }
        String out = this.delimit(this.removeIndexes(in));
        for (int i = this.uniOpList.size() - 1; i >= 0; --i) {
            if (!out.contains(this.delimit(this.uniOpList.get(i)))) continue;
            out = out.replace(this.delimit(this.uniOpList.get(i)), this.delimit(this.unaryOpMap.get(this.uniOpList.get(i))));
        }
        if (out.contains(this.delimit(gridLabel))) {
            out = this.hasDiffEquations && !this.inPW ? out.replace(gridLabel, "t") : out.replace(gridLabel, "T");
        }
        for (Map.Entry<String, String> pairs : this.binOpMap.entrySet()) {
            if (!out.contains(this.delimit(pairs.getKey().toString()))) continue;
            out = out.replace(this.delimit(pairs.getKey().toString()), this.delimit(pairs.getValue().toString()));
        }
        for (Map.Entry<String, String> pairs : this.unaryOpMap.entrySet()) {
            if (!out.contains(this.delimit(pairs.getKey().toString()))) continue;
            out = out.replace(this.delimit(pairs.getKey().toString()), this.delimit(pairs.getValue().toString()));
        }
        for (SymbolRef s : this.stateV_Parameters) {
            if (Parser.isIn(s, this.theta_Parameters) || this.isCovariate(s) || !out.contains(this.delimit(s.getSymbIdRef())) || !this.parVariablesFromMap.containsKey(s.getSymbIdRef()) || this.isDerivativeVar(s.getSymbIdRef())) continue;
            newId = this.delimit(s.getSymbIdRef() + upperSuffixDerDepLabel);
            out = out.replaceAll(this.delimit(s.getSymbIdRef()), this.delimit(newId));
        }
        for (SymbolRef s : this.leafPiecewiseParameters) {
            if (!this.parVariablesFromMap.containsKey(s.getSymbIdRef())) continue;
            if (!this.isDerivativeVar(s.getSymbIdRef())) {
                newId = this.delimit(s.getSymbIdRef() + upperSuffixDerDepLabel);
                out = out.replaceAll(this.delimit(s.getSymbIdRef()), this.delimit(newId));
                continue;
            }
            newId = this.derivativeMapNew.get(s.getSymbIdRef());
            out = out.replaceAll(this.delimit(s.getSymbIdRef() + upperSuffixDerDepLabel), this.delimit(newId));
            out = out.replaceAll(this.delimit(s.getSymbIdRef()), this.delimit(newId));
        }
        for (SymbolRef s : this.indivV_Parameters) {
            if (Parser.isIn(s, this.theta_Parameters) || this.isCovariate(s) || !out.contains(this.delimit(s.getSymbIdRef())) || !this.parVariablesFromMap.containsKey(s.getSymbIdRef()) || this.isPiecewiseVar(s.getSymbIdRef())) continue;
            out = out.replaceAll(this.delimit(s.getSymbIdRef()), this.delimit(s.getSymbIdRef() + upperSuffixDerDepLabel));
        }
        for (Map.Entry<String, String> pairs : this.derivativeMapNew.entrySet()) {
            if (!out.contains(this.delimit(pairs.getKey().toString()))) continue;
            if (this instanceof PascalParser1) {
                out = out.replace(this.delimit(pairs.getKey().toString()), this.delimit(this.derivativeMap.get(pairs.getKey()).toString()));
                continue;
            }
            out = out.replace(this.delimit(pairs.getKey().toString()), this.delimit(pairs.getValue().toString()));
        }
        for (SymbolRef s : this.leafOdeParameters) {
            if (!Parser.isIn(s, this.theta_Parameters) && !this.isCovariate(s)) {
                if (!this.isPiecewiseVar(s.getSymbIdRef())) {
                    out = out.replaceAll(this.delimit(s.getSymbIdRef()), this.doAppendSuffix(s));
                    continue;
                }
                out = out.replaceAll(this.delimit(s.getSymbIdRef()), this.piecewiseSuffix + "_" + s.getSymbIdRef());
                continue;
            }
            if (this.isIndependentVariableSym(s.getSymbIdRef()) && this.hasDiffEquations) continue;
            out = out.replaceAll(this.delimit(s.getSymbIdRef()), s.getSymbIdRef());
        }
        out = out.replaceAll(this.interpSuffix, "");
        if (this.parVariablesFromMap.containsKey(Util.clean(out = out.replaceAll("_" + upperSuffixDerDepLabel, "")))) {
            out = this.delimit(out.replace(this.delimit(Util.clean(out)), this.delimit(Util.clean(out) + upperSuffixDerDepLabel)));
        }
        for (String dv : this.doseVar) {
            if (!out.contains(this.delimit(dv + "[1]"))) continue;
            out = out.replace(this.delimit(dv + "[1]"), this.delimit(dv));
        }
        return this.removeIndexes(out);
    }

    public List<String> removeIndexes(List<String> in) {
        ArrayList<String> out = new ArrayList<String>();
        for (String s : in) {
            if (s.trim().length() <= 0) continue;
            out.add(this.removeIndexes(s));
        }
        return out;
    }

    protected String removeIndexesNew(String in) {
        String out = in;
        while (out.contains(this.leftArrayBracket) && out.contains(this.rightArrayBracket)) {
            out = out.substring(0, out.indexOf(this.leftArrayBracket)) + out.substring(out.indexOf(this.rightArrayBracket) + 1);
        }
        return out;
    }

    protected String removeIndexes(String in) {
        String out = in;
        if (!out.contains(this.leftArrayBracket)) {
            return out;
        }
        if (out.contains(this.IND_BOTH) || out.contains(this.IND_BOTH2)) {
            out = out.replace(this.IND_BOTH, "");
            out = out.replace(this.IND_BOTH2, "");
        }
        if (out.contains(this.IND_TIME) || in.contains(this.IND_TIME2)) {
            out = out.replace(this.IND_TIME, "");
            out = out.replace(this.IND_TIME2, "");
        }
        if (out.contains(this.IND_SUBJ)) {
            out = out.replace(this.IND_SUBJ, "");
        }
        out = out.replace("ind_subj,", "");
        return out;
    }

    protected String getModelFunctionName(StructuralBlock sb) {
        String format = this.lexer.getDom().getName().getValue();
        return String.format(format, new Object[0]);
    }

    protected String concat(List<String> lines, String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + tabs);
        for (String s : lines) {
            sb.append(s);
            sb.append(tabs);
        }
        return sb.toString();
    }

    protected String concat(String sep, List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String s : lines) {
            sb.append(s);
            sb.append(sep);
        }
        return sb.toString();
    }

    protected String concat(Map<String, String> lines, String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + tabs);
        for (Map.Entry<String, String> s : lines.entrySet()) {
            sb.append(s.getValue());
            sb.append(tabs);
        }
        return sb.toString();
    }

    protected String concat(List<SymbolRef> lines) {
        ArrayList<String> names = new ArrayList<String>();
        for (SymbolRef s : lines) {
            names.add(s.getSymbIdRef());
        }
        Arrays.sort(names.toArray());
        return this.concat(names, " ");
    }

    protected String concatVars(List<VariableDefinition> lines) {
        ArrayList<String> names = new ArrayList<String>();
        for (VariableDefinition s : lines) {
            names.add(s.getSymbId());
        }
        Arrays.sort(names.toArray());
        return this.concat(names, " ");
    }

    protected String concatSblocks(List<StructuralBlock> lines) {
        ArrayList<String> names = new ArrayList<String>();
        for (StructuralBlock s : lines) {
            for (VariableDefinition s0 : s.getLocalVariables()) {
                names.add(s0.getSymbId());
            }
        }
        Arrays.sort(names.toArray());
        return this.concat(names, " ");
    }

    private void addVar(String[] c, List<List<String>> g) {
        boolean inserted = false;
        for (List<String> l : g) {
            if (Parser.isInList(l, c[0])) {
                if (!Parser.isInList(l, c[1])) {
                    l.add(c[1]);
                }
                inserted = true;
                break;
            }
            if (!Parser.isInList(l, c[1])) continue;
            if (!Parser.isInList(l, c[0])) {
                l.add(c[0]);
            }
            inserted = true;
            break;
        }
        if (!inserted) {
            ArrayList<String> nl = new ArrayList<String>();
            nl.add(c[0]);
            nl.add(c[1]);
            g.add(nl);
        }
    }

    private void manageCorrelations(ParameterBlock pb) {
        int i;
        List corr = pb.getCorrelations();
        ArrayList<String> vars = new ArrayList<String>();
        for (CorrelationRef cr : corr) {
            String id = cr.rnd1.getSymbId();
            if (!vars.contains(id)) {
                vars.add(id);
            }
            if (vars.contains(id = cr.rnd2.getSymbId())) continue;
            vars.add(id);
        }
        int dim = vars.size();
        String[][] matrix = new String[dim][dim];
        for (i = 0; i < dim; ++i) {
            for (int j = i + 1; j < dim; ++j) {
                String string = this.getCorr((String)vars.get(i), (String)vars.get(j), corr);
                matrix[j][i] = string;
                matrix[i][j] = string;
            }
        }
        for (i = 0; i < dim; ++i) {
            matrix[i][i] = Util.clean(this.getRandomVarVariance((String)vars.get(i)));
        }
        List<List<String>> groups = new ArrayList<List<String>>();
        String[] couple = new String[2];
        for (CorrelationRef cr : corr) {
            couple[0] = cr.rnd1.getSymbId();
            couple[1] = cr.rnd2.getSymbId();
            this.addVar(couple, groups);
        }
        for (List<String> l : groups) {
            l = Util.getUniqueString(l);
        }
        groups = this.mergeGroups(groups);
        for (List<String> l : groups) {
            l = Util.getUniqueString(l);
        }
        this.generateEtaOmegaMatrix(vars, matrix, groups);
    }

    private List<List<String>> mergeGroups(List<List<String>> g) {
        ArrayList<List<String>> tmp = new ArrayList<List<String>>();
        ArrayList<List<String>> tmp0 = new ArrayList<List<String>>();
        ArrayList<List<String>> toRemove = new ArrayList<List<String>>();
        tmp0.addAll(g);
        for (int i = 0; i < g.size(); ++i) {
            for (int j = i + 1; j < g.size(); ++j) {
                if (!this.intersection(g.get(i), g.get(j))) continue;
                tmp.add(Util.mergeStrings(g.get(i), g.get(j)));
                toRemove.add(g.get(i));
                toRemove.add(g.get(j));
            }
        }
        tmp0.removeAll(toRemove);
        for (List list : tmp0) {
            tmp.add(list);
        }
        return tmp;
    }

    private boolean intersection(List<String> a1, List<String> a2) {
        boolean flag = false;
        for (String s : a1) {
            if (!Parser.isInList(a2, s)) continue;
            return true;
        }
        return false;
    }

    private void generateEtaOmegaMatrix(List<String> vars, String[][] matrix, List<List<String>> groups) {
        for (int i = 1; i <= groups.size(); ++i) {
            List<String> cor = groups.get(i - 1);
            int j = 1;
            int num = cor.size();
            this.correlationLines.add(String.format("%s[%s,1:%s] %s dmnorm(%s[], %s[,])", "ETA" + i, IND_S, num, dist_symb, "mu" + i, "T" + i));
            this.correlationLines.add(String.format("%s[1:%s,1:%s] %s inverse(%s[,])", "T" + i, num, num, assignSymbol, "OMEGA" + i));
            for (String s : cor) {
                String left = this.delimit(String.format("%s[%s]", s, IND_S));
                String right = this.delimit(String.format("%s[%s,%s]", "ETA" + i, IND_S, "" + j));
                this.correlationLines.add(String.format("%s %s %s", this.delimit(left), assignSymbol, right));
                this.variablesAssignementMap.put(this.delimit(s), this.delimit(left));
                double mean = this.getRandomVarMean(s);
                this.correlationLines.add(String.format("%s[%s] %s %s", "mu" + i, "" + j, assignSymbol, "" + mean));
                ++j;
            }
            this.generateOmega(matrix, "OMEGA" + i, cor, vars);
        }
    }

    private double getRandomVarMean(String id) {
        ParameterRandomVariable context = this.getLinkedRandomVar(id);
        if (context.getDistribution().getUncertML() != null) {
            PharmMLElement distribution = Util.getDistributionType(context);
            if (distribution instanceof NormalDistribution && ((NormalDistribution)distribution).getMean() != null) {
                return ((NormalDistribution)distribution).getMean().getRVal();
            }
        } else if (context.getDistribution().getProbOnto() != null) {
            DistributionParameter dp = context.getDistribution().getProbOnto().getParameter(ParameterName.MEAN);
            return Double.parseDouble(dp.getAssign().getScalar().valueToString());
        }
        return -99999.0;
    }

    private String getRandomVarVariance(String id) {
        ParameterRandomVariable context = this.getLinkedRandomVar(id);
        String varianceAssign = "";
        PharmMLElement distribution = Util.getDistributionType(context);
        if (distribution instanceof NormalDistribution && ((NormalDistribution)distribution).getVariance() != null) {
            BinaryTree bt = this.lexer.getStatement((Object)((NormalDistribution)distribution).getVariance());
            varianceAssign = this.parse(((NormalDistribution)distribution).getVariance(), bt);
        } else if (distribution instanceof NormalDistribution && ((NormalDistribution)distribution).getStddev() != null) {
            BinaryTree bt = this.lexer.getStatement((Object)((NormalDistribution)distribution).getStddev());
            varianceAssign = this.parse(((NormalDistribution)distribution).getStddev(), bt);
            varianceAssign = "pow(" + varianceAssign + ",2)";
        } else if (distribution instanceof ProbOnto) {
            ProbOnto pb = (ProbOnto)distribution;
            DistributionParameter dp = null;
            if (pb.getName().value().equals("Normal1")) {
                dp = pb.getParameter(ParameterName.STDEV);
                varianceAssign = this.delimit(String.format("pow(%s,2)", this.getParameter(dp)));
            } else if (pb.getName().value().equals("Normal2")) {
                dp = pb.getParameter(ParameterName.VAR);
                varianceAssign = this.delimit(this.getParameter(dp));
            } else if (pb.getName().value().equals("Normal3")) {
                dp = pb.getParameter(ParameterName.PRECISION);
                varianceAssign = this.delimit(String.format("(1/(%s))", this.getParameter(dp)));
            } else {
                throw new RuntimeException("Distribution not supported");
            }
        }
        return varianceAssign;
    }

    private void generateOmega(String[][] matrix, String omegaN, List<String> group, List<String> vars) {
        int i = 1;
        int j = 1;
        int num = group.size();
        for (i = 1; i <= num; ++i) {
            for (j = 1; j <= num; ++j) {
                int im = Util.getCorrVarIndex(group.get(i - 1), vars);
                int jm = Util.getCorrVarIndex(group.get(j - 1), vars);
                this.correlationLines.add(String.format("%s[%s,%s] %s %s", omegaN, "" + i, "" + j, assignSymbol, matrix[im][jm]));
            }
        }
    }

    private ParameterRandomVariable getLinkedRandomVar(String symbol) {
        if (symbol != null) {
            List<ParameterBlock> pbs = this.getParameterBlocks();
            for (ParameterBlock pb : pbs) {
                List rvs = pb.getLinkedRandomVariables();
                for (ParameterRandomVariable rv : rvs) {
                    if (!symbol.equals(rv.getSymbId())) continue;
                    return rv;
                }
            }
            List obs = this.lexer.getObservationBlocks();
            for (ObservationBlock ob : obs) {
                List rvs = ob.getRandomVariables();
                for (ParameterRandomVariable rv : rvs) {
                    if (!symbol.equals(rv.getSymbId())) continue;
                    return rv;
                }
            }
        }
        return null;
    }

    private VariableDefinition getVariable(String symbol) {
        if (symbol != null && !this.lexer.getStructuralBlocks().isEmpty()) {
            List sbs = this.lexer.getStructuralBlocks();
            for (StructuralBlock sb : sbs) {
                if (sb == null) continue;
                List ips = sb.getLocalVariables();
                for (VariableDefinition ip : ips) {
                    String currentSymbol;
                    if (ip == null || (currentSymbol = ip.getSymbId()) == null || !currentSymbol.equals(symbol)) continue;
                    return ip;
                }
            }
        }
        return null;
    }

    private PopulationParameter getPopulationParameter(String symbol) {
        ParameterBlock sb;
        if (symbol != null && !this.lexer.getStructuralBlocks().isEmpty() && (sb = this.lexer.getParameterBlock()) != null) {
            List ips = sb.getParameters();
            for (PopulationParameter ip : ips) {
                String currentSymbol;
                if (ip == null || (currentSymbol = ip.getSymbId()) == null || !currentSymbol.equals(symbol)) continue;
                return ip;
            }
        }
        return null;
    }

    protected Piecewise getPiecewise(String symbol) {
        if (symbol != null) {
            ParameterBlock sb;
            if (!this.lexer.getStructuralBlocks().isEmpty()) {
                List sbs = this.lexer.getStructuralBlocks();
                for (StructuralBlock sb2 : sbs) {
                    if (sb2 == null) continue;
                    List ips = sb2.getLocalVariables();
                    for (VariableDefinition ip : ips) {
                        String currentSymbol;
                        if (ip == null || (currentSymbol = ip.getSymbId()) == null || !currentSymbol.equals(symbol) || ip.getAssign().getPiecewise() == null) continue;
                        return ip.getAssign().getPiecewise();
                    }
                }
            }
            if (!this.lexer.getStructuralBlocks().isEmpty() && (sb = this.lexer.getParameterBlock()) != null) {
                List ips = sb.getParameters();
                for (PopulationParameter ip : ips) {
                    String currentSymbol;
                    if (ip == null || (currentSymbol = ip.getSymbId()) == null || !currentSymbol.equals(symbol) || ip.getAssign().getPiecewise() == null) continue;
                    return ip.getAssign().getPiecewise();
                }
            }
        }
        return null;
    }

    private String getCorr(String get, String get0, List<CorrelationRef> corr) {
        String c = "0";
        for (CorrelationRef cr : corr) {
            BinaryTree bt;
            if ((!cr.rnd1.getSymbId().equals(get) || !cr.rnd2.getSymbId().equals(get0)) && (!cr.rnd1.getSymbId().equals(get0) || !cr.rnd2.getSymbId().equals(get))) continue;
            if (cr.correlationCoefficient != null) {
                bt = this.lexer.getTreeMaker().newInstance((Object)cr.correlationCoefficient);
                c = this.parse(cr.correlationCoefficient, bt) + "*" + this.getStdDev(cr.rnd1) + "*" + this.getStdDev(cr.rnd2);
                continue;
            }
            if (cr.covariance == null) continue;
            bt = this.lexer.getTreeMaker().newInstance((Object)cr.covariance);
            c = this.parse(cr.covariance, bt);
        }
        return c;
    }

    String getStdDev(ParameterRandomVariable v) {
        String std = "";
        BinaryTree tmpstmt = this.lexer.getStatement((Object)v);
        if (v.getDistribution().getUncertML() != null && v.getDistribution().getUncertML().getAbstractContinuousUnivariateDistribution() != null) {
            AbstractContinuousUnivariateDistributionType val = (AbstractContinuousUnivariateDistributionType)v.getDistribution().getUncertML().getAbstractContinuousUnivariateDistribution().getValue();
            if (val instanceof NormalDistribution) {
                NormalDistribution nDist = (NormalDistribution)val;
                if (nDist.getStddev() != null) {
                    if (nDist.getStddev().getPrVal() != null) {
                        std = nDist.getStddev().getPrVal().toString();
                    } else if (nDist.getStddev().getVar() != null) {
                        std = this.delimit(nDist.getStddev().getVar().getVarId());
                    }
                } else if (nDist.getVariance() != null) {
                    if (nDist.getVariance().getPrVal() != null) {
                        std = String.format("sqrt(%s)", nDist.getVariance().getPrVal().toString());
                    } else if (nDist.getVariance().getVar() != null) {
                        std = String.format("sqrt(%s)", nDist.getVariance().getVar().getVarId());
                    }
                }
            }
        } else if (v.getDistribution().getProbOnto() != null) {
            ProbOnto dist = v.getDistribution().getProbOnto();
            String name = dist.getName().value();
            DistributionParameter dp = null;
            if (name.equals("Normal1")) {
                dp = dist.getParameter(ParameterName.STDEV);
                std = this.delimit(this.getParameter(dp));
            } else if (name.equals("Normal2")) {
                dp = dist.getParameter(ParameterName.VAR);
                std = this.delimit(String.format("sqrt(%s)", this.getParameter(dp)));
            } else if (name.equals("Normal3")) {
                dp = dist.getParameter(ParameterName.PRECISION);
                std = this.delimit(String.format("1/sqrt(%s)", this.getParameter(dp)));
            } else {
                throw new RuntimeException("Distribution not supported");
            }
        }
        return std;
    }

    private String getParameter(DistributionParameter dp) {
        String tmp = "";
        if (dp.getAssign().getVector() != null) {
            Vector v = dp.getAssign().getVector();
            int i = 1;
            String id = ((CommonParameter)dp.getParent().getParent().getParent()).getSymbId();
            for (VectorValue el : v.getVectorElements().getListOfElements()) {
                this.matrixVectorLines.add(String.format("%s_%s[%s] %s %s", id, dp.getName(), i, assignSymbol, el.asString()));
            }
            tmp = id + "_" + dp.getName();
        } else if (dp.getAssign().getMatrix() != null) {
            Matrix v = dp.getAssign().getMatrix();
            String type = v.getMatrixType();
            String id = ((CommonParameter)dp.getParent().getParent().getParent()).getSymbId();
            tmp = id + "_" + dp.getName().value();
            switch (type) {
                case "Any": {
                    this.matrixVectorLines.addAll(this.getMatrixElementsAny(v, tmp));
                    break;
                }
                case "LowerTriangular": {
                    this.matrixVectorLines.addAll(this.getMatrixElementsLT(v, tmp));
                    break;
                }
                case "UpperTriangular": {
                    this.matrixVectorLines.addAll(this.getMatrixElementsUT(v, tmp));
                }
            }
            this.matrixMap.put(id, this.matrixMap.get(tmp));
        } else {
            tmp = Util.clean(this.removeIndexesNew(this.parse(dp, this.lexer.getTreeMaker().newInstance((Object)dp))));
        }
        return tmp;
    }

    private String getVectorValue(VectorValue dp) {
        return this.parse(dp, this.lexer.getTreeMaker().newInstance((Object)dp));
    }

    protected String myParse(Object o) {
        return this.parse(o, this.lexer.getTreeMaker().newInstance(o));
    }

    private void manageInitialEstimates() {
        EstimationStep es = this.lexer.getEstimationStep();
        List fpList = es.getFixedParameters();
        for (FixedParameter fp : fpList) {
            BinaryTree bt = this.lexer.getTreeMaker().newInstance((Object)fp.pe.getInitialEstimate());
            this.initialEstimatesLines.add(String.format("%s %s %s\n", fp.pe.getSymbRef().getSymbIdRef(), assignSymbol, this.parse(fp.pe.getInitialEstimate(), bt)));
        }
    }

    private String getPiecewiseName(String pid) {
        String format = "%s%s[%s,%s]";
        String pid1 = this.removeIndexes(pid);
        String tmp = "";
        boolean ind = true;
        tmp = String.format(format, piecewiseSymb, this.piecewiseIndexMap.get(Util.clean(this.removeIndexes(pid))), IND_S, IND_T);
        return tmp;
    }

    protected BinaryTree doPutCategory(BinaryTree bt) {
        List<CategoryRef_> lc;
        SymbolRef sr = null;
        boolean isCategorical = false;
        for (Node node : bt.nodes) {
            CovariateDefinition cd;
            if (!(node.data instanceof SymbolRef) || (cd = this.getCovariate((sr = (SymbolRef)node.data).getSymbIdRef())) == null || cd.getCategorical() == null) continue;
            isCategorical = true;
            break;
        }
        if (sr != null && isCategorical && (lc = this.categoricalMap.get(sr.getSymbIdRef())) != null) {
            for (Node node : bt.nodes) {
                if (!(node.data instanceof CategoryRef)) continue;
                CategoryRef cr = (CategoryRef)node.data;
                for (CategoryRef_ val : lc) {
                    if (!val.getModelSymbol().equals(cr.getCatIdRef())) continue;
                    node.data = val.getDataSymbol();
                }
            }
        }
        return bt;
    }

    private static SymbolRef symbolRef(PharmMLRootType o, Accessor a) {
        String symbId = null;
        boolean addScope = false;
        if (PharmMLTypeChecker.isSymbolReference((Object)o)) {
            return (SymbolRef)o;
        }
        if (PharmMLTypeChecker.isCommonParameter((Object)o)) {
            symbId = ((CommonParameter)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isLocalVariable((Object)o)) {
            symbId = ((VariableDefinition)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isDerivative((Object)o)) {
            symbId = ((DerivativeVariable)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isIndividualParameter((Object)o)) {
            symbId = ((IndividualParameter)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isRandomVariable((Object)o)) {
            symbId = ((ParameterRandomVariable)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isIndependentVariable((Object)o)) {
            symbId = ((IndependentVariable)o).getSymbId();
        } else if (PharmMLTypeChecker.isCovariate((Object)o)) {
            symbId = ((CovariateDefinition)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isFunctionParameter((Object)o)) {
            symbId = ((FunctionParameter)o).getSymbId();
        } else if (PharmMLTypeChecker.isFunction((Object)o)) {
            symbId = ((FunctionDefinition)o).getSymbId();
        } else if (PharmMLTypeChecker.isObservationError((Object)o)) {
            symbId = ((ObservationError)o).getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isColumnDefinition((Object)o)) {
            symbId = ((ColumnDefinition)o).getColumnId();
            addScope = false;
        } else if (PharmMLTypeChecker.isContinuousCovariate((Object)o)) {
            ContinuousCovariate ccov = (ContinuousCovariate)o;
            for (CovariateTransformation trans : ccov.getListOfTransformation()) {
                TransformedCovariate tc;
                if (trans == null || (tc = trans.getTransformedCovariate()) == null) continue;
                symbId = tc.getSymbId();
                addScope = true;
                break;
            }
        } else if (PharmMLTypeChecker.isVariabilityLevelDefinition((Object)o)) {
            VariabilityLevelDefinition level = (VariabilityLevelDefinition)o;
            symbId = level.getSymbId();
            addScope = true;
        } else if (PharmMLTypeChecker.isGeneralError((Object)o)) {
            GeneralObsError goe = (GeneralObsError)o;
            symbId = goe.getSymbId();
            addScope = true;
        } else {
            throw new UnsupportedOperationException("Unsupported Symbol reference (src='" + o + "')");
        }
        if (symbId == null) {
            throw new NullPointerException("SymbId is NULL.");
        }
        SymbolRef ref = new SymbolRef();
        ref.setSymbIdRef(symbId);
        if (addScope) {
            String blkId = a.getBlockId(o);
            if (blkId == null) {
                throw new NullPointerException("BlkId is not known (symbId='" + symbId + "', class='" + Utils.getClassName((Object)o) + "')");
            }
            ref.setBlkIdRef(blkId);
        }
        return ref;
    }

    protected static void assign(Rhs rhs, Object o, Accessor a) {
        if (rhs == null || o == null) {
            return;
        }
        if (PharmMLTypeChecker.isConstant((Object)o)) {
            rhs.setConstant((Constant)o);
        } else if (PharmMLTypeChecker.isLocalVariable((Object)o)) {
            rhs.setSymbRef(Parser.symbolRef((PharmMLRootType)((VariableDefinition)o), a));
        } else if (PharmMLTypeChecker.isPopulationParameter((Object)o)) {
            rhs.setSymbRef(Parser.symbolRef((PharmMLRootType)((PopulationParameter)o), a));
        } else if (PharmMLTypeChecker.isBinaryOperation((Object)o)) {
            rhs.setBinop((Binop)o);
        } else if (PharmMLTypeChecker.isDerivative((Object)o)) {
            rhs.setSymbRef(Parser.symbolRef((PharmMLRootType)((DerivativeVariable)o), a));
        } else if (Parser.isString_((Object)o)) {
            rhs.setScalar((Scalar)new StringValue((String)o));
        } else if (Parser.isBoolean((Object)o)) {
            Boolean b = (Boolean)o;
            if (b.booleanValue()) {
                rhs.setScalar((Scalar)new TrueBoolean());
            } else {
                rhs.setScalar((Scalar)new FalseBoolean());
            }
        } else if (Parser.isInteger((Object)o)) {
            rhs.setScalar((Scalar)new IntValue((Integer)o));
        } else if (Parser.isBigInteger((Object)o)) {
            BigInteger v = (BigInteger)o;
            rhs.setScalar((Scalar)new IntValue(Integer.valueOf(v.intValue())));
        } else if (Parser.isDouble((Object)o)) {
            rhs.setScalar((Scalar)new RealValue(((Double)o).doubleValue()));
        } else if (PharmMLTypeChecker.isUnaryOperation((Object)o)) {
            rhs.setUniop((Uniop)o);
        } else if (PharmMLTypeChecker.isIndependentVariable((Object)o)) {
            rhs.setSymbRef(Parser.symbolRef((PharmMLRootType)((IndependentVariable)o), a));
        } else if (PharmMLTypeChecker.isIndividualParameter((Object)o)) {
            rhs.setSymbRef(Parser.symbolRef((PharmMLRootType)((IndividualParameter)o), a));
        } else if (PharmMLTypeChecker.isFunctionCall((Object)o)) {
            rhs.setFunctionCall((FunctionCallType)o);
        } else if (PharmMLTypeChecker.isScalarInterface((Object)o)) {
            rhs.setScalar((Scalar)o);
        } else if (PharmMLTypeChecker.isPiecewise((Object)o)) {
            rhs.setPiecewise((Piecewise)o);
        } else if (PharmMLTypeChecker.isSymbolReference((Object)o)) {
            rhs.setSymbRef((SymbolRef)o);
        } else if (PharmMLTypeChecker.isDelay((Object)o)) {
            rhs.setDelay((Delay)o);
        } else if (PharmMLTypeChecker.isSum((Object)o)) {
            rhs.setSum((Sum)o);
        } else if (PharmMLTypeChecker.isJAXBElement((Object)o)) {
            JAXBElement element = (JAXBElement)o;
            Parser.assign(rhs, element.getValue(), a);
        } else if (PharmMLTypeChecker.isMatrix((Object)o)) {
            rhs.setMatrix((Matrix)o);
        } else if (PharmMLTypeChecker.isProduct((Object)o)) {
            rhs.setProduct((Product)o);
        } else if (PharmMLTypeChecker.isSequence((Object)o)) {
            rhs.setSequence((Sequence)o);
        } else if (PharmMLTypeChecker.isVector((Object)o)) {
            rhs.setVector((Vector)o);
        } else if (PharmMLTypeChecker.isInterval((Object)o)) {
            rhs.setInterval((Interval)o);
        } else if (PharmMLTypeChecker.isInterpolation((Object)o)) {
            rhs.setInterpolation((Interpolation)o);
        } else if (PharmMLTypeChecker.isProbability((Object)o)) {
            rhs.setProbability((Probability)o);
        } else if (PharmMLTypeChecker.isMatrixUnaryOperation((Object)o)) {
            rhs.setMatrixUniop((MatrixUniOp)o);
        } else if (PharmMLTypeChecker.isMatrixSelector((Object)o)) {
            rhs.setMatrixSelector((MatrixSelector)o);
        } else if (PharmMLTypeChecker.isVectorSelector((Object)o)) {
            rhs.setVectorSelector((VectorSelector)o);
        } else if (PharmMLTypeChecker.isRhs((Object)o)) {
            Rhs assign = (Rhs)o;
            Parser.assign(rhs, assign.getContent(), a);
        } else {
            throw new UnsupportedOperationException("Unsupported Expression Term (value='" + o + "')");
        }
    }

    protected static Rhs rhs(Object o, Accessor a) {
        if (o == null) {
            throw new NullPointerException("Expression Class NULL");
        }
        Rhs rhs = new Rhs();
        Parser.assign(rhs, o, a);
        return rhs;
    }

    protected String generatePiecewiseBlock(Piecewise pw, String symbId) {
        Piece piece;
        int i;
        String symbol = unassigned_symbol;
        List pieces = pw.getListOfPiece();
        Piece else_block = null;
        BinaryTree[] assignment_trees = new BinaryTree[pieces.size()];
        BinaryTree[] conditional_trees = new BinaryTree[pieces.size()];
        String[] conditional_stmts = new String[pieces.size()];
        String[] assignment_stmts = new String[pieces.size()];
        TreeMaker tm = this.lexer.getTreeMaker();
        Accessor a = this.lexer.getAccessor();
        int assignment_count = 0;
        int else_index = -1;
        for (i = 0; i < pieces.size(); ++i) {
            piece = (Piece)pieces.get(i);
            if (piece == null) continue;
            Condition cond = piece.getCondition();
            if (cond != null) {
                conditional_trees[i] = tm.newInstance((Object)piece.getCondition());
                conditional_trees[i] = this.doPutCategory(conditional_trees[i]);
                if (cond.getOtherwise() != null) {
                    else_block = piece;
                    else_index = i;
                }
            }
            BinaryTree assignment_tree = null;
            ExpressionValue expr = piece.getValue();
            if (PharmMLTypeChecker.isBinaryOperation((Object)expr)) {
                assignment_tree = tm.newInstance((Object)Parser.rhs((Binop)expr, a));
                ++assignment_count;
            } else if (PharmMLTypeChecker.isConstant((Object)expr)) {
                assignment_tree = tm.newInstance((Object)expr);
                ++assignment_count;
            } else if (PharmMLTypeChecker.isFunctionCall((Object)expr)) {
                assignment_tree = tm.newInstance((Object)Parser.rhs((FunctionCallType)expr, a));
                ++assignment_count;
            } else if (PharmMLTypeChecker.isJAXBElement((Object)expr)) {
                assignment_tree = tm.newInstance((Object)Parser.rhs((JAXBElement)expr, a));
                ++assignment_count;
            } else if (PharmMLTypeChecker.isSymbolReference((Object)expr)) {
                assignment_tree = tm.newInstance((Object)expr);
                ++assignment_count;
            } else if (PharmMLTypeChecker.isScalarInterface((Object)expr)) {
                assignment_tree = tm.newInstance((Object)expr);
                ++assignment_count;
            } else {
                throw new IllegalStateException("Piecewise assignment failed (expr='" + expr + "')");
            }
            if (assignment_tree == null) continue;
            assignment_trees[i] = assignment_tree;
        }
        if (assignment_count == 0) {
            throw new IllegalStateException("A piecewise block has no assignment statements.");
        }
        for (i = 0; i < pieces.size(); ++i) {
            piece = (Piece)pieces.get(i);
            if (conditional_trees[i] == null || assignment_trees[i] == null) continue;
            if (!piece.equals(else_block)) {
                conditional_stmts[i] = this.parse(piece, conditional_trees[i]);
                conditional_stmts[i] = this.pascalNamesTransform(conditional_stmts[i]);
            }
            assignment_stmts[i] = this.parse(new Object(), assignment_trees[i]);
            assignment_stmts[i] = this.pascalNamesTransform(assignment_stmts[i]);
        }
        int block_assignment = 0;
        StringBuilder block = new StringBuilder("");
        this.field_tag = "value";
        for (int i2 = 0; i2 < pieces.size(); ++i2) {
            Piece piece2 = (Piece)pieces.get(i2);
            if (piece2 == null || piece2.equals(else_block) || conditional_stmts[i2] == null || assignment_stmts[i2] == null) continue;
            String operator = "IF";
            String format = "%s %s THEN;\n\t\t\t%s := %s; \n";
            if (block_assignment > 0) {
                operator = "ELSIF ";
                format = "\t\t%s (%s) THEN; \n\t\t\t%s := %s; \n";
            }
            if (this.inPW) {
                block.append(String.format(format, operator, conditional_stmts[i2], this.field_tag, assignment_stmts[i2]));
            } else {
                block.append(String.format(format, operator, conditional_stmts[i2], this.piecewiseSuffix + "_" + symbId, assignment_stmts[i2]));
            }
            ++block_assignment;
        }
        if (else_block != null && else_index >= 0) {
            block.append("\t\tELSE;\n");
            String format = "\t\t\t%s := %s;\n";
            if (this.inPW) {
                block.append(String.format(format, this.field_tag, assignment_stmts[else_index]));
            } else {
                block.append(String.format(format, this.piecewiseSuffix + "_" + symbId, assignment_stmts[else_index]));
            }
        }
        block.append("\t\tEND;\n");
        if (assignment_count == 0) {
            throw new IllegalStateException("Piecewise statement assigned no conditional blocks.");
        }
        symbol = block.toString();
        symbol = this.pascalNamesTransform(symbol);
        return symbol;
    }

    String getName(String in) {
        if (in.endsWith(upperSuffixDerDepLabel)) {
            return in.substring(0, in.indexOf(upperSuffixDerDepLabel));
        }
        if (in.startsWith(piecePrefix)) {
            return in.substring(piecePrefix.length());
        }
        if (in.endsWith(this.interpSuffix)) {
            return in.substring(0, in.indexOf(this.interpSuffix));
        }
        return in;
    }

    protected List<String> getSortedOde() {
        ArrayList<String> sortedIds = new ArrayList<String>();
        sortedIds.addAll(Util.getList(this.theta_Parameters));
        sortedIds.addAll(this.derivativeMapNew.values());
        sortedIds.addAll(Util.getList(this.usedOdeCatCovNames));
        sortedIds.addAll(Util.getList(this.usedOdeContCovNames));
        return sortedIds;
    }

    protected List<String> getSortedPiecewise(String pwId) {
        ArrayList<String> sortedIds = new ArrayList<String>();
        for (Map.Entry<Integer, String> s : this.piecewiseVarToPascal.get(pwId).entrySet()) {
            sortedIds.add(this.getName(s.getValue()));
        }
        return sortedIds;
    }

    protected Map<String, String> checkEquations(Map<String, String> eqLines, List<String> sortedIds) {
        HashMap<String, String> tmpEq = new HashMap<String, String>();
        for (String var : eqLines.keySet()) {
            if (this.parVariablesFromMap.get(var) == null) continue;
            List<SymbolRef> depV = this.parVariablesFromMap.get(var);
            for (SymbolRef v : depV) {
                String eq;
                TransformedCovariate tc;
                if (eqLines.keySet().contains(v.getSymbIdRef()) || tmpEq.keySet().contains(v.getSymbIdRef()) || this.parVariablesFromMap.get(v.getSymbIdRef()) == null || Parser.isInList(Util.getList(this.theta_Parameters), v.getSymbIdRef()) || !this.isContinuousCovariate(v) && !this.isTransformedCovariate(v)) continue;
                String id = v.getSymbIdRef();
                PharmMLRootType o = this.lexer.getAccessor().fetchElement(id);
                if (o instanceof TransformedCovariate) {
                    tc = (TransformedCovariate)o;
                    eq = String.format("%s := %s;\n", id + upperSuffixDerDepLabel, this.pascalNamesTransform(this.myParse(tc.getParent())));
                    tmpEq.put(id, eq);
                    continue;
                }
                tc = (CovariateDefinition)o;
                eq = String.format("%s := %s;\n", id + upperSuffixDerDepLabel, this.pascalNamesTransform(this.myParse(tc)));
                tmpEq.put(id, eq);
            }
        }
        eqLines.putAll(tmpEq);
        return eqLines;
    }

    protected List<String> sortVarLines(Map<String, String> list, List<String> sortedIds) {
        list = this.checkEquations(list, sortedIds);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : list.keySet()) {
            if (!sortedIds.contains(key)) continue;
            toRemove.add(key);
        }
        for (String key : toRemove) {
            list.remove(key);
        }
        toRemove.clear();
        ArrayList<String> sortedEq = new ArrayList<String>();
        while (!list.isEmpty()) {
            toRemove.clear();
            for (Map.Entry<String, String> pair : list.entrySet()) {
                String var = this.getName(pair.getKey());
                if (sortedIds.contains(pair.getKey())) continue;
                if (!this.parVariablesFromMap.containsKey(var)) {
                    sortedEq.add(pair.getValue());
                    sortedIds.add(var);
                    toRemove.add(pair.getKey());
                    continue;
                }
                List<String> lf = Util.getList(this.parVariablesFromMap.get(var));
                int i = 0;
                for (String s : lf) {
                    if (!sortedIds.contains(s) && !this.isIndependentVariableSym(s) && !this.isDerivativeVar(s)) continue;
                    ++i;
                }
                if (i != lf.size()) continue;
                sortedEq.add(pair.getValue());
                sortedIds.add(var);
                toRemove.add(pair.getKey());
            }
            boolean removed = false;
            for (String el : toRemove) {
                list.remove(el);
                removed = true;
            }
            if (removed) continue;
            throw new UnsupportedOperationException("Equations loop!");
        }
        return sortedEq;
    }

    protected List<String> sortVarLines(Map<String, String> list) {
        ArrayList<String> out = new ArrayList<String>();
        ArrayList<String> sortedIds = new ArrayList<String>();
        Set<String> inputId = list.keySet();
        ArrayList sortedEq = new ArrayList();
        boolean cont = true;
        boolean ended = true;
        while (ended) {
            ended = false;
            for (Map.Entry entry : list.entrySet()) {
                String var = this.getName((String)entry.getKey());
                if (sortedIds.contains(var)) continue;
                if (!this.parVariablesFromMap.containsKey(var)) {
                    sortedEq.add(entry.getValue());
                    sortedIds.add(var);
                    continue;
                }
                for (SymbolRef leaf : this.parVariablesFromMap.get(var)) {
                    if (this.parVariablesFromMap.containsKey(var)) continue;
                    sortedEq.add(entry.getValue());
                    sortedIds.add(var);
                }
            }
            if (sortedEq.size() == list.entrySet().size()) continue;
            ended = true;
        }
        for (String string : sortedEq) {
            out.add(list.get(string));
        }
        return out;
    }

    protected List<String> sortVarLinesOld(Map<String, String> list) {
        ArrayList<String> toRemove = new ArrayList<String>();
        ArrayList<String> sortedIds = new ArrayList<String>();
        sortedIds.addAll(Util.getList(this.theta_Parameters));
        sortedIds.addAll(this.derivativeMapNew.values());
        sortedIds.addAll(Util.getList(this.usedOdeCatCovNames));
        sortedIds.addAll(Util.getList(this.usedOdeContCovNames));
        Set<String> inputId = list.keySet();
        for (String key : list.keySet()) {
            if (!sortedIds.contains(key)) continue;
            toRemove.add(key);
        }
        for (String key : toRemove) {
            list.remove(key);
        }
        toRemove.clear();
        ArrayList<String> sortedEq = new ArrayList<String>();
        while (!list.isEmpty()) {
            toRemove.clear();
            for (Map.Entry<String, String> pair : list.entrySet()) {
                String var = this.getName(pair.getKey());
                if (sortedIds.contains(pair.getKey())) continue;
                if (!this.parVariablesFromMap.containsKey(var)) {
                    sortedEq.add(pair.getValue());
                    sortedIds.add(var);
                    toRemove.add(pair.getKey());
                    continue;
                }
                List<String> lf = Util.getList(this.parVariablesFromMap.get(var));
                int i = 0;
                for (String s : lf) {
                    if (!sortedIds.contains(s) && !this.isIndependentVariableSym(s) && !this.isDerivativeVar(s)) continue;
                    ++i;
                }
                if (i != lf.size()) continue;
                sortedEq.add(pair.getValue());
                sortedIds.add(var);
                toRemove.add(pair.getKey());
            }
            boolean removed = false;
            for (String el : toRemove) {
                list.remove(el);
                removed = true;
            }
            if (removed) continue;
            throw new UnsupportedOperationException("Equations loop!");
        }
        return sortedEq;
    }

    protected List<String> sortVarLinesOLD(Map<String, String> list, Set<String> otherVar) {
        ArrayList<String> out = new ArrayList<String>();
        ArrayList<String> sortedIds = new ArrayList<String>();
        Set<String> inputId = list.keySet();
        ArrayList<String> sortedEq = new ArrayList<String>();
        boolean cont = true;
        boolean flag = true;
        while (flag) {
            flag = false;
            for (String s : inputId) {
                if (sortedIds.contains(s)) continue;
                if (!this.parVariablesFromMap.containsKey(s)) {
                    sortedEq.add(s);
                    sortedIds.add(s);
                    continue;
                }
                int n = this.parVariablesFromMap.get(s).size();
                int i = 0;
                for (String s0 : Util.getList(this.parVariablesFromMap.get(s))) {
                    if (sortedIds.contains(s0)) {
                        ++i;
                        continue;
                    }
                    if (inputId.contains(s0)) continue;
                    sortedIds.add(s0);
                    ++i;
                }
                if (i != this.parVariablesFromMap.get(s).size()) continue;
                sortedEq.add(s);
                sortedIds.add(s);
            }
            if (sortedEq.size() == list.entrySet().size()) continue;
            flag = true;
        }
        for (String s : sortedEq) {
            out.add(list.get(s));
        }
        return out;
    }

    protected List<String> pascalIndivEqGeneration(List<SymbolRef> calcVars) {
        ArrayList<String> varLines = new ArrayList<String>();
        String equation = "";
        String current_symbol = "";
        String operand = "";
        String format = "%s " + this.pascalAssignSymbol + " %s;\n";
        List<String> eqList = Util.mergeStrings(this.winbugsIndivLines, this.variableLines);
        for (String s : eqList) {
            String eq;
            if (s == null || s.length() <= 0) continue;
            current_symbol = this.delimit(s.substring(0, s.indexOf(assignSymbol)).trim());
            operand = current_symbol.contains("probit") ? "probit" : (current_symbol.contains("logit") ? "logit" : (current_symbol.contains("log") ? "log" : ""));
            if (this.transfMap.containsKey(current_symbol)) {
                current_symbol = this.transfMap.get(current_symbol);
            }
            equation = this.unaryOperandEqMap.get(current_symbol);
            String symbol = this.getName(Util.clean(this.removeIndexes(current_symbol)).trim());
            if (!Util.getList(calcVars).contains(this.getName(symbol))) continue;
            String pascal_symbol = this.delimit(this.getName(symbol) + upperSuffixDerDepLabel);
            String pascal_equation = "";
            String pascal_operand = "";
            String tmp = "";
            tmp = new String(this.removeIndexes(s.substring(s.indexOf(assignSymbol) + assignSymbol.length(), s.length())));
            if (equation != null) {
                pascal_equation = operand.length() > 0 ? this.doInverseTransformation(operand, this.pascalIndivMap.get(current_symbol)) : this.pascalIndivMap.get(current_symbol);
                pascal_equation = this.removeIndexes(pascal_equation);
                if (!this.unaryOperandEqMap.containsKey(current_symbol)) {
                    varLines.add(String.format(format, current_symbol, tmp.trim()));
                }
                eq = String.format("%s " + this.pascalAssignSymbol + " %s;", pascal_symbol, pascal_equation);
                this.pascalIndivLines.add(eq);
                this.pascalAssignIndivEqLinesMap.put(Util.clean(this.removeIndexes(current_symbol)), eq);
                continue;
            }
            if (this.pascalIndivMap.get(symbol) != null) {
                pascal_equation = this.removeIndexes(this.pascalIndivMap.get(symbol));
                if (this.piecewiseParameters.get(symbol) == null || !Parser.isInList(Util.getList(this.odeParameters), symbol) && !Parser.isInList(Util.getList(this.piecewiseParameters.get(symbol)), symbol)) continue;
                eq = String.format("%s " + this.pascalAssignSymbol + " %s;", pascal_symbol, pascal_equation.trim());
                this.pascalIndivLines.add(eq);
                this.pascalAssignIndivEqLinesMap.put(Util.clean(this.removeIndexes(current_symbol)), eq);
                continue;
            }
            PharmMLRootType rt = this.lexer.getAccessor().fetchElement(symbol);
            if (rt instanceof CovariateDefinition) {
                CovariateDefinition covT = (CovariateDefinition)rt;
                String covTeq = this.covariateTransformationMap.get(covT);
                if (covTeq == null) continue;
                pascal_equation = this.removeIndexes(covTeq);
                if (this.piecewiseParameters.get(symbol) == null || !Parser.isInList(Util.getList(this.odeParameters), symbol) && !Parser.isInList(Util.getList(this.piecewiseParameters.get(symbol)), symbol)) continue;
                String eq2 = String.format("%s " + this.pascalAssignSymbol + " %s;", pascal_symbol, pascal_equation.trim());
                this.pascalIndivLines.add(eq2);
                this.pascalAssignIndivEqLinesMap.put(Util.clean(this.removeIndexes(current_symbol)), eq2);
                continue;
            }
            if (!(rt instanceof TransformedCovariate)) continue;
            for (Map.Entry<Object, String> ct : this.covariateTransformationMap.entrySet()) {
                if (!((CovariateTransformation)ct.getKey()).getTransformedCovariate().getSymbId().equals(symbol)) continue;
                pascal_equation = this.pascalNamesTransform(ct.getValue());
            }
            String eq3 = String.format("%s " + this.pascalAssignSymbol + " %s;", pascal_symbol, pascal_equation.trim());
            this.pascalIndivLines.add(eq3);
            this.pascalAssignIndivEqLinesMap.put(Util.clean(this.removeIndexes(current_symbol)), eq3);
        }
        return varLines;
    }

    protected String generatePiecewiseBlocks(String pwId) {
        HashMap<String, String> completeVarAssignEq = new HashMap<String, String>();
        Set<Object> otherVar = new HashSet();
        String format = "%s := func.arguments[0][%s].Value();\n\t\t";
        StringBuilder sb1 = new StringBuilder("");
        StringBuilder[] s2 = new StringBuilder[1];
        StringBuilder sb3 = new StringBuilder();
        String varEq = "";
        ArrayList<SymbolRef> vars = new ArrayList();
        vars = this.parVariablesFromMap.get(pwId);
        List<SymbolRef> a = this.getPiecewiseParameters_Pascal(vars);
        a = this.completeList(a);
        this.pascalIndivEqGeneration(a);
        vars = new ArrayList();
        vars = this.parVariablesFromMap.get(pwId);
        List<SymbolRef> completeVarList = this.getPiecewiseParameters_Pascal(vars);
        for (String line : Util.getUniqueString(this.pascalIndivLines)) {
            String name = this.getName(Util.clean(line.substring(0, line.indexOf(this.pascalAssignSymbol))).trim());
            if (!Parser.isInList(Util.getList(completeVarList), name)) continue;
            completeVarAssignEq.put(Util.clean(name), line);
        }
        int ind = 0;
        Map<Integer, String> tmp = this.piecewiseVarToPascal.get(pwId);
        if (tmp != null) {
            for (int i = 1; i <= tmp.size(); ++i) {
                sb1.append(String.format(format, tmp.get(i), ind++));
            }
            String line = null;
            for (SymbolRef par : a) {
                String id = par.getSymbIdRef();
                if (id == null || !this.parVariablesFromMap.containsKey(id)) continue;
                if (this.pascalAssignIndivEqLines.get(id) != null) {
                    line = Util.clean(this.pascalAssignIndivEqLines.get(id));
                    completeVarAssignEq.put(id, line);
                    continue;
                }
                if (this.pascalAssignVarEqLines.get(id) == null) continue;
                line = Util.clean(this.pascalAssignVarEqLines.get(id));
                completeVarAssignEq.put(id, line);
            }
            otherVar = completeVarAssignEq.keySet();
            varEq = this.cleanPascal(this.concat(this.sortVarLines(completeVarAssignEq, this.getSortedPiecewise(pwId)), "\n\t\t"));
            s2 = this.generateIFELSEBlocks();
            this.pascalAssignIndivEq = Util.clean(this.concat(this.filterBy(this.pascalAssignIndivEqLines, pwId), "\t\t"));
            if (!this.pascalAssignIndivEq.trim().isEmpty()) {
                sb3.append(this.pascalAssignIndivEq);
            }
        }
        return sb1.toString() + varEq + sb3.toString() + s2[this.piecewiseIndexMap.get(pwId) - 1];
    }

    protected StringBuilder[] generateIFELSEBlocks() {
        StringBuilder[] sb2 = new StringBuilder[this.piecewiseCompleteList.size()];
        for (int i = 0; i < sb2.length; ++i) {
            sb2[i] = new StringBuilder();
        }
        for (Map.Entry<String, Integer> pw : this.piecewiseIndexMap.entrySet()) {
            sb2[pw.getValue() - 1].append(this.generatePiecewiseBlock(this.getPiecewise(pw.getKey()), pw.getKey()));
        }
        return sb2;
    }

    protected List<String> filterBy(Map<String, String> map, String id) {
        ArrayList<String> out = new ArrayList<String>();
        List<SymbolRef> list = this.parVariablesFromMap.get(id);
        for (SymbolRef s : list) {
            if (map.get(s.getId()) == null) continue;
            out.add(map.get(s.getId()));
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    private void managePiecewiseVariables() {
        BinaryTree bt;
        List<VariableDefinition> pwv = this.piecewiseVariables;
        ArrayList<String> pwLines = new ArrayList<String>();
        for (VariableDefinition variableDefinition : pwv) {
            this.piecewiseODE.put(variableDefinition.getSymbId(), false);
            if (Util.getList(this.odeParameters).contains(variableDefinition.getSymbId())) {
                this.piecewiseODE.put(variableDefinition.getSymbId(), true);
            }
            this.piecewiseVariablesId.add(variableDefinition.getSymbId());
            bt = this.lexer.getTreeMaker().newInstance((Object)variableDefinition);
            if (variableDefinition.getAssign().getPiecewise() != null) {
                String string = this.generatePiecewiseBlock(variableDefinition.getAssign().getPiecewise(), variableDefinition.getSymbId());
                pwLines.add(string);
                continue;
            }
            this.derivativeDefFromMap.put(variableDefinition.getSymbId(), String.format("%s%s(%s%s[%s,%s,])", this.piecewiseFunctionSuffix, this.piecewiseIndexMap.get(variableDefinition.getSymbId()), piecewiseSymb, this.piecewiseIndexMap.get(variableDefinition.getSymbId()), IND_S, IND_T2));
        }
        for (PopulationParameter populationParameter : this.piecewisePopPars) {
            this.piecewiseODE.put(populationParameter.getSymbId(), false);
            if (Util.getList(this.odeParameters).contains(populationParameter.getSymbId())) {
                this.piecewiseODE.put(populationParameter.getSymbId(), true);
                continue;
            }
            this.piecewiseVariablesId.add(populationParameter.getSymbId());
            bt = this.lexer.getTreeMaker().newInstance((Object)populationParameter);
            String string = this.parse(pwv, bt);
            pwLines.add(string);
            this.derivativeDefFromMap.put(populationParameter.getSymbId(), String.format("%s%s(%s%s[%s,%s,])", this.piecewiseFunctionSuffix, this.piecewiseIndexMap.get(populationParameter.getSymbId()), piecewiseSymb, this.piecewiseIndexMap.get(populationParameter.getSymbId()), IND_S, IND_T2));
        }
        int n = 0;
        for (SymbolRef sr : this.leafPiecewiseParameters) {
            this.pascalVarMap.put(sr.getSymbIdRef(), n++);
        }
        for (SymbolRef sr : this.theta_Parameters) {
            if (this.pascalVarMap.containsKey(sr.getSymbIdRef())) continue;
            this.pascalVarMap.put(sr.getSymbIdRef(), n++);
        }
        if (!this.hasDiffEquations) {
            String pid;
            String string = "%s%s[%s,%s,%s] %s %s\n\t\t";
            boolean bl = true;
            for (VariableDefinition variableDefinition : this.piecewiseVariables) {
                void var6_17;
                pid = variableDefinition.getSymbId();
                this.generateWinbugsPWLine(pid, (int)var6_17, string);
                ++var6_17;
            }
            for (PopulationParameter populationParameter : this.piecewisePopPars) {
                void var6_18;
                pid = populationParameter.getSymbId();
                this.generateWinbugsPWLine(pid, (int)var6_18, string);
                ++var6_18;
            }
        } else {
            String id1;
            List<SymbolRef> vars;
            String id;
            int ind;
            String string = "%s%s[%s,%s,%s] %s %s\n\t\t";
            for (VariableDefinition variableDefinition : this.piecewiseVariables) {
                String pwId = variableDefinition.getSymbId();
                ind = 1;
                if (Util.getList(this.odeParameters).contains(pwId)) continue;
                this.generateWinbugsPWLine(pwId, ind, string);
                ++ind;
                for (Map.Entry<String, Object> pw : this.pascalVarMap.entrySet()) {
                    id = pw.getKey();
                    if (this.piecewiseParameters.get(pwId) == null || !Parser.isInList(Util.getList(this.piecewiseParameters.get(pwId)), id) || pwId.equals(id)) continue;
                    vars = this.parVariablesFromMap.get(id);
                    if (vars != null) {
                        for (SymbolRef sr : vars) {
                            id1 = sr.getSymbIdRef();
                            id = this.variablesAssignementMap.get(this.delimit(id1)) != null ? this.delimit(this.variablesAssignementMap.get(this.delimit(id1))) : (this.variablesAssignementMap.get(this.delimit(id)) != null ? this.delimit(this.variablesAssignementMap.get(this.delimit(id))) : this.delimit(id));
                            if (!this.isDerivativeVar(Util.clean(this.removeIndexes(id)))) {
                                String string2 = String.format(string, piecewiseSymb, this.piecewiseIndexMap.get(pwId), IND_S, IND_T, ind++, assignSymbol, this.delimit(id1));
                                this.winbugsPiecewiseLines.add(string2);
                                continue;
                            }
                            String string4 = String.format(string, piecewiseSymb, this.piecewiseIndexMap.get(pwId), IND_S, IND_T2, ind++, assignSymbol, this.delimit(id));
                            string4 = this.adjustStatement(string4);
                            this.winbugsPiecewiseDerivDepLines.add(string4);
                        }
                        continue;
                    }
                    String string5 = String.format(string, piecewiseSymb, this.piecewiseIndexMap.get(pwId), IND_S, IND_T, ind++, assignSymbol, this.delimit(id));
                    this.winbugsPiecewiseLines.add(string5);
                }
            }
            for (PopulationParameter populationParameter : this.piecewisePopPars) {
                String pid = populationParameter.getSymbId();
                ind = 1;
                if (!Util.getList(this.odeParameters).contains(pid) || this.piecewiseMap.containsKey(this.delimit(this.variablesAssignementMap.get(this.delimit(pid))))) {
                    this.generateWinbugsPWLine(pid, this.piecewiseIndexMap.get(pid), string);
                    ++ind;
                }
                for (Map.Entry<String, Object> pw : this.pascalVarMap.entrySet()) {
                    id = pw.getKey();
                    if (this.piecewiseParameters.get(id) == null || !Parser.isInList(Util.getList(this.piecewiseParameters.get(id)), id) || pid.equals(id)) continue;
                    vars = this.parVariablesFromMap.get(id);
                    if (vars != null) {
                        for (SymbolRef sr : vars) {
                            id1 = sr.getSymbIdRef();
                            id = this.variablesAssignementMap.get(this.delimit(id1)) != null ? this.delimit(this.variablesAssignementMap.get(this.delimit(id1))) : (this.variablesAssignementMap.get(this.delimit(id)) != null ? this.delimit(this.variablesAssignementMap.get(this.delimit(id))) : this.delimit(id));
                            if (!this.isDerivativeVar(Util.clean(this.removeIndexes(id)))) {
                                String string6 = String.format(string, piecewiseSymb, this.piecewiseIndexMap.get(pid), IND_S, IND_T, this.piecewiseIndexMap.get(Util.clean(this.removeIndexes(id))), assignSymbol, this.delimit(id1));
                                this.winbugsPiecewiseLines.add(string6);
                                continue;
                            }
                            String string8 = String.format(string, piecewiseSymb, this.piecewiseIndexMap.get(pid), IND_S, IND_T2, ind++, assignSymbol, this.delimit(id));
                            string8 = this.adjustStatement(string8);
                            this.winbugsPiecewiseDerivDepLines.add(string8);
                        }
                        continue;
                    }
                    String string9 = String.format(string, piecewiseSymb, this.piecewiseIndexMap.get(pid), IND_S, IND_T, ind++, assignSymbol, this.delimit(id));
                    this.winbugsPiecewiseLines.add(string9);
                }
            }
        }
    }

    private void generateWinbugsPWLine(String pid, int ind, String format) {
        HashSet tmpList = new HashSet();
        this.pwBugsList.add(pid);
        this.winbugsPiecewiseLines.add(this.adjustStatement(String.format("%s_%s %s %s%s(%s%s[%s,%s,])", this.piecewiseSuffix, pid, assignSymbol, this.piecewiseFunctionSuffix, ind, piecewiseSymb, ind, IND_S, IND_T)));
        HashSet tmpSet = new HashSet(this.parVariablesFromMap.get(pid));
        HashSet toAdd = new HashSet();
        HashSet<SymbolRef> toRemove = new HashSet<SymbolRef>();
        boolean end = false;
        while (!end) {
            end = true;
            for (SymbolRef tl : tmpSet) {
                if (tmpList.contains(tl) || this.parVariablesFromMap.get(tl.getSymbIdRef()) == null) continue;
                toAdd.addAll(this.parVariablesFromMap.get(tl.getSymbIdRef()));
                toRemove.add(tl);
                end = false;
            }
            tmpSet.addAll(toAdd);
            tmpSet.removeAll(toRemove);
            toAdd.clear();
            toRemove.clear();
        }
        tmpList.addAll(tmpSet);
        int iv = 1;
        HashMap<Integer, String> tmpMap = new HashMap<Integer, String>();
        for (SymbolRef sr : tmpList) {
            tmpMap.put(iv, sr.getSymbIdRef());
            String tmp = String.format(format, piecewiseSymb, this.piecewiseIndexMap.get(pid), IND_S, IND_T, iv++, assignSymbol, this.delimit(sr.getSymbIdRef()));
            this.winbugsPiecewiseLines.add(this.adjustStatement(tmp));
        }
        this.piecewiseVarToPascal.put(pid, tmpMap);
    }

    private void generateWinbugsCovLine(String pid, int ind, String format) {
        HashSet tmpList = new HashSet();
        this.winbugsCovariateLines.add(this.adjustStatement(String.format("%s_%s %s %s%s(%s%s[%s,%s,])", this.categSuffix, pid, assignSymbol, this.categFunctionSuffix, ind, pid + "", ind, IND_S, IND_T)));
        HashSet tmpSet = new HashSet(this.parVariablesFromMap.get(pid));
        HashSet toAdd = new HashSet();
        HashSet<SymbolRef> toRemove = new HashSet<SymbolRef>();
        boolean end = false;
        while (!end) {
            end = true;
            for (SymbolRef tl : tmpSet) {
                if (tmpList.contains(tl) || this.parVariablesFromMap.get(tl.getSymbIdRef()) == null) continue;
                toAdd.addAll(this.parVariablesFromMap.get(tl.getSymbIdRef()));
                toRemove.add(tl);
                end = false;
            }
            tmpSet.addAll(toAdd);
            tmpSet.removeAll(toRemove);
            toAdd.clear();
            toRemove.clear();
        }
        tmpList.addAll(tmpSet);
        int iv = 1;
        HashMap<Integer, String> tmpMap = new HashMap<Integer, String>();
        for (SymbolRef sr : tmpList) {
            tmpMap.put(iv, sr.getSymbIdRef());
            String tmp = String.format(format, piecewiseSymb, this.piecewiseIndexMap.get(pid), IND_S, IND_T, iv++, assignSymbol, this.delimit(sr.getSymbIdRef()));
            this.winbugsPiecewiseLines.add(this.adjustStatement(tmp));
        }
        this.piecewiseVarToPascal.put(pid, tmpMap);
    }

    private String addSuffix(String symbol, String suffix) {
        if (symbol.contains(this.leftArrayBracket)) {
            int pos = symbol.indexOf(this.leftArrayBracket.charAt(0));
            return symbol.substring(0, pos) + suffix + symbol.substring(pos);
        }
        return symbol;
    }

    private String doString(String string) {
        return string;
    }

    private String doReal(RealValue realValue) {
        return realValue.valueToString();
    }

    private String doStringValue(StringValue stringValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String doInt(IntValue intValue) {
        return intValue.valueToString();
    }

    protected String doPiecewise(Piecewise pw) {
        Piece piece;
        int i;
        this.incrementPiecewiseIndent();
        String symbol = unassigned_symbol;
        List pieces = pw.getListOfPiece();
        Piece else_block = null;
        BinaryTree[] assignment_trees = new BinaryTree[pieces.size()];
        BinaryTree[] conditional_trees = new BinaryTree[pieces.size()];
        String[] conditional_stmts = new String[pieces.size()];
        String[] assignment_stmts = new String[pieces.size()];
        TreeMaker tm = this.lexer.getTreeMaker();
        int assignment_count = 0;
        int else_index = -1;
        for (i = 0; i < pieces.size(); ++i) {
            piece = (Piece)pieces.get(i);
            if (piece == null) continue;
            Condition cond = piece.getCondition();
            if (cond != null) {
                conditional_trees[i] = tm.newInstance((Object)piece.getCondition());
                if (cond.getOtherwise() != null) {
                    else_block = piece;
                    else_index = i;
                }
            }
            BinaryTree assignment_tree = tm.newInstance((Object)piece);
            this.lexer.updateNestedTrees();
            if (assignment_tree == null) continue;
            assignment_trees[i] = assignment_tree;
            ++assignment_count;
        }
        if (assignment_count == 0) {
            throw new IllegalStateException("A piecewise block has no assignment statements.");
        }
        for (i = 0; i < pieces.size(); ++i) {
            piece = (Piece)pieces.get(i);
            if (conditional_trees[i] == null || assignment_trees[i] == null) continue;
            if (!piece.equals(else_block)) {
                conditional_stmts[i] = this.parse(piece, conditional_trees[i]);
            }
            assignment_stmts[i] = this.parse(new Object(), assignment_trees[i]);
        }
        int block_assignment = 0;
        StringBuilder block = new StringBuilder();
        for (int i2 = 0; i2 < pieces.size(); ++i2) {
            Piece piece2 = (Piece)pieces.get(i2);
            if (piece2 == null || piece2.equals(else_block) || conditional_stmts[i2] == null || assignment_stmts[i2] == null) continue;
            String operator = "if";
            if (block_assignment > 0) {
                operator = "elseif";
            }
            String format = "%s%s%s %s\n%s%s = %s;\n";
            block.append(String.format(format, "", this.indent(this.getLogicalStatementIndent()), operator, conditional_stmts[i2], this.indent(this.getAssignmentStatementIndent()), this.field_tag, assignment_stmts[i2]));
            ++block_assignment;
        }
        if (else_block != null && else_index >= 0) {
            block.append(this.indent(this.getLogicalStatementIndent()) + "else\n");
            if (PharmMLTypeChecker.isNestedPiecewise((Object)else_block)) {
                String format = "%s%s\n";
                block.append(String.format(format, this.indent(this.getLogicalStatementIndent()), assignment_stmts[else_index]));
            } else {
                String format = "%s%s = %s;\n";
                block.append(String.format(format, this.indent(this.getAssignmentStatementIndent()), this.field_tag, assignment_stmts[else_index]));
            }
        }
        block.append(this.indent(this.getLogicalStatementIndent()) + "end");
        if (assignment_count == 0) {
            throw new IllegalStateException("Piecewise statement assigned no conditional blocks.");
        }
        symbol = block.toString();
        this.decrementPiecewiseIndent();
        return symbol;
    }

    private String doLogicalBinaryOperator(LogicBinOp logicBinOp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String doLogicalUnaryOperator(LogicUniOp logicUniOp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String doParameterEstimate(ParameterEstimate parameterEstimate) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean isActivityDoseAmountBlock(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String doElement(JAXBElement<?> jaxbElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String doUnivariateDistribution(AbstractContinuousUnivariateDistributionType abstractContinuousUnivariateDistributionType) {
        return abstractContinuousUnivariateDistributionType.getDefinition();
    }

    private String doProbonto(ProbOnto prob) {
        return prob.getName().value();
    }

    private String doVarRef(VarRefType varRefType) {
        return varRefType.getVarId();
    }

    private boolean isReplicateVariable(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String doCorrelation(CorrelationRef correlationRef) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String doBigInteger(BigInteger bigInteger) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String doFixedParameter(FixedParameter fixedParameter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String doParameterAssignmentFromEstimation(ParameterAssignmentFromEstimation parameterAssignmentFromEstimation) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean isRandomVariableRef(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean isReplicateLinkedParameter(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLexer(ILexer lexer) {
        if (lexer == null) {
            throw new NullPointerException("The lexer is NULL.");
        }
        this.lexer = lexer;
        this.z = new SymbolReader(lexer);
    }

    private String doSimulationOutput(SimulationOutput simulationOutput) {
        String symbol = unassigned_symbol;
        if (simulationOutput == null) {
            throw new NullPointerException("Simulation output reference is NULL");
        }
        if (PharmMLTypeChecker.isLocalVariable((Object)simulationOutput.v)) {
            VariableDefinition v = (VariableDefinition)simulationOutput.v;
            String format = "%s";
            symbol = String.format(format, this.z.get((Object)v));
        } else if (PharmMLTypeChecker.isDerivative((Object)simulationOutput.v)) {
            DerivativeVariable dv = (DerivativeVariable)simulationOutput.v;
            String format = "%s";
            symbol = String.format(format, this.z.get((Object)dv));
        } else {
            throw new UnsupportedOperationException("Simulation output type not supported (ref='" + simulationOutput.v + "')");
        }
        return symbol;
    }

    private static Object getDist(Distribution dist) {
        if (dist == null) {
            return null;
        }
        ProbOnto probOnto = dist.getProbOnto();
        if (probOnto != null) {
            return probOnto;
        }
        UncertML uncert = dist.getUncertML();
        if (uncert == null) {
            return null;
        }
        JAXBElement tag = uncert.getAbstractContinuousUnivariateDistribution();
        AbstractContinuousUnivariateDistributionType d = null;
        if (tag != null) {
            d = (AbstractContinuousUnivariateDistributionType)tag.getValue();
        }
        return d;
    }

    private static Object getDist(ParameterRandomVariable rv) {
        return Parser.getDist(rv.getDistribution());
    }

    private boolean isFixedParameter(Object o) {
        return o instanceof FixedParameter;
    }

    private boolean isObjectiveFunctionParameter(Object o) {
        return o instanceof ParameterAssignmentFromEstimation;
    }

    private boolean isIndividualParameterAssignment(Object o) {
        return o instanceof IndividualParameterAssignment;
    }

    private boolean isContinuous(Object context) {
        return context instanceof Continuous;
    }

    private List<String> genPrior() {
        ArrayList<String> priorLines = new ArrayList<String>();
        for (Map.Entry<PharmMLRootType, String> p : this.priorPar.entrySet()) {
            if (!(p.getKey() instanceof PopulationParameter) && !(p.getKey() instanceof ParameterRandomVariable)) continue;
            priorLines.addAll(this.doProbOntoDistributionPrior(p.getKey()));
        }
        return priorLines;
    }

    String doNormalDist(ParameterRandomVariable context, List<String> lines) {
        String formatDistMeanValAssign = "<- %s";
        String formatDistVarValAssign = "<- 1 / %s";
        String formatDistMeanVal = "%s";
        NormalDistribution value = (NormalDistribution)context.getDistribution().getUncertML().getAbstractContinuousUnivariateDistribution().getValue();
        String distName = this.getDistName((AbstractDistributionType)value);
        ContinuousValueType mean = value.getMean();
        SymbolRef srM = new SymbolRef();
        if (mean.getVar() != null) {
            srM.setSymbIdRef(mean.getVar().getVarId());
        }
        String meanAssign = this.delimit("" + (mean.getVar() == null ? mean.getRVal() : this.getSymbol(srM)));
        String varianceAssign = "";
        varianceAssign = this.delimit(this.getVarAssign(value));
        String rhsVarExpression = String.format(formatDistVarValAssign, varianceAssign);
        String rhsMeanExpression = String.format(formatDistMeanValAssign, meanAssign);
        String meanExpression = this.delimit(String.format(formatDistMeanVal, meanAssign));
        String brackets = this.getIndexes(rhsMeanExpression) == 32 ? "" : this.getBrackets(rhsMeanExpression);
        brackets = this.getIndexes(rhsVarExpression) == 32 ? "" : this.getBracketsGen(rhsVarExpression);
        String varTmpName = context.getSymbId() + varianceSuffixLabel;
        String formatDistVarAssignement = varTmpName + "%s %s";
        String varAssignStmt = String.format(formatDistVarAssignement, brackets, rhsVarExpression);
        String varCompleteLabel = this.delimit(Util.clean(varTmpName + brackets));
        lines.add(varAssignStmt);
        String current_symbol = this.getSymbol(context);
        String statementDistFormat = "%s ~ %s(%s, %s)";
        return String.format(statementDistFormat, this.delimit(current_symbol), distName, meanExpression, varCompleteLabel);
    }

    private List<String> doNormalPriors(PharmMLRootType elem) {
        ArrayList<String> lines = new ArrayList<String>();
        ProbOnto value = (ProbOnto)Util.getDistribution(elem);
        DistributionParameter par1 = value.getParameter(ParameterName.MEAN);
        DistributionParameter par2 = null;
        String varianceEquation = "";
        String meanEquation = "";
        varianceEquation = String.format("%s", this.parse(par1, this.lexer.getTreeMaker().newInstance((Object)par1)));
        switch (value.getName().value()) {
            case "Normal1": {
                par2 = value.getParameter(ParameterName.STDEV);
                varianceEquation = String.format("1/pow(%s,2)", this.parse(par2, this.lexer.getTreeMaker().newInstance((Object)par2)));
                break;
            }
            case "Normal2": {
                par2 = value.getParameter(ParameterName.VAR);
                varianceEquation = this.delimit(String.format("(1/(%s))", this.parse(par2, this.lexer.getTreeMaker().newInstance((Object)par2))));
                break;
            }
            case "Normal3": {
                par2 = value.getParameter(ParameterName.PRECISION);
                varianceEquation = this.parse(par2, this.lexer.getTreeMaker().newInstance((Object)par2));
            }
        }
        String precPriorValue = "";
        String meanPriorValue = "";
        String tmp = "";
        String tmp2 = "";
        ArrayList priors = new ArrayList();
        Rhs ass = par2.getAssign();
        if (ass.getSymbRef() != null) {
            tmp = ass.getSymbRef().getSymbIdRef();
        } else if (ass.getScalar() != null) {
            tmp = ass.getScalar().valueToString();
        }
        this.lexer.getAccessor().fetchElement(Util.clean(tmp));
        tmp = this.parse(par2, this.lexer.getTreeMaker().newInstance((Object)par2));
        Rhs a = Util.getPriorValue(this.getPopulationParameter(Util.clean(tmp)));
        if (a != null && (tmp2 = this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a))) != null) {
            precPriorValue = String.format("%s %s %s", tmp, assignSymbol, tmp2);
        }
        if ((a = Util.getPriorValue(this.getPopulationParameter(Util.clean(tmp = this.parse(par1, this.lexer.getTreeMaker().newInstance((Object)par1)))))) != null) {
            tmp2 = this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a));
            this.priorList.add(tmp);
            if (tmp2 != null) {
                meanPriorValue = String.format("%s %s %s", tmp, assignSymbol, tmp2);
            }
        }
        String varCompleteLabel = this.delimit(Util.clean(Util.getSymbId(elem) + varianceSuffixLabel));
        String statementDistFormat = "%s ~ %s(%s, %s)";
        lines.add(String.format("\n" + statementDistFormat, this.delimit(this.getSymbol(elem)), this.getDistName(value), this.delimit(this.parse(par1, this.lexer.getTreeMaker().newInstance((Object)par1))), varCompleteLabel));
        if (meanPriorValue.trim().length() > 0) {
            lines.add(meanPriorValue);
        }
        lines.add(String.format("%s %s %s", varCompleteLabel, assignSymbol, varianceEquation));
        this.priorList.add(this.parse(par2, this.lexer.getTreeMaker().newInstance((Object)par2)));
        if (precPriorValue.trim().length() > 0) {
            lines.add(precPriorValue);
        }
        return lines;
    }

    private List<String> doGammaPriors(PharmMLRootType elem) {
        ArrayList<String> lines = new ArrayList<String>();
        String formatDist = "\n%s %s %s(%s, %s)";
        String formatPar1 = "%s %s 1/%s";
        ProbOnto value = (ProbOnto)Util.getDistribution(elem);
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        String par1 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(0)));
        String par2 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(1)));
        String rateId = Util.getSymbId(elem) + "_rate";
        String tmp2 = "";
        lines.add(String.format(formatDist, Util.getSymbId(elem), dist_symb, this.getDistName(value), par1, rateId));
        Rhs a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(par1)));
        if (a != null) {
            tmp2 = this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a));
            String shapePriorValue = String.format("%s %s %s", par1, assignSymbol, tmp2);
            this.priorList.add(par1);
            lines.add(shapePriorValue);
        }
        if (distName.equals("Gamma1")) {
            lines.add(String.format(formatPar1, rateId, assignSymbol, par2));
        } else if (distName.equals("Gamma2")) {
            lines.add(String.format("%s %s %s", rateId, assignSymbol, par2));
        }
        a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(par2)));
        if (a != null) {
            tmp2 = this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a));
            String ratePriorValue = String.format("%s %s %s", par2, assignSymbol, tmp2);
            this.priorList.add(par2);
            lines.add(ratePriorValue);
        }
        return lines;
    }

    private List<String> doExponentialPriors(PharmMLRootType elem) {
        ArrayList<String> lines = new ArrayList<String>();
        String formatDist = "\n%s %s %s(%s)";
        String formatPar1 = "%s %s 1/%s";
        ProbOnto value = (ProbOnto)Util.getDistribution(elem);
        String distName = value.getName().value();
        List listP = value.getListOfParameter();
        String par1 = this.parse(listP.get(0), this.lexer.getTreeMaker().newInstance(listP.get(0)));
        String rateId = Util.getSymbId(elem) + "_rate";
        String tmp = "";
        String tmp2 = "";
        lines.add(String.format(formatDist, Util.getSymbId(elem), dist_symb, this.getDistName(value), par1));
        if (distName.equals("Exponential2")) {
            lines.add(String.format(formatPar1, rateId, assignSymbol, par1));
        } else if (distName.equals("Exponential2")) {
            lines.add(String.format("%s %s %s", rateId, assignSymbol, par1));
        }
        Rhs a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(par1)));
        if (a != null) {
            tmp2 = this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a));
            String ratePriorValue = String.format("%s %s %s", par1, assignSymbol, tmp2);
            this.priorList.add(par1);
            lines.add(ratePriorValue);
        }
        return lines;
    }

    private List<String> doLogNormalPriors(PharmMLRootType elem) {
        ArrayList<String> lines = new ArrayList<String>();
        String formatDist = "%s %s %s(%s,%s)";
        String formatPar1 = "%s %s";
        ProbOnto value = (ProbOnto)Util.getDistribution(elem);
        String distName = value.getName().value();
        String id = ((PopulationParameter)elem).getSymbId();
        String precId = id + varianceSuffixLabel;
        String meanId = id + "_meanLog";
        lines.add(String.format(formatDist, Util.getSymbId(elem), dist_symb, this.getDistName(this.getProbOntoDistributionType(elem)), meanId, precId));
        if (distName.equals("LogNormal5")) {
            DistributionParameter par1 = value.getParameter(ParameterName.MEAN_LOG);
            DistributionParameter par2 = value.getParameter(ParameterName.PRECISION);
            lines.add(String.format("%s %s %s", meanId, assignSymbol, this.getParameter(par1)));
            lines.add(String.format("%s %s %s", precId, assignSymbol, this.getParameter(par2)));
        } else if (distName.equals("LogNormal2")) {
            DistributionParameter par1 = value.getParameter(ParameterName.MEAN_LOG);
            DistributionParameter par2 = value.getParameter(ParameterName.VAR_LOG);
            lines.add(String.format("%s %s %s", meanId, assignSymbol, this.getParameter(par1)));
            lines.add(String.format("%s %s 1/%s", precId, assignSymbol, this.getParameter(par2)));
        } else if (distName.equals("LogNormal3")) {
            DistributionParameter par1 = value.getParameter(ParameterName.MEDIAN);
            DistributionParameter par2 = value.getParameter(ParameterName.STDEV_LOG);
            lines.add(String.format("%s %s log(%s)", meanId, assignSymbol, this.getParameter(par1)));
            lines.add(String.format("%s %s 1/pow(%s,2)", precId, assignSymbol, this.getParameter(par2)));
        } else if (distName.equals("LogNormal6")) {
            DistributionParameter par1 = value.getParameter(ParameterName.MEDIAN);
            DistributionParameter par2 = value.getParameter(ParameterName.GEOM_STDEV);
            lines.add(String.format(formatPar1 + "log(%s)", meanId, assignSymbol, this.getParameter(par1)));
            lines.add(String.format("%s %s 1/pow(%s,2)", precId, assignSymbol, this.getParameter(par2)));
        } else if (distName.equals("LogNormal1")) {
            DistributionParameter par1 = value.getParameter(ParameterName.MEAN_LOG);
            DistributionParameter par2 = value.getParameter(ParameterName.PRECISION);
            lines.add(String.format(formatPar1 + "%s", meanId, assignSymbol, this.getParameter(par1)));
            lines.add(String.format(formatPar1 + "1/pow(%s,2)", precId, assignSymbol, this.getParameter(par2)));
        } else if (distName.equals("LogNormal4")) {
            DistributionParameter par1 = value.getParameter(ParameterName.MEAN_LOG);
            DistributionParameter par2 = value.getParameter(ParameterName.COEF_VAR);
            lines.add(String.format(formatPar1 + "%s", meanId, assignSymbol, this.getParameter(par1)));
            lines.add(String.format(formatPar1 + "1/(log(pow(%s,2)+1))", precId, assignSymbol, this.getParameter(par2)));
        }
        return lines;
    }

    private List<String> doBetaPriors(PharmMLRootType elem) {
        ArrayList<String> lines = new ArrayList<String>();
        String formatDist = "%s %s %s(%s,%s)";
        String formatPar2 = "%s %s %s";
        ProbOnto value = (ProbOnto)Util.getDistribution(elem);
        List listP = value.getListOfParameter();
        String parAlpha = this.parse(value.getParameter(ParameterName.ALPHA), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.ALPHA)));
        String parBeta = this.parse(value.getParameter(ParameterName.BETA), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.BETA)));
        String alphaId = Util.getSymbId(elem) + "_alpha";
        String betaId = Util.getSymbId(elem) + "_beta";
        lines.add(String.format(formatDist, Util.getSymbId(elem), dist_symb, this.getDistName(this.getProbOntoDistributionType(elem)), parAlpha, parBeta));
        Rhs a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parAlpha)));
        if (a != null) {
            String alphaPriorValue = String.format("%s %s %s", alphaId, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a)));
            this.priorList.add(parAlpha);
            lines.add(alphaPriorValue);
        }
        if ((a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parBeta)))) != null) {
            String betaPriorValue = String.format("%s %s %s", betaId, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a)));
            this.priorList.add(parBeta);
            lines.add(betaPriorValue);
        }
        return lines;
    }

    private List<String> doStudentPriors(PharmMLRootType elem) {
        Rhs a;
        ArrayList<String> lines = new ArrayList<String>();
        String formatDist = "%s %s %s(%s,%s,%s)";
        String formatPar2 = "%s %s %s";
        ProbOnto value = (ProbOnto)Util.getDistribution(elem);
        String distName = value.getName().value();
        String parDegFreed = this.parse(value.getParameter(ParameterName.DEGREES_OF_FREEDOM), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.DEGREES_OF_FREEDOM)));
        String parMean = this.parse(value.getParameter(ParameterName.MEAN), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.MEAN)));
        String parScale = this.parse(value.getParameter(ParameterName.SCALE), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.SCALE)));
        String meanId = Util.getSymbId(elem) + meanSuffixLabel;
        String degId = Util.getSymbId(elem) + "_deg";
        String scaleId = Util.getSymbId(elem) + "_scale";
        lines.add(String.format(formatDist, Util.getSymbId(elem), dist_symb, this.getDistName(this.getProbOntoDistributionType(elem)), meanId, scaleId, degId));
        if (distName.equals("StudentT1")) {
            lines.add(String.format(formatPar2, meanId, assignSymbol, 0));
            lines.add(String.format(formatPar2, scaleId, assignSymbol, 1));
        } else {
            String ratePriorValue;
            lines.add(String.format(formatPar2, meanId, assignSymbol, parMean));
            lines.add(String.format(formatPar2, scaleId, assignSymbol, parScale));
            a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parMean)));
            if (a != null) {
                ratePriorValue = String.format("%s %s %s", meanId, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a)));
                this.priorList.add(parMean);
                lines.add(ratePriorValue);
            }
            if ((a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parScale)))) != null) {
                ratePriorValue = String.format("%s %s %s", scaleId, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a)));
                this.priorList.add(parScale);
                lines.add(ratePriorValue);
            }
        }
        a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parDegFreed)));
        if (a != null) {
            String precPriorValue = String.format("%s %s %s", degId, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a)));
            this.priorList.add(parDegFreed);
            lines.add(precPriorValue);
        }
        return lines;
    }

    private List<String> doWeibullPriors(PharmMLRootType elem) {
        ArrayList<String> lines = new ArrayList<String>();
        String formatDist = "%s %s %s(%s,%s,%s)";
        String formatPar2 = "%s %s %s";
        ProbOnto value = (ProbOnto)Util.getDistribution(elem);
        String distName = value.getName().value();
        String parShape = this.parse(value.getParameter(ParameterName.SHAPE), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.SHAPE)));
        String parScale = this.parse(value.getParameter(ParameterName.SCALE), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.SHAPE)));
        String parLambda = this.parse(value.getParameter(ParameterName.LAMBDA), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.LAMBDA)));
        String shapeId = Util.getSymbId(elem) + "_shape";
        String lambdaId = Util.getSymbId(elem) + "_lambda";
        String scaleId = Util.getSymbId(elem) + "_scale";
        lines.add(String.format(formatDist, Util.getSymbId(elem), dist_symb, this.getDistName(this.getProbOntoDistributionType(elem)), lambdaId, shapeId));
        if (distName.equals(DistributionName.WEIBULL_1)) {
            lines.add(String.format(formatPar2 + "pow(%s,(-1/%s))", lambdaId, assignSymbol, scaleId, shapeId));
            Rhs a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parScale)));
            if (a != null) {
                String precPriorValue = String.format("%s %s %s", scaleId, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a)));
                this.priorList.add(parScale);
                lines.add(precPriorValue);
            }
        }
        lines.addAll(this.addPrior(shapeId, parShape));
        lines.addAll(this.addPrior(lambdaId, parLambda));
        return lines;
    }

    private List<String> addPrior(String dofId, String parDOF) {
        ArrayList<String> lines = new ArrayList<String>();
        Rhs a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parDOF)));
        if (a != null) {
            if (a.getMatrix() != null) {
                Matrix mat = a.getMatrix();
                lines.addAll(this.getMatrix(mat, parDOF));
            } else {
                lines.add(String.format("%s %s %s", parDOF, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a))));
            }
            this.priorList.add(parDOF);
        }
        return lines;
    }

    private List<String> doWishartPriors(PharmMLRootType elem) {
        ArrayList<String> lines = new ArrayList<String>();
        this.doWishart((CommonParameter)elem, lines, true);
        return lines;
    }

    private List<String> doInverseWishartPriors(PharmMLRootType elem) {
        ArrayList<String> lines = new ArrayList<String>();
        this.doInverseWishart((CommonParameter)elem, lines, true);
        return lines;
    }

    private List<String> doMultivariateNormalPriors(PharmMLRootType elem) {
        ArrayList<String> lines = new ArrayList<String>();
        this.doMultivariateNormal((CommonParameter)elem, lines, true);
        return lines;
    }

    private List<String> doMultivariateStudentTPriors(PharmMLRootType elem) {
        ArrayList<String> lines = new ArrayList<String>();
        this.doMultivariateTStudent((CommonParameter)elem, lines, true);
        return lines;
    }

    private List<String> doInverseGammaPriors(PharmMLRootType elem) {
        String alphaPriorValue;
        String tmpId = "_IGamma";
        ArrayList<String> lines = new ArrayList<String>();
        String formatDist = "%s %s %s(%s,%s)";
        PopulationParameter popPar = (PopulationParameter)elem;
        String newSym = popPar.getSymbId() + tmpId;
        ProbOnto value = (ProbOnto)Util.getDistribution(elem);
        String parShape = this.parse(value.getParameter(ParameterName.SHAPE), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.SHAPE)));
        String parScale = this.parse(value.getParameter(ParameterName.SCALE), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.SCALE)));
        String shapeId = Util.getSymbId(elem) + "_shape";
        String rateId = Util.getSymbId(elem) + "_rate";
        String scaleId = Util.getSymbId(elem) + "_scale";
        lines.add(String.format(formatDist, newSym, dist_symb, this.getDistName(this.getProbOntoDistributionType(elem)), shapeId, rateId));
        Rhs a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parShape)));
        if (a != null) {
            alphaPriorValue = String.format("%s %s %s", shapeId, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a)));
            this.priorList.add(parShape);
            lines.add(alphaPriorValue);
        }
        if ((a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parScale)))) != null) {
            alphaPriorValue = String.format("%s %s %s", scaleId, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a)));
            this.priorList.add(parScale);
            lines.add(alphaPriorValue);
        }
        lines.add(String.format("%s %s 1/%s", rateId, assignSymbol, scaleId));
        lines.add(String.format("%s %s 1/%s", Util.getSymbId(elem), assignSymbol, newSym));
        return lines;
    }

    private List<String> doUniformPriors(PharmMLRootType elem) {
        String maxPriorValue;
        String minPriorValue;
        ArrayList<String> lines = new ArrayList<String>();
        String formatDist = "%s %s %s(%s,%s)";
        String formatPar2 = "%s %s %s";
        ProbOnto value = (ProbOnto)Util.getDistribution(elem);
        List listP = value.getListOfParameter();
        String parMinimum = this.parse(value.getParameter(ParameterName.MINIMUM), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.MINIMUM)));
        String parMaximum = this.parse(value.getParameter(ParameterName.MAXIMUM), this.lexer.getTreeMaker().newInstance((Object)value.getParameter(ParameterName.MAXIMUM)));
        String maxId = Util.getSymbId(elem) + "_max";
        String minId = Util.getSymbId(elem) + "_min";
        lines.add(String.format(formatDist, Util.getSymbId(elem), dist_symb, this.getDistName(this.getProbOntoDistributionType(elem)), minId, maxId));
        Rhs a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parMinimum)));
        if (a != null) {
            minPriorValue = String.format("%s %s %s", minId, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a)));
            this.priorList.add(parMinimum);
            lines.add(minPriorValue);
        } else {
            minPriorValue = String.format("%s %s %s", minId, assignSymbol, parMinimum);
            lines.add(minPriorValue);
        }
        a = Util.getPriorValue(this.lexer.getAccessor().fetchElement(Util.clean(parMaximum)));
        if (a != null) {
            maxPriorValue = String.format("%s %s %s", maxId, assignSymbol, this.parse(a, this.lexer.getTreeMaker().newInstance((Object)a)));
            this.priorList.add(parMaximum);
            lines.add(maxPriorValue);
        } else {
            maxPriorValue = String.format("%s %s %s", maxId, assignSymbol, parMaximum);
            lines.add(maxPriorValue);
        }
        return lines;
    }

    private List<OperationProperty> getOperation(String type) {
        ModellingSteps steps = this.lexer.getDom().getModellingSteps();
        List operation = ((Estimation)((JAXBElement)steps.getCommonModellingStep().get(0)).getValue()).getOperation();
        for (EstimationOperation op : operation) {
            if (!op.getOpType().equals("BUGS")) continue;
            return op.getProperty();
        }
        return null;
    }

    void removeNotUsedFromDataFile() throws FileNotFoundException, IOException {
        String dataFileName = jobDir + "/" + "data_BUGS.txt";
        BufferedReader in = new BufferedReader(new FileReader(new File(dataFileName)));
        List ext = ((ExternalDataSet)this.lexer.getScriptDefinition().getTrialDesignBlock().getModel().getListOfExternalDataSet().get(0)).getListOfColumnMappingOrColumnTransformationOrMultipleDVMapping();
        List pi = null;
        for (PharmMLRootType el : ext) {
            ColumnMapping cm;
            if (el instanceof ColumnMapping) {
                cm = (ColumnMapping)el;
                if (!cm.getColumnRef().getColumnIdRef().equals("AMT")) continue;
                this.doseTargetMap.put(cm.getColumnRef().getColumnIdRef(), cm.getPiecewise().getListOfPiece());
                pi = cm.getPiecewise().getListOfPiece();
                continue;
            }
            if (!(el instanceof MultipleDVMapping) || !(cm = (MultipleDVMapping)el).getColumnRef().getColumnIdRef().equals("AMT")) continue;
            this.doseTargetMap.put(cm.getColumnRef().getColumnIdRef(), cm.getPiecewise().getListOfPiece());
            pi = cm.getPiecewise().getListOfPiece();
        }
        if (pi == null) {
            return;
        }
        this.outDebug.println("-- Dose mapping --");
        for (Piece p : pi) {
            String id = ((SymbolRef)p.getValue()).getSymbIdRef();
            String number = this.getCmtFromCondition(p.getCondition());
            this.cmtMap.put(number, id);
            this.outDebug.println(id + " - " + number);
            this.outDebug.println(this.getStateVarIndex(id) + 1 + " <-- " + number);
        }
        String dataFile = this.getStringFile(new BufferedReader(new FileReader(new File(dataFileName))));
        String remappedFile = this.remap(dataFile);
        this.output(remappedFile, new File(dataFileName), this.inPW);
    }

    private static String extractCovName(String in) {
        return in.substring(in.lastIndexOf(",") + 1).trim();
    }

    protected String loadVarNamesFromDataFile(String dataFile, Map<Integer, String> names) {
        int k = 0;
        String[] tokens = dataFile.split("=");
        names.put(k++, tokens[0].substring(tokens[0].lastIndexOf("(") + 1).trim());
        for (int i = 1; i < tokens.length - 1; ++i) {
            String piece = new String(Parser.extractCovName(tokens[i].trim()));
            if (piece.startsWith("stru") || piece.startsWith(".Dim")) continue;
            names.put(k++, piece);
        }
        return tokens[0].substring(0, tokens[0].indexOf(names.get(0)));
    }

    protected void loadVarsFromDataFile(Map<String, String> varsOfDataFile, Map<Integer, String> names, String tmp) {
        for (String n : names.values()) {
            varsOfDataFile.put(n, Util.getDataFromDataFile(tmp, n));
        }
    }

    protected String loadDataFile(String dataFileName, Map<String, String> varsOfDataFile, Map<Integer, String> names) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(new File(dataFileName)));
        String tmp = this.getStringFile(in);
        String firstPiece = this.loadVarNamesFromDataFile(tmp, names);
        this.loadVarsFromDataFile(varsOfDataFile, names, tmp);
        return firstPiece;
    }

    public int removeNotUsedCovariatesFromDataFile(boolean writeDataFile) throws FileNotFoundException, IOException {
        String dataFileName = jobDir + "/" + "data_BUGS.txt";
        String firstPiece = "";
        TreeMap<Integer, String> names = new TreeMap<Integer, String>();
        TreeMap<String, String> varsOfDataFile = new TreeMap<String, String>();
        firstPiece = this.loadDataFile(dataFileName, varsOfDataFile, names);
        int actualNum1 = this.cleanDataFile(names, varsOfDataFile, firstPiece, dataFileName, writeDataFile);
        return actualNum1;
    }

    private int get_max_m_num(String v, Map<String, String> varsOfDataFile) {
        int num = 0;
        if (varsOfDataFile.get(this.maxNamePrefix + v) != null) {
            num = Integer.parseInt(varsOfDataFile.get(this.maxNamePrefix + v));
        }
        return num;
    }

    private int cleanDataFile(Map<Integer, String> names, Map<String, String> varsOfDataFile, String firstPiece, String dataFileName, boolean writeFile) throws FileNotFoundException {
        this.outDebug.println("-- Data File cleaning --");
        int nCont = 0;
        int nCat = 0;
        int oldCont = 0;
        int oldCat = 0;
        int numToDecrease = 0;
        int tmp = 0;
        int ncov = this.lexer.getCovariates().size();
        for (CovariateDefinition var : this.lexer.getCovariates()) {
            tmp += 2 * this.get_max_m_num(var.getSymbId(), varsOfDataFile);
        }
        if (varsOfDataFile.get(this.nCovCatName) != null) {
            oldCat = nCat = Integer.parseInt(varsOfDataFile.get(this.nCovCatName));
        }
        if (varsOfDataFile.get(this.nCovContName) != null) {
            oldCont = nCont = Integer.parseInt(varsOfDataFile.get(this.nCovContName));
        }
        int actualNum1 = 1 * (oldCont > 0 ? 1 : 0) + 1 * (oldCat > 0 ? 1 : 0) + 2 * ncov + tmp;
        List<String> toRemoveNames = this.getToRemoveCovariatesNames();
        for (String v : toRemoveNames) {
            if (((CovariateDefinition)this.lexer.getAccessor().fetchElement(v)).getCategorical() != null) {
                --nCat;
            } else if (((CovariateDefinition)this.lexer.getAccessor().fetchElement(v)).getContinuous() != null) {
                --nCont;
            }
            numToDecrease += 2 + 2 * this.get_max_m_num(v, varsOfDataFile);
        }
        if (oldCat > 0 && nCat <= 0) {
            ++numToDecrease;
        }
        if (oldCont > 0 && nCont <= 0) {
            ++numToDecrease;
        }
        actualNum1 -= numToDecrease;
        if (numToDecrease == 0) {
            this.outDebug.println("No data removed");
        }
        if (!writeFile) {
            return actualNum1;
        }
        HashMap<String, String> varsToWrite = new HashMap<String, String>();
        for (Map.Entry<String, String> var : varsOfDataFile.entrySet()) {
            if (!this.dataToRemove.contains(var.getKey())) {
                varsToWrite.put(var.getKey(), var.getValue());
                continue;
            }
            this.outDebug.println("WARNING: variable " + var.getKey() + " removed");
        }
        if (nCont <= 0 && varsToWrite.remove(this.nCovContName) != null) {
            this.outDebug.println("WARNING: variable " + this.nCovContName + " removed");
        } else if (oldCont != nCont) {
            varsToWrite.put(this.nCovContName, "" + nCont);
            this.outDebug.println("WARNING: variable " + this.nCovContName + " updated");
        }
        if (nCat <= 0 && varsToWrite.remove(this.nCovCatName) != null) {
            this.outDebug.println("WARNING: variable " + this.nCovCatName + " removed");
        } else if (oldCat != nCat) {
            varsToWrite.put(this.nCovCatName, "" + nCat);
            this.outDebug.println("WARNING: variable " + this.nCovCatName + " updated");
        }
        StringBuffer sb = new StringBuffer(firstPiece);
        for (Map.Entry<Integer, String> name : names.entrySet()) {
            if (varsToWrite.get(name.getValue()) == null) continue;
            String id = name.getValue();
            String data = (String)varsToWrite.get(id);
            sb.append(id).append(" = ").append(data).append(", ");
        }
        String out = sb.substring(0, sb.length() - 2).toString() + ")";
        if (writeFile) {
            PrintStream outF = new PrintStream(new File(dataFileName));
            outF.println(out);
            outF.close();
        }
        return actualNum1;
    }

    public List<String> getToRemoveCovariatesNames() {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> covariates = new ArrayList<String>();
        for (CovariateDefinition cov : this.lexer.getCovariates()) {
            covariates.add(cov.getSymbId());
        }
        ArrayList<String> pwVars = new ArrayList<String>();
        for (Map.Entry<String, Map<Integer, String>> pw : this.piecewiseVarToPascal.entrySet()) {
            pwVars.addAll(pw.getValue().values());
        }
        pwVars.addAll(this.covToNotRemove);
        for (String id : covariates) {
            if (Util.getList(this.usedOdeCatCovNames).contains(id) || Util.getList(this.usedOdeContCovNames).contains(id) || pwVars.contains(id)) continue;
            list.add(id);
        }
        return list;
    }

    public List<String> toRemoveCovariates() {
        List<String> list = this.getToRemoveCovariatesNames();
        for (String var : list) {
            for (String v : this.dataCovKeywords) {
                this.dataToRemove.add(v + var);
            }
            this.dataToRemove.add(var);
        }
        if (this.dataToRemove.isEmpty()) {
            this.outDebug.println("No data to remove from data file");
        }
        return list;
    }

    protected void adjustDataFile() throws FileNotFoundException, IOException {
        String dataFileName = jobDir + "/" + "data_BUGS.txt";
        BufferedReader in = new BufferedReader(new FileReader(new File(dataFileName)));
        List ext = ((ExternalDataSet)this.lexer.getScriptDefinition().getTrialDesignBlock().getModel().getListOfExternalDataSet().get(0)).getListOfColumnMappingOrColumnTransformationOrMultipleDVMapping();
        List pi = null;
        for (PharmMLRootType el : ext) {
            ColumnMapping cm;
            if (el instanceof ColumnMapping) {
                cm = (ColumnMapping)el;
                if (!cm.getColumnRef().getColumnIdRef().equals("AMT")) continue;
                this.doseTargetMap.put(cm.getColumnRef().getColumnIdRef(), cm.getPiecewise().getListOfPiece());
                pi = cm.getPiecewise().getListOfPiece();
                continue;
            }
            if (!(el instanceof MultipleDVMapping) || !(cm = (MultipleDVMapping)el).getColumnRef().getColumnIdRef().equals("AMT")) continue;
            this.doseTargetMap.put(cm.getColumnRef().getColumnIdRef(), cm.getPiecewise().getListOfPiece());
            pi = cm.getPiecewise().getListOfPiece();
        }
        if (pi == null) {
            return;
        }
        this.outDebug.println("-- Dose mapping --");
        for (Piece p : pi) {
            String id = ((SymbolRef)p.getValue()).getSymbIdRef();
            String number = this.getCmtFromCondition(p.getCondition());
            this.cmtMap.put(number, id);
            this.outDebug.println(id + " - " + number);
            this.outDebug.println(this.getStateVarIndex(id) + 1 + " <-- " + number);
        }
        String dataFile = this.getStringFile(new BufferedReader(new FileReader(new File(dataFileName))));
        String remappedFile = this.remap(dataFile);
        this.output(remappedFile, new File(dataFileName), this.inPW);
    }

    private String remap(String data) {
        String start = "cmt = structure(.Data = c(";
        int pos = data.indexOf(start);
        if (pos == -1) {
            throw new RuntimeException("Data file does not contain CMT values.");
        }
        String toRemap = data.substring(pos + start.length(), pos + data.substring(pos).indexOf(")"));
        String[] vals = toRemap.split(",");
        if (this.cmtMap.entrySet().size() == 1) {
            String id = this.cmtMap.values().iterator().next();
            vals = this.putVal(vals, "" + (this.getStateVarIndex(id) + 1));
        } else {
            for (Map.Entry<String, String> e : this.cmtMap.entrySet()) {
                String newV = "" + (this.getStateVarIndex(e.getValue()) + 1);
                vals = this.remap(vals, e.getKey(), newV);
            }
        }
        String first = data.substring(0, pos + start.length());
        String last = data.substring(pos + start.length() + toRemap.length());
        this.outDebug.println("toRemap = " + toRemap);
        String middle = Util.createList(vals, ", ");
        this.outDebug.println("mapped = " + middle);
        return first + middle + last;
    }

    private String[] putVal(String[] vet, String newV) {
        String[] newVals = new String[vet.length];
        int num = 0;
        for (int i = 0; i < vet.length; ++i) {
            newVals[i] = new String(newV.trim());
            ++num;
        }
        this.outDebug.println(num + " substitution");
        return newVals;
    }

    private String[] remap(String[] vet, String oldV, String newV) {
        String[] newVals = new String[vet.length];
        for (int i = 0; i < vet.length; ++i) {
            newVals[i] = new String(vet[i]);
        }
        System.out.println(oldV + " --> " + newV);
        int num = 0;
        for (int i = 0; i < vet.length; ++i) {
            if (vet[i].trim().equals(oldV.trim())) {
                newVals[i] = new String(newV.trim());
                ++num;
                continue;
            }
            newVals[i] = vet[i].trim();
        }
        this.outDebug.println(num + " substitution");
        return newVals;
    }

    private String getCmtFromCondition(Condition condition) {
        if (condition.getLogicBinop() != null) {
            return this.getCondValue(condition.getLogicBinop().getContent());
        }
        return null;
    }

    private String getCondValue(List<JAXBElement<?>> vv) {
        for (JAXBElement<?> v : vv) {
            if (v.getValue() != null && v.getValue() instanceof LogicBinOp) {
                return this.getCondValue(((LogicBinOp)v.getValue()).getContent());
            }
            if (v.getValue() != null && v.getValue() instanceof ColumnReference) {
                if (!((ColumnReference)v.getValue()).getColumnIdRef().equals("CMT")) continue;
                continue;
            }
            if (v.getValue() == null || !(v.getValue() instanceof IntValue)) continue;
            return ((IntValue)v.getValue()).asString();
        }
        return null;
    }

    public String getDefaultPiecewiseAssignmentValue(Object o, Object o1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String indent(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        listIndexes = new String[2];
        upperSuffixDerDepLabel = suffixDerDepLabel.toUpperCase();
        upperStateLabel = stateLabel.toUpperCase();
    }
}

