/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs;

import crx.converter.tree.Node;
import eu.ddmore.converters.unipv.winbugs.PascalParser;
import eu.ddmore.converters.unipv.winbugs.Util;
import eu.ddmore.libpharmml.dom.commontypes.DerivativeVariable;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.commontypes.VariableDefinition;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateDefinition;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateTransformation;
import eu.ddmore.libpharmml.dom.modeldefn.IndividualParameter;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomVariable;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class PascalParser1
extends PascalParser {
    protected static final String templateFile = "PascalTemplate.txt";
    protected static final String templateCovFile = "PascalTemplateCov.txt";
    protected String pascalDiffEq = new String();
    private final String ODECALLNAME = "function.model.wbdev";

    public PascalParser1() throws IOException {
        this.odeCallName = "function.model.wbdev";
    }

    protected String pascalThetaAssignement() {
        StringBuilder sb = new StringBuilder();
        int ind = this.indPAS0;
        String format = "%s %s %s%s%s%s;\n\t\t";
        String formatCov = "%s %s %s%slastindex+%s%s;\n\t\t";
        for (SymbolRef s : this.theta_Parameters) {
            if (this.isIndependentVariableSym(s.getSymbIdRef())) continue;
            if (this.hasCovariate) {
                sb.append(String.format(formatCov, s.getSymbIdRef(), this.pascalAssignSymbol, this.parName, this.leftArrayBracket, ind++, this.rightArrayBracket));
                continue;
            }
            sb.append(String.format(format, s.getSymbIdRef(), this.pascalAssignSymbol, this.parName, this.leftArrayBracket, ind++, this.rightArrayBracket));
        }
        return sb.toString();
    }

    protected String pascalCovAssignEqLines() {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        int ind = this.indPAS0;
        String format = "%s %s %s%s%s%s;\n\t\t";
        List<Object> names = new ArrayList();
        if (this.usedOdeContCovNames.size() > 0) {
            names = Util.getNames(this.usedOdeContCovNames);
            for (String string : names) {
                sb.append(String.format(format, string, this.pascalAssignSymbol, this.parContCovName, this.leftArrayBracket, ind++, this.rightArrayBracket));
            }
        }
        ind = this.indPAS0;
        if (this.usedOdeCatCovNames.size() > 0) {
            names = Util.getNames(this.usedOdeCatCovNames);
            for (String string : names) {
                sb.append(String.format(format, string, this.pascalAssignSymbol, this.parCatCovName, this.leftArrayBracket, ind++, this.rightArrayBracket));
                if (this.covCatMap.get(string) == null) continue;
                sb1.append((String)this.covBlockMap.get(string));
            }
        }
        return sb.toString() + sb1.toString();
    }

    protected String getCovBlocks() {
        StringBuilder sb = new StringBuilder();
        for (String id : Util.getList(this.usedOdeCatCovNames)) {
            if (this.covCatMap.get(id) == null) continue;
            sb.append(Util.clean((String)this.covBlockMap.get(id)));
        }
        return sb.toString();
    }

    protected List<String> winbugsOdeParAssignement() {
        ArrayList<String> lines = new ArrayList<String>();
        int ind = this.indWB0;
        boolean isIndividual = false;
        isIndividual = this.checkIndiv();
        for (SymbolRef s : this.theta_Parameters) {
            String format;
            String symbol = this.getSymbol(s);
            int indice = ind++;
            if (!isIndividual || this.isDosingTime(symbol)) {
                format = "%s%s%s%s %s %s";
                lines.add(String.format(format, this.parName, this.leftArrayBracket, indice, this.rightArrayBracket, "<-", symbol));
                continue;
            }
            format = "%s%s%s,%s%s %s %s%s";
            lines.add(String.format(format, this.parName, this.leftArrayBracket, "ind_subj", indice, this.rightArrayBracket, "<-", symbol, ""));
        }
        return lines;
    }

    protected List<String> winbugsOdeCovParAssignement() {
        ArrayList<String> lines = new ArrayList<String>();
        int ind = this.indWB0;
        List<Object> names = new ArrayList();
        names = Util.getNames(this.usedOdeContCovNames);
        int startIndex = 1 + 2 * this.getNoTransfCovContNumber();
        lines.add(String.format("%s[%s,1] %s n_cov_cont\n", this.parName, "ind_subj", "<-"));
        ++ind;
        String thetaFormat = "%s[%s,%s] %s %s%s\n";
        for (String string : names) {
            lines.add(String.format(thetaFormat, this.parName, "ind_subj", ind++, "<-", this.maxNamePrefix, string));
        }
        thetaFormat = "%s[%s,%s] %s %s%s[%s]\n";
        for (String string : names) {
            lines.add(String.format(thetaFormat, this.parName, "ind_subj", ind++, "<-", this.NtNamePrefix, string, "ind_subj"));
        }
        thetaFormat = "\t%s%s%s,%s%s %s %s%s%s%s,i%s\n";
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder block = new StringBuilder();
        String s0 = "i+" + startIndex;
        for (String string : names) {
            String maxN = this.maxNamePrefix + string;
            block.append(String.format("for (i in 1 : %s){ \n", maxN));
            block.append(String.format(thetaFormat, this.parName, this.leftArrayBracket, "ind_subj", s0, this.rightArrayBracket, "<-", this.gridPrefix, string, this.leftArrayBracket, "ind_subj", this.rightArrayBracket));
            String s1 = s0 + "+" + maxN;
            block.append("}\n");
            ++ind;
            block.append(String.format("for (i in 1 : %s){ \n", maxN));
            block.append(String.format(thetaFormat, this.parName, this.leftArrayBracket, "ind_subj", s1, this.rightArrayBracket, "<-", string, "", this.leftArrayBracket, "ind_subj", this.rightArrayBracket));
            block.append("}\n\n");
            s0 = s0 + "+2*" + maxN;
            ++ind;
        }
        s0 = s0.substring(2);
        lines.add(block.toString());
        boolean isIndividual = this.isodeParIndividual() || this.lexer.getCovariateBlocks().size() > 0;
        int indice = 1;
        for (SymbolRef s : this.theta_Parameters) {
            String symbol = this.getSymbol(s);
            if (!isIndividual) {
                String string = "\t%s%s%s+%s%s %s %s\n";
                lines.add(String.format(string, this.parName, this.leftArrayBracket, s0, ++indice, this.rightArrayBracket, "<-", symbol));
                continue;
            }
            String string = "\t%s%s%s,%s+%s%s %s %s\n";
            lines.add(String.format(string, this.parName, this.leftArrayBracket, "ind_subj", s0, ++indice, this.rightArrayBracket, "<-", symbol));
        }
        return Util.getUniqueString(lines);
    }

    @Override
    protected String pascalParametersDeclaration() {
        List<String> lines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String format = "%s: REAL;\n\t\t";
        for (Map.Entry es : this.parVariablesFromMap.entrySet()) {
            String s = (String)es.getKey();
            if (!PascalParser1.isInList(Util.getList(this.odeParameters1), s) || PascalParser1.isInList(Util.getList(this.theta_Parameters), s)) continue;
            if (this.isPiecewiseVar(s)) {
                lines.add(String.format(format, this.piecewiseSuffix + "_" + s));
                continue;
            }
            lines.add(String.format(format, s + upperSuffixDerDepLabel));
        }
        for (SymbolRef s1 : this.leafOdeParameters) {
            if (!PascalParser1.isIn(s1, this.theta_Parameters) && !this.isCovariate(s1)) {
                if (!this.isPiecewiseVar(s1.getSymbIdRef())) {
                    lines.add(String.format(format, this.doAppendSuffix(s1)));
                    continue;
                }
                lines.add(String.format(format, this.piecewiseSuffix + "_" + s1.getSymbIdRef()));
                continue;
            }
            if (this.isIndependentVariableSym(s1.getSymbIdRef()) && this.hasDiffEquations) continue;
            lines.add(String.format(format, s1.getSymbIdRef()));
            if (this.covCatMap.get(s1.getSymbIdRef()) == null) continue;
            lines.add(String.format(format, this.covCatMap.get(s1.getSymbIdRef())));
        }
        for (SymbolRef cv : this.usedOdeCatCovNames) {
            lines.add(String.format(format, "piece_" + cv.getSymbIdRef()));
            lines.add(String.format(format, cv.getSymbIdRef()));
        }
        for (SymbolRef cv : this.usedOdeContCovNames) {
            lines.add(String.format(format, cv.getSymbIdRef()));
        }
        lines = Util.getUniqueString(lines);
        for (String s0 : lines) {
            sb.append(s0);
        }
        return sb.toString();
    }

    @Override
    protected void pascalEquation(Object context, Node leaf) {
        String id = null;
        String stmt = this.pascalVariableEquation(context, leaf);
        if (context instanceof DerivativeVariable) {
            this.pascalDiffEqLines.add(this.pascalDiffEquation(context, leaf));
        } else if (context instanceof VariableDefinition) {
            id = ((VariableDefinition)context).getSymbId();
            if (this.toBeInPascal(context, id)) {
                this.pascalAssignVarEqLines.put(id, stmt);
            }
            if (this.toBeInFuncPW(context, id)) {
                this.pascalAssignVarEqLines.put(id, stmt);
            }
        } else if (context instanceof IndividualParameter || context instanceof PopulationParameter) {
            if (context instanceof IndividualParameter) {
                id = ((IndividualParameter)context).getSymbId();
            } else if (context instanceof PopulationParameter) {
                id = ((PopulationParameter)context).getSymbId();
            }
            if (this.toBeInPascal(context, id)) {
                this.pascalAssignVarEqLines.put(id, stmt);
            }
            if (this.toBeInFuncPW(context, id)) {
                this.pascalAssignVarEqLines.put(id, stmt);
            }
        } else if (context instanceof CovariateTransformation) {
            id = ((CovariateTransformation)context).getTransformedCovariate().getSymbId();
            if (this.toBeInPascal(context, id)) {
                this.pascalAssignVarEqLines.put(id, stmt);
            }
            if (this.toBeInFuncPW(context, id)) {
                this.pascalAssignVarEqLines.put(id, stmt);
            }
        }
    }

    @Override
    protected void pascalPiecewiseEquation(Object context, Node leaf) {
        String id = null;
        String stmt = null;
        stmt = this.pascalVariableEquation(context, leaf);
        if (context instanceof VariableDefinition) {
            VariableDefinition v = (VariableDefinition)context;
            if (v.getAssign() != null && v.getAssign().getPiecewise() != null) {
                return;
            }
            id = ((VariableDefinition)context).getSymbId();
            if (this.isInList(context, this.piecewiseParameters) && this.parVariablesFromMap.containsKey(id)) {
                this.pascalAssignVarEqLines.put(id, stmt);
            }
        } else if (context instanceof PopulationParameter) {
            id = ((PopulationParameter)context).getSymbId();
        } else if (context instanceof IndividualParameter) {
            id = ((IndividualParameter)context).getSymbId();
        }
        if (this.piecewiseCompleteList.size() > 0 && !PascalParser1.isInList(this.piecewiseVariablesId, id) && stmt != null && (context instanceof IndividualParameter && !this.isPiecewiseVar(((IndividualParameter)context).getSymbId()) || context instanceof PopulationParameter && !this.isPiecewiseVar(((PopulationParameter)context).getSymbId())) && this.isInList(context, this.leafOdeParameters) && !this.isInList(context, this.theta_Parameters) && !this.isPiecewiseVar(id)) {
            this.pascalAssignIndivEqLines.put(id, stmt);
        }
    }

    @Override
    protected List<String> winbugsPascalOdeCallGen() throws FileNotFoundException, IOException {
        ArrayList<String> lines = new ArrayList<String>();
        int derivativeNumber = this.completeStateVariablesList.size();
        String NT_loop = "N_t";
        if (this.n_loops == 2) {
            NT_loop = this.NT_INDIV;
        }
        if (this.checkIndiv() || this.hasCovariate) {
            if (this.odeInitialValueSubjDep) {
                String odeFormat = "%s[%s,1:%s, 1:%s]<- " + this.odeCallName + this.modelNum + "(%s[%s,1:%s], %s[%s,1:%s], %s[%s,],%s, %s)\n";
                this.pascalOdeCall = String.format(odeFormat, "der99wb_unipv", "ind_subj", NT_loop, derivativeNumber + "", "initial_value", "ind_subj", derivativeNumber + "", "grid", "ind_subj", NT_loop, this.parName, "ind_subj", "origin", "0.001");
            } else {
                String odeFormat = "%s[%s,1:%s, 1:%s]<- " + this.odeCallName + this.modelNum + "(%s[1:%s], %s[%s,1:%s], %s[%s,],%s, %s)\n";
                this.pascalOdeCall = String.format(odeFormat, "der99wb_unipv", "ind_subj", NT_loop, derivativeNumber + "", "initial_value", derivativeNumber + "", "grid", "ind_subj", NT_loop, this.parName, "ind_subj", "origin", "0.001");
            }
        } else if (this.odeInitialValueSubjDep) {
            String odeFormat = "%s[%s,1:%s, 1:%s]<- " + this.odeCallName + this.modelNum + "(%s[%s,1:%s], %s[%s,1:%s], %s[],%s, %s)\n";
            this.pascalOdeCall = String.format(odeFormat, "der99wb_unipv", "ind_subj", NT_loop, derivativeNumber + "", "initial_value", "ind_subj", derivativeNumber + "", "grid", "ind_subj", NT_loop, this.parName, "origin", "0.001");
        } else {
            String odeFormat = "%s[%s,1:%s, 1:%s]<- " + this.odeCallName + this.modelNum + "(%s[1:%s], %s[%s,1:%s], %s[],%s, %s)\n";
            this.pascalOdeCall = String.format(odeFormat, "der99wb_unipv", "ind_subj", NT_loop, derivativeNumber + "", "initial_value", derivativeNumber + "", "grid", "ind_subj", NT_loop, this.parName, "origin", "0.001");
        }
        lines.add(this.pascalOdeCall);
        if (this.hasDiffEquations) {
            lines.addAll(this.pascalCodeFileGeneration());
        }
        return lines;
    }

    protected int getNoTransfCovContNumber() {
        List covs = this.lexer.getCovariates();
        int n_cont = 0;
        for (CovariateDefinition cov : covs) {
            if (cov.getContinuous() == null || !cov.getContinuous().getListOfTransformation().isEmpty()) continue;
            ++n_cont;
        }
        return n_cont;
    }

    protected int getCovCatNumber() {
        List covs = this.lexer.getCovariates();
        int n_cat = 0;
        for (CovariateDefinition cov : covs) {
            if (cov.getCategorical() == null || cov.getCategorical().getListOfCategory().size() <= 1) continue;
            ++n_cat;
        }
        return n_cat;
    }

    @Override
    protected List<String> pascalCodeFileGeneration() throws FileNotFoundException, IOException {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<String> varLines = new ArrayList<String>();
        String format = "%s " + this.pascalAssignSymbol + " %s;\n";
        String formatTr = "%s(%s)";
        String modelName = this.getModelName();
        this.updateUniopMap();
        String pascalParamDeclLines = Util.clean(this.pascalParametersDeclaration());
        String pascalParamAssignLines = Util.clean(this.pascalThetaAssignement());
        this.pascalAssignIndivEq = Util.clean(this.concat(this.pascalAssignIndivEqLines, "\t\t"));
        this.pascalAssignVarEq = Util.clean(this.concat(this.pascalAssignVarEqLines, "\t\t"));
        this.pascalIndivEq = Util.clean(this.concat(Util.getUniqueString(this.pascalIndivLines), "\t\t"));
        String varLinesEq = Util.clean(this.concat(varLines, "\t\t"));
        String pascalCovAssignement = Util.clean(this.pascalCovAssignEqLines());
        this.pascalDiffEq = Util.clean(this.concat(this.pascalDiffEqLines, "\t\t")).trim();
        String nomeTemplate = this.hasCovariate ? templateCovFile : templateFile;
        format = this.getPascalTemplate(nomeTemplate);
        if (this.hasCovariate) {
            this.pascalBody = String.format(format, this.modelNum, this.derivativeSymbols.size(), this.parName, upperStateLabel, upperStateLabel, pascalParamDeclLines, this.getNoTransfCovContNumber(), pascalCovAssignement, pascalParamAssignLines, this.pascalAssignIndivEq + this.pascalAssignVarEq + this.pascalIndivEq + varLinesEq + this.pascalDiffEq, this.modelNum);
            lines.addAll(this.winbugsOdeCovParAssignement());
        } else {
            this.pascalBody = String.format(format, this.modelNum, this.derivativeSymbols.size(), this.parName, upperStateLabel, upperStateLabel, pascalParamDeclLines, pascalParamAssignLines, this.pascalAssignIndivEq.toString() + this.pascalAssignVarEq.toString() + this.pascalIndivEq + varLinesEq + this.pascalDiffEq, this.modelNum);
            lines.addAll(this.winbugsOdeParAssignement());
        }
        return lines;
    }

    protected String pascalDiffEquation(Object context, Node leaf) {
        String format = "%s " + this.pascalAssignSymbol + " %s;\n";
        String current_symbol = this.getSymbol((DerivativeVariable)context);
        this.derivativeSymbols.add(this.getDerivativeSymbol((DerivativeVariable)context));
        String tmp = new String(leaf.data.toString());
        String line = String.format(format, current_symbol, this.pascalNamesTransform(tmp));
        return line;
    }

    protected String pascalVariableEquation(Object context, Node leaf) {
        String format = "%s " + this.pascalAssignSymbol + " %s;\n";
        String current_symbol = "";
        current_symbol = this.getSymbol(context);
        current_symbol = this.pascalNamesTransform(current_symbol);
        String tmp = new String(leaf.data.toString());
        tmp = this.pascalNamesTransform(tmp);
        String line = String.format(format, current_symbol, tmp);
        return line;
    }

    public String getSymbol(VariableDefinition o) {
        String symbol = this.doDerivativeDependentVariable(o);
        return this.delimit(symbol);
    }

    public String getSymbol(DerivativeVariable o) {
        String symbol = this.doDerivative(o);
        return this.delimit(symbol);
    }

    public String getSymbol(ParameterRandomVariable o) {
        String symbol = this.doDerivativeRef(o.getSymbId());
        return this.delimit(symbol);
    }

    public String getSymbol(IndividualParameter o) {
        String symbol = this.doIndividualParameter(o);
        return this.delimit(symbol);
    }

    @Override
    protected String doDerivative(DerivativeVariable o) {
        String symbol = unassigned_symbol;
        String format = "";
        Integer idx = this.getStateVarIndex(o.getSymbId());
        format = "d" + upperStateLabel + "dt" + this.leftArrayBracket + "%s" + this.rightArrayBracket;
        symbol = String.format(format, idx);
        return symbol;
    }
}

