/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs;

import crx.converter.spi.blocks.StructuralBlock;
import crx.converter.tree.BinaryTree;
import crx.converter.tree.TreeMaker;
import eu.ddmore.converters.unipv.winbugs.PascalParser1;
import eu.ddmore.converters.unipv.winbugs.Util;
import eu.ddmore.libpharmml.dom.commontypes.DerivativeVariable;
import eu.ddmore.libpharmml.dom.commontypes.InitialCondition;
import eu.ddmore.libpharmml.dom.commontypes.StandardAssignable;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PascalParser2
extends PascalParser1 {
    protected static final String templateWBDev_Mod = "TemplatePascal_WBDev_Mod.txt";
    protected static final String templateRK45_Pmetrics_Mod = "TemplatePascal_RK45_Pmetrics_Mod.txt";
    protected static final String templateLSODA_Pmetrics_Mod = "TemplatePascal_LSODA_Pmetrics_Mod.txt";
    protected static final String templateLSODA_Pmetrics_Mod_Cov_CONT = "TemplatePascal_LSODA_Pmetrics_Mod_Cov_CONT.txt";
    protected static final String templateRK45_Pmetrics_Mod_Cov_CONT = "TemplatePascal_RK45_Pmetrics_Mod_Cov_CONT.txt";
    protected static final String templateLSODA_Pmetrics_Mod_Cov_CONT_CAT = "TemplatePascal_LSODA_Pmetrics_Mod_Cov_CONT_CAT.txt";
    protected static final String templateRK45_Pmetrics_Mod_Cov_CONT_CAT = "TemplatePascal_RK45_Pmetrics_Mod_Cov_CONT_CAT.txt";
    protected static final String templateLSODA_Pmetrics_Mod_Cov_CAT = "TemplatePascal_LSODA_Pmetrics_Mod_Cov_CAT.txt";
    protected static final String templateRK45_Pmetrics_Mod_Cov_CAT = "TemplatePascal_RK45_Pmetrics_Mod_Cov_CAT.txt";
    private String amtLabel = "amt";
    private String rateLabel = "rate";
    private String iiLabel = "ii";
    private String evidLabel = "evid";
    private String cmtLabel = "cmt";
    private String addlLabel = "addl";
    private String ssLabel = "ss";
    private int tot_covariate_size = 0;
    private final String ODECALLNAME = "function.model";

    public void setTot_covariate_size(int tot) {
        this.tot_covariate_size = tot;
    }

    public PascalParser2() throws IOException {
        this.odeCallName = "function.model";
    }

    @Override
    public void setPascalModFileName(File fileName) {
        this.pascalModFile = fileName;
    }

    public void setPascalPKmetricsFileName(File fileName) {
        this.pascalPMetricsFileName = fileName;
    }

    public void setOutputDirPascal2(String outputDirPascal2) {
        this.outputDirPascal2 = outputDirPascal2;
    }

    public void setOutputDirPascal2Mod(String outputDirPascal2Mod) {
        this.outputDirPascal2Mod = outputDirPascal2Mod;
    }

    boolean intersection(List<String> aa, List<String> bb) {
        for (String a : aa) {
            for (String b : bb) {
                if (!a.equals(b)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isIndepVarInList(List<SymbolRef> SymList) {
        for (SymbolRef s : SymList) {
            if (!this.isIndependentVariableSym(s.getSymbIdRef())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<String> pascalCodeFileGeneration() throws FileNotFoundException, IOException {
        String nomeTemplate;
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<String> varLines = new ArrayList<String>();
        String equation = "";
        String current_symbol = "";
        String operand = "";
        String format = "%s " + this.pascalAssignSymbol + " %s;";
        this.updateUniopMap();
        String modelName = this.getModelName();
        this.winbugsIndivLines = Util.cleanEmpty(this.winbugsIndivLines);
        for (String indivLine : this.winbugsIndivLines) {
            String eq;
            String pascal_equation;
            if (indivLine == null || indivLine.length() <= 0) continue;
            current_symbol = this.delimit(indivLine.substring(0, indivLine.indexOf("<-")).trim());
            operand = current_symbol.contains("probit") ? "probit" : (current_symbol.contains("logit") ? "logit" : (current_symbol.contains("log") ? "log" : ""));
            if (this.transfMap.containsKey(current_symbol)) {
                current_symbol = (String)this.transfMap.get(current_symbol);
            }
            equation = (String)this.unaryOperandEqMap.get(current_symbol);
            String symbol = Util.clean(this.removeIndexes(current_symbol)).trim();
            String pascal_symbol = this.delimit(Util.clean(this.removeIndexes(current_symbol)).trim() + upperSuffixDerDepLabel);
            String tmp = this.removeIndexes(indivLine.substring(indivLine.indexOf("<-") + "<-".length(), indivLine.length()));
            if (equation != null) {
                pascal_equation = operand.length() > 0 ? this.doInverseTransformation(operand, (String)this.pascalIndivMap.get(current_symbol)) : (String)this.pascalIndivMap.get(current_symbol);
                pascal_equation = this.removeIndexes(pascal_equation);
                if (!this.unaryOperandEqMap.containsKey(current_symbol)) {
                    varLines.add(String.format(format, current_symbol, tmp.trim()));
                }
                if (!PascalParser2.isInList(Util.getList(this.odeParameters), symbol)) continue;
                eq = String.format("%s " + this.pascalAssignSymbol + " %s;\n", pascal_symbol, pascal_equation);
                this.pascalIndivLines.add(eq);
                if (!PascalParser2.isInList(Util.getList(this.leafOdeParameters), symbol) || PascalParser2.isInList(Util.getList(this.theta_Parameters), symbol)) continue;
                this.pascalAssignIndivEqLinesMap.put(Util.clean(this.removeIndexes(current_symbol)), eq);
                continue;
            }
            pascal_equation = this.removeIndexes((String)this.pascalIndivMap.get(current_symbol));
            if (!PascalParser2.isInList(Util.getList(this.odeParameters), symbol)) continue;
            eq = String.format("%s " + this.pascalAssignSymbol + " %s;\n", pascal_symbol, pascal_equation.trim());
            this.pascalIndivLines.add(eq);
            this.pascalAssignIndivEqLinesMap.put(Util.clean(this.removeIndexes(current_symbol)), eq);
        }
        StringBuilder pwLines = new StringBuilder();
        HashMap<String, String> pwLinesMap = new HashMap<String, String>();
        StringBuilder[] pwSb = this.generateIFELSEBlocks();
        for (Map.Entry pw : this.piecewiseMap.entrySet()) {
            String sId = Util.clean(this.removeIndexes((String)pw.getKey()));
            if (!Util.getList(this.leafOdeParameters).contains(sId) && !Util.getList(this.odeParameters).contains(sId)) continue;
            Integer id = (Integer)this.piecewiseIndexMap.get(sId);
            int index = id;
            pwLines.append(this.cleanPascal("\n\t\t" + pwSb[index - 1]));
            pwLinesMap.put(sId, this.cleanPascal(pwSb[index - 1].toString()));
        }
        HashMap<String, String> completeVarAssignEq = new HashMap<String, String>();
        String pascalParamDeclLines = Util.clean(this.pascalParametersDeclaration());
        String pascalParamAssignLines = Util.clean(this.pascalThetaAssignement());
        String pascalICAssignLines = Util.clean(this.pascalICAssignement());
        completeVarAssignEq = new HashMap(this.pascalAssignIndivEqLines);
        completeVarAssignEq.putAll(this.pascalAssignVarEqLines);
        for (String line : this.pascalIndivLines) {
            completeVarAssignEq.put(Util.clean(line.substring(0, line.indexOf(this.pascalAssignSymbol))), line);
        }
        HashMap<String, String> eqLines = new HashMap<String, String>();
        for (Map.Entry line : completeVarAssignEq.entrySet()) {
            String val = (String)line.getValue();
            String tmp = Util.clean(val.substring(0, val.indexOf(this.pascalAssignSymbol)).trim());
            if (tmp.endsWith(upperSuffixDerDepLabel)) {
                tmp = tmp.substring(0, tmp.indexOf(upperSuffixDerDepLabel));
            }
            eqLines.put(Util.clean(tmp), val);
        }
        eqLines.putAll(pwLinesMap);
        completeVarAssignEq = new HashMap(eqLines);
        this.pascalAssignIndivEq = this.cleanPascal(this.concat(this.sortVarLines(eqLines, this.getSortedOde()), "\t\t"));
        this.pascalIndivEq = this.cleanPascal(this.concat(Util.getUniqueString(this.pascalIndivLines), "\t\t"));
        this.pascalAssignVarEq = this.cleanPascal(this.concat(this.sortVarLines(completeVarAssignEq, this.getSortedOde()), "\t\t"));
        String pascalStateVarAssign = this.cleanPascal(this.pascalVarAssignLines());
        this.pascalIndivEq = this.cleanPascal(this.concat(Util.getUniqueString(this.pascalIndivLines), "\t\t"));
        String varLinesEq = this.cleanPascal(this.concat(varLines, "\t\t"));
        String pascalCovAssignement = this.cleanPascal(this.pascalCovAssignEqLines());
        this.pascalDiffEq = this.cleanPascal(this.concat(this.pascalDiffEqLines, "\t\t")).trim();
        if (DEBUG) {
            this.outDebug.println("ODE solver: " + this.getOdeSolver());
        }
        switch (this.getOdeSolver()) {
            case "RK45": {
                if (this.usedOdeCatCovNames.size() > 0) {
                    if (this.usedOdeContCovNames.size() > 0) {
                        nomeTemplate = templateRK45_Pmetrics_Mod_Cov_CONT_CAT;
                        break;
                    }
                    nomeTemplate = templateRK45_Pmetrics_Mod_Cov_CAT;
                    break;
                }
                if (this.usedOdeContCovNames.size() > 0) {
                    nomeTemplate = templateRK45_Pmetrics_Mod_Cov_CONT;
                    break;
                }
                nomeTemplate = templateRK45_Pmetrics_Mod;
                break;
            }
            case "LSODA": {
                if (this.usedOdeCatCovNames.size() > 0) {
                    if (this.usedOdeContCovNames.size() > 0) {
                        nomeTemplate = templateLSODA_Pmetrics_Mod_Cov_CONT_CAT;
                        break;
                    }
                    nomeTemplate = templateLSODA_Pmetrics_Mod_Cov_CAT;
                    break;
                }
                if (this.usedOdeContCovNames.size() > 0) {
                    nomeTemplate = templateLSODA_Pmetrics_Mod_Cov_CONT;
                    break;
                }
                nomeTemplate = templateLSODA_Pmetrics_Mod;
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.getOdeSolver() + " not available");
            }
        }
        format = this.getPascalTemplate(nomeTemplate);
        String formatMod = this.getPascalTemplate(templateWBDev_Mod);
        int nTheta = this.theta_Parameters.size();
        if (this.isIndepVarInList(this.theta_Parameters)) {
            --nTheta;
        }
        int m_nParameter = Integer.parseInt(this.num1) + nTheta + 3 * this.derivativeSymbols.size();
        int m_F1Index = Integer.parseInt(this.num1) + nTheta + this.derivativeSymbols.size();
        int m_tlag1Index = Integer.parseInt(this.num1) + nTheta + 2 * this.derivativeSymbols.size();
        if (this.piecewiseMap.isEmpty()) {
            this.pascalBody = this.usedOdeCatCovNames.size() > 0 ? (this.usedOdeContCovNames.size() > 0 ? String.format(format, this.modelNum, this.derivativeSymbols.size(), this.parName, upperStateLabel, upperStateLabel, pascalParamDeclLines, this.usedOdeContCovNames.size(), this.usedOdeCatCovNames.size(), Util.genPVect(this.usedOdeContCovNames, this.parContCovName), Util.genPVect(this.usedOdeCatCovNames, this.parCatCovName), this.getCovBlocks(), pascalParamAssignLines + pascalICAssignLines + pascalStateVarAssign + this.pascalAssignIndivEq + varLinesEq + this.pascalDiffEq, m_nParameter, m_F1Index, m_tlag1Index, this.derivativeSymbols.size(), this.modelNum) : String.format(format, this.modelNum, this.derivativeSymbols.size(), this.parName, upperStateLabel, upperStateLabel, pascalParamDeclLines, this.usedOdeCatCovNames.size(), pascalCovAssignement, pascalParamAssignLines + pascalICAssignLines, pascalStateVarAssign + this.pascalAssignIndivEq + varLinesEq + this.pascalDiffEq, m_nParameter, m_F1Index, m_tlag1Index, this.derivativeSymbols.size(), this.modelNum)) : (this.usedOdeContCovNames.size() > 0 ? String.format(format, this.modelNum, this.derivativeSymbols.size(), this.parName, upperStateLabel, upperStateLabel, pascalParamDeclLines, this.usedOdeContCovNames.size(), pascalCovAssignement, pascalParamAssignLines + pascalICAssignLines, pascalStateVarAssign + this.pascalAssignIndivEq + varLinesEq + this.pascalDiffEq, m_nParameter, m_F1Index, m_tlag1Index, this.derivativeSymbols.size(), this.modelNum) : String.format(format, this.modelNum, this.derivativeSymbols.size(), this.parName, upperStateLabel, upperStateLabel, pascalParamDeclLines, pascalParamAssignLines + pascalICAssignLines, pascalStateVarAssign + this.pascalAssignIndivEq + varLinesEq + this.pascalDiffEq, m_nParameter, m_F1Index, m_tlag1Index, this.derivativeSymbols.size(), this.modelNum));
        } else {
            this.inPW = false;
            this.pascalBody = this.usedOdeCatCovNames.size() > 0 ? (this.usedOdeContCovNames.size() > 0 ? String.format(format, this.modelNum, this.derivativeSymbols.size(), this.parName, upperStateLabel, upperStateLabel, pascalParamDeclLines, this.usedOdeContCovNames.size(), this.usedOdeCatCovNames.size(), Util.genPVect(this.usedOdeContCovNames, this.parContCovName), Util.genPVect(this.usedOdeCatCovNames, this.parCatCovName), pascalParamAssignLines + pascalICAssignLines, pascalStateVarAssign + this.pascalAssignIndivEq + varLinesEq + this.pascalDiffEq, m_nParameter, m_F1Index, m_tlag1Index, this.derivativeSymbols.size(), this.modelNum) : String.format(format, this.modelNum, this.derivativeSymbols.size(), this.parName, upperStateLabel, upperStateLabel, pascalParamDeclLines, this.usedOdeCatCovNames.size(), pascalCovAssignement, pascalParamAssignLines + pascalICAssignLines, pascalStateVarAssign + this.pascalAssignIndivEq + varLinesEq + this.pascalDiffEq, m_nParameter, m_F1Index, m_tlag1Index, this.derivativeSymbols.size(), this.modelNum)) : (this.usedOdeContCovNames.size() > 0 ? String.format(format, this.modelNum, this.derivativeSymbols.size(), this.parName, upperStateLabel, upperStateLabel, pascalParamDeclLines, this.usedOdeContCovNames.size(), pascalCovAssignement, pascalParamAssignLines + pascalICAssignLines + pascalStateVarAssign + this.pascalAssignIndivEq + varLinesEq, this.pascalDiffEq, m_nParameter, m_F1Index, m_tlag1Index, this.derivativeSymbols.size(), this.modelNum) : String.format(format, this.modelNum, this.derivativeSymbols.size(), this.parName, upperStateLabel, upperStateLabel, pascalParamDeclLines, this.usedOdeContCovNames.size(), pascalCovAssignement, pascalParamAssignLines + pascalICAssignLines, pascalStateVarAssign + this.pascalAssignIndivEq + varLinesEq + this.pascalDiffEq, m_nParameter, m_F1Index, m_tlag1Index, this.derivativeSymbols.size(), this.modelNum));
        }
        lines.addAll(this.winbugsOdeParAssignement());
        this.pascalMod = String.format(formatMod, this.modelNum, "" + this.modelNum, "" + this.modelNum, this.modelNum);
        return lines;
    }

    @Override
    protected List<String> winbugsPascalOdeCallGen() throws FileNotFoundException, IOException {
        ArrayList<String> lines = new ArrayList<String>();
        int derivativeNumber = this.completeStateVariablesList.size();
        String NT_loop = "N_t";
        if (this.n_loops == 2) {
            NT_loop = this.NT_INDIV;
        }
        if (this.checkIndiv() || this.hasCovariate || this.odeInitialValueSubjDep) {
            String odeFormat = "%s[%s,1:%s, 1:%s]<- " + this.odeCallName + this.modelNum + "(%s[%s,1:%s], %s[%s,1:%s],  %s[%s,1:%s], %s[%s,1:%s], %s[%s,1:%s]," + " %s[%s,1:%s], %s[%s,1:%s], %s[%s,1:%s], %s[%s,])";
            this.pascalOdeCall = String.format(odeFormat, "der99wb_unipv", "ind_subj", NT_loop, derivativeNumber + "", "grid", "ind_subj", this.NT_INDIV + "", this.amtLabel, "ind_subj", this.NT_INDIV + "", this.rateLabel, "ind_subj", this.NT_INDIV + "", this.iiLabel, "ind_subj", this.NT_INDIV + "", this.evidLabel, "ind_subj", this.NT_INDIV + "", this.cmtLabel, "ind_subj", this.NT_INDIV + "", this.addlLabel, "ind_subj", this.NT_INDIV + "", this.ssLabel, "ind_subj", this.NT_INDIV + "", this.parName, "ind_subj");
        } else {
            String odeFormat = "%s[%s,1:%s, 1:%s]<- " + this.odeCallName + this.modelNum + "(%s[%s,1:%s], %s[%s,1:%s],  %s[%s,1:%s], %s[%s,1:%s], %s[%s,1:%s]," + " %s[%s,1:%s], %s[%s,1:%s], %s[%s,1:%s], %s[])";
            this.pascalOdeCall = String.format(odeFormat, "der99wb_unipv", "ind_subj", NT_loop, derivativeNumber + "", "grid", "ind_subj", this.NT_INDIV + "", this.amtLabel, "ind_subj", this.NT_INDIV + "", this.rateLabel, "ind_subj", this.NT_INDIV + "", this.iiLabel, "ind_subj", this.NT_INDIV + "", this.evidLabel, "ind_subj", this.NT_INDIV + "", this.cmtLabel, "ind_subj", this.NT_INDIV + "", this.addlLabel, "ind_subj", this.NT_INDIV + "", this.ssLabel, "ind_subj", this.NT_INDIV + "", this.parName);
        }
        lines.add(this.pascalOdeCall);
        if (this.hasDiffEquations) {
            lines.addAll(this.pascalCodeFileGeneration());
        }
        return lines;
    }

    private boolean checkInitValSubDep() {
        boolean flag = false;
        for (StructuralBlock sb : this.lexer.getStructuralBlocks()) {
            flag = flag || this.checkInitValSubDep(sb);
        }
        return flag;
    }

    private boolean checkInitValSubDep(StructuralBlock _sb) {
        for (int i = 0; i < _sb.getStateVariables().size(); ++i) {
            DerivativeVariable var = (DerivativeVariable)_sb.getStateVariables().get(i);
            this.lexer.setCurrentStructuralBlock(_sb);
            InitialCondition ic = var.getInitialCondition();
            StandardAssignable initV = ic.getInitialValue();
            String initialCondition = "0";
            TreeMaker tm = this.lexer.getTreeMaker();
            if (initV == null || initV.getAssign() == null) continue;
            if (initV.getAssign().getScalar() != null) {
                initialCondition = "" + initV.getAssign().getScalar().valueToString();
            } else if (initV.getAssign().getSymbRef() != null) {
                initialCondition = "" + this.doSymbolRef(initV.getAssign().getSymbRef());
            } else if (initV.getAssign() != null) {
                BinaryTree bt = tm.newInstance((Object)ic);
                initialCondition = this.parse(initV, bt);
            }
            if (!initialCondition.contains("ind_subj")) continue;
            this.odeInitialValueSubjDep = true;
            break;
        }
        return this.odeInitialValueSubjDep;
    }

    @Override
    protected List<String> winbugsOdeCovParAssignement() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(this.winbugsOdeParAssignement());
        return lines;
    }

    private String genIndexNames(String index, List<SymbolRef> odeCovNames, int start) {
        String covNames = index;
        String format = "%s%s%s,%s%s %s %s";
        int ind = start;
        ArrayList<String> lines = new ArrayList<String>();
        for (String id : Util.getNames(odeCovNames)) {
            covNames = covNames + "+2*" + this.maxNamePrefix + id;
            lines.add(String.format(format, this.parName, this.leftArrayBracket, "ind_subj", ind, this.rightArrayBracket, "<-", this.maxNamePrefix + id));
            ++ind;
        }
        return covNames;
    }

    private List<String> genCovSumList(List<SymbolRef> odeCovNames, Map<String, String> accessors, boolean categ) {
        String covNames;
        int ind;
        ArrayList<String> lines = new ArrayList<String>();
        if (!categ) {
            ind = Integer.parseInt(accessors.get("ind"));
            covNames = accessors.get("contNames");
        } else {
            ind = Integer.parseInt(accessors.get("ind"));
            covNames = accessors.get("catNames");
        }
        String format = "%s%s%s,%s%s %s %s";
        String index = "";
        if (this.usedOdeCatCovNames.size() > 0 || this.usedOdeContCovNames.size() > 0) {
            index = covNames.trim().length() > 0 ? covNames + "+" + ind : "" + ind;
            if (this.usedOdeContCovNames.size() > 0 && !categ) {
                lines.add(String.format(format, this.parName, this.leftArrayBracket, "ind_subj", index, this.rightArrayBracket, "<-", "n_cov_cont"));
            }
            if (this.usedOdeCatCovNames.size() > 0 && categ) {
                lines.add(String.format(format, this.parName, this.leftArrayBracket, "ind_subj", index, this.rightArrayBracket, "<-", "n_cov_cat"));
            }
            if (this.usedOdeContCovNames.size() > 0) {
                covNames = this.usedOdeCatCovNames.size() > 0 ? Util.genCompleteIndexNames(index, Util.merge(this.usedOdeContCovNames, this.usedOdeCatCovNames), this.maxNamePrefix) : this.genIndexNames(index, this.usedOdeContCovNames, ind);
            } else if (this.usedOdeCatCovNames.size() > 0) {
                covNames = Util.genCompleteIndexNames(index, this.usedOdeCatCovNames, this.maxNamePrefix);
            }
        }
        ++ind;
        if (!categ) {
            accessors.put("ind", ind + "");
            accessors.put("contNames", covNames);
        } else {
            accessors.put("ind", ind + "");
            accessors.put("catNames", covNames);
        }
        return lines;
    }

    private List<String> genCovAssign(List<SymbolRef> odeCovNames, Map<String, String> accessors, boolean categ, String prefix) {
        ArrayList<String> lines = new ArrayList<String>();
        String thetaFormat = prefix.equals(this.maxNamePrefix) ? this.parName + this.leftArrayBracket + "ind_subj" + ",%s" + this.rightArrayBracket + " " + "<-" + " %s" + "\n" : this.parName + this.leftArrayBracket + "ind_subj" + ",%s" + this.rightArrayBracket + " " + "<-" + " %s" + this.leftArrayBracket + "ind_subj" + this.rightArrayBracket + "\n";
        int ind = !categ ? Integer.parseInt(accessors.get("ind")) : Integer.parseInt(accessors.get("ind"));
        for (String id : Util.getNames(odeCovNames)) {
            lines.add(String.format(thetaFormat, ind, prefix + id));
            ++ind;
        }
        accessors.put("ind", ind + "");
        return lines;
    }

    private List<String> genThetaCovAssign(List<SymbolRef> thetaNames, Map<String, String> accessors, boolean categ) {
        ArrayList<String> lines = new ArrayList<String>();
        String s1 = "";
        String start = this.usedOdeContCovNames.size() > 0 && this.usedOdeCatCovNames.size() > 0 ? "" + (2 * this.usedOdeContCovNames.size() + 2 * this.usedOdeCatCovNames.size() + 2) + Util.getThetaIndex(this.usedOdeContCovNames, this.usedOdeCatCovNames, this.maxNamePrefix) + " +" : (this.usedOdeContCovNames.size() > 0 ? "" + (2 * this.usedOdeContCovNames.size() + 1) + Util.getThetaIndex(this.usedOdeContCovNames, this.usedOdeCatCovNames, this.maxNamePrefix) + " +" : (this.usedOdeCatCovNames.size() > 0 ? "" + (2 * this.usedOdeCatCovNames.size() + 1) + Util.getThetaIndex(this.usedOdeContCovNames, this.usedOdeCatCovNames, this.maxNamePrefix) + " +" : ""));
        int indice = 1;
        for (SymbolRef s : thetaNames) {
            String symbol = this.getSymbol(s);
            if (this.isIndependentVariableSym(s.getSymbIdRef())) continue;
            s1 = start + indice;
            ++indice;
            String formatI = "%s%s%s,%s%s %s %s%s\n";
            String formatNI = "%s%s%s%s %s %s%s\n";
            if (!this.odeInitialValueSubjDep && !this.hasCovariate) {
                lines.add(String.format(formatNI, this.parName, this.leftArrayBracket, s1, this.rightArrayBracket, "<-", symbol, ""));
                continue;
            }
            if (this.isDosingTime(s.getSymbIdRef())) {
                lines.add(String.format(formatNI, this.parName, this.leftArrayBracket, "ind_subj," + s1, this.rightArrayBracket, "<-", symbol, this.IND_SUBJ));
                continue;
            }
            lines.add(String.format(formatI, this.parName, this.leftArrayBracket, "ind_subj", s1, this.rightArrayBracket, "<-", symbol, ""));
        }
        accessors.put("ind", indice + "");
        if (!categ) {
            accessors.put("contNames", s1);
        } else {
            accessors.put("catNames", s1);
        }
        return lines;
    }

    @Override
    protected List<String> winbugsOdeParAssignement() {
        ArrayList<String> lines = new ArrayList<String>();
        int ind = this.indWB0;
        int n_cov_cont = this.usedOdeContCovNames.size();
        int n_cov_cat = this.usedOdeCatCovNames.size();
        this.odeInitialValueSubjDep = this.checkInitValSubDep() || this.checkIndiv();
        HashMap<String, String> accessors = new HashMap<String, String>();
        accessors.put("ind", ind + "");
        accessors.put("contNames", "");
        accessors.put("catNames", "");
        if (this.usedOdeContCovNames.size() > 0) {
            lines.addAll(this.genCovSumList(this.usedOdeContCovNames, accessors, false));
            ind += this.usedOdeContCovNames.size() + 1;
            lines.addAll(this.genCovAssign(this.usedOdeContCovNames, accessors, false, this.maxNamePrefix));
            lines.addAll(this.genCovAssign(this.usedOdeContCovNames, accessors, false, this.NtNamePrefix));
            ind += this.usedOdeContCovNames.size();
        }
        if (this.usedOdeCatCovNames.size() > 0) {
            lines.addAll(this.genCovSumList(this.usedOdeCatCovNames, accessors, true));
            ind += this.usedOdeCatCovNames.size() + 1;
            lines.addAll(this.genCovAssign(this.usedOdeCatCovNames, accessors, true, this.maxNamePrefix));
            lines.addAll(this.genCovAssign(this.usedOdeCatCovNames, accessors, true, this.NtNamePrefix));
            ind += this.usedOdeCatCovNames.size();
        }
        lines.addAll(this.genThetaCovAssign(this.theta_Parameters, accessors, true));
        return lines;
    }

    @Override
    protected String pascalParametersDeclaration() {
        String format = "%s: REAL;\n\t\t";
        String l = super.pascalParametersDeclaration();
        return l + this.stateVarDecl(format) + this.stateICDecl(format);
    }

    private List<String> genGridLines(int nCov, List<String> names) {
        String tmpGridIndex = "";
        int iCov = 1;
        int start = this.usedOdeContCovNames.size() > 0 && this.usedOdeCatCovNames.size() > 0 ? 2 * (1 + this.usedOdeContCovNames.size() + this.usedOdeCatCovNames.size()) : (this.usedOdeContCovNames.size() > 0 ? 1 + 2 * this.usedOdeContCovNames.size() : (this.usedOdeCatCovNames.size() > 0 ? 1 + 2 * this.usedOdeCatCovNames.size() : 1 + names.size()));
        String gridIndex = "i+" + start;
        tmpGridIndex = "i+" + start;
        ArrayList<String> gridLines = new ArrayList<String>();
        String thetaFormat = "%s%s%s,%s%s %s %s%s%s%s,i%s\n";
        for (String id : names) {
            ++iCov;
            String maxN = this.maxNamePrefix + id;
            gridLines.add(String.format("for (i in 1 : %s){ \n", maxN));
            gridLines.add(String.format(thetaFormat, this.parName, this.leftArrayBracket, "ind_subj", gridIndex, this.rightArrayBracket, "<-", this.gridPrefix, id, this.leftArrayBracket, "ind_subj", this.rightArrayBracket));
            tmpGridIndex = tmpGridIndex + "+2*" + maxN;
            gridIndex = gridIndex + "+" + maxN;
            gridLines.add("}\n");
            gridLines.add(String.format("for (i in 1 : %s){ \n", maxN));
            gridLines.add(String.format(thetaFormat, this.parName, this.leftArrayBracket, "ind_subj", gridIndex, this.rightArrayBracket, "<-", id, "", this.leftArrayBracket, "ind_subj", this.rightArrayBracket));
            gridLines.add("}\n\n");
            gridIndex = tmpGridIndex;
        }
        return gridLines;
    }

    @Override
    protected List<String> winbugsOdeInitialValues(StructuralBlock _sb) {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<String> tmpICLines = new ArrayList<String>();
        ArrayList<String> gridLines = new ArrayList<String>();
        this.odeInitialValueSubjDep = this.checkInitValSubDep(_sb) || this.checkIndiv();
        gridLines.addAll(this.genGridLines(this.usedOdeContCovNames.size(), Util.getNames(this.usedOdeContCovNames, this.usedOdeCatCovNames)));
        tmpICLines.addAll(this.genIcTlagLines(_sb, Util.getNames(this.usedOdeContCovNames, this.usedOdeCatCovNames)));
        lines.add(this.concat(gridLines, "\t"));
        lines.addAll(tmpICLines);
        return lines;
    }

    private List<String> genIcTlagLines(StructuralBlock _sb, List<String> names) {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<String> tmpICLines = new ArrayList<String>();
        ArrayList<String> tmpFLines = new ArrayList<String>();
        ArrayList<String> tmpTLAGLines = new ArrayList<String>();
        String formatInit = "%s[%s] <- %s #%s %s\n";
        String formatIndivInit = "%s[%s,%s] <- %s #%s %s\n";
        int nInitTime = 0;
        int nTheta = this.theta_Parameters.size();
        if (this.isIndepVarInList(this.theta_Parameters)) {
            --nTheta;
        }
        int nState = this.completeStateVariablesList.size();
        String fVal = "1";
        String tlagVal = "0";
        int nCov = names.size();
        for (int i = 0; i < nState; ++i) {
            fVal = "1";
            tlagVal = "0";
            DerivativeVariable var = (DerivativeVariable)_sb.getStateVariables().get(i);
            this.lexer.setCurrentStructuralBlock(_sb);
            String tmp = this.getFVal(var.getSymbId());
            fVal = tmp != null ? tmp : fVal;
            tmp = this.getTlagVal(var.getSymbId());
            tlagVal = tmp != null ? tmp : tlagVal;
            StandardAssignable initT = var.getInitialCondition().getInitialTime();
            String initialCondition = this.getStateInitialCondition(var);
            int startT = nState + nTheta;
            String fIndex = this.usedOdeCatCovNames.size() > 0 && this.usedOdeContCovNames.size() > 0 ? 2 + 2 * nCov + "" : 1 + 2 * nCov + "";
            for (String id : names) {
                fIndex = fIndex + "+2*" + this.maxNamePrefix + id;
            }
            int start = nTheta + 1;
            if (!this.hasCovariate) {
                if (!this.odeInitialValueSubjDep) {
                    tmpICLines.add(String.format(formatInit, this.parName, nTheta + 1 + i, initialCondition, "IC", var.getSymbId()));
                } else {
                    tmpICLines.add(String.format(formatIndivInit, this.parName, "ind_subj", nTheta + 1 + i, initialCondition, "IC", var.getSymbId()));
                }
            } else {
                tmpICLines.add(String.format(formatIndivInit, this.parName, "ind_subj", fIndex + "+" + (i + start), initialCondition, "IC", var.getSymbId()));
            }
            String s2 = !this.hasCovariate ? "" + (nTheta + nState + i + 1) : fIndex + "+" + (nTheta + nState + i + 1);
            if (initT != null) {
                ++nInitTime;
                if (!this.hasCovariate && !this.odeInitialValueSubjDep) {
                    tmpFLines.add(String.format(formatInit, this.parName, s2, fVal, "F", var.getSymbId()));
                } else {
                    tmpFLines.add(String.format(formatIndivInit, this.parName, "ind_subj", s2, fVal, "F", var.getSymbId()));
                }
            } else {
                s2 = this.hasCovariate ? fIndex + "+" + (startT + 1 + i) : "" + (nTheta + nState + i);
                if (!this.hasCovariate && !this.odeInitialValueSubjDep) {
                    tmpFLines.add(String.format(formatInit, this.parName, s2, fVal, "F", var.getSymbId()));
                } else if (!this.hasCovariate) {
                    tmpFLines.add(String.format(formatIndivInit, this.parName, "ind_subj", s2, fVal, "F", var.getSymbId()));
                } else {
                    tmpFLines.add(String.format(formatIndivInit, this.parName, "ind_subj", s2, fVal, "F", var.getSymbId()));
                }
                if (nInitTime > 1) {
                    throw new IllegalStateException("Multiple ODE initial times are not allowed.");
                }
            }
            String s3 = this.hasCovariate ? fIndex + "+" + (startT + nState + i + 1) : "" + (nTheta + 2 * nState + i + 1);
            if (!this.hasCovariate && !this.odeInitialValueSubjDep) {
                tmpTLAGLines.add(String.format(formatInit, this.parName, s3, tlagVal, "TLAG", var.getSymbId()));
                continue;
            }
            if (!this.hasCovariate) {
                tmpTLAGLines.add(String.format(formatIndivInit, this.parName, "ind_subj", s3, tlagVal, "TLAG", var.getSymbId()));
                continue;
            }
            tmpTLAGLines.add(String.format(formatIndivInit, this.parName, "ind_subj", s3, tlagVal, "TLAG", var.getSymbId()));
        }
        lines.addAll(tmpICLines);
        lines.addAll(tmpFLines);
        lines.addAll(tmpTLAGLines);
        return lines;
    }

    @Override
    protected boolean checkIndiv() {
        boolean isIndividual = false;
        for (SymbolRef s : this.theta_Parameters) {
            String symbol = this.getSymbol(s);
            if (!symbol.contains("ind_subj")) continue;
            isIndividual = true;
        }
        return isIndividual || this.odeInitialValueSubjDep;
    }

    private String pascalICAssignement() {
        StringBuilder sb = new StringBuilder();
        int nTheta = this.theta_Parameters.size();
        if (this.isIndepVarInList(this.theta_Parameters)) {
            --nTheta;
        }
        int ind = this.indPAS0 + nTheta;
        String format = "%s %s %s%s%s%s;\n\t\t";
        String formatCov = "%s %s %s%slastindex+%s%s;\n\t\t";
        for (int i = 0; i < this.completeStateVariablesList.size(); ++i) {
            if (this.hasCovariate) {
                sb.append(String.format(formatCov, this.icLabel + i, this.pascalAssignSymbol, this.parName, this.leftArrayBracket, ind++, this.rightArrayBracket));
                continue;
            }
            sb.append(String.format(format, this.icLabel + i, this.pascalAssignSymbol, this.parName, this.leftArrayBracket, ind++, this.rightArrayBracket));
        }
        return sb.toString();
    }

    private String pascalVarAssignLines() {
        StringBuilder sb = new StringBuilder();
        String format = "%s %s %s%s%s%s+%s;\n\t\t";
        String formatCov = "%s %s %s%s%s%s+%s;\n\t\t";
        for (int i = 0; i < this.completeStateVariablesList.size(); ++i) {
            if (this.hasCovariate) {
                sb.append(String.format(formatCov, this.varLabel + i, this.pascalAssignSymbol, upperStateLabel, this.leftArrayBracket, i, this.rightArrayBracket, this.icLabel + i));
                continue;
            }
            sb.append(String.format(format, this.varLabel + i, this.pascalAssignSymbol, upperStateLabel, this.leftArrayBracket, i, this.rightArrayBracket, this.icLabel + i));
        }
        return sb.toString();
    }
}

