/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs.parts;

import crx.converter.engine.Accessor;
import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.engine.common.CovariateParameterRef;
import crx.converter.spi.ILexer;
import crx.converter.spi.blocks.CovariateBlock;
import crx.converter.tree.BinaryTree;
import crx.converter.tree.TreeMaker;
import eu.ddmore.converters.unipv.winbugs.parts.PartImpl;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.modeldefn.CommonParameter;
import eu.ddmore.libpharmml.dom.modeldefn.ContinuousCovariate;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateDefinition;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateModel;
import eu.ddmore.libpharmml.dom.modeldefn.CovariateTransformation;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CovariateBlockImpl
extends PartImpl
implements CovariateBlock {
    private List<String> categorical_cov_names = new ArrayList<String>();
    private CovariateModel cm = null;
    private List<ContinuousCovariate> continuous_covariates = new ArrayList<ContinuousCovariate>();
    private Map<CovariateDefinition, CovariateParameterRef> cov_param_map = new HashMap<CovariateDefinition, CovariateParameterRef>();
    private List<CovariateDefinition> covariates = new ArrayList<CovariateDefinition>();
    private List<PopulationParameter> params = null;
    private List<String> symbols = new ArrayList<String>();

    public CovariateBlockImpl(CovariateModel cm_, ILexer lexer_) {
        if (cm_ == null) {
            throw new NullPointerException("The Covariate model cannot be null.");
        }
        if (lexer_ == null) {
            throw new NullPointerException("The lexer variable cannot be null.");
        }
        this.cm = cm_;
        this.lexer = lexer_;
        this.params = this.cm.getListOfPopulationParameter();
        if (this.params != null) {
            for (PopulationParameter p : this.params) {
                if (p == null) continue;
                this.checkAssignment(p);
            }
        }
    }

    public boolean addParameterToCovariate(String covName, String parameterName) {
        if (covName == null || parameterName == null) {
            return false;
        }
        Accessor a = this.lexer.getAccessor();
        PharmMLRootType element = a.fetchElement(covName);
        if (!PharmMLTypeChecker.isCovariate((Object)element)) {
            return false;
        }
        CovariateDefinition cov = (CovariateDefinition)element;
        element = a.fetchElement(parameterName);
        if (!PharmMLTypeChecker.isCommonParameter((Object)element)) {
            return false;
        }
        CommonParameter p = (CommonParameter)element;
        CovariateParameterRef ref = null;
        if (!this.cov_param_map.containsKey(cov)) {
            ref = new CovariateParameterRef(cov);
            this.cov_param_map.put(cov, ref);
        } else {
            ref = this.cov_param_map.get(cov);
        }
        if (ref != null) {
            return ref.addParameter(p);
        }
        return false;
    }

    @Override
    public void buildTrees() {
        List covs;
        TreeMaker tm = this.lexer.getTreeMaker();
        if (this.params != null) {
            for (PopulationParameter p : this.params) {
                if (p == null) continue;
                BinaryTree bt = tm.newInstance((Object)p);
                this.lexer.addStatement((Object)p, bt);
            }
        }
        if ((covs = this.cm.getListOfCovariate()) != null) {
            for (CovariateDefinition cov : covs) {
                if (cov == null) continue;
                this.lexer.addStatement((Object)cov, tm.newInstance((Object)cov));
                String symbId = cov.getSymbId();
                if (symbId == null) {
                    throw new NullPointerException("Covariate symbol ID is null");
                }
                if (!this.symbols.contains(symbId)) {
                    this.symbols.add(symbId);
                }
                if (cov.getContinuous() != null) {
                    ContinuousCovariate continuous = cov.getContinuous();
                    if (continuous.getInterpolation() != null) {
                        throw new UnsupportedOperationException("covariate::interpolate not supported yet.");
                    }
                    this.lexer.addStatement((Object)continuous, tm.newInstance((Object)continuous));
                    this.lexer.updateNestedTrees();
                    for (CovariateTransformation transform : continuous.getListOfTransformation()) {
                        if (transform == null) continue;
                        this.lexer.addStatement((Object)transform, tm.newInstance((Object)transform));
                    }
                }
                this.covariates.add(cov);
            }
        }
    }

    public List<String> getCategoricalCovariateNames() {
        return this.categorical_cov_names;
    }

    public List<ContinuousCovariate> getContinuousCovariates() {
        return this.continuous_covariates;
    }

    public Collection<CovariateParameterRef> getCovariateParameterRefs() {
        return this.cov_param_map.values();
    }

    public List<CovariateDefinition> getCovariates() {
        return this.covariates;
    }

    public CovariateModel getModel() {
        return this.cm;
    }

    @Override
    public String getName() {
        String name = null;
        if (this.cm != null) {
            name = this.cm.getBlkId();
        }
        return name;
    }

    public List<PopulationParameter> getParameters() {
        if (this.params == null) {
            return new ArrayList<PopulationParameter>();
        }
        return this.params;
    }

    @Override
    public List<String> getSymbolIds() {
        return this.symbols;
    }

    @Override
    public boolean hasSymbolId(String name) {
        return name != null && this.symbols.contains(name);
    }

    public boolean isCategorical() {
        throw new UnsupportedOperationException();
    }

    public List<String> getCategories(CovariateDefinition cov) {
        throw new UnsupportedOperationException();
    }

    public boolean isCategorical(String covariateName) {
        throw new UnsupportedOperationException();
    }
}

