/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs.parts;

import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.engine.assoc.Cluster;
import crx.converter.engine.common.CorrelationRef;
import crx.converter.engine.common.ParameterEvent;
import crx.converter.spi.ILexer;
import crx.converter.spi.blocks.OrderableBlock;
import crx.converter.spi.blocks.ParameterBlock;
import crx.converter.tree.BinaryTree;
import crx.converter.tree.TreeMaker;
import eu.ddmore.converters.unipv.winbugs.parts.BaseRandomVariableBlockImpl;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.Rhs;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.modeldefn.CommonParameter;
import eu.ddmore.libpharmml.dom.modeldefn.Correlation;
import eu.ddmore.libpharmml.dom.modeldefn.IndividualParameter;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterModel;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomVariable;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ParameterBlockImpl
extends BaseRandomVariableBlockImpl
implements OrderableBlock,
ParameterBlock {
    private List<PharmMLRootType> cached_declaration_list = new ArrayList<PharmMLRootType>();
    private List<ParameterEvent> events = new ArrayList<ParameterEvent>();
    private List<PharmMLElement> objects_to_remove = new ArrayList<PharmMLElement>();
    private HashMap<CommonParameter, Integer> param_map_idx = new HashMap();
    private HashMap<String, CommonParameter> param_map_name = new HashMap();
    private ArrayList<PopulationParameter> params = new ArrayList();
    private ParameterModel pm = null;

    public ParameterBlockImpl(ParameterModel pm_, ILexer c_) {
        if (pm_ == null) {
            throw new NullPointerException("ParameterModel is NULL.");
        }
        this.pm = pm_;
        if (this.pm.getBlkId() == null) {
            throw new IllegalStateException("Parameter model must have a BLK ID");
        }
        this.lexer = c_;
        int i = 1;
        int indiv_i = 1;
        for (PharmMLElement o : this.pm.getListOfParameterModelElements()) {
            Integer idx;
            String symbolId;
            if (PharmMLTypeChecker.isPopulationParameter((Object)o)) {
                PopulationParameter p = (PopulationParameter)o;
                symbolId = p.getSymbId();
                if (!this.isSymbolIdOkay(symbolId)) {
                    throw new IllegalStateException("The node symbolId (" + symbolId + ") is not okay.");
                }
                idx = i++;
                this.params.add(p);
                this.param_map_idx.put((CommonParameter)p, idx);
                this.param_map_name.put(symbolId, (CommonParameter)p);
                this.checkAssignment(p);
                continue;
            }
            if (PharmMLTypeChecker.isIndividualParameter((Object)o)) {
                IndividualParameter ip = (IndividualParameter)o;
                symbolId = ip.getSymbId();
                if (!this.isSymbolIdOkay(symbolId)) {
                    throw new IllegalStateException("The node symbolId (" + symbolId + ") is not okay.");
                }
                idx = indiv_i++;
                this.param_map_idx.put((CommonParameter)ip, idx);
                this.indiv_params.add(ip);
                this.param_map_name.put(symbolId, (CommonParameter)ip);
                continue;
            }
            if (PharmMLTypeChecker.isRandomVariable((Object)o)) {
                ParameterRandomVariable rv = (ParameterRandomVariable)o;
                symbolId = rv.getSymbId();
                if (!this.isSymbolIdOkay(symbolId)) {
                    throw new IllegalStateException("The node symbolId (" + symbolId + ") is not okay.");
                }
                this.param_map_name.put(symbolId, (CommonParameter)rv);
                this.rvs.add(rv);
                continue;
            }
            if (PharmMLTypeChecker.isCorrelation((Object)o)) {
                this.register((Correlation)o);
                continue;
            }
            new UnsupportedOperationException("PharmML type not supported yet (type=" + o + ")");
        }
        this.removeMatrixParameters();
    }

    public boolean addCluster(Cluster cluster) {
        throw new UnsupportedOperationException();
    }

    private void buildMatrixDeclarationTrees() {
        if (this.has_matrices.size() == 0) {
            return;
        }
        TreeMaker tm = this.lexer.getTreeMaker();
        for (Object o : this.has_matrices) {
            this.lexer.addStatement(o, tm.newInstance(o));
            this.lexer.updateNestedTrees();
        }
    }

    @Override
    public void buildTrees() {
        TreeMaker tm = this.lexer.getTreeMaker();
        for (PopulationParameter p : this.params) {
            BinaryTree bt;
            if (this.lexer.isUsePiecewiseAsEvents()) {
                if (this.hasPiecewise(p)) {
                    ParameterEvent evt = new ParameterEvent(p, this.lexer);
                    evt.buildTrees();
                    this.events.add(evt);
                    this.lexer.addStatement((Object)p, evt.getDefaultTree());
                    continue;
                }
                bt = tm.newInstance((Object)p);
                this.lexer.addStatement((Object)p, bt);
                this.lexer.updateNestedTrees();
                continue;
            }
            bt = tm.newInstance((Object)p);
            this.lexer.addStatement((Object)p, bt);
            this.lexer.updateNestedTrees();
        }
        for (ParameterRandomVariable rv : this.rvs) {
            this.lexer.addStatement((Object)rv, tm.newInstance((Object)rv));
            this.lexer.updateNestedTrees();
        }
        for (CorrelationRef corr : this.correlations) {
            this.buildTrees(corr);
        }
        this.buildIndividualParameterTrees();
        this.buildMatrixDeclarationTrees();
    }

    private void clearAllParameterLists() {
        this.params.clear();
        this.rvs.clear();
        this.indiv_params.clear();
        this.linked_rvs.clear();
    }

    public boolean contains(PharmMLRootType v) {
        block5: {
            block6: {
                block4: {
                    if (!PharmMLTypeChecker.isPopulationParameter((Object)v)) break block4;
                    for (PopulationParameter p : this.params) {
                        if (p == null || !p.equals(v)) continue;
                        return true;
                    }
                    break block5;
                }
                if (!PharmMLTypeChecker.isIndividualParameter((Object)v)) break block6;
                for (IndividualParameter ip : this.indiv_params) {
                    if (ip == null || !ip.equals(v)) continue;
                    return true;
                }
                break block5;
            }
            if (!PharmMLTypeChecker.isRandomVariable((Object)v)) break block5;
            for (ParameterRandomVariable rv : this.rvs) {
                if (rv == null || !rv.equals(v)) continue;
                return true;
            }
            for (ParameterRandomVariable rv : this.linked_rvs) {
                if (rv == null || !rv.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Cluster> getClusters() {
        throw new UnsupportedOperationException();
    }

    public List<ParameterEvent> getEvents() {
        return this.events;
    }

    public List<PharmMLRootType> getListOfDeclarations() {
        if (!this.cached_declaration_list.isEmpty()) {
            return this.cached_declaration_list;
        }
        ArrayList<PharmMLRootType> params = new ArrayList<PharmMLRootType>();
        params.addAll(this.getParameters());
        params.addAll(this.getRandomVariables());
        params.addAll(this.getIndividualParameters());
        params.addAll(this.getLinkedRandomVariables());
        return params;
    }

    public ParameterModel getModel() {
        return this.pm;
    }

    @Override
    public String getName() {
        String blkId = "__RUBBISH_DEFAULT_VALUE_";
        if (this.pm != null && this.pm.getBlkId() != null) {
            blkId = this.pm.getBlkId();
        }
        return blkId;
    }

    public Integer getParameterIndex(String name) {
        CommonParameter p;
        Integer idx = -1;
        if (this.param_map_name.containsKey(name) && (p = this.param_map_name.get(name)) != null && this.param_map_idx.containsKey(p)) {
            idx = this.param_map_idx.get(p);
            if (this.lexer.isIndexFromZero()) {
                Integer n = idx;
                Integer n2 = idx = Integer.valueOf(idx - 1);
            }
        }
        return idx;
    }

    public Integer getParameterIndex(SymbolRef ref) {
        PharmMLRootType p;
        Integer idx = -1;
        if (ref != null && (p = this.lexer.getAccessor().fetchElement(ref)) != null && this.param_map_idx.containsKey(p)) {
            idx = this.param_map_idx.get(p);
        }
        return idx;
    }

    public List<PopulationParameter> getParameters() {
        return this.params;
    }

    public List<ParameterRandomVariable> getRandomVariables() {
        return this.rvs;
    }

    @Override
    public List<String> getSymbolIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (PopulationParameter p : this.params) {
            if (p == null || p.getSymbId() == null) continue;
            ids.add(p.getSymbId());
        }
        return ids;
    }

    public boolean hasEvents() {
        return !this.events.isEmpty();
    }

    public boolean hasMatrixAssignedParameters() {
        return this.has_matrices.size() > 0;
    }

    private boolean hasPiecewise(PopulationParameter p) {
        if (p == null) {
            return false;
        }
        Rhs rhs = p.getAssign();
        if (rhs == null) {
            return false;
        }
        return rhs.getPiecewise() != null;
    }

    @Override
    public boolean hasSymbolId(String name) {
        boolean has = false;
        if (name != null) {
            for (PopulationParameter s : this.params) {
                String v_name = s.getSymbId();
                if (v_name == null || !v_name.equals(name)) continue;
                has = true;
                break;
            }
        }
        return has;
    }

    public boolean isLinkedRandomVariable(ParameterRandomVariable rv) {
        if (rv != null) {
            return this.linked_rvs.contains(rv);
        }
        return false;
    }

    private void removeMatrixParameters() {
        if (this.objects_to_remove.size() == 0) {
            return;
        }
        this.pm.getListOfParameterModelElements().removeAll(this.objects_to_remove);
    }

    public void setOrderedVariableList(List<PharmMLElement> ordered_variables) {
        if (ordered_variables == null) {
            return;
        }
        if (ordered_variables.isEmpty()) {
            return;
        }
        ArrayList<PopulationParameter> old_params = new ArrayList<PopulationParameter>();
        ArrayList<ParameterRandomVariable> old_rvs = new ArrayList<ParameterRandomVariable>();
        ArrayList<IndividualParameter> old_indiv_params = new ArrayList<IndividualParameter>();
        ArrayList<ParameterRandomVariable> old_linked_rvs = new ArrayList<ParameterRandomVariable>();
        old_params.addAll(this.getParameters());
        old_rvs.addAll(this.getRandomVariables());
        old_indiv_params.addAll(this.getIndividualParameters());
        old_linked_rvs.addAll(this.getLinkedRandomVariables());
        this.clearAllParameterLists();
        for (PharmMLElement ordered_variable : ordered_variables) {
            if (PharmMLTypeChecker.isPopulationParameter((Object)ordered_variable)) {
                PopulationParameter p = (PopulationParameter)ordered_variable;
                if (!old_params.contains(p)) continue;
                this.params.add(p);
                continue;
            }
            if (PharmMLTypeChecker.isIndividualParameter((Object)ordered_variable)) {
                IndividualParameter ip = (IndividualParameter)ordered_variable;
                if (!old_indiv_params.contains(ip)) continue;
                this.indiv_params.add(ip);
                continue;
            }
            if (!PharmMLTypeChecker.isRandomVariable((Object)ordered_variable)) continue;
            ParameterRandomVariable rv = (ParameterRandomVariable)ordered_variable;
            if (old_rvs.contains(rv)) {
                this.rvs.add(rv);
                continue;
            }
            if (!old_linked_rvs.contains(rv)) continue;
            this.linked_rvs.add(rv);
        }
        this.cached_declaration_list.clear();
        for (PharmMLElement o : ordered_variables) {
            if (!PharmMLTypeChecker.isPopulationParameter((Object)o) && !PharmMLTypeChecker.isIndividualParameter((Object)o) && !PharmMLTypeChecker.isRandomVariable((Object)o)) continue;
            this.cached_declaration_list.add((PharmMLRootType)o);
        }
    }
}

