/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs.parts;

import crx.converter.engine.Accessor;
import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.engine.VariableDeclarationContext;
import crx.converter.engine.assoc.Cluster;
import crx.converter.engine.common.DerivativeEvent;
import crx.converter.spi.ILexer;
import crx.converter.spi.blocks.OrderableBlock;
import crx.converter.spi.blocks.StructuralBlock;
import crx.converter.spi.steps.EstimationStep;
import crx.converter.tree.BinaryTree;
import crx.converter.tree.TreeMaker;
import eu.ddmore.converters.unipv.winbugs.parts.PartImpl;
import eu.ddmore.libpharmml.dom.commontypes.CommonVariableDefinition;
import eu.ddmore.libpharmml.dom.commontypes.DerivativeVariable;
import eu.ddmore.libpharmml.dom.commontypes.InitialCondition;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLElement;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.RealValue;
import eu.ddmore.libpharmml.dom.commontypes.Rhs;
import eu.ddmore.libpharmml.dom.commontypes.Scalar;
import eu.ddmore.libpharmml.dom.commontypes.StandardAssignable;
import eu.ddmore.libpharmml.dom.commontypes.VariableDefinition;
import eu.ddmore.libpharmml.dom.modeldefn.PopulationParameter;
import eu.ddmore.libpharmml.dom.modeldefn.StructuralModel;
import eu.ddmore.libpharmml.dom.modeldefn.pkmacro.PKMacro;
import eu.ddmore.libpharmml.pkmacro.translation.MacroOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructuralBlockImpl
extends PartImpl
implements StructuralBlock,
OrderableBlock {
    private Accessor a = null;
    private List<BinaryTree> bts = new ArrayList<BinaryTree>();
    private List<PharmMLRootType> cached_declaration_list = new ArrayList<PharmMLRootType>();
    private VariableDefinition doseTimingVariable = null;
    private List<DerivativeEvent> events = new ArrayList<DerivativeEvent>();
    private Map<String, VariableDefinition> local_map_name = new HashMap<String, VariableDefinition>();
    private List<VariableDefinition> locals = new ArrayList<VariableDefinition>();
    private List<VariableDefinition> globals = new ArrayList<VariableDefinition>();
    private List<PKMacro> macro_list = null;
    private MacroOutput macro_output = null;
    private List<PopulationParameter> params = new ArrayList<PopulationParameter>();
    private StructuralModel sm = null;
    private Map<CommonVariableDefinition, Integer> state_map_idx = new HashMap<CommonVariableDefinition, Integer>();
    private Map<String, CommonVariableDefinition> state_map_name = new HashMap<String, CommonVariableDefinition>();
    private List<DerivativeVariable> states = new ArrayList<DerivativeVariable>();
    private TreeMaker tm = null;
    private Map<Object, BinaryTree> tree_map = new HashMap<Object, BinaryTree>();

    private static InitialCondition initialCondition(Double value) {
        InitialCondition ic = new InitialCondition();
        ic.setInitialValue(StructuralBlockImpl.standardAssignable(value));
        ic.setInitialTime(StructuralBlockImpl.standardAssignable(0.0));
        return ic;
    }

    private static StandardAssignable standardAssignable(double value) {
        StandardAssignable v = new StandardAssignable();
        v.assign((Scalar)new RealValue(value));
        return v;
    }

    public StructuralBlockImpl(StructuralModel sm_, ILexer lexer_) {
        if (sm_ == null) {
            throw new NullPointerException("The structural model cannot be NULL.");
        }
        this.sm = sm_;
        if (this.sm.getBlkId() == null) {
            throw new IllegalStateException("State model must have a BLK ID");
        }
        this.lexer = lexer_;
        this.tm = this.lexer.getTreeMaker();
        this.a = this.lexer.getAccessor();
        Integer idx = 0;
        for (Object v : this.sm.getListOfStructuralModelElements()) {
            if (!PharmMLTypeChecker.isDerivative(v)) continue;
            DerivativeVariable dv = (DerivativeVariable)v;
            String symbolId = dv.getSymbId();
            if (!this.isSymbolIdOkay(symbolId)) {
                throw new IllegalStateException("The node symbolId (" + symbolId + ") is not okay.");
            }
            Integer n = idx;
            Integer n2 = idx = Integer.valueOf(idx + 1);
            if (this.lexer.isUsePiecewiseAsEvents() && this.hasPiecewise(dv)) {
                DerivativeEvent evt = new DerivativeEvent(dv, this.a);
                this.events.add(evt);
            }
            this.state_map_idx.put((CommonVariableDefinition)dv, idx);
            this.state_map_name.put(symbolId, (CommonVariableDefinition)dv);
            this.states.add(dv);
        }
        EstimationStep est = this.lexer.getEstimationStep();
        for (Object v : this.sm.getListOfStructuralModelElements()) {
            if (!PharmMLTypeChecker.isLocalVariable(v)) continue;
            VariableDefinition local = (VariableDefinition)v;
            String symbolId = local.getSymbId();
            if (!this.isSymbolIdOkay(symbolId)) {
                throw new IllegalStateException("The node symbolId (" + symbolId + ") is not okay.");
            }
            boolean isConditionalDoseEventTarget = false;
            VariableDeclarationContext ctx = this.lexer.guessContext(local);
            if (this.lexer.isIsolatingDoseTimingVariable()) {
                if (VariableDeclarationContext.DT.equals((Object)ctx)) {
                    this.doseTimingVariable = local;
                    continue;
                }
                if (VariableDeclarationContext.DOSE.equals((Object)ctx)) continue;
            }
            if (est != null && est.isConditionalDoseEventTarget(local)) {
                isConditionalDoseEventTarget = true;
            }
            if (this.lexer.isIsolatingDoseTimingVariable() && VariableDeclarationContext.DT.equals((Object)this.lexer.guessContext(local))) {
                this.doseTimingVariable = local;
                continue;
            }
            if (isConditionalDoseEventTarget && this.lexer.isIsolateConditionalDoseVariable()) continue;
            if (this.lexer.isIsolateGloballyScopedVariables() && VariableDeclarationContext.GLOBAL_SCOPE.equals((Object)ctx)) {
                this.globals.add(local);
            } else {
                this.locals.add(local);
            }
            this.local_map_name.put(symbolId, local);
        }
        for (Object v : this.sm.getListOfStructuralModelElements()) {
            if (!PharmMLTypeChecker.isPopulationParameter(v)) continue;
            this.params.add((PopulationParameter)v);
        }
    }

    private void add(Object key, BinaryTree value) {
        if (key != null && value != null && !this.tree_map.containsKey(key)) {
            this.tree_map.put(key, value);
        }
    }

    public boolean addCluster(Cluster cluster) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void buildTrees() {
        if (this.treeBuilt) {
            return;
        }
        this.bts.clear();
        this.createStateTrees();
        this.createLocalVariableTrees();
        this.createInitialConditionTrees();
        this.createParameterTrees();
        this.treeBuilt = true;
    }

    private void clearAllVariableLists() {
        this.params.clear();
        this.locals.clear();
        this.states.clear();
    }

    public boolean contains(PharmMLRootType v) {
        return PharmMLTypeChecker.isDerivative((Object)v) ? this.states.contains(v) : PharmMLTypeChecker.isLocalVariable((Object)v) && this.locals.contains(v);
    }

    private void createInitialConditionTrees() {
        for (DerivativeVariable s : this.states) {
            if (s.getHistory() != null) continue;
            if (s.getInitialCondition() == null) {
                s.setInitialCondition(StructuralBlockImpl.initialCondition(0.0));
            }
            InitialCondition ic = s.getInitialCondition();
            BinaryTree bt = this.tm.newInstance((Object)ic);
            this.bts.add(bt);
            this.lexer.addStatement((Object)ic, bt);
            this.lexer.updateNestedTrees();
        }
    }

    private void createLocalVariableTrees() {
        for (VariableDefinition v : this.locals) {
            BinaryTree bt = this.tm.newInstance((Object)v);
            this.lexer.updateNestedTrees();
            this.bts.add(bt);
            this.add(v, bt);
            this.lexer.addStatement((Object)v, bt);
        }
    }

    private void createParameterTrees() {
        if (this.params.isEmpty()) {
            return;
        }
        for (PopulationParameter p : this.params) {
            if (p == null) continue;
            BinaryTree bt = this.tm.newInstance((Object)p);
            this.lexer.addStatement((Object)p, bt);
        }
    }

    private void createStateTrees() {
        for (DerivativeVariable s : this.states) {
            BinaryTree bt = this.tm.newInstance((Object)s);
            this.lexer.updateNestedTrees();
            this.bts.add(bt);
            this.add(s, bt);
            this.lexer.addStatement((Object)s, bt);
        }
    }

    public List<Cluster> getClusters() {
        throw new UnsupportedOperationException();
    }

    public VariableDefinition getDoseTimingVariable() {
        return this.doseTimingVariable;
    }

    public List<DerivativeEvent> getEvents() {
        return this.events;
    }

    public List<PharmMLRootType> getListOfDeclarations() {
        if (!this.cached_declaration_list.isEmpty()) {
            return this.cached_declaration_list;
        }
        ArrayList<PharmMLRootType> variables = new ArrayList<PharmMLRootType>();
        variables.addAll(this.getParameters());
        variables.addAll(this.getLocalVariables());
        variables.addAll(this.getStateVariables());
        return variables;
    }

    public List<VariableDefinition> getLocalVariables() {
        return this.locals;
    }

    public StructuralModel getModel() {
        return this.sm;
    }

    @Override
    public String getName() {
        String blkId = "_RUBBISH_DEFAULT_VALUE_";
        if (this.sm != null && this.sm.getBlkId() != null) {
            blkId = this.sm.getBlkId();
        }
        return blkId;
    }

    public List<PopulationParameter> getParameters() {
        return this.params;
    }

    public MacroOutput getPKMacroOutput() {
        return this.macro_output;
    }

    public List<PKMacro> getPKMacros() {
        return this.macro_list;
    }

    public Integer getStateVariableIndex(String name) {
        return null;
    }

    public List<DerivativeVariable> getStateVariables() {
        return this.states;
    }

    @Override
    public List<String> getSymbolIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (DerivativeVariable s : this.states) {
            if (s == null || s.getSymbId() == null) continue;
            ids.add(s.getSymbId());
        }
        return ids;
    }

    public boolean hasDoseTimingVariable() {
        return this.doseTimingVariable != null;
    }

    public boolean hasEvents() {
        return this.events.size() > 0;
    }

    public boolean hasParameters() {
        return !this.params.isEmpty();
    }

    private boolean hasPiecewise(DerivativeVariable dv) {
        Rhs eq;
        return dv != null && (eq = dv.getAssign()) != null && eq.getPiecewise() != null;
    }

    public boolean hasPKMacros() {
        if (this.macro_list == null) {
            return false;
        }
        return this.macro_list.size() > 0;
    }

    @Override
    public boolean hasSymbolId(String name) {
        if (name != null) {
            String v_name;
            for (DerivativeVariable s : this.states) {
                v_name = s.getSymbId();
                if (v_name == null || !v_name.equals(name)) continue;
                return true;
            }
            for (VariableDefinition local : this.locals) {
                v_name = local.getSymbId();
                if (v_name == null || !v_name.equals(name)) continue;
                return true;
            }
            for (PopulationParameter p : this.params) {
                v_name = p.getSymbId();
                if (v_name == null || !v_name.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDDE() {
        throw new UnsupportedOperationException();
    }

    public boolean isMixedEffect() {
        throw new UnsupportedOperationException();
    }

    public boolean isODE() {
        return !this.states.isEmpty();
    }

    public boolean isPlainFunction() {
        return this.states.size() == 0;
    }

    public boolean isStateVariable(String name) {
        boolean dt_something = false;
        if (name != null) {
            for (DerivativeVariable state : this.states) {
                String symId;
                if (state == null || (symId = state.getSymbId()) == null || !symId.equals(name)) continue;
                dt_something = true;
                break;
            }
        }
        return dt_something;
    }

    public boolean isUsingUntranslatedPKMacros() {
        throw new UnsupportedOperationException();
    }

    public void setOrderedVariableList(List<PharmMLElement> ordered_variables) {
        if (ordered_variables == null) {
            return;
        }
        if (ordered_variables.isEmpty()) {
            return;
        }
        ArrayList<PopulationParameter> old_params = new ArrayList<PopulationParameter>();
        ArrayList<VariableDefinition> old_locals = new ArrayList<VariableDefinition>();
        ArrayList<DerivativeVariable> old_states = new ArrayList<DerivativeVariable>();
        old_params.addAll(this.params);
        old_locals.addAll(this.locals);
        old_states.addAll(this.states);
        this.clearAllVariableLists();
        for (PharmMLElement ordered_variable : ordered_variables) {
            DerivativeVariable dv;
            if (PharmMLTypeChecker.isPopulationParameter((Object)ordered_variable)) {
                PopulationParameter p = (PopulationParameter)ordered_variable;
                if (!old_params.contains(p)) continue;
                this.params.add(p);
                continue;
            }
            if (PharmMLTypeChecker.isLocalVariable((Object)ordered_variable)) {
                VariableDefinition v = (VariableDefinition)ordered_variable;
                if (!old_locals.contains(v)) continue;
                this.locals.add(v);
                continue;
            }
            if (!PharmMLTypeChecker.isDerivative((Object)ordered_variable) || !old_states.contains(dv = (DerivativeVariable)ordered_variable)) continue;
            this.states.add(dv);
        }
        this.cached_declaration_list.clear();
        for (PharmMLElement o : ordered_variables) {
            if (!PharmMLTypeChecker.isPopulationParameter((Object)o) && !PharmMLTypeChecker.isLocalVariable((Object)o) && !PharmMLTypeChecker.isDerivative((Object)o)) continue;
            this.cached_declaration_list.add((PharmMLRootType)o);
        }
    }

    public void setPKMacroOutput(MacroOutput macro_output_) {
        this.macro_output = macro_output_;
    }

    public void setPKMacros(List<PKMacro> macro_list_) {
        this.macro_list = macro_list_;
    }

    public List<CommonVariableDefinition> getRegressors() {
        throw new UnsupportedOperationException();
    }

    public boolean isRegressor(CommonVariableDefinition v) {
        throw new UnsupportedOperationException();
    }

    public List<VariableDefinition> getGlobalVariables() {
        return null;
    }

    public boolean hasGlobalVariables() {
        return false;
    }
}

