/*
 * Decompiled with CFR 0.152.
 */
package eu.ddmore.converters.unipv.winbugs.parts;

import crx.converter.engine.Accessor;
import crx.converter.engine.PharmMLTypeChecker;
import crx.converter.spi.ILexer;
import crx.converter.spi.blocks.VariabilityBlock;
import eu.ddmore.converters.unipv.winbugs.parts.PartImpl;
import eu.ddmore.libpharmml.dom.commontypes.LevelReference;
import eu.ddmore.libpharmml.dom.commontypes.PharmMLRootType;
import eu.ddmore.libpharmml.dom.commontypes.StringValue;
import eu.ddmore.libpharmml.dom.commontypes.SymbolRef;
import eu.ddmore.libpharmml.dom.modeldefn.ParameterRandomVariable;
import eu.ddmore.libpharmml.dom.modeldefn.ParentLevel;
import eu.ddmore.libpharmml.dom.modeldefn.Variability;
import eu.ddmore.libpharmml.dom.modeldefn.VariabilityDefnBlock;
import eu.ddmore.libpharmml.dom.modeldefn.VariabilityLevelDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariabilityBlockImpl
extends PartImpl
implements VariabilityBlock {
    private Map<String, StringValue> comparator_map = new HashMap<String, StringValue>();
    private boolean is_parameter_variability = false;
    private boolean residual_error = false;
    private Map<String, String> level_dependency_map = new HashMap<String, String>();
    private List<String> symbols = new ArrayList<String>();
    private VariabilityDefnBlock vb = null;

    public VariabilityBlockImpl(VariabilityDefnBlock vb_, ILexer lexer_) {
        if (vb_ == null) {
            throw new NullPointerException("VariabilityDefnBlock argument cannot be null.");
        }
        if (lexer_ == null) {
            throw new NullPointerException("Converter/Lexer argument cannot be null.");
        }
        this.vb = vb_;
        this.lexer = lexer_;
        Variability type = this.vb.getType();
        if (type == Variability.PARAMETER_VARIABILITY) {
            this.is_parameter_variability = true;
        } else if (type == Variability.RESIDUAL_ERROR) {
            this.residual_error = true;
        } else {
            throw new UnsupportedOperationException("Variability not supported (" + type + ")");
        }
        Accessor a = this.lexer.getAccessor();
        List levels = this.vb.getLevel();
        for (VariabilityLevelDefinition level : levels) {
            String symbId = level.getSymbId();
            if (symbId == null) {
                throw new NullPointerException("Level ID is NULL.");
            }
            this.symbols.add(symbId);
            if (level.getParentLevel() != null) {
                ParentLevel pl = level.getParentLevel();
                SymbolRef ref = pl.getSymbRef();
                PharmMLRootType element = a.fetchElement(pl.getSymbRef());
                if (!PharmMLTypeChecker.isVariabilityLevelDefinition((Object)element)) {
                    throw new IllegalStateException("The parent model element is not a variability level (symbId='" + ref.getSymbIdRef() + "')");
                }
                if (this.level_dependency_map.containsKey(symbId)) {
                    throw new IllegalStateException("A variability level appears to have cyclic referencing.");
                }
                this.level_dependency_map.put(symbId, ref.getSymbIdRef());
            }
            this.addToCompareMap(symbId);
        }
    }

    private void addToCompareMap(String symbol) {
        if (symbol == null) {
            return;
        }
        if (!this.comparator_map.containsKey(symbol)) {
            this.comparator_map.put(symbol, new StringValue(symbol));
        }
    }

    @Override
    public void buildTrees() {
    }

    public boolean dependsUpon(String levelChild, String levelParent) {
        if (levelChild == null || levelParent == null) {
            return false;
        }
        if (!this.hasSymbolId(levelChild) || !this.hasSymbolId(levelParent)) {
            return false;
        }
        return false;
    }

    public List<String> getLevels() {
        return this.symbols;
    }

    public VariabilityDefnBlock getModel() {
        return this.vb;
    }

    @Override
    public String getName() {
        if (this.vb != null) {
            return this.vb.getBlkId();
        }
        return null;
    }

    @Override
    public List<String> getSymbolIds() {
        return this.symbols;
    }

    public boolean hasScope(ParameterRandomVariable rv) {
        if (rv == null) {
            return false;
        }
        List lrefs = rv.getListOfVariabilityReference();
        if (lrefs == null) {
            return false;
        }
        for (LevelReference lref : lrefs) {
            SymbolRef ref;
            if (lref == null || (ref = lref.getSymbRef()) == null || !this.hasSymbolId(ref.getSymbIdRef())) continue;
            return true;
        }
        return false;
    }

    public boolean hasScope(String level, ParameterRandomVariable rv) {
        if (rv == null || level == null) {
            return false;
        }
        if (!this.hasSymbolId(level)) {
            return false;
        }
        List lrefs = rv.getListOfVariabilityReference();
        for (LevelReference lref : lrefs) {
            String referenced_level;
            SymbolRef ref;
            if (lref == null || (ref = lref.getSymbRef()) == null || !this.hasSymbolId(referenced_level = ref.getSymbIdRef())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSymbolId(String name) {
        if (name != null) {
            return this.symbols.contains(name);
        }
        return false;
    }

    public boolean isParameterVariability() {
        return this.is_parameter_variability;
    }

    public boolean isResidualError() {
        return this.residual_error;
    }

    public String readLevel(ParameterRandomVariable rv) {
        SymbolRef ref;
        LevelReference lref;
        List lrefs;
        String level = null;
        if (rv != null && (lrefs = rv.getListOfVariabilityReference()) != null && lrefs.size() > 0 && (lref = (LevelReference)lrefs.get(0)) != null && (ref = lref.getSymbRef()) != null) {
            level = ref.getSymbIdRef();
        }
        return level;
    }

    public String toString() {
        return this.getName();
    }
}

