@echo on
rem @echo off

rem ############# sets preamble directory and calls preambles
set PREAMBLE="${job.commandExecutionTarget.environmentSetupScript}"
for %%F in (%PREAMBLE%) do set PREAMBLE_DIR=%%~dpF
cd "%PREAMBLE_DIR%"

CALL %PREAMBLE%

rem ############# sets WORK_DIR and WORK_DIR_DRIVE
set WORK_DIR="${job.jobWorkingDirectory}"
for %%D in (%WORK_DIR%) do set WORK_DIR_DRIVE=%%~dD
echo Job Working Directory = %WORK_DIR%
echo Job Working Directory Drive = %WORK_DIR_DRIVE%
%WORK_DIR_DRIVE%
cd %WORK_DIR%

<#assign executionFile = job.executionFileName>
<#if (job.executionFileName.endsWith(".xml")) >
	<#assign executionFile = "RunScript.txt">
</#if>

rem ############# set env. variables and creates symbolic link
set WB_DIR="%SEE_HOME%\BlackBoxWinBUGS"
for %%D in (%WB_DIR%) do set WB_DIR_DRIVE=%%~dD
echo WinBUGS Working Directory = %WB_DIR%
echo WinBUGS Working Directory Drive = %WB_DIR_DRIVE%

rem ############# copy of the data file, named data_BUGS.txt, from the job working directory to Winbugs directory
copy  "%WORK_DIR%\data_BUGS.txt" "%WB_DIR%\data_BUGS.txt"
rem #############

rem ############# moves to the WB drive and to the WB directory
%WB_DIR_DRIVE%
cd %WB_DIR%

rem ############# calls bbcompile.bat to compile BlackBox
CALL "${job.commandExecutionTarget.customScriptsDirectory}/bbCompile.bat"
rem #############

rem ############# bbscript-BlackBox-WinBUGS model execution
rem ${job.commandExecutionTarget.toolExecutablePath} /PAR "%WB_DIR%\runScript.txt"
${job.commandExecutionTarget.toolExecutablePath} /PAR runScript.txt
rem #############
echo step RUN MODEL: ${job.commandExecutionTarget.toolExecutablePath} /PAR "%WB_DIR%\runScript.txt"bbs		
SETLOCAL EnableExtensions
set EXE=${job.commandExecutionTarget.toolExecutablePath}
:FOUND4
echo step(4) START - bbscript-BlackBox-WinBUGS model execution, WinBUGS model running
FOR /F %%x IN ('tasklist /NH /FI "IMAGENAME eq %EXE%"') DO IF %%x == %EXE% goto FOUND4
echo bbscriptWinBUGS model execution running
goto FIN4
:FIN4
echo step(4) END - WinBUGS model execution ended

rem ############# calls bbFinalize to remove files
CALL "${job.commandExecutionTarget.customScriptsDirectory}/bbFinalize.bat"
rem #############

%WORK_DIR_DRIVE%
cd %WORK_DIR%

exit 0